/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.util.SReflect;
import java.util.Map;

public class ConditionalNode
extends ExpressionNode {
    public ConditionalNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void precompile() {
        if (this.jjtGetNumChildren() != 3) {
            throw new ParseException("Wrong number of subterms for expression: " + this);
        }
        ExpressionNode choice = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode node1 = (ExpressionNode)this.jjtGetChild(1);
        ExpressionNode node2 = (ExpressionNode)this.jjtGetChild(2);
        Class clazz = choice.getStaticType();
        if (clazz != null && clazz.isPrimitive()) {
            clazz = SReflect.getWrappedType(clazz);
        }
        if (clazz != null && clazz != Boolean.class) {
            throw new ParseException("First term not boolean: " + this);
        }
        if (choice.isConstant()) {
            try {
                boolean val = (Boolean)choice.getValue(null);
                if (val) {
                    if (node1.isConstant()) {
                        this.setConstantValue(node1.getValue(null));
                        this.setConstant(true);
                    } else {
                        this.setStaticType(node1.getStaticType());
                    }
                } else if (node2.isConstant()) {
                    this.setConstantValue(node2.getValue(null));
                    this.setConstant(true);
                } else {
                    this.setStaticType(node2.getStaticType());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Object getValue(Map params) throws Exception {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        ExpressionNode choice = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode node1 = (ExpressionNode)this.jjtGetChild(1);
        ExpressionNode node2 = (ExpressionNode)this.jjtGetChild(2);
        boolean val = (Boolean)choice.getValue(params);
        Object ret = val ? node1.getValue(params) : node2.getValue(params);
        return ret;
    }

    public String toPlainString() {
        return this.subnodeToString(0) + " ? " + this.subnodeToString(1) + " : " + this.subnodeToString(2);
    }
}

