/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParseException;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.util.Map;

public class CompareNode
extends ExpressionNode {
    public static final int EQUAL = 1;
    public static final int UNEQUAL = 2;
    public static final int GREATER = 3;
    public static final int LESS = 4;
    public static final int GREATEREQUAL = 5;
    public static final int LESSEQUAL = 6;
    public static final int INSTANCEOF = 7;
    protected int op;

    public CompareNode(ParserImpl p, int id) {
        super(p, id);
        this.setStaticType(Boolean.class);
    }

    public void setText(String text) {
        super.setText(text);
        this.op = CompareNode.fromString(text);
    }

    public void precompile() {
        if (this.jjtGetNumChildren() != 2) {
            throw new ParseException("Wrong number of subterms for expression: " + this);
        }
        switch (this.op) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new ParseException("Unknown operator type " + this.op + ": " + this);
            }
        }
        ExpressionNode left = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode right = (ExpressionNode)this.jjtGetChild(1);
        if (this.op == 7 && right.getStaticType() != null && right.getStaticType() != Class.class) {
            throw new ParseException("Right hand side of instanceof has to be a type: " + this);
        }
        if (left.isConstant() && right.isConstant()) {
            try {
                this.setConstantValue(this.getValue(null));
                this.setConstant(true);
                if (this.getConstantValue() != null) {
                    this.setStaticType(this.getConstantValue().getClass());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getValue(Map params) throws Exception {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        Object val1 = ((ExpressionNode)this.jjtGetChild(0)).getValue(params);
        Object val2 = ((ExpressionNode)this.jjtGetChild(1)).getValue(params);
        switch (this.op) {
            case 1: {
                return val1 instanceof Number && val2 instanceof Number ? new Boolean(this.compare(val1, val2) == 0) : new Boolean(SUtil.equals(val1, val2));
            }
            case 2: {
                return val1 instanceof Number && val2 instanceof Number ? new Boolean(this.compare(val1, val2) != 0) : new Boolean(!SUtil.equals(val1, val2));
            }
            case 3: {
                return new Boolean(this.compare(val1, val2) > 0);
            }
            case 4: {
                return new Boolean(this.compare(val1, val2) < 0);
            }
            case 5: {
                return new Boolean(this.compare(val1, val2) >= 0);
            }
            case 6: {
                return new Boolean(this.compare(val1, val2) <= 0);
            }
            case 7: {
                return new Boolean(val1 != null && SReflect.isSupertype((Class)val2, val1.getClass()));
            }
        }
        throw new RuntimeException("Unknown operator type: " + this.op);
    }

    public String toPlainString() {
        return this.subnodeToString(0) + CompareNode.toString(this.op) + this.subnodeToString(1);
    }

    protected int compare(Object val1, Object val2) {
        if (val1 == null || val2 == null) {
            throw new NullPointerException("Cannot compare null " + this);
        }
        if (val1 instanceof Number && val2 instanceof Number) {
            Number numval1 = (Number)val1;
            Number numval2 = (Number)val2;
            if (numval1 instanceof Double || numval2 instanceof Double || numval1 instanceof Float || numval2 instanceof Float) {
                double cmp = numval1.doubleValue() - numval2.doubleValue();
                return cmp > 0.0 ? 1 : (cmp < 0.0 ? -1 : 0);
            }
            if (numval1 instanceof Long || numval2 instanceof Long) {
                return (int)(numval1.longValue() - numval2.longValue());
            }
            return numval1.intValue() - numval2.intValue();
        }
        return ((Comparable)val1).compareTo(val2);
    }

    public static String toString(int operator) {
        switch (operator) {
            case 1: {
                return "==";
            }
            case 2: {
                return "!=";
            }
            case 3: {
                return ">";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return ">=";
            }
            case 6: {
                return "<=";
            }
            case 7: {
                return " instanceof ";
            }
        }
        return "" + operator;
    }

    public static int fromString(String operator) {
        if ("==".equals(operator)) {
            return 1;
        }
        if ("!=".equals(operator)) {
            return 2;
        }
        if (">".equals(operator)) {
            return 3;
        }
        if ("<".equals(operator)) {
            return 4;
        }
        if (">=".equals(operator)) {
            return 5;
        }
        if ("<=".equals(operator)) {
            return 6;
        }
        if ("instanceof".equals(operator)) {
            return 7;
        }
        throw new ParseException("Unknown operator: " + operator);
    }
}

