/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser.javaccimpl;

import jadex.parser.javaccimpl.ExpressionNode;
import jadex.parser.javaccimpl.ParserImpl;
import jadex.util.SReflect;
import java.util.Map;

public class CastNode
extends ExpressionNode {
    public CastNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void precompile() {
        ExpressionNode type = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode expression = (ExpressionNode)this.jjtGetChild(1);
        if (type.isConstant()) {
            try {
                this.setStaticType((Class)type.getValue(null));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type.isConstant() && expression.isConstant()) {
            try {
                this.setConstantValue(this.getValue(null));
                this.setConstant(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getValue(Map params) throws Exception {
        if (!this.isConstant()) {
            Object value = ((ExpressionNode)this.jjtGetChild(1)).getValue(params);
            if (value != null) {
                Class type = this.getStaticType();
                if (type == null) {
                    type = (Class)((ExpressionNode)this.jjtGetChild(0)).getValue(null);
                }
                if (!SReflect.isSupertype(type, value.getClass()) && SReflect.isSupertype(Number.class, type) && value instanceof Number) {
                    if ((type = SReflect.getWrappedType(type)) == Float.class) {
                        value = new Float(((Number)value).floatValue());
                    } else if (type == Long.class) {
                        value = new Long(((Number)value).longValue());
                    } else if (type == Integer.class) {
                        value = new Integer(((Number)value).intValue());
                    } else if (type == Short.class) {
                        value = new Short(((Number)value).shortValue());
                    } else if (type == Byte.class) {
                        value = new Byte(((Number)value).byteValue());
                    } else if (type == Character.class) {
                        value = new Character((char)((Number)value).intValue());
                    }
                } else if (!SReflect.isSupertype(type, value.getClass())) {
                    throw new ClassCastException(value.toString() + " cannot be cast to " + type.getName());
                }
            }
            return value;
        }
        return this.getConstantValue();
    }

    public String toPlainString() {
        return "(" + this.jjtGetChild(0).toPlainString() + ")" + this.jjtGetChild(1).toPlainString();
    }
}

