/*
 * Decompiled with CFR 0.152.
 */
package jadex.parser;

import jadex.config.Configuration;
import jadex.parser.IParser;
import jadex.parser.IParserFactory;
import jadex.parser.ITerm;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class SParser {
    public static final String PARSER_JAVACC = "jadex.parser.javaccimpl.Parser";
    public static final String PARSER_JANINO = "jadex.parser.janinoimpl.Parser";
    protected static IParserFactory factory;
    protected static IParser parser;
    static /* synthetic */ Class class$java$lang$String;

    public static IParser createParser(String[] imports) {
        return SParser.getFactory().createParser(imports);
    }

    public static IParser createParser(String[] imports, String filename, long lastmodified) {
        return SParser.getFactory().createParser(imports, filename, lastmodified);
    }

    protected static IParserFactory getFactory() {
        String factoryname = Configuration.getConfiguration().getParserName();
        if (factory == null || !factory.getClass().getName().equals(factoryname)) {
            try {
                factory = (IParserFactory)SReflect.findClass(factoryname, null).newInstance();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new RuntimeException(sw.toString());
            }
        }
        return factory;
    }

    public static Object evaluateExpression(String exp, String[] imports, Map params) throws Exception {
        if (parser == null) {
            parser = SParser.createParser(imports);
        }
        ITerm term = parser.parseExpression(exp, params != null ? SUtil.arrayToList(params.keySet().toArray()) : null);
        return term.getValue(params);
    }

    public static void main(String[] args) throws Exception {
        IParser parser = SParser.createParser(null);
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                System.out.println("\n" + args[i]);
                HashMap<String, Class> params = new HashMap<String, Class>();
                params.put("$param", class$java$lang$String == null ? SParser.class$("java.lang.String") : class$java$lang$String);
                ITerm term = parser.parseExpression(args[i], null);
                Object retval = term.getValue(null);
                System.out.println("Result: " + retval);
            }
        } else {
            Properties props = new Properties();
            props.load(SParser.class.getResourceAsStream("TestExpressions.properties"));
            String imports = props.getProperty("imports");
            if (imports != null) {
                props.remove("imports");
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer stok = new StringTokenizer(imports, ", ");
                while (stok.hasMoreTokens()) {
                    list.add(stok.nextToken().trim());
                }
                parser = SParser.createParser(list.toArray(new String[list.size()]));
            }
            String parameters = props.getProperty("parameters");
            HashMap<String, Object> params = new HashMap<String, Object>();
            HashMap paramtypes = new HashMap();
            if (parameters != null) {
                props.remove("parameters");
                StringTokenizer stok = new StringTokenizer(parameters, ",");
                while (stok.hasMoreTokens()) {
                    String param = stok.nextToken().trim();
                    String value = props.getProperty(param);
                    params.put(param, parser.parseExpression(value, null).getValue(params));
                    if (params.get(param) != null) {
                        paramtypes.put(param, params.get(param).getClass());
                    }
                    props.remove(param);
                }
            }
            int passed = 0;
            int failed = 0;
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String rets;
                Object retval;
                ITerm node;
                boolean fail;
                boolean evalex;
                boolean parsex;
                String value;
                String exp;
                block26: {
                    String type;
                    block25: {
                        exp = (String)keys.nextElement();
                        String result = props.getProperty(exp);
                        int sep = result.lastIndexOf(":");
                        value = result.substring(0, sep).trim();
                        type = result.substring(sep + 1).trim();
                        boolean constant = false;
                        if (type.startsWith("c")) {
                            constant = true;
                            type = type.substring(1).trim();
                        }
                        parsex = false;
                        if (type.startsWith("p")) {
                            parsex = true;
                            type = type.substring(1).trim();
                        }
                        evalex = false;
                        if (type.startsWith("e")) {
                            evalex = true;
                            type = type.substring(1).trim();
                        }
                        fail = false;
                        node = null;
                        try {
                            node = parser.parseExpression(exp, null);
                            System.out.println(node);
                            if (parsex) {
                                System.err.println(node);
                                System.err.println("Parse: Fail (expected exception: " + type + ")");
                                fail = true;
                            }
                        }
                        catch (Throwable e) {
                            if (!parsex) {
                                System.err.println("Parse: Fail (unexpected exception)");
                                e.printStackTrace();
                                fail = true;
                            }
                            if (e.toString().startsWith(type)) break block25;
                            System.err.println("Parse: Fail (expected exception: " + type + ", but was " + e + ")");
                            e.printStackTrace();
                            fail = true;
                        }
                    }
                    retval = null;
                    if (!fail && !parsex) {
                        try {
                            retval = node.getValue(params);
                            if (evalex) {
                                System.err.println(node);
                                System.err.println("Eval: Fail (expected exception: " + type + ")");
                                fail = true;
                            }
                        }
                        catch (Exception e) {
                            if (!evalex) {
                                System.err.println(node);
                                System.err.println("Eval: Fail (unexpected exception)");
                                e.printStackTrace();
                                fail = true;
                            }
                            if (e.toString().startsWith(type)) break block26;
                            System.err.println(node);
                            System.err.println("Eval: Fail (expected exception: " + type + ", but was " + e + ")");
                            e.printStackTrace();
                            fail = true;
                        }
                    }
                }
                if (!(fail || parsex || evalex || (rets = "" + retval).startsWith(value))) {
                    System.err.println(node);
                    System.err.println("Value: Fail (was " + rets + ", should be " + value + ")");
                    fail = true;
                }
                if (fail) {
                    ++failed;
                    System.err.println("Failed expression: " + exp);
                    System.err.println("\n");
                    continue;
                }
                ++passed;
            }
            if (failed == 0) {
                System.out.println("\nAll " + passed + " tests completed.");
            } else {
                System.out.println("\nFailed " + failed + " tests of " + (passed + failed) + ".");
            }
        }
    }
}

