/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.IMBeliefbase;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMConfigBase;
import jadex.model.IMConfigElement;
import jadex.model.IMConfiguration;
import jadex.model.IMElement;
import jadex.model.IMEventbase;
import jadex.model.IMGoalbase;
import jadex.model.IMPlanbase;
import jadex.model.IReport;
import jadex.model.jibximpl.MElement;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.IndexMap;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Report
implements IReport,
Cloneable {
    protected IMElement element;
    protected MultiCollection entries;
    protected Map externals;
    protected boolean nocheck;

    public Report(IMElement element) {
        this(element, false);
    }

    public Report(IMElement element, boolean nocheck) {
        this.element = element;
        this.nocheck = nocheck;
    }

    public boolean isEmpty() {
        return this.entries == null || this.entries.isEmpty();
    }

    public void addEntry(IMElement element, String message) {
        if (this.entries == null) {
            this.entries = new MultiCollection(new IndexMap().getAsMap(), ArrayList.class);
        }
        this.entries.put(element, message);
    }

    public IMElement[] getElements() {
        if (this.entries == null) {
            return new IMElement[0];
        }
        return (IMElement[])this.entries.getKeys(IMElement.class);
    }

    public String[] getMessages(IMElement element) {
        if (this.entries == null) {
            return new String[0];
        }
        Collection ret = this.entries.getCollection(element);
        return ret.toArray(new String[ret.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Report for ");
        buf.append(this.element);
        buf.append("\n");
        if (this.element instanceof IMCapability && ((IMCapability)this.element).getFilename() != null) {
            buf.append("File: ");
            buf.append(((IMCapability)this.element).getFilename());
            buf.append("\n");
        }
        buf.append("\n");
        if (this.isEmpty()) {
            buf.append(this.nocheck ? "Checking disabled for element." : "Model is valid.");
        } else {
            IMElement[] elements = this.getElements();
            for (int i = 0; i < elements.length; ++i) {
                buf.append(elements[i].toString());
                buf.append(":\n");
                String[] messages = this.getMessages(elements[i]);
                for (int j = 0; j < messages.length; ++j) {
                    buf.append("\t");
                    buf.append(messages[j]);
                    buf.append("\n");
                }
            }
        }
        return SUtil.stripTags(buf.toString());
    }

    public String toHTMLString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<h3>Report for ");
        buf.append(this.element);
        buf.append("</h3>\n");
        if (this.element instanceof IMCapability && ((IMCapability)this.element).getFilename() != null) {
            buf.append("File: ");
            buf.append(((IMCapability)this.element).getFilename());
            buf.append("\n");
        }
        if (this.isEmpty()) {
            buf.append("<h4>Summary</h4>\n");
            buf.append("Model is valid.");
        } else {
            IMElement[] capabilities = this.getCapabilityErrors();
            IMElement[] beliefs = this.getOwnedElementErrors(IMBeliefbase.class);
            IMElement[] goals = this.getOwnedElementErrors(IMGoalbase.class);
            IMElement[] plans = this.getOwnedElementErrors(IMPlanbase.class);
            IMElement[] events = this.getOwnedElementErrors(IMEventbase.class);
            IMElement[] initials = this.getOwnedElementErrors(IMConfigBase.class);
            IMElement[] others = this.getOtherErrors();
            buf.append("<h4>Summary</h4>\n<ul>\n");
            this.generateOverview(buf, "Capability", capabilities);
            this.generateOverview(buf, "Belief", beliefs);
            this.generateOverview(buf, "Goal", goals);
            this.generateOverview(buf, "Plan", plans);
            this.generateOverview(buf, "Event", events);
            this.generateOverview(buf, "Initial State", initials);
            this.generateOverview(buf, "Other element", others);
            buf.append("</ul>\n");
            this.generateDetails(buf, "Capability", capabilities);
            this.generateDetails(buf, "Belief", beliefs);
            this.generateDetails(buf, "Goal", goals);
            this.generateDetails(buf, "Plan", plans);
            this.generateDetails(buf, "Event", events);
            this.generateDetails(buf, "Initial State", initials);
            this.generateDetails(buf, "Other element", others);
        }
        return buf.toString();
    }

    public IMElement[] getCapabilityErrors() {
        ArrayList errors = SCollection.createArrayList();
        IMElement[] elements = this.getElements();
        block0: for (int i = 0; i < elements.length; ++i) {
            for (IMElement element = elements[i]; element != null && !errors.contains(element); element = element.getOwner()) {
                if (!(element instanceof IMCapabilityReference)) continue;
                errors.add(element);
                continue block0;
            }
        }
        return errors.toArray(new IMElement[errors.size()]);
    }

    public IMElement[] getOwnedElementErrors(Class basetype) {
        ArrayList errors = SCollection.createArrayList();
        IMElement[] elements = this.getElements();
        block0: for (int i = 0; i < elements.length; ++i) {
            for (IMElement element = elements[i]; element != null && !errors.contains(element); element = element.getOwner()) {
                if (element.getOwner() == null || !SReflect.isSupertype(basetype, element.getOwner().getClass())) continue;
                errors.add(element);
                continue block0;
            }
        }
        return errors.toArray(new IMElement[errors.size()]);
    }

    public IMElement[] getOtherErrors() {
        ArrayList errors = SCollection.createArrayList();
        IMElement[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            IMElement element;
            for (element = elements[i]; !(element == null || errors.contains(element) || element instanceof IMCapabilityReference || element.getOwner() instanceof IMBeliefbase || element.getOwner() instanceof IMGoalbase || element.getOwner() instanceof IMPlanbase || element.getOwner() instanceof IMEventbase || element.getOwner() instanceof IMConfigBase); element = element.getOwner()) {
            }
            if (element != null) continue;
            errors.add(elements[i]);
        }
        return errors.toArray(new IMElement[errors.size()]);
    }

    public IMElement[] getElementErrors(IMElement ancestor) {
        ArrayList errors = SCollection.createArrayList();
        IMElement[] elements = this.getElements();
        block0: for (int i = 0; i < elements.length; ++i) {
            for (IMElement element = elements[i]; element != null && !errors.contains(element); element = element.getOwner()) {
                if (!ancestor.equals(element)) continue;
                errors.add(elements[i]);
                continue block0;
            }
        }
        return errors.toArray(new IMElement[errors.size()]);
    }

    public void addDocument(String id, String doc) {
        if (this.externals == null) {
            this.externals = SCollection.createHashMap();
        }
        this.externals.put(id, doc);
    }

    public Map getDocuments() {
        return this.externals == null ? Collections.EMPTY_MAP : this.externals;
    }

    public int getErrorCount() {
        return this.entries == null ? 0 : this.entries.size();
    }

    protected void generateOverview(StringBuffer buf, String type, IMElement[] elements) {
        if (elements.length > 0) {
            buf.append("<li>");
            buf.append(type);
            buf.append(" errors\n<ul>\n");
            for (int i = 0; i < elements.length; ++i) {
                buf.append("<li><a href=\"#");
                buf.append(SUtil.makeConform("" + elements[i]));
                buf.append("\">");
                buf.append(SUtil.makeConform("" + elements[i]));
                buf.append("</a> has errors.</li>\n");
            }
            buf.append("</ul>\n</li>\n");
        }
    }

    protected void generateDetails(StringBuffer buf, String type, IMElement[] elements) {
        if (elements.length > 0) {
            buf.append("<h4>");
            buf.append(type);
            buf.append(" details</h4>\n<ul>\n");
            for (int i = 0; i < elements.length; ++i) {
                buf.append("<li><a name=\"");
                buf.append(SUtil.makeConform("" + elements[i]));
                buf.append("\">");
                buf.append(SUtil.makeConform("" + elements[i]));
                if (elements[i] instanceof IMConfigElement) {
                    IMElement owner;
                    for (owner = elements[i]; owner != null && !(owner instanceof IMConfiguration); owner = owner.getOwner()) {
                    }
                    if (owner != null) {
                        buf.append(" in ");
                    }
                    buf.append(SUtil.makeConform("" + owner));
                }
                buf.append("</a> errors:\n");
                IMElement[] errors = this.getElementErrors(elements[i]);
                buf.append("<dl>\n");
                for (int j = 0; j < errors.length; ++j) {
                    buf.append("<dt>");
                    buf.append(errors[j]);
                    String[] msgs = this.getMessages(errors[j]);
                    buf.append("\n<dd>");
                    for (int k = 0; k < msgs.length; ++k) {
                        buf.append(msgs[k]);
                        buf.append("\n");
                        if (msgs.length <= 1 || k == msgs.length - 1) continue;
                        buf.append("<br>");
                    }
                    buf.append("</dd>\n");
                }
                buf.append("</dl>\n</li>\n");
            }
            buf.append("</ul>\n");
        }
    }

    public Object clone() {
        Object ret = null;
        boolean creator = false;
        HashMap cls = (HashMap)MElement.clones.get();
        if (cls == null) {
            cls = SCollection.createHashMap();
            MElement.clones.set(cls);
            creator = true;
        } else {
            ret = cls.get(this);
        }
        if (ret == null) {
            try {
                ret = super.clone();
            }
            catch (CloneNotSupportedException exception) {
                throw new RuntimeException("Cloning not supported: " + this);
            }
            cls.put(this, ret);
            this.doClone(ret);
        }
        if (creator) {
            MElement.clones.set(null);
        }
        return ret;
    }

    protected void doClone(Object clone) {
        Report rep = (Report)clone;
        if (this.element != null) {
            rep.element = (IMElement)((MElement)rep.element).clone();
        }
        if (this.entries != null) {
            rep.entries = new MultiCollection(new IndexMap().getAsMap(), ArrayList.class);
            Object[] keys = this.entries.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                Object[] vals = this.entries.getCollection(keys[i]).toArray();
                for (int j = 0; j < vals.length; ++j) {
                    rep.entries.put(((MElement)keys[i]).clone(), vals[j]);
                }
            }
        }
    }
}

