/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.IMBase;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMElementReference;
import jadex.model.IMReferenceableElement;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MElementReference;
import jadex.model.jibximpl.Report;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public abstract class MReferenceableElement
extends MElement
implements IMReferenceableElement {
    protected String exported = "false";
    private ArrayList assigntonames;
    private List assigntos;
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    protected void init() {
        super.init();
        this.initAssignToElements();
    }

    protected void doCheck(Report report) {
        super.doCheck(report);
        String[] asstos = this.getAssignTos();
        for (int i = 0; i < asstos.length; ++i) {
            IMReferenceableElement refelem = this.findReferencedElement(asstos[i]);
            if (refelem == null) {
                report.addEntry(this, "Invalid assignto specification '" + asstos[i] + "'. Referenced element not found.");
                continue;
            }
            if (!(refelem instanceof IMElementReference) || !((IMElementReference)refelem).isAbstract()) {
                report.addEntry(this, "Invalid assignto specification '" + asstos[i] + "'. Cannot reference element, because it is not abstract.");
                continue;
            }
            if (this.assignable((IMElementReference)refelem)) continue;
            report.addEntry(this, "Invalid assignto specification '" + asstos[i] + "'. Cannot reference incompatible element '" + SReflect.getInnerClassName(refelem.getClass()) + "'.");
        }
    }

    protected abstract boolean assignable(IMElementReference var1);

    public String getExported() {
        return this.exported;
    }

    public void setExported(String exported) {
        this.exported = exported;
    }

    public String[] getAssignTos() {
        if (this.assigntonames == null) {
            return new String[0];
        }
        return this.assigntonames.toArray(new String[this.assigntonames.size()]);
    }

    public void createAssignTo(String ref) {
        if (this.assigntonames == null) {
            this.assigntonames = SCollection.createArrayList();
        }
        this.assigntonames.add(ref);
    }

    public void deleteAssignTo(String ref) {
        if (!this.assigntonames.remove(ref)) {
            throw new RuntimeException("Could not find: " + ref);
        }
    }

    public IMElementReference[] getAssignToElements() {
        if (this.assigntos == null) {
            return new IMElementReference[0];
        }
        return this.assigntos.toArray(new IMElementReference[this.assigntos.size()]);
    }

    protected void initAssignToElements() {
        if (!$assertionsDisabled && this.isChecking()) {
            throw new AssertionError(this);
        }
        if (!$assertionsDisabled && this.getOwner() == null) {
            throw new AssertionError();
        }
        String[] asstos = this.getAssignTos();
        for (int i = 0; i < asstos.length; ++i) {
            String refname = asstos[i];
            IMReferenceableElement refelem = this.findReferencedElement(refname);
            if (!$assertionsDisabled && refelem == null) {
                throw new AssertionError();
            }
            this.addAssignToElement(refelem);
        }
    }

    protected IMReferenceableElement findReferencedElement(String refname) {
        IMReferenceableElement ret = null;
        int idx = refname.indexOf(".");
        if (idx != -1) {
            IMCapability capa;
            String capaname = refname.substring(0, idx);
            IMCapabilityReference caparef = this.getScope().getCapabilityReference(capaname);
            if (caparef != null && (capa = caparef.getCapability()) != null) {
                String rest = refname.substring(idx + 1, refname.length());
                IMBase base = (IMBase)this.getOwner();
                ret = base.getCorrespondingBase(capa).getReferenceableElement(rest);
            }
        }
        return ret;
    }

    protected void addAssignToElement(IMReferenceableElement elem) {
        if (!$assertionsDisabled && elem == null) {
            throw new AssertionError();
        }
        if (this.assigntos == null) {
            this.assigntos = SCollection.createArrayList();
        }
        this.assigntos.add(elem);
        if (elem instanceof IMElementReference) {
            ((MElementReference)elem).setAssignFromElement(this);
        }
    }

    public void addAssignToName(String ref) {
        if (this.assigntonames == null) {
            this.assigntonames = SCollection.createArrayList();
        }
        this.assigntonames.add(ref);
    }

    public Iterator iterAssignToNames() {
        return this.assigntonames == null ? Collections.EMPTY_LIST.iterator() : this.assigntonames.iterator();
    }

    public void doClone(MElement cl) {
        super.doClone(cl);
        MReferenceableElement clone = (MReferenceableElement)cl;
        if (this.assigntonames != null) {
            clone.assigntonames = (ArrayList)this.assigntonames.clone();
        }
        if (this.assigntos != null) {
            clone.assigntos = SCollection.createArrayList();
            for (int i = 0; i < this.assigntos.size(); ++i) {
                MElement elem = (MElement)this.assigntos.get(i);
                if (elem == null) {
                    throw new NullPointerException("Problem in assignto " + i + " of element: " + this + ", " + this.getScope());
                }
                clone.assigntos.add(elem.clone());
            }
        }
    }

    static {
        $assertionsDisabled = !MReferenceableElement.class.desiredAssertionStatus();
    }

    public final /* synthetic */ MReferenceableElement JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        MReferenceableElement mReferenceableElement = this;
        MElement mElement = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_1_0(arg1);
        this.exported = arg1.attributeText(null, "exported", "false");
        return this;
    }

    public final /* synthetic */ MReferenceableElement JiBX_src_jadex_model_jibximpl_binding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        MReferenceableElement mReferenceableElement = this;
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "assignto")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "assignto");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "assignto");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "assignto");
            this.addAssignToName(string);
        }
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_1_0(arg1);
        if (this.exported != null) {
            String string = this.exported;
            if (!Utility.isEqual((Object)string, (Object)"false")) {
                marshallingContext = marshallingContext.attribute(0, "exported", string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        Iterator var0 = this.iterAssignToNames();
        while (var0.hasNext()) {
            void var3_3;
            String string = (String)var0.next();
            arg1.startTagNamespaces(3, "assignto", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", (String)var3_3);
            arg1.closeStartEmpty();
        }
    }
}

