/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMBeliefSet;
import jadex.model.IMBeliefSetReference;
import jadex.model.IMCondition;
import jadex.model.IMPlanTrigger;
import jadex.model.IMReference;
import jadex.model.IMReferenceableElement;
import jadex.model.jibximpl.MBindingCondition;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MReference;
import jadex.model.jibximpl.MTrigger;
import jadex.model.jibximpl.Report;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MPlanTrigger
extends MTrigger
implements IMPlanTrigger {
    protected ArrayList goals;
    protected MBindingCondition condition;
    protected ArrayList beliefchanges;
    protected ArrayList beliefsetchanges;
    protected ArrayList factadditions;
    protected ArrayList factremovals;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    protected void init() {
        super.init();
        if (this.getCondition() != null && this.getCondition().getTrigger() == null) {
            this.getCondition().setTrigger("is_true");
        }
    }

    public List getChildren() {
        List ret = super.getChildren();
        if (this.goals != null) {
            ret.addAll(this.goals);
        }
        if (this.condition != null) {
            ret.add(this.condition);
        }
        return ret;
    }

    protected void doCheck(Report report) {
        IMReferenceableElement refelem;
        int i;
        super.doCheck(report);
        IMReference[] refs = this.getGoals();
        for (int i2 = 0; i2 < refs.length; ++i2) {
            String goalname = refs[i2].getReference();
            IMReferenceableElement target = this.getScope().getGoalbase().getReferenceableElement(goalname);
            if (target != null) continue;
            report.addEntry(refs[i2], "Referenced goal not found '" + goalname + "'.");
        }
        String[] triggers = this.getBeliefChanges();
        for (i = 0; i < triggers.length; ++i) {
            refelem = this.getScope().getBeliefbase().getReferenceableElement(triggers[i]);
            if (refelem instanceof IMBelief || refelem instanceof IMBeliefReference) continue;
            report.addEntry(this, "Cannot find triggering belief '" + triggers[i] + "'.");
        }
        triggers = this.getBeliefSetChanges();
        for (i = 0; i < triggers.length; ++i) {
            refelem = this.getScope().getBeliefbase().getReferenceableElement(triggers[i]);
            if (refelem instanceof IMBeliefSet || refelem instanceof IMBeliefSetReference) continue;
            report.addEntry(this, "Cannot find triggering beliefset '" + triggers[i] + "'.");
        }
        triggers = this.getFactAddedTriggers();
        for (i = 0; i < triggers.length; ++i) {
            refelem = this.getScope().getBeliefbase().getReferenceableElement(triggers[i]);
            if (refelem instanceof IMBeliefSet || refelem instanceof IMBeliefSetReference) continue;
            report.addEntry(this, "Cannot find triggering beliefset '" + triggers[i] + "'.");
        }
        triggers = this.getFactRemovedTriggers();
        for (i = 0; i < triggers.length; ++i) {
            refelem = this.getScope().getBeliefbase().getReferenceableElement(triggers[i]);
            if (refelem instanceof IMBeliefSet || refelem instanceof IMBeliefSetReference) continue;
            report.addEntry(this, "Cannot find triggering beliefset '" + triggers[i] + "'.");
        }
    }

    public IMReference[] getGoals() {
        if (this.goals == null) {
            return new IMReference[0];
        }
        return this.goals.toArray(new IMReference[this.goals.size()]);
    }

    public IMReference createGoal(String ref) {
        if (this.goals == null) {
            this.goals = SCollection.createArrayList();
        }
        MReference ret = new MReference();
        ret.setReference(ref);
        ret.setOwner(this);
        ret.init();
        this.goals.add(ret);
        return ret;
    }

    public void deleteGoal(IMReference ref) {
        if (!this.goals.remove(ref)) {
            throw new RuntimeException("Goal ref not found: " + ref);
        }
    }

    public IMCondition getCondition() {
        return this.condition;
    }

    public IMCondition createCondition(String expression) {
        this.condition = new MBindingCondition();
        this.condition.setExpressionText(expression);
        this.condition.setTrigger("is_true");
        this.condition.setOwner(this);
        this.condition.init();
        return this.condition;
    }

    public void deleteCondition() {
        this.condition = null;
    }

    public String[] getBeliefChanges() {
        if (this.beliefchanges == null) {
            return new String[0];
        }
        return this.beliefchanges.toArray(new String[this.beliefchanges.size()]);
    }

    public void createBeliefChange(String ref) {
        if (this.beliefchanges == null) {
            this.beliefchanges = SCollection.createArrayList();
        }
        this.beliefchanges.add(ref);
    }

    public void deleteBeliefChange(String ref) {
        this.beliefchanges.remove(ref);
    }

    public String[] getBeliefSetChanges() {
        if (this.beliefsetchanges == null) {
            return new String[0];
        }
        return this.beliefsetchanges.toArray(new String[this.beliefsetchanges.size()]);
    }

    public void createBeliefSetChange(String ref) {
        if (this.beliefsetchanges == null) {
            this.beliefsetchanges = SCollection.createArrayList();
        }
        this.beliefsetchanges.add(ref);
    }

    public void deleteBeliefSetChange(String ref) {
        this.beliefsetchanges.remove(ref);
    }

    public String[] getFactAddedTriggers() {
        if (this.factadditions == null) {
            return new String[0];
        }
        return this.factadditions.toArray(new String[this.factadditions.size()]);
    }

    public void createFactAddedTrigger(String ref) {
        if (this.factadditions == null) {
            this.factadditions = SCollection.createArrayList();
        }
        this.factadditions.add(ref);
    }

    public void deleteFactAddedTrigger(String ref) {
        this.factadditions.remove(ref);
    }

    public String[] getFactRemovedTriggers() {
        if (this.factremovals == null) {
            return new String[0];
        }
        return this.factremovals.toArray(new String[this.factremovals.size()]);
    }

    public void createFactRemovedTrigger(String ref) {
        if (this.factremovals == null) {
            this.factremovals = SCollection.createArrayList();
        }
        this.factremovals.add(ref);
    }

    public void deleteFactRemovedTrigger(String ref) {
        this.factremovals.remove(ref);
    }

    public void addGoal(MReference goal) {
        if (this.goals == null) {
            this.goals = SCollection.createArrayList();
        }
        this.goals.add(goal);
    }

    public Iterator iterGoals() {
        return this.goals == null ? Collections.EMPTY_LIST.iterator() : this.goals.iterator();
    }

    public Iterator iterBeliefChanges() {
        return this.beliefchanges == null ? Collections.EMPTY_LIST.iterator() : this.beliefchanges.iterator();
    }

    public Iterator iterBeliefSetChanges() {
        return this.beliefsetchanges == null ? Collections.EMPTY_LIST.iterator() : this.beliefsetchanges.iterator();
    }

    public Iterator iterFactAddedTriggers() {
        return this.factadditions == null ? Collections.EMPTY_LIST.iterator() : this.factadditions.iterator();
    }

    public Iterator iterFactRemovedTriggers() {
        return this.factremovals == null ? Collections.EMPTY_LIST.iterator() : this.factremovals.iterator();
    }

    public void doClone(MElement cl) {
        super.doClone(cl);
        MPlanTrigger clone = (MPlanTrigger)cl;
        if (this.goals != null) {
            clone.goals = SCollection.createArrayList();
            for (int i = 0; i < this.goals.size(); ++i) {
                clone.goals.add(((MElement)this.goals.get(i)).clone());
            }
        }
        if (this.condition != null) {
            clone.condition = (MBindingCondition)this.condition.clone();
        }
        if (this.beliefchanges != null) {
            clone.beliefchanges = (ArrayList)this.beliefchanges.clone();
        }
        if (this.factadditions != null) {
            clone.factadditions = (ArrayList)this.factadditions.clone();
        }
        if (this.factremovals != null) {
            clone.factremovals = (ArrayList)this.factremovals.clone();
        }
    }

    public static /* synthetic */ MPlanTrigger JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(UnmarshallingContext arg1) throws JiBXException {
        return new MPlanTrigger();
    }

    public final /* synthetic */ MPlanTrigger JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_0(UnmarshallingContext arg1) throws JiBXException {
        MPlanTrigger mPlanTrigger = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_2_0(arg1);
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "goal")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "goal");
            MReference mReference = MReference.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "goal");
            mReference.JiBX_src_jadex_model_jibximpl_binding_unmarshal_2_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "goal");
            this.addGoal(mReference);
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "condition")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "condition");
            MBindingCondition mBindingCondition = this.condition;
            if (mBindingCondition == null) {
                mBindingCondition = MBindingCondition.JiBX_src_jadex_model_jibximpl_binding_newinstance_5_0(arg1);
            }
            this.condition = mBindingCondition.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "condition");
            this.condition.JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "condition");
        } else {
            this.condition = null;
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "beliefchange")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "beliefchange");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "beliefchange");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "beliefchange");
            this.createBeliefChange(string);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "beliefsetchange")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "beliefsetchange");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "beliefsetchange");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "beliefsetchange");
            this.createBeliefSetChange(string);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "factadded")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "factadded");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "factadded");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "factadded");
            this.createFactAddedTrigger(string);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "factremoved")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "factremoved");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "factremoved");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "factremoved");
            this.createFactRemovedTrigger(string);
        }
        return this;
    }

    public final /* synthetic */ MPlanTrigger JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_1(UnmarshallingContext arg1) throws JiBXException {
        MPlanTrigger mPlanTrigger = this;
        this.preset((IUnmarshallingContext)arg1);
        arg1.pushTrackedObject((Object)this);
        MPlanTrigger mPlanTrigger2 = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_0(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_3_1(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_2_1(arg1);
        Iterator var0 = this.iterGoals();
        while (var0.hasNext()) {
            MReference mReference = (MReference)var0.next();
            arg1.startTagNamespaces(3, "goal", new int[]{3}, new String[]{""});
            mReference.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_4(arg1);
            arg1.closeStartContent();
            mReference.JiBX_src_jadex_model_jibximpl_binding_marshal_2_5(arg1);
            arg1.endTag(3, "goal");
        }
        if (this.condition != null) {
            MBindingCondition mBindingCondition = this.condition;
            arg1.startTagNamespaces(3, "condition", new int[]{3}, new String[]{""});
            mBindingCondition.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_4(arg1);
            arg1.closeStartContent();
            mBindingCondition.JiBX_src_jadex_model_jibximpl_binding_marshal_5_5(arg1);
            arg1.endTag(3, "condition");
        }
        Iterator var02 = this.iterBeliefChanges();
        while (var02.hasNext()) {
            String string = (String)var02.next();
            arg1.startTagNamespaces(3, "beliefchange", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", var1);
            arg1.closeStartEmpty();
        }
        Iterator var03 = this.iterBeliefSetChanges();
        while (var03.hasNext()) {
            String string = (String)var03.next();
            arg1.startTagNamespaces(3, "beliefsetchange", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", var1);
            arg1.closeStartEmpty();
        }
        Iterator var04 = this.iterFactAddedTriggers();
        while (var04.hasNext()) {
            String string = (String)var04.next();
            arg1.startTagNamespaces(3, "factadded", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", var1);
            arg1.closeStartEmpty();
        }
        Iterator var05 = this.iterFactRemovedTriggers();
        while (var05.hasNext()) {
            String string = (String)var05.next();
            arg1.startTagNamespaces(3, "factremoved", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", var1);
            arg1.closeStartEmpty();
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_3_2(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_3_1(arg1);
        arg1.popObject();
    }
}

