/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.IMBase;
import jadex.model.IMParameterElement;
import jadex.model.IMParameterElementReference;
import jadex.model.IMPlan;
import jadex.model.IMPlanParameter;
import jadex.model.IMReference;
import jadex.model.IMReferenceableElement;
import jadex.model.jibximpl.MParameter;
import jadex.model.jibximpl.Report;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MPlanParameter
extends MParameter
implements IMPlanParameter {
    protected ArrayList internaleventmappings;
    protected ArrayList messageeventmappings;
    protected ArrayList goalmappings;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    protected void doCheck(Report report) {
        super.doCheck(report);
        IMPlan plan = (IMPlan)this.getOwner();
        this.checkMappings(this.getInternalEventMappings(), plan.getTrigger() != null ? plan.getTrigger().getInternalEvents() : null, report, this.getScope().getEventbase());
        this.checkMappings(this.getMessageEventMappings(), plan.getTrigger() != null ? plan.getTrigger().getMessageEvents() : null, report, this.getScope().getEventbase());
        IMReference[] goalrefs = null;
        if (plan.getTrigger() != null) {
            goalrefs = (IMReference[])SUtil.joinArrays(plan.getTrigger().getGoalFinisheds(), plan.getTrigger().getGoals());
        }
        this.checkMappings(this.getGoalMappings(), goalrefs, report, this.getScope().getGoalbase());
    }

    protected void checkMappings(String[] mappings, IMReference[] triggers, Report report, IMBase base) {
        if (mappings.length > 0) {
            int i;
            HashSet trigset = SCollection.createHashSet();
            for (i = 0; triggers != null && i < triggers.length; ++i) {
                trigset.add(triggers[i].getReference());
            }
            for (i = 0; i < mappings.length; ++i) {
                String trname;
                int idx = mappings[i].indexOf(".");
                if (idx == -1) {
                    report.addEntry(this, "Wrong mapping syntax, must be <triggername>.<paramname>: " + mappings[i]);
                }
                if (!trigset.contains(trname = mappings[i].substring(0, idx))) {
                    report.addEntry(this, "Trigger not found: " + mappings[i]);
                }
                String paramname = mappings[i].substring(idx + 1);
                IMReferenceableElement elem = base.getReferenceableElement(trname);
                if (this.findParameter(elem, paramname)) continue;
                report.addEntry(this, "Parameter of trigger not found: " + paramname);
            }
        }
    }

    protected boolean findParameter(IMReferenceableElement elem, String paramname) {
        boolean success = false;
        if (elem instanceof IMParameterElement) {
            if (((IMParameterElement)elem).getParameter(paramname) != null) {
                success = true;
            }
        } else if (elem instanceof IMParameterElementReference) {
            success = ((IMParameterElementReference)elem).getParameterReference(paramname) != null ? true : this.findParameter(((IMParameterElementReference)elem).getReferencedElement(), paramname);
        }
        return success;
    }

    public void createInternalEventMapping(String name) {
        if (this.internaleventmappings == null) {
            this.internaleventmappings = SCollection.createArrayList();
        }
        this.internaleventmappings.add(name);
    }

    public void deleteInternalEventMapping(String name) {
        this.internaleventmappings.remove(name);
    }

    public String[] getInternalEventMappings() {
        if (this.internaleventmappings == null) {
            return new String[0];
        }
        return this.internaleventmappings.toArray(new String[this.internaleventmappings.size()]);
    }

    public void createMessageEventMapping(String name) {
        if (this.messageeventmappings == null) {
            this.messageeventmappings = SCollection.createArrayList();
        }
        this.messageeventmappings.add(name);
    }

    public void deleteMessageEventMapping(String name) {
        this.messageeventmappings.remove(name);
    }

    public String[] getMessageEventMappings() {
        if (this.messageeventmappings == null) {
            return new String[0];
        }
        return this.messageeventmappings.toArray(new String[this.messageeventmappings.size()]);
    }

    public void createGoalMapping(String name) {
        if (this.goalmappings == null) {
            this.goalmappings = SCollection.createArrayList();
        }
        this.goalmappings.add(name);
    }

    public void deleteGoalMapping(String name) {
        this.goalmappings.remove(name);
    }

    public String[] getGoalMappings() {
        if (this.goalmappings == null) {
            return new String[0];
        }
        return this.goalmappings.toArray(new String[this.goalmappings.size()]);
    }

    public Iterator iterInternalEventMappings() {
        return this.internaleventmappings == null ? Collections.EMPTY_LIST.iterator() : this.internaleventmappings.iterator();
    }

    public Iterator iterMessageEventMappings() {
        return this.messageeventmappings == null ? Collections.EMPTY_LIST.iterator() : this.messageeventmappings.iterator();
    }

    public Iterator iterGoalMappings() {
        return this.goalmappings == null ? Collections.EMPTY_LIST.iterator() : this.goalmappings.iterator();
    }

    public static /* synthetic */ MPlanParameter JiBX_src_jadex_model_jibximpl_binding_newinstance_5_0(UnmarshallingContext arg1) throws JiBXException {
        return new MPlanParameter();
    }

    public final /* synthetic */ MPlanParameter JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_0(UnmarshallingContext arg1) throws JiBXException {
        MPlanParameter mPlanParameter = this;
        MParameter mParameter = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_4_0(arg1);
        return this;
    }

    public final /* synthetic */ MPlanParameter JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_1(UnmarshallingContext arg1) throws JiBXException {
        MPlanParameter mPlanParameter = this;
        this.preset((IUnmarshallingContext)arg1);
        arg1.pushTrackedObject((Object)this);
        MPlanParameter mPlanParameter2 = this;
        MPlanParameter mPlanParameter3 = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_0(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ MPlanParameter JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_1(UnmarshallingContext arg1) throws JiBXException {
        MPlanParameter mPlanParameter = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_4_1(arg1);
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "internaleventmapping")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "internaleventmapping");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "internaleventmapping");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "internaleventmapping");
            this.createInternalEventMapping(string);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "messageeventmapping")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "messageeventmapping");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "messageeventmapping");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "messageeventmapping");
            this.createMessageEventMapping(string);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "goalmapping")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "goalmapping");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "goalmapping");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "goalmapping");
            this.createGoalMapping(string);
        }
        return this;
    }

    public final /* synthetic */ MPlanParameter JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_2(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MPlanParameter mPlanParameter = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_1(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_2(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_4_2(arg1);
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_3(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_2(arg1);
        arg1.popObject();
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_5_3(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_4_3(arg1);
        Iterator var0 = this.iterInternalEventMappings();
        while (var0.hasNext()) {
            void var3_3;
            String string = (String)var0.next();
            arg1.startTagNamespaces(3, "internaleventmapping", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", (String)var3_3);
            arg1.closeStartEmpty();
        }
        Iterator var02 = this.iterMessageEventMappings();
        while (var02.hasNext()) {
            String string = (String)var02.next();
            arg1.startTagNamespaces(3, "messageeventmapping", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", var1);
            arg1.closeStartEmpty();
        }
        Iterator var03 = this.iterGoalMappings();
        while (var03.hasNext()) {
            String string = (String)var03.next();
            arg1.startTagNamespaces(3, "goalmapping", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", var1);
            arg1.closeStartEmpty();
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_5_4(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_5_3(arg1);
        arg1.popObject();
    }
}

