/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.IMElement;
import jadex.model.IMParameter;
import jadex.model.IMParameterElement;
import jadex.model.IMParameterSet;
import jadex.model.jibximpl.MBase;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MParameter;
import jadex.model.jibximpl.MParameterSet;
import jadex.model.jibximpl.MReferenceableElement;
import jadex.model.jibximpl.Report;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public abstract class MParameterElement
extends MReferenceableElement
implements IMParameterElement {
    private ArrayList parameters;
    private ArrayList parametersets;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    public List getChildren() {
        List ret = super.getChildren();
        if (this.parameters != null) {
            ret.addAll(this.parameters);
        }
        if (this.parametersets != null) {
            ret.addAll(this.parametersets);
        }
        return ret;
    }

    protected void doCheck(Report report) {
        super.doCheck(report);
        IMElement[] elements = null;
        if (this.parameters != null && this.parametersets != null) {
            elements = (IMElement[])SUtil.joinArrays(this.parameters.toArray(new IMElement[this.parameters.size()]), this.getParameterSets());
        } else if (this.parameters != null) {
            elements = this.getParameters();
        } else if (this.parametersets != null) {
            elements = this.getParameterSets();
        }
        if (elements != null) {
            MBase.checkNameUniqueness(this, report, elements);
        }
    }

    public IMParameter[] getParameters() {
        if (this.parameters == null) {
            return new IMParameter[0];
        }
        return this.parameters.toArray(new IMParameter[this.parameters.size()]);
    }

    public IMParameter getParameter(String name) {
        IMParameter ret = null;
        for (int i = 0; this.parameters != null && i < this.parameters.size(); ++i) {
            IMParameter tmp = (IMParameter)this.parameters.get(i);
            if (!name.equals(tmp.getName())) continue;
            ret = tmp;
        }
        return ret;
    }

    public IMParameter createParameter(String name, Class clazz, String direction, long updaterate, String expression, String mode) {
        if (this.parameters == null) {
            this.parameters = SCollection.createArrayList();
        }
        MParameter ret = new MParameter();
        ret.setName(name);
        ret.setClazz(clazz);
        ret.setDirection(direction == null ? "in" : direction);
        ret.setUpdateRate(updaterate);
        if (expression != null) {
            ret.createDefaultValue(expression, mode);
        }
        ret.setOwner(this);
        ret.init();
        this.parameters.add(ret);
        return ret;
    }

    public void deleteParameter(IMParameter parameter) {
        if (!this.parameters.remove(parameter)) {
            throw new RuntimeException("Parameter not found: " + parameter);
        }
    }

    public IMParameterSet[] getParameterSets() {
        if (this.parametersets == null) {
            return new IMParameterSet[0];
        }
        return this.parametersets.toArray(new IMParameterSet[this.parametersets.size()]);
    }

    public IMParameterSet getParameterSet(String name) {
        IMParameterSet ret = null;
        for (int i = 0; this.parametersets != null && i < this.parametersets.size(); ++i) {
            IMParameterSet tmp = (IMParameterSet)this.parametersets.get(i);
            if (!name.equals(tmp.getName())) continue;
            ret = tmp;
        }
        return ret;
    }

    public IMParameterSet createParameterSet(String name, Class clazz, String direction, long updaterate, String expression, String mode) {
        if (this.parametersets == null) {
            this.parametersets = SCollection.createArrayList();
        }
        MParameterSet ret = new MParameterSet();
        ret.setName(name);
        ret.setClazz(clazz);
        ret.setDirection(direction == null ? "in" : direction);
        ret.setUpdateRate(updaterate);
        if (expression != null) {
            ret.createDefaultValuesExpression(expression, mode);
        }
        ret.setOwner(this);
        ret.init();
        this.parametersets.add(ret);
        return ret;
    }

    public void deleteParameterSet(IMParameterSet parameterset) {
        if (!this.parametersets.remove(parameterset)) {
            throw new RuntimeException("Parameter set could not be found: " + parameterset);
        }
    }

    public void addParameter(IMParameter elem) {
        if (this.parameters == null) {
            this.parameters = SCollection.createArrayList();
        }
        this.parameters.add(elem);
    }

    public Iterator iterParameters() {
        return this.parameters == null ? Collections.EMPTY_LIST.iterator() : this.parameters.iterator();
    }

    public void addParameterSet(IMParameterSet elem) {
        if (this.parametersets == null) {
            this.parametersets = SCollection.createArrayList();
        }
        this.parametersets.add(elem);
    }

    public Iterator iterParameterSets() {
        return this.parametersets == null ? Collections.EMPTY_LIST.iterator() : this.parametersets.iterator();
    }

    public IMParameter[] getBindingParameters() {
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; this.parameters != null && i < this.parameters.size(); ++i) {
            IMParameter param = (IMParameter)this.parameters.get(i);
            if (param.getBindingOptions() == null) continue;
            ret.add(param);
        }
        return ret.toArray(new IMParameter[ret.size()]);
    }

    public void doClone(MElement cl) {
        int i;
        super.doClone(cl);
        MParameterElement clone = (MParameterElement)cl;
        if (this.parameters != null) {
            clone.parameters = SCollection.createArrayList();
            for (i = 0; i < this.parameters.size(); ++i) {
                clone.parameters.add(((MElement)this.parameters.get(i)).clone());
            }
        }
        if (this.parametersets != null) {
            clone.parametersets = SCollection.createArrayList();
            for (i = 0; i < this.parametersets.size(); ++i) {
                clone.parametersets.add(((MElement)this.parametersets.get(i)).clone());
            }
        }
    }

    public final /* synthetic */ MParameterElement JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_0(UnmarshallingContext arg1) throws JiBXException {
        MParameterElement mParameterElement = this;
        MReferenceableElement mReferenceableElement = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_0(arg1);
        return this;
    }

    public final /* synthetic */ MParameterElement JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_0(UnmarshallingContext arg1) throws JiBXException {
        MParameterElement mParameterElement = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_2_0(arg1);
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "parameter")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "parameter");
            MParameter mParameter = MParameter.JiBX_src_jadex_model_jibximpl_binding_newinstance_4_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_4_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "parameter");
            mParameter.JiBX_src_jadex_model_jibximpl_binding_unmarshal_4_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "parameter");
            this.addParameter(mParameter);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "parameterset")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "parameterset");
            MParameterSet mParameterSet = MParameterSet.JiBX_src_jadex_model_jibximpl_binding_newinstance_4_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_4_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "parameterset");
            mParameterSet.JiBX_src_jadex_model_jibximpl_binding_unmarshal_4_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "parameterset");
            this.addParameterSet(mParameterSet);
        }
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_0(arg1);
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_3_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_2_0(arg1);
        Iterator var0 = this.iterParameters();
        while (var0.hasNext()) {
            MParameter mParameter = (MParameter)var0.next();
            arg1.startTagNamespaces(3, "parameter", new int[]{3}, new String[]{""});
            mParameter.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_4_3(arg1);
            arg1.closeStartContent();
            mParameter.JiBX_src_jadex_model_jibximpl_binding_marshal_4_4(arg1);
            arg1.endTag(3, "parameter");
        }
        Iterator var02 = this.iterParameterSets();
        while (var02.hasNext()) {
            MParameterSet mParameterSet = (MParameterSet)var02.next();
            arg1.startTagNamespaces(3, "parameterset", new int[]{3}, new String[]{""});
            mParameterSet.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_4_3(arg1);
            arg1.closeStartContent();
            mParameterSet.JiBX_src_jadex_model_jibximpl_binding_marshal_4_4(arg1);
            arg1.endTag(3, "parameterset");
        }
    }
}

