/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.config.Configuration;
import jadex.model.IMElementReference;
import jadex.model.IMExpression;
import jadex.model.IMMessageEvent;
import jadex.model.IMMessageEventReference;
import jadex.model.IMParameter;
import jadex.model.IMParameterSet;
import jadex.model.IMReferenceableElement;
import jadex.model.MessageType;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MEvent;
import jadex.model.jibximpl.MExpression;
import jadex.model.jibximpl.MParameter;
import jadex.model.jibximpl.MParameterSet;
import jadex.model.jibximpl.Report;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.util.HashSet;
import java.util.List;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MMessageEvent
extends MEvent
implements IMMessageEvent {
    protected String direction = "send_receive";
    protected String type;
    protected int degree;
    protected MessageType messagetype;
    protected List declaredparams;
    protected List declaredparamsets;
    protected MExpression match;
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    protected void init() {
        super.init();
        this.declaredparams = SCollection.createArrayList();
        this.declaredparamsets = SCollection.createArrayList();
        if (this.posttoall == null) {
            this.setPostToAll(false);
        }
        IMParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.declaredparams.add(parameters[i]);
            if (!parameters[i].getDirection().equals("fixed") || parameters[i].getDefaultValue() == null) continue;
            ++this.degree;
        }
        IMParameterSet[] parametersets = this.getParameterSets();
        for (int i = 0; i < parametersets.length; ++i) {
            this.declaredparamsets.add(parametersets[i]);
            if (!parametersets[i].getDirection().equals("fixed") || parametersets[i].getDefaultValuesExpression() == null && parametersets[i].getDefaultValues().length <= 0) continue;
            ++this.degree;
        }
        if (this.getMessageType() != null) {
            int i;
            MessageType.ParameterSpecification[] params = this.messagetype.getParameters();
            MessageType.ParameterSpecification[] paramsets = this.messagetype.getParameterSets();
            for (i = 0; i < params.length; ++i) {
                if (this.getParameter(params[i].getName()) != null) continue;
                super.createParameter(params[i].getName(), params[i].getClazz(), "inout", 0L, params[i].getDefaultValue(), null);
            }
            for (i = 0; i < paramsets.length; ++i) {
                if (this.getParameterSet(paramsets[i].getName()) != null) continue;
                super.createParameterSet(paramsets[i].getName(), paramsets[i].getClazz(), "inout", 0L, paramsets[i].getDefaultValue(), null);
            }
        }
    }

    protected void doCheck(Report report) {
        super.doCheck(report);
        if (this.match != null) {
            this.match.checkClass(Boolean.class, report);
        }
        if (this.getType() == null) {
            report.addEntry(this, "No 'type' specified.");
        } else {
            MessageType messagetype = Configuration.getConfiguration().getMessageType(this.getType());
            if (messagetype == null) {
                report.addEntry(this, "Unknown message type '" + this.getType() + "'.");
            } else {
                IMReferenceableElement p;
                int i;
                IMParameter[] mparams = this.getParameters();
                IMParameterSet[] mparamsets = this.getParameterSets();
                MessageType.ParameterSpecification[] params = messagetype.getParameters();
                MessageType.ParameterSpecification[] paramsets = messagetype.getParameterSets();
                HashSet<String> allowedparams = new HashSet<String>();
                HashSet<String> allowedparamsets = new HashSet<String>();
                for (i = 0; i < params.length; ++i) {
                    allowedparams.add(params[i].getName());
                    p = this.getParameter(params[i].getName());
                    if (p == null || p.getClazz() == null || params[i].getClazz() == null || SReflect.isSupertype(params[i].getClazz(), p.getClazz())) continue;
                    report.addEntry(p, "Unsupported parameter type '" + p.getClazz() + "', expected '" + params[i].getClazz().getName() + "'.");
                }
                for (i = 0; i < paramsets.length; ++i) {
                    allowedparamsets.add(paramsets[i].getName());
                    p = this.getParameterSet(paramsets[i].getName());
                    if (p == null || p.getClazz() == null || paramsets[i].getClazz() == null || SReflect.isSupertype(paramsets[i].getClazz(), p.getClazz())) continue;
                    report.addEntry(p, "Unsupported parameter set type '" + p.getClazz() + "', expected '" + paramsets[i].getClazz() + "'.");
                }
                for (i = 0; i < mparams.length; ++i) {
                    if (allowedparams.contains(mparams[i].getName())) continue;
                    report.addEntry(mparams[i], "Parameter '" + mparams[i].getName() + "' not supported for messages of type '" + this.getType() + "'.");
                }
                for (i = 0; i < mparamsets.length; ++i) {
                    if (allowedparamsets.contains(mparamsets[i].getName())) continue;
                    report.addEntry(mparamsets[i], "Parameter set '" + mparamsets[i].getName() + "' not supported for messages of type '" + this.getType() + "'.");
                }
            }
        }
        if ("receive".equals(this.getDirection()) || "send_receive".equals(this.getDirection())) {
            IMParameter[] mparams = this.getParameters();
            for (int i = 0; i < mparams.length; ++i) {
                if (mparams[i].getBindingOptions() == null) continue;
                report.addEntry(mparams[i], "Binding options not supported for parameters of messages with direction 'receive' or 'send_receive'.");
            }
        }
    }

    public List getChildren() {
        List ret = super.getChildren();
        if (this.match != null) {
            ret.add(this.match);
        }
        return ret;
    }

    public void doClone(MElement cl) {
        int i;
        super.doClone(cl);
        MMessageEvent clone = (MMessageEvent)cl;
        if (this.declaredparams != null) {
            clone.declaredparams = SCollection.createArrayList();
            for (i = 0; i < this.declaredparams.size(); ++i) {
                clone.declaredparams.add(((MElement)this.declaredparams.get(i)).clone());
            }
        }
        if (this.declaredparamsets != null) {
            clone.declaredparamsets = SCollection.createArrayList();
            for (i = 0; i < this.declaredparamsets.size(); ++i) {
                clone.declaredparamsets.add(((MElement)this.declaredparamsets.get(i)).clone());
            }
        }
        if (this.match != null) {
            clone.match = (MExpression)this.match.clone();
        }
    }

    protected boolean assignable(IMElementReference ref) {
        return ref instanceof IMMessageEventReference;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public IMExpression getMatchExpression() {
        return this.match;
    }

    public IMExpression createMatchExpression(String match) {
        MExpression ret = new MExpression();
        ret.setName(this.name);
        ret.setExpressionText(match);
        ret.setClazz(Boolean.class);
        ret.setEvaluationMode("dynamic");
        ret.setExported("false");
        ret.setOwner(this);
        this.match = ret;
        return ret;
    }

    public void deleteMatchExpression() {
        this.match = null;
    }

    public int getSpecializationDegree() {
        return this.degree;
    }

    public MessageType getMessageType() {
        if (this.messagetype == null) {
            this.messagetype = Configuration.getConfiguration().getMessageType(this.getType());
        }
        if (this.messagetype == null) {
            throw new RuntimeException("Message type nulls: " + this.getName());
        }
        return this.messagetype;
    }

    public void setMessageType(MessageType messagetype) {
        if (!$assertionsDisabled && messagetype == null) {
            throw new AssertionError((Object)"Message type nulls.");
        }
        this.messagetype = messagetype;
    }

    public IMParameter getParameter(String name) {
        IMParameter ret = super.getParameter(name);
        if (ret == null && this.isChecking() && this.getMessageType() != null) {
            MessageType.ParameterSpecification[] params = this.getMessageType().getParameters();
            for (int i = 0; ret == null && i < params.length; ++i) {
                if (!params[i].getName().equals(name)) continue;
                ret = new MParameter();
                ret.setName(params[i].getName());
                ret.setClazz(params[i].getClazz());
                ((MParameter)ret).setOwner(this);
            }
        }
        return ret;
    }

    public IMParameterSet getParameterSet(String name) {
        IMParameterSet ret = super.getParameterSet(name);
        if (ret == null && this.isChecking() && this.getMessageType() != null) {
            MessageType.ParameterSpecification[] params = this.getMessageType().getParameterSets();
            for (int i = 0; ret == null && i < params.length; ++i) {
                if (!params[i].getName().equals(name)) continue;
                ret = new MParameterSet();
                ret.setName(params[i].getName());
                ret.setClazz(params[i].getClazz());
                ((MParameterSet)ret).setOwner(this);
            }
        }
        return ret;
    }

    public IMParameter[] getDeclaredParameters() {
        return this.declaredparams.toArray(new IMParameter[this.declaredparams.size()]);
    }

    public IMParameterSet[] getDeclaredParameterSets() {
        return this.declaredparamsets.toArray(new IMParameterSet[this.declaredparamsets.size()]);
    }

    public IMParameter createParameter(String name, Class clazz, String direction, long updaterate, String expression, String mode) {
        IMParameter ret = super.createParameter(name, clazz, direction, updaterate, expression, mode);
        this.declaredparams.add(ret);
        return ret;
    }

    public void deleteParameter(IMParameter parameter) {
        super.deleteParameter(parameter);
        this.declaredparams.remove(parameter);
    }

    public IMParameterSet createParameterSet(String name, Class clazz, String direction, long updaterate, String expression, String mode) {
        IMParameterSet ret = super.createParameterSet(name, clazz, direction, updaterate, expression, mode);
        this.declaredparamsets.add(ret);
        return ret;
    }

    public void deleteParameterSet(IMParameterSet parameterset) {
        super.deleteParameterSet(parameterset);
        this.declaredparamsets.remove(parameterset);
    }

    static {
        $assertionsDisabled = !MMessageEvent.class.desiredAssertionStatus();
    }

    public static /* synthetic */ MMessageEvent JiBX_src_jadex_model_jibximpl_binding_newinstance_5_0(UnmarshallingContext arg1) throws JiBXException {
        return new MMessageEvent();
    }

    public final /* synthetic */ MMessageEvent JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_0(UnmarshallingContext arg1) throws JiBXException {
        MMessageEvent mMessageEvent = this;
        MEvent mEvent = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_4_0(arg1);
        this.direction = arg1.attributeText(null, "direction", "send_receive");
        this.type = arg1.attributeText(null, "type", null);
        return this;
    }

    public final /* synthetic */ MMessageEvent JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_1(UnmarshallingContext arg1) throws JiBXException {
        MMessageEvent mMessageEvent = this;
        this.preset((IUnmarshallingContext)arg1);
        arg1.pushTrackedObject((Object)this);
        MMessageEvent mMessageEvent2 = this;
        MMessageEvent mMessageEvent3 = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_5_0(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ MMessageEvent JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_1(UnmarshallingContext arg1) throws JiBXException {
        MMessageEvent mMessageEvent = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_4_0(arg1);
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "match")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "match");
            MExpression mExpression = this.match;
            if (mExpression == null) {
                mExpression = MExpression.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.match = mExpression.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "match");
            this.match.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "match");
        } else {
            this.match = null;
        }
        return this;
    }

    public final /* synthetic */ MMessageEvent JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_2(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MMessageEvent mMessageEvent = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_5_1(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_2(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_4_0(arg1);
        if (this.direction != null) {
            String string = this.direction;
            if (!Utility.isEqual((Object)string, (Object)"send_receive")) {
                marshallingContext = marshallingContext.attribute(0, "direction", string);
            }
        }
        if (this.type != null) {
            marshallingContext = marshallingContext.attribute(0, "type", this.type);
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_3(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_5_2(arg1);
        arg1.popObject();
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_5_3(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_4_0(arg1);
        if (this.match != null) {
            MExpression mExpression = this.match;
            arg1.startTagNamespaces(3, "match", new int[]{3}, new String[]{""});
            mExpression.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_4(arg1);
            arg1.closeStartContent();
            mExpression.JiBX_src_jadex_model_jibximpl_binding_marshal_3_5(arg1);
            arg1.endTag(3, "match");
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_5_4(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_5_3(arg1);
        arg1.popObject();
    }
}

