/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.ExpressionParameterInfo;
import jadex.model.IMBase;
import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMBeliefSet;
import jadex.model.IMBeliefSetReference;
import jadex.model.IMBindingCondition;
import jadex.model.IMConditionReference;
import jadex.model.IMElement;
import jadex.model.IMElementReference;
import jadex.model.IMExpression;
import jadex.model.IMExpressionParameter;
import jadex.model.IMExpressionReference;
import jadex.model.IMGoal;
import jadex.model.IMGoalReference;
import jadex.model.IMMessageEvent;
import jadex.model.IMParameter;
import jadex.model.IMParameterElement;
import jadex.model.IMParameterElementReference;
import jadex.model.IMParameterSet;
import jadex.model.IMPlan;
import jadex.model.IMPlanParameter;
import jadex.model.IMPlanTrigger;
import jadex.model.IMReference;
import jadex.model.IMReferenceableElement;
import jadex.model.IMRelevantElement;
import jadex.model.ISystemEventTypes;
import jadex.model.MessageType;
import jadex.model.jibximpl.MBase;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MExpressionParameter;
import jadex.model.jibximpl.MReferenceableElement;
import jadex.model.jibximpl.MRelevantElement;
import jadex.model.jibximpl.Report;
import jadex.parser.ITerm;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MExpression
extends MReferenceableElement
implements IMExpression {
    protected static final String BELIEF_REF = "beliefref";
    protected static final String BELIEFSET_REF = "beliefsetref";
    protected static final String GOAL_REF = "goalref";
    protected static final String PARAMETER_REF = "parameterref";
    protected static final String PARAMETERSET_REF = "parametersetref";
    protected static final IMExpression[] EMPTY_EXPRESSION_SET;
    protected String evaluationmode;
    protected String classname;
    protected String exptext;
    protected ArrayList expressionparameters;
    protected ArrayList relevantbeliefs;
    protected ArrayList relevantbeliefsets;
    protected ArrayList relevantgoals;
    protected ArrayList relevantparameters;
    protected ArrayList relevantparametersets;
    protected ITerm term;
    protected MultiCollection relevant;
    protected Class clazz;
    private static int mcnt;
    protected static IMRelevantElement[] EMPTY_RELSET;
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    public List getChildren() {
        List ret = super.getChildren();
        if (this.expressionparameters != null) {
            ret.addAll(this.expressionparameters);
        }
        if (this.relevantbeliefs != null) {
            ret.addAll(this.relevantbeliefs);
        }
        if (this.relevantbeliefsets != null) {
            ret.addAll(this.relevantbeliefsets);
        }
        if (this.relevantgoals != null) {
            ret.addAll(this.relevantgoals);
        }
        if (this.relevantparameters != null) {
            ret.addAll(this.relevantparameters);
        }
        if (this.relevantparametersets != null) {
            ret.addAll(this.relevantparametersets);
        }
        return ret;
    }

    protected void doCheck(Report report) {
        int i;
        super.doCheck(report);
        if (this.getClassname() != null && SReflect.findClass0(this.getClassname(), this.getScope().getFullImports()) == null) {
            report.addEntry(this, "Unknown type: " + this.getClassname());
        }
        try {
            this.term = this.getTerm();
        }
        catch (RuntimeException e) {
            report.addEntry(this, e.toString());
        }
        MBase.checkNameUniqueness(this, report, this.getExpressionParameters());
        IMRelevantElement[] rel = this.getRelevantBeliefs();
        for (i = 0; i < rel.length; ++i) {
            if (this.findRelevantElement(rel[i].getReference(), BELIEF_REF) != null) continue;
            report.addEntry(this, "Relevant belief '" + rel[i].getReference() + "' not found.");
        }
        rel = this.getRelevantBeliefSets();
        for (i = 0; i < rel.length; ++i) {
            if (this.findRelevantElement(rel[i].getReference(), BELIEFSET_REF) != null) continue;
            report.addEntry(this, "Relevant belief set '" + rel[i].getReference() + "' not found.");
        }
        rel = this.getRelevantGoals();
        for (i = 0; i < rel.length; ++i) {
            if (this.findRelevantElement(rel[i].getReference(), GOAL_REF) != null) continue;
            report.addEntry(this, "Relevant goal '" + rel[i].getReference() + "' not found.");
        }
        rel = this.getRelevantParameters();
        for (i = 0; i < rel.length; ++i) {
            if (this.findRelevantElement(rel[i].getReference(), PARAMETER_REF) != null) continue;
            report.addEntry(this, "Relevant parameter '" + rel[i].getReference() + "' not found.");
        }
        rel = this.getRelevantParameterSets();
        for (i = 0; i < rel.length; ++i) {
            if (this.findRelevantElement(rel[i].getReference(), PARAMETERSET_REF) != null) continue;
            report.addEntry(this, "Relevant parameter set '" + rel[i].getReference() + "' not found.");
        }
    }

    protected void checkClass(Class clazz, Report report) {
        if (clazz != null) {
            ITerm term = null;
            try {
                term = this.getTerm();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (term != null && term.getStaticType() != null && !SReflect.isSupertype(clazz, term.getStaticType())) {
                report.addEntry(this, "Type " + term.getStaticType().getName() + " of expression incompatible with required type " + clazz.getName() + ".");
            }
        }
    }

    protected boolean assignable(IMElementReference ref) {
        return ref instanceof IMExpressionReference && !(ref instanceof IMConditionReference);
    }

    public String getEvaluationMode() {
        return this.evaluationmode;
    }

    public void setEvaluationMode(String eva) {
        this.evaluationmode = eva;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getExpressionText() {
        return this.exptext;
    }

    public void setExpressionText(String expression) {
        this.exptext = expression;
    }

    public IMExpressionParameter[] getExpressionParameters() {
        if (this.expressionparameters == null) {
            return new IMExpressionParameter[0];
        }
        return this.expressionparameters.toArray(new IMExpressionParameter[this.expressionparameters.size()]);
    }

    public IMExpressionParameter createExpressionParameter(String name, Class clazz) {
        if (this.expressionparameters == null) {
            this.expressionparameters = SCollection.createArrayList();
        }
        MExpressionParameter ret = new MExpressionParameter();
        ret.setName(name);
        ret.setClazz(clazz);
        ret.setOwner(this);
        ret.init();
        this.expressionparameters.add(ret);
        return ret;
    }

    public void deleteExpressionParameter(IMExpressionParameter param) {
        if (!this.expressionparameters.remove(param)) {
            throw new RuntimeException("Could not find element to remove: " + param);
        }
    }

    public IMRelevantElement[] getRelevantBeliefs() {
        if (this.relevantbeliefs == null) {
            return EMPTY_RELSET;
        }
        return this.relevantbeliefs.toArray(new IMRelevantElement[this.relevantbeliefs.size()]);
    }

    public IMRelevantElement createRelevantBelief(String ref, String event) {
        if (this.relevantbeliefs == null) {
            this.relevantbeliefs = SCollection.createArrayList();
        }
        MRelevantElement ret = new MRelevantElement();
        ret.setReference(ref);
        ret.setEventType(event);
        ret.setOwner(this);
        ret.init();
        this.relevantbeliefs.add(ret);
        return ret;
    }

    public void deleteRelevantBelief(IMRelevantElement ref) {
        if (!this.relevantbeliefs.remove(ref)) {
            throw new RuntimeException("Element not found: " + ref);
        }
    }

    public IMRelevantElement[] getRelevantBeliefSets() {
        if (this.relevantbeliefsets == null) {
            return EMPTY_RELSET;
        }
        return this.relevantbeliefsets.toArray(new IMRelevantElement[this.relevantbeliefsets.size()]);
    }

    public IMRelevantElement createRelevantBeliefSet(String ref, String event) {
        if (this.relevantbeliefsets == null) {
            this.relevantbeliefsets = SCollection.createArrayList();
        }
        MRelevantElement ret = new MRelevantElement();
        ret.setReference(ref);
        ret.setEventType(event);
        ret.setOwner(this);
        ret.init();
        this.relevantbeliefsets.add(ret);
        return ret;
    }

    public void deleteRelevantBeliefSet(IMRelevantElement ref) {
        if (!this.relevantbeliefsets.remove(ref)) {
            throw new RuntimeException("Element not found: " + ref);
        }
    }

    public IMRelevantElement[] getRelevantGoals() {
        if (this.relevantgoals == null) {
            return EMPTY_RELSET;
        }
        return this.relevantgoals.toArray(new IMRelevantElement[this.relevantgoals.size()]);
    }

    public IMRelevantElement createRelevantGoal(String ref, String event) {
        if (this.relevantgoals == null) {
            this.relevantgoals = SCollection.createArrayList();
        }
        MRelevantElement ret = new MRelevantElement();
        ret.setReference(ref);
        ret.setEventType(event);
        ret.setOwner(this);
        ret.init();
        this.relevantgoals.add(ret);
        return ret;
    }

    public void deleteRelevantGoal(IMRelevantElement ref) {
        if (!this.relevantgoals.remove(ref)) {
            throw new RuntimeException("Element not found: " + ref);
        }
    }

    public IMRelevantElement[] getRelevantParameters() {
        if (this.relevantparameters == null) {
            return EMPTY_RELSET;
        }
        return this.relevantparameters.toArray(new IMRelevantElement[this.relevantparameters.size()]);
    }

    public IMRelevantElement createRelevantParameter(String ref, String event) {
        if (this.relevantparameters == null) {
            this.relevantparameters = SCollection.createArrayList();
        }
        MRelevantElement ret = new MRelevantElement();
        ret.setReference(ref);
        ret.setEventType(event);
        ret.setOwner(this);
        ret.init();
        this.relevantparameters.add(ret);
        return ret;
    }

    public void deleteRelevantParameter(IMRelevantElement ref) {
        if (!this.relevantparameters.remove(ref)) {
            throw new RuntimeException("Element not found: " + ref);
        }
    }

    public IMRelevantElement[] getRelevantParameterSets() {
        if (this.relevantparametersets == null) {
            return EMPTY_RELSET;
        }
        return this.relevantparametersets.toArray(new IMRelevantElement[this.relevantparametersets.size()]);
    }

    public IMRelevantElement createRelevantParameterSet(String ref, String event) {
        if (this.relevantparametersets == null) {
            this.relevantparametersets = SCollection.createArrayList();
        }
        MRelevantElement ret = new MRelevantElement();
        ret.setReference(ref);
        ret.setEventType(event);
        ret.setOwner(this);
        ret.init();
        this.relevantparametersets.add(ret);
        return ret;
    }

    public void deleteRelevantParameterSet(IMRelevantElement ref) {
        if (!this.relevantparametersets.remove(ref)) {
            throw new RuntimeException("Element not found: " + ref);
        }
    }

    public String getName() {
        if (this.name == null) {
            if (!$assertionsDisabled && this.isChecking()) {
                throw new AssertionError();
            }
            String name = SReflect.getInnerClassName(this.getClass()) + "#" + ++mcnt;
            this.setName(name);
        }
        return super.getName();
    }

    public List getSystemExpressionParameters() {
        List exparams = super.getSystemExpressionParameters();
        IMPlan plan = null;
        if (this.getOwner() instanceof IMPlan && ((IMPlan)this.getOwner()).getPrecondition() == this) {
            plan = (IMPlan)this.getOwner();
            IMParameter[] bps = plan.getBindingParameters();
            for (int i = 0; i < bps.length; ++i) {
                exparams.add(new ExpressionParameterInfo(bps[i].getName(), null, bps[i].getClazz()));
            }
        }
        if (this.getOwner() instanceof IMPlanParameter) {
            plan = (IMPlan)this.getOwner().getOwner();
        }
        if (plan != null && plan.getTrigger() != null) {
            IMReference[] ierefs;
            IMReference[] grefs = plan.getTrigger().getGoals();
            if (grefs.length > 0) {
                IMReferenceableElement gref = this.getScope().getGoalbase().getReferenceableElement(grefs[0].getReference());
                if (!$assertionsDisabled && gref == null) {
                    throw new AssertionError();
                }
                exparams.add(new ExpressionParameterInfo("$goal", (IMElement)gref, "jadex.runtime.impl.IRGoal"));
            }
            if ((ierefs = plan.getTrigger().getInternalEvents()).length > 0) {
                IMReferenceableElement ieref = this.getScope().getEventbase().getReferenceableElement(ierefs[0].getReference());
                if (!$assertionsDisabled && ieref == null) {
                    throw new AssertionError();
                }
                exparams.add(new ExpressionParameterInfo("$event", (IMElement)ieref, "jadex.runtime.impl.IREvent"));
            } else {
                IMReference[] merefs = plan.getTrigger().getMessageEvents();
                if (merefs.length > 0) {
                    IMReferenceableElement meref = this.getScope().getEventbase().getReferenceableElement(merefs[0].getReference());
                    if (!$assertionsDisabled && meref == null) {
                        throw new AssertionError();
                    }
                    exparams.add(new ExpressionParameterInfo("$event", (IMElement)meref, "jadex.runtime.impl.IREvent"));
                }
            }
        }
        if (this.getOwner() instanceof IMMessageEvent && ((IMMessageEvent)this.getOwner()).getMatchExpression() == this) {
            IMMessageEvent mevent = (IMMessageEvent)this.getOwner();
            IMParameter[] params = mevent.getParameters();
            HashSet allps = SCollection.createHashSet();
            for (int i = 0; i < params.length; ++i) {
                allps.add(params[i].getName());
                String paramname = "$" + SUtil.replace(params[i].getName(), "-", "_");
                exparams.add(new ExpressionParameterInfo(paramname, (IMElement)params[i], params[i].getClazz()));
            }
            IMParameterSet[] paramsets = mevent.getParameterSets();
            for (int i = 0; i < paramsets.length; ++i) {
                allps.add(paramsets[i].getName());
                String paramsetname = "$" + SUtil.replace(paramsets[i].getName(), "-", "_");
                exparams.add(new ExpressionParameterInfo(paramsetname, (IMElement)paramsets[i], Array.newInstance(paramsets[i].getClazz(), new int[1]).getClass()));
            }
            exparams.add(new ExpressionParameterInfo("$messagemap", null, Map.class));
            if (this.isChecking()) {
                int i;
                MessageType mt = mevent.getMessageType();
                MessageType.ParameterSpecification[] ps = mt.getParameters();
                for (i = 0; i < ps.length; ++i) {
                    if (allps.contains(ps[i].getName())) continue;
                    String paramname = "$" + SUtil.replace(ps[i].getName(), "-", "_");
                    exparams.add(new ExpressionParameterInfo(paramname, null, ps[i].getClazz()));
                }
                ps = mt.getParameterSets();
                for (i = 0; i < ps.length; ++i) {
                    if (allps.contains(ps[i].getName())) continue;
                    String paramsetname = "$" + SUtil.replace(ps[i].getName(), "-", "_");
                    exparams.add(new ExpressionParameterInfo(paramsetname, null, Array.newInstance(ps[i].getClazz(), new int[1]).getClass()));
                }
            }
        }
        return exparams;
    }

    public MultiCollection getRelevantList() {
        if (this.relevant == null) {
            String type;
            String ref;
            int i;
            this.relevant = new MultiCollection(SCollection.createHashMap(), HashSet.class);
            IMRelevantElement[] rels = this.getRelevantBeliefs();
            for (i = 0; i < rels.length; ++i) {
                ref = rels[i].getReference();
                type = rels[i].getEventType();
                this.addEventType(type, ref, BELIEF_REF);
            }
            rels = this.getRelevantBeliefSets();
            for (i = 0; i < rels.length; ++i) {
                ref = rels[i].getReference();
                type = rels[i].getEventType();
                this.addEventType(type, ref, BELIEFSET_REF);
            }
            rels = this.getRelevantGoals();
            for (i = 0; i < rels.length; ++i) {
                ref = rels[i].getReference();
                type = rels[i].getEventType();
                this.addEventType(type, ref, GOAL_REF);
            }
            rels = this.getRelevantParameters();
            for (i = 0; i < rels.length; ++i) {
                ref = rels[i].getReference();
                type = rels[i].getEventType();
                this.addEventType(type, ref, PARAMETER_REF);
            }
            rels = this.getRelevantParameterSets();
            for (i = 0; i < rels.length; ++i) {
                ref = rels[i].getReference();
                type = rels[i].getEventType();
                this.addEventType(type, ref, PARAMETERSET_REF);
            }
            this.determineEvents();
        }
        return this.relevant;
    }

    public ITerm getTerm() {
        if (this.term == null && this.exptext != null && this.exptext.length() > 0) {
            List exparams = this.getSystemExpressionParameters();
            IMExpressionParameter[] exps = this.getExpressionParameters();
            for (int i = 0; i < exps.length; ++i) {
                exparams.add(new ExpressionParameterInfo(exps[i].getName(), null, exps[i].getClazz()));
            }
            ITerm term = this.getScope().getParser().parseExpression(this.getExpressionText(), exparams);
            if (this.isChecking()) {
                return term;
            }
            this.term = term;
        }
        return this.term;
    }

    public Class getClazz() {
        if (this.clazz == null && this.getClassname() != null) {
            this.clazz = SReflect.findClass0(this.getClassname(), this.getScope().getFullImports());
        }
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
        this.setClassname(this.getClassname() != null ? clazz.getName() : null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SReflect.getInnerClassName(this.getClass()));
        sb.append("(expression = ");
        sb.append(this.exptext);
        sb.append(")");
        return sb.toString();
    }

    public void addExpressionParameter(IMExpressionParameter exp) {
        if (this.expressionparameters == null) {
            this.expressionparameters = SCollection.createArrayList();
        }
        this.expressionparameters.add(exp);
    }

    public Iterator iterExpressionParameters() {
        return this.expressionparameters == null ? Collections.EMPTY_LIST.iterator() : this.expressionparameters.iterator();
    }

    public void addRelevantBelief(IMRelevantElement rel) {
        if (this.relevantbeliefs == null) {
            this.relevantbeliefs = SCollection.createArrayList();
        }
        this.relevantbeliefs.add(rel);
    }

    public Iterator iterRelevantBeliefs() {
        return this.relevantbeliefs == null ? Collections.EMPTY_LIST.iterator() : this.relevantbeliefs.iterator();
    }

    public void addRelevantBeliefSet(IMRelevantElement rel) {
        if (this.relevantbeliefsets == null) {
            this.relevantbeliefsets = SCollection.createArrayList();
        }
        this.relevantbeliefsets.add(rel);
    }

    public Iterator iterRelevantBeliefSets() {
        return this.relevantbeliefsets == null ? Collections.EMPTY_LIST.iterator() : this.relevantbeliefsets.iterator();
    }

    public void addRelevantGoal(IMRelevantElement rel) {
        if (this.relevantgoals == null) {
            this.relevantgoals = SCollection.createArrayList();
        }
        this.relevantgoals.add(rel);
    }

    public Iterator iterRelevantGoals() {
        return this.relevantgoals == null ? Collections.EMPTY_LIST.iterator() : this.relevantgoals.iterator();
    }

    public void addRelevantParameter(IMRelevantElement rel) {
        if (this.relevantparameters == null) {
            this.relevantparameters = SCollection.createArrayList();
        }
        this.relevantparameters.add(rel);
    }

    public Iterator iterRelevantParameters() {
        return this.relevantparameters == null ? Collections.EMPTY_LIST.iterator() : this.relevantparameters.iterator();
    }

    public void addRelevantParameterSet(IMRelevantElement rel) {
        if (this.relevantparametersets == null) {
            this.relevantparametersets = SCollection.createArrayList();
        }
        this.relevantparametersets.add(rel);
    }

    public Iterator iterRelevantParameterSets() {
        return this.relevantparametersets == null ? Collections.EMPTY_LIST.iterator() : this.relevantparametersets.iterator();
    }

    protected void initAssignToElements() {
        if (!$assertionsDisabled && this.getOwner() == null) {
            throw new AssertionError((Object)this.getExpressionText());
        }
        if (this.getOwner() instanceof IMBase) {
            super.initAssignToElements();
        }
    }

    protected void determineEvents() {
        List rels = this.getTerm().getRelevantEventtypes();
        for (int i = 0; i < rels.size(); ++i) {
            String[] tmp = (String[])rels.get(i);
            if (tmp[0].equals("$beliefbase")) {
                IMReferenceableElement elm = this.getScope().getBeliefbase().getReferenceableElement(tmp[1]);
                if (elm instanceof IMBelief || elm instanceof IMBeliefReference) {
                    this.addEventType(null, elm.getName(), BELIEF_REF);
                    continue;
                }
                if (elm != null) {
                    this.addEventType(null, elm.getName(), BELIEFSET_REF);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)(tmp[0] + " " + tmp[1]));
                }
                continue;
            }
            if (tmp[0].equals("$goalbase")) {
                if (tmp[1] == null) {
                    this.addEventType("BDI_goal", "any_element_indicator", null);
                    continue;
                }
                this.addEventType(null, tmp[1], GOAL_REF);
                continue;
            }
            if (tmp[0].equals("$goal")) {
                if (this.getOwner() instanceof IMGoal) {
                    if (((IMGoal)this.getOwner()).getParameter(tmp[1]) != null) {
                        this.addEventType(null, tmp[1], PARAMETER_REF);
                        continue;
                    }
                    if (((IMGoal)this.getOwner()).getParameterSet(tmp[1]) != null) {
                        this.addEventType(null, tmp[1], PARAMETERSET_REF);
                        continue;
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)(tmp[0] + " " + tmp[1]));
                    }
                    continue;
                }
                if (!(this.getOwner() instanceof IMGoalReference)) continue;
                if (((IMGoalReference)this.getOwner()).getParameterReference(tmp[1]) != null) {
                    this.addEventType(null, tmp[1], PARAMETER_REF);
                    continue;
                }
                if (((IMGoalReference)this.getOwner()).getParameterSetReference(tmp[1]) != null) {
                    this.addEventType(null, tmp[1], PARAMETERSET_REF);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)(tmp[0] + " " + tmp[1]));
                }
                continue;
            }
            if (!tmp[0].equals("$plan") || !(this.getOwner() instanceof IMPlan)) continue;
            if (((IMPlan)this.getOwner()).getParameter(tmp[1]) != null) {
                this.addEventType(null, tmp[1], PARAMETER_REF);
                continue;
            }
            if (((IMPlan)this.getOwner()).getParameterSet(tmp[1]) != null) {
                this.addEventType(null, tmp[1], PARAMETERSET_REF);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)(tmp[0] + " " + tmp[1]));
            }
        }
        if (this instanceof IMBindingCondition) {
            IMElement owner;
            for (owner = this.getOwner(); !(owner instanceof IMParameterElement) && owner != null; owner = owner.getOwner()) {
            }
            if (!$assertionsDisabled && owner == null) {
                throw new AssertionError((Object)(this + ", " + this.getOwner()));
            }
            IMParameter[] bindings = ((IMParameterElement)owner).getBindingParameters();
            if (bindings.length > 0) {
                for (int i = 0; i < bindings.length; ++i) {
                    this.addEventType("BDI_bindingChanged", bindings[i].getName(), PARAMETER_REF);
                }
            }
        }
    }

    protected void addEventType(String eventtype, String modelref, String reftype) {
        Object rel = this.findRelevantElement(modelref, reftype);
        if (rel == null) {
            rel = "any_element_indicator";
        }
        if (BELIEF_REF.equals(reftype)) {
            if (eventtype == null) {
                eventtype = "BDI_factChanged";
            }
        } else if (BELIEFSET_REF.equals(reftype)) {
            if (eventtype == null) {
                eventtype = "BDI_bsfactsChanged";
            }
        } else if (GOAL_REF.equals(reftype)) {
            if (eventtype == null) {
                eventtype = "BDI_goal";
            }
        } else if (PARAMETER_REF.equals(reftype)) {
            if (eventtype == null) {
                eventtype = "BDI_valueChanged";
            }
        } else if (PARAMETERSET_REF.equals(reftype) && eventtype == null) {
            eventtype = "BDI_esValuesChanged";
        }
        Collection types = ISystemEventTypes.Subtypes.getSubtypes(eventtype);
        Iterator itypes = types.iterator();
        while (itypes.hasNext()) {
            this.relevant.put(rel, itypes.next());
        }
    }

    protected IMReferenceableElement findRelevantElement(String modelref, String reftype) {
        IMReferenceableElement refelem = null;
        if (BELIEF_REF.equals(reftype)) {
            refelem = this.getScope().getBeliefbase().getReferenceableElement(modelref);
            if (!(refelem instanceof IMBelief) && !(refelem instanceof IMBeliefReference)) {
                refelem = null;
            }
        } else if (BELIEFSET_REF.equals(reftype)) {
            refelem = this.getScope().getBeliefbase().getReferenceableElement(modelref);
            if (!(refelem instanceof IMBeliefSet) && !(refelem instanceof IMBeliefSetReference)) {
                refelem = null;
            }
        } else if (GOAL_REF.equals(reftype)) {
            refelem = this.getScope().getGoalbase().getReferenceableElement(modelref);
        } else if (PARAMETER_REF.equals(reftype) || PARAMETERSET_REF.equals(reftype)) {
            IMElement pe = null;
            String paramref = modelref;
            if (modelref.indexOf(".") != -1) {
                String peref = modelref.substring(0, modelref.lastIndexOf("."));
                paramref = modelref.substring(modelref.lastIndexOf(".") + 1);
                pe = this.getScope().getGoalbase().getReferenceableElement(peref);
                if (pe == null) {
                    pe = this.getScope().getPlanbase().getReferenceableElement(peref);
                }
                if (pe == null) {
                    pe = this.getScope().getEventbase().getReferenceableElement(peref);
                }
            } else if (this.getOwner() instanceof IMParameterElement || this.getOwner() instanceof IMParameterElementReference) {
                pe = this.getOwner();
            } else if (this.getOwner() instanceof IMPlanTrigger) {
                pe = this.getOwner().getOwner();
            }
            if (pe != null) {
                refelem = PARAMETER_REF.equals(reftype) ? (pe instanceof IMParameterElement ? ((IMParameterElement)pe).getParameter(paramref) : ((IMParameterElementReference)pe).getParameterReference(paramref)) : (pe instanceof IMParameterElement ? ((IMParameterElement)pe).getParameterSet(paramref) : ((IMParameterElementReference)pe).getParameterSetReference(paramref));
            }
        }
        return refelem;
    }

    public void doClone(MElement cl) {
        int i;
        super.doClone(cl);
        MExpression clone = (MExpression)cl;
        this.relevant = null;
        if (this.expressionparameters != null) {
            clone.expressionparameters = SCollection.createArrayList();
            for (i = 0; i < this.expressionparameters.size(); ++i) {
                clone.expressionparameters.add(((MElement)this.expressionparameters.get(i)).clone());
            }
        }
        if (this.relevantbeliefs != null) {
            clone.relevantbeliefs = SCollection.createArrayList();
            for (i = 0; i < this.relevantbeliefs.size(); ++i) {
                clone.relevantbeliefs.add(((MElement)this.relevantbeliefs.get(i)).clone());
            }
        }
        if (this.relevantbeliefsets != null) {
            clone.relevantbeliefsets = SCollection.createArrayList();
            for (i = 0; i < this.relevantbeliefsets.size(); ++i) {
                clone.relevantbeliefsets.add(((MElement)this.relevantbeliefsets.get(i)).clone());
            }
        }
        if (this.relevantgoals != null) {
            clone.relevantgoals = SCollection.createArrayList();
            for (i = 0; i < this.relevantgoals.size(); ++i) {
                clone.relevantgoals.add(((MElement)this.relevantgoals.get(i)).clone());
            }
        }
        if (this.relevantparameters != null) {
            clone.relevantparameters = SCollection.createArrayList();
            for (i = 0; i < this.relevantparameters.size(); ++i) {
                clone.relevantparameters.add(((MElement)this.relevantparameters.get(i)).clone());
            }
        }
        if (this.relevantparametersets != null) {
            clone.relevantparametersets = SCollection.createArrayList();
            for (i = 0; i < this.relevantparametersets.size(); ++i) {
                clone.relevantparametersets.add(((MElement)this.relevantparametersets.get(i)).clone());
            }
        }
    }

    static {
        $assertionsDisabled = !MExpression.class.desiredAssertionStatus();
        EMPTY_EXPRESSION_SET = new IMExpression[0];
        EMPTY_RELSET = new IMRelevantElement[0];
    }

    public static /* synthetic */ MExpression JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(UnmarshallingContext arg1) throws JiBXException {
        return new MExpression();
    }

    public final /* synthetic */ MExpression JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_0(UnmarshallingContext arg1) throws JiBXException {
        MExpression mExpression = this;
        MElement mElement = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_1_0(arg1);
        this.exported = arg1.attributeText(null, "exported", "false");
        this.evaluationmode = arg1.attributeText(null, "evaluationmode", null);
        this.classname = arg1.attributeText(null, "class", null);
        return this;
    }

    public final /* synthetic */ MExpression JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(UnmarshallingContext arg1) throws JiBXException {
        MExpression mExpression = this;
        this.preset((IUnmarshallingContext)arg1);
        arg1.pushTrackedObject((Object)this);
        MExpression mExpression2 = this;
        MExpression mExpression3 = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_0(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ MExpression JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_1(UnmarshallingContext arg1) throws JiBXException {
        MExpression mExpression = this;
        this.setExpressionText(arg1.parseContentText());
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "assignto")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "assignto");
            String string = arg1.attributeText(null, "ref");
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "assignto");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "assignto");
            this.addAssignToName(string);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "parameter")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "parameter");
            MExpressionParameter mExpressionParameter = MExpressionParameter.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "parameter");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "parameter");
            this.addExpressionParameter(mExpressionParameter);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "relevantbelief")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "relevantbelief");
            MRelevantElement mRelevantElement = MRelevantElement.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "relevantbelief");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "relevantbelief");
            this.addRelevantBelief(mRelevantElement);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "relevantbeliefset")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "relevantbeliefset");
            MRelevantElement mRelevantElement = MRelevantElement.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "relevantbeliefset");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "relevantbeliefset");
            this.addRelevantBeliefSet(mRelevantElement);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "relevantgoal")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "relevantgoal");
            MRelevantElement mRelevantElement = MRelevantElement.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "relevantgoal");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "relevantgoal");
            this.addRelevantGoal(mRelevantElement);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "relevantparameter")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "relevantparameter");
            MRelevantElement mRelevantElement = MRelevantElement.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "relevantparameter");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "relevantparameter");
            this.addRelevantParameter(mRelevantElement);
        }
        while (arg1.isAt("http://jadex.sourceforge.net/jadex", "relevantparameterset")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "relevantparameterset");
            MRelevantElement mRelevantElement = MRelevantElement.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "relevantparameterset");
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "relevantparameterset");
            this.addRelevantParameterSet(mRelevantElement);
        }
        return this;
    }

    public final /* synthetic */ MExpression JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MExpression mExpression = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_1(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_1_0(arg1);
        if (this.exported != null) {
            String string = this.exported;
            if (!Utility.isEqual((Object)string, (Object)"false")) {
                marshallingContext = marshallingContext.attribute(0, "exported", string);
            }
        }
        if (this.evaluationmode != null) {
            marshallingContext = marshallingContext.attribute(0, "evaluationmode", this.evaluationmode);
        }
        if (this.classname != null) {
            marshallingContext = marshallingContext.attribute(0, "class", this.classname);
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_4(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
        arg1.popObject();
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        if (this.getExpressionText() != null) {
            marshallingContext = marshallingContext.writeContent(this.getExpressionText());
        }
        Iterator var0 = this.iterAssignToNames();
        while (var0.hasNext()) {
            void var3_3;
            String string = (String)var0.next();
            arg1.startTagNamespaces(3, "assignto", new int[]{3}, new String[]{""});
            String var1 = string;
            marshallingContext = marshallingContext.attribute(0, "ref", (String)var3_3);
            arg1.closeStartEmpty();
        }
        Iterator var02 = this.iterExpressionParameters();
        while (var02.hasNext()) {
            MExpressionParameter mExpressionParameter = (MExpressionParameter)var02.next();
            arg1.startTagNamespaces(3, "parameter", new int[]{3}, new String[]{""});
            mExpressionParameter.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_2(arg1);
            arg1.closeStartEmpty();
        }
        Iterator var03 = this.iterRelevantBeliefs();
        while (var03.hasNext()) {
            MRelevantElement mRelevantElement = (MRelevantElement)var03.next();
            arg1.startTagNamespaces(3, "relevantbelief", new int[]{3}, new String[]{""});
            mRelevantElement.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_3(arg1);
            arg1.closeStartEmpty();
        }
        Iterator var04 = this.iterRelevantBeliefSets();
        while (var04.hasNext()) {
            MRelevantElement mRelevantElement = (MRelevantElement)var04.next();
            arg1.startTagNamespaces(3, "relevantbeliefset", new int[]{3}, new String[]{""});
            mRelevantElement.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_3(arg1);
            arg1.closeStartEmpty();
        }
        Iterator var05 = this.iterRelevantGoals();
        while (var05.hasNext()) {
            MRelevantElement mRelevantElement = (MRelevantElement)var05.next();
            arg1.startTagNamespaces(3, "relevantgoal", new int[]{3}, new String[]{""});
            mRelevantElement.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_3(arg1);
            arg1.closeStartEmpty();
        }
        Iterator var06 = this.iterRelevantParameters();
        while (var06.hasNext()) {
            MRelevantElement mRelevantElement = (MRelevantElement)var06.next();
            arg1.startTagNamespaces(3, "relevantparameter", new int[]{3}, new String[]{""});
            mRelevantElement.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_3(arg1);
            arg1.closeStartEmpty();
        }
        Iterator var07 = this.iterRelevantParameterSets();
        while (var07.hasNext()) {
            MRelevantElement mRelevantElement = (MRelevantElement)var07.next();
            arg1.startTagNamespaces(3, "relevantparameterset", new int[]{3}, new String[]{""});
            mRelevantElement.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_3(arg1);
            arg1.closeStartEmpty();
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_3_5(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
        arg1.popObject();
    }
}

