/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.config.Configuration;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IReport;
import jadex.model.SXML;
import jadex.model.jibximpl.MCapability;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.Report;
import java.io.IOException;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MCapabilityReference
extends MElement
implements IMCapabilityReference {
    protected String file;
    protected IMCapability inner;
    protected IMCapability check;
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    protected void init() {
        super.init();
        if (!$assertionsDisabled && this.check != null) {
            throw new AssertionError(this);
        }
    }

    protected void doCheck(Report report) {
        super.doCheck(report);
        if (this.getFile() == null) {
            report.addEntry(this, "A 'file' has to be specified.");
        } else {
            IMCapability cap = this.getCapability();
            if (cap == null) {
                report.addEntry(this, "Cannot load capability file '" + this.getFile() + "'.");
            } else {
                IReport rep2 = cap.getReport();
                if (!rep2.isEmpty()) {
                    report.addEntry(this, "Loaded capability <a href=\"#" + cap.getFullName() + "\">" + cap.getFullName() + "</a> has errors.");
                    report.addDocument(cap.getFullName(), rep2.toHTMLString());
                    report.getDocuments().putAll(rep2.getDocuments());
                }
            }
        }
    }

    protected void doCheckCleanup() {
        super.doCheckCleanup();
        this.check = null;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public IMCapability getCapability() {
        if (this.isChecking()) {
            if (this.check == null) {
                this.check = this.loadCapability();
            }
        } else if (this.inner == null) {
            this.inner = this.loadCapability();
        }
        return this.isChecking() ? this.check : this.inner;
    }

    protected IMCapability loadCapability() {
        String capaname = "capability." + this.getFile();
        String ref = Configuration.getConfiguration().getProperty(capaname);
        if (ref == null) {
            ref = this.getFile();
        }
        IMCapability ret = null;
        try {
            ret = SXML.loadCapabilityModel(ref, this.getScope().getFullImports(), this.getScope());
        }
        catch (IOException e) {
            // empty catch block
        }
        return ret;
    }

    public void doClone(MElement cl) {
        super.doClone(cl);
        MCapabilityReference clone = (MCapabilityReference)cl;
        if (this.inner != null) {
            clone.inner = (IMCapability)((MCapability)this.inner).clone();
        }
    }

    static {
        $assertionsDisabled = !MCapabilityReference.class.desiredAssertionStatus();
    }

    public static /* synthetic */ MCapabilityReference JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new MCapabilityReference();
    }

    public final /* synthetic */ MCapabilityReference JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        MCapabilityReference mCapabilityReference = this;
        MElement mElement = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_1_0(arg1);
        this.file = arg1.attributeText(null, "file");
        return this;
    }

    public final /* synthetic */ MCapabilityReference JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(UnmarshallingContext arg1) throws JiBXException {
        MCapabilityReference mCapabilityReference = this;
        this.preset((IUnmarshallingContext)arg1);
        arg1.pushTrackedObject((Object)this);
        MCapabilityReference mCapabilityReference2 = this;
        MCapabilityReference mCapabilityReference3 = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_0(arg1);
        arg1.popObject();
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_1(MarshallingContext arg1) throws JiBXException {
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_1_0(arg1);
        MarshallingContext marshallingContext = arg1.attribute(0, "file", this.file);
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_2(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_1(arg1);
        arg1.popObject();
    }
}

