/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.model.ExpressionParameterInfo;
import jadex.model.IMBeliefbase;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMConfigurationbase;
import jadex.model.IMElement;
import jadex.model.IMEventbase;
import jadex.model.IMExpressionbase;
import jadex.model.IMGoalbase;
import jadex.model.IMPlanbase;
import jadex.model.IMPropertybase;
import jadex.model.jibximpl.MBase;
import jadex.model.jibximpl.MBeliefbase;
import jadex.model.jibximpl.MCapabilityReference;
import jadex.model.jibximpl.MConfigurationbase;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MEventbase;
import jadex.model.jibximpl.MExpressionbase;
import jadex.model.jibximpl.MGoalbase;
import jadex.model.jibximpl.MPlanbase;
import jadex.model.jibximpl.MPropertybase;
import jadex.model.jibximpl.Report;
import jadex.parser.IParser;
import jadex.parser.SParser;
import jadex.util.DynamicURLClassLoader;
import jadex.util.collection.SCollection;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MCapability
extends MElement
implements IMCapability {
    protected String packagename;
    protected boolean isabstract = false;
    protected MBeliefbase beliefbase;
    protected MGoalbase goalbase;
    protected MPlanbase planbase;
    protected MEventbase eventbase;
    protected MExpressionbase expressionbase;
    protected MPropertybase propertybase;
    protected MConfigurationbase configurationbase;
    protected ArrayList imports;
    protected ArrayList capabilityrefs;
    protected transient IParser parser;
    protected String filename;
    protected long lastmodified;
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    public List getChildren() {
        List ret = super.getChildren();
        if (this.capabilityrefs != null) {
            ret.addAll(this.capabilityrefs);
        }
        if (this.beliefbase != null) {
            ret.add(this.beliefbase);
        }
        if (this.goalbase != null) {
            ret.add(this.goalbase);
        }
        if (this.planbase != null) {
            ret.add(this.planbase);
        }
        if (this.eventbase != null) {
            ret.add(this.eventbase);
        }
        if (this.expressionbase != null) {
            ret.add(this.expressionbase);
        }
        if (this.propertybase != null) {
            ret.add(this.propertybase);
        }
        if (this.configurationbase != null) {
            ret.add(this.configurationbase);
        }
        return ret;
    }

    protected void doCheck(Report report) {
        super.doCheck(report);
        if (this.getName() == null) {
            report.addEntry(this, "Element requires a name.");
        } else {
            String expected = this.getName() + this.getFileExtension();
            boolean match = this.filename.endsWith(expected);
            if (match && this.filename.length() > expected.length()) {
                char prefix = this.filename.charAt(this.filename.length() - expected.length() - 1);
                boolean bl = match = prefix == '/' || prefix == File.separatorChar;
            }
            if (!match) {
                report.addEntry(this, "Name conflict between model name '" + this.getName() + "' and filename '" + this.filename + "'");
            }
        }
        String actpkg = DynamicURLClassLoader.getPackageOfFileFromInstance(this.filename);
        if (actpkg != null && !actpkg.equals(this.packagename == null ? "" : this.packagename)) {
            report.addEntry(this, "File is contained in package '" + (actpkg.equals("") ? "default" : actpkg) + "' but declared in '" + (this.packagename == null || this.packagename.equals("") ? "default" : this.packagename) + "'." + "Maybe, this error is not caused by the file itself, but due to adding the wrong (sub-)directory to the project tree or classpath.");
        }
        MBase.checkNameUniqueness(this, report, this.getCapabilityReferences());
    }

    protected String getFileExtension() {
        return ".capability.xml";
    }

    public String getPackage() {
        return this.packagename;
    }

    public void setPackage(String _package) {
        this.packagename = _package;
    }

    public String[] getImports() {
        if (this.imports == null) {
            return new String[0];
        }
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public void createImport(String exp) {
        if (this.imports == null) {
            this.imports = SCollection.createArrayList();
        }
        this.imports.add(exp);
        this.parser = null;
    }

    public void deleteImport(String exp) {
        if (!this.imports.remove(exp)) {
            throw new RuntimeException("Could not find in imports: " + exp);
        }
    }

    public IMCapabilityReference[] getCapabilityReferences() {
        if (this.capabilityrefs == null) {
            return new IMCapabilityReference[0];
        }
        return this.capabilityrefs.toArray(new IMCapabilityReference[this.capabilityrefs.size()]);
    }

    public IMCapabilityReference getCapabilityReference(String name) {
        IMCapabilityReference ret = null;
        for (int i = 0; this.capabilityrefs != null && i < this.capabilityrefs.size(); ++i) {
            IMCapabilityReference tmp = (IMCapabilityReference)this.capabilityrefs.get(i);
            if (!name.equals(tmp.getName())) continue;
            ret = tmp;
        }
        return ret;
    }

    public IMCapabilityReference createCapabilityReference(String name, String file) {
        if (this.capabilityrefs == null) {
            this.capabilityrefs = SCollection.createArrayList();
        }
        MCapabilityReference ret = new MCapabilityReference();
        ret.setName(name);
        ret.setFile(file);
        ret.setOwner(this);
        ret.init();
        this.capabilityrefs.add(ret);
        return ret;
    }

    public void deleteCapabilityReference(IMCapabilityReference reference) {
        if (!this.capabilityrefs.remove(reference)) {
            throw new RuntimeException("Could not find capability reference: " + reference);
        }
    }

    public boolean isAbstract() {
        return this.isabstract;
    }

    public void setAbstract(boolean isabstract) {
        this.isabstract = isabstract;
    }

    public IMBeliefbase getBeliefbase() {
        if (this.beliefbase == null) {
            this.beliefbase = new MBeliefbase();
            this.beliefbase.setOwner(this);
            if (this.inited) {
                this.beliefbase.init();
            }
        } else if (this.inited && !this.beliefbase.inited) {
            this.beliefbase.init();
        }
        return this.beliefbase;
    }

    public IMGoalbase getGoalbase() {
        if (this.goalbase == null) {
            this.goalbase = new MGoalbase();
            this.goalbase.setOwner(this);
            if (this.inited) {
                this.goalbase.init();
            }
        } else if (this.inited && !this.goalbase.inited) {
            this.goalbase.init();
        }
        return this.goalbase;
    }

    public IMPlanbase getPlanbase() {
        if (this.planbase == null) {
            this.planbase = new MPlanbase();
            this.planbase.setOwner(this);
            if (this.inited) {
                this.planbase.init();
            }
        } else if (this.inited && !this.planbase.inited) {
            this.planbase.init();
        }
        return this.planbase;
    }

    public IMEventbase getEventbase() {
        if (this.eventbase == null) {
            this.eventbase = new MEventbase();
            this.eventbase.setOwner(this);
            if (this.inited) {
                this.eventbase.init();
            }
        } else if (this.inited && !this.eventbase.inited) {
            this.eventbase.init();
        }
        return this.eventbase;
    }

    public IMExpressionbase getExpressionbase() {
        if (this.expressionbase == null) {
            this.expressionbase = new MExpressionbase();
            this.expressionbase.setOwner(this);
            if (this.inited) {
                this.expressionbase.init();
            }
        } else if (this.inited && !this.expressionbase.inited) {
            this.expressionbase.init();
        }
        return this.expressionbase;
    }

    public IMPropertybase getPropertybase() {
        if (this.propertybase == null) {
            this.propertybase = new MPropertybase();
            this.propertybase.setOwner(this);
            if (this.inited) {
                this.propertybase.init();
            }
        } else if (this.inited && !this.propertybase.inited) {
            this.propertybase.init();
        }
        return this.propertybase;
    }

    public IMConfigurationbase getConfigurationbase() {
        if (this.configurationbase == null) {
            this.configurationbase = new MConfigurationbase();
            this.configurationbase.setOwner(this);
            if (this.inited) {
                this.configurationbase.init();
            }
        } else if (this.inited && !this.configurationbase.inited) {
            this.configurationbase.init();
        }
        return this.configurationbase;
    }

    protected boolean isChecking() {
        return this.checking;
    }

    public String[] getFullImports() {
        String[] ret;
        String[] stringArray = ret = this.imports == null ? null : this.imports.toArray(new String[this.imports.size()]);
        if (this.getPackage() != null) {
            if (ret != null) {
                String[] tmp = new String[ret.length + 1];
                tmp[0] = this.getPackage() + ".*";
                System.arraycopy(ret, 0, tmp, 1, ret.length);
                ret = tmp;
            } else {
                ret = new String[]{this.getPackage() + ".*"};
            }
        }
        return ret;
    }

    public IParser getParser() {
        if (this.parser == null) {
            String cachename = this.getFilename().substring(0, this.getFilename().length() - 3) + "prec";
            if (this.getFilename().startsWith("jar:") || this.getFilename().startsWith("http:") || this.getFilename().startsWith("ftp:")) {
                try {
                    new URL(this.filename).openConnection();
                }
                catch (IOException e) {
                    File f = new File(".");
                    String ft = this.getFilename().endsWith("agent.xml") ? "agent" : "capability";
                    cachename = f.getAbsolutePath() + File.separator + this.getFullName() + ft + ".prec";
                }
            }
            this.parser = SParser.createParser(this.getFullImports(), cachename, this.getLastModified());
        }
        return this.parser;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    public void setLastModified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public String getFullName() {
        return this.getPackage() != null && this.getPackage().length() > 0 ? this.getPackage() + "." + this.getName() : this.getName();
    }

    public Iterator iterImports() {
        return this.imports == null ? Collections.EMPTY_LIST.iterator() : this.imports.iterator();
    }

    public void addCapabilityReference(IMCapabilityReference ref) {
        if (this.capabilityrefs == null) {
            this.capabilityrefs = SCollection.createArrayList();
        }
        this.capabilityrefs.add(ref);
    }

    public Iterator iterCapabilityReferences() {
        return this.capabilityrefs == null ? Collections.EMPTY_LIST.iterator() : this.capabilityrefs.iterator();
    }

    public List getSystemExpressionParameters() {
        ArrayList copy = SCollection.createArrayList();
        copy.add(new ExpressionParameterInfo("$scope", (IMElement)this, "jadex.runtime.impl.RCapability"));
        copy.add(new ExpressionParameterInfo("$beliefbase", (IMElement)this.getBeliefbase(), "jadex.runtime.impl.RBeliefbase"));
        copy.add(new ExpressionParameterInfo("$goalbase", (IMElement)this.getGoalbase(), "jadex.runtime.impl.RGoalbase"));
        copy.add(new ExpressionParameterInfo("$planbase", (IMElement)this.getPlanbase(), "jadex.runtime.impl.RPlanbase"));
        copy.add(new ExpressionParameterInfo("$eventbase", (IMElement)this.getEventbase(), "jadex.runtime.impl.REventbase"));
        copy.add(new ExpressionParameterInfo("$expressionbase", (IMElement)this.getExpressionbase(), "jadex.runtime.impl.RExpressionbase"));
        copy.add(new ExpressionParameterInfo("$propertybase", (IMElement)this.getPropertybase(), "jadex.runtime.impl.RPropertybase"));
        return copy;
    }

    public void doClone(MElement cl) {
        super.doClone(cl);
        MCapability clone = (MCapability)cl;
        if (this.beliefbase != null) {
            clone.beliefbase = (MBeliefbase)this.beliefbase.clone();
        }
        if (this.goalbase != null) {
            clone.goalbase = (MGoalbase)this.goalbase.clone();
        }
        if (this.planbase != null) {
            clone.planbase = (MPlanbase)this.planbase.clone();
        }
        if (this.eventbase != null) {
            clone.eventbase = (MEventbase)this.eventbase.clone();
        }
        if (this.expressionbase != null) {
            clone.expressionbase = (MExpressionbase)this.expressionbase.clone();
        }
        if (this.propertybase != null) {
            clone.propertybase = (MPropertybase)this.propertybase.clone();
        }
        if (this.goalbase != null) {
            clone.goalbase = (MGoalbase)this.goalbase.clone();
        }
        if (this.configurationbase != null) {
            clone.configurationbase = (MConfigurationbase)this.configurationbase.clone();
        }
        if (this.imports != null) {
            clone.imports = (ArrayList)this.imports.clone();
        }
        if (this.capabilityrefs != null) {
            clone.capabilityrefs = SCollection.createArrayList();
            for (int i = 0; i < this.capabilityrefs.size(); ++i) {
                clone.capabilityrefs.add(((MElement)this.capabilityrefs.get(i)).clone());
            }
        }
    }

    public final /* synthetic */ MCapability JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_0(UnmarshallingContext arg1) throws JiBXException {
        MCapability mCapability = this;
        this.preset((IUnmarshallingContext)arg1);
        MCapability mCapability2 = this;
        MElement mElement = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_1_0(arg1);
        this.packagename = arg1.attributeText(null, "package", null);
        this.isabstract = arg1.attributeBoolean(null, "abstract", false);
        return this;
    }

    public final /* synthetic */ MCapability JiBX_src_jadex_model_jibximpl_binding_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        MCapability mCapability = this;
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "imports")) {
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "imports");
            while (arg1.isAt("http://jadex.sourceforge.net/jadex", "import")) {
                this.createImport(arg1.parseElementText("http://jadex.sourceforge.net/jadex", "import"));
            }
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "imports");
        } else {
            mCapability = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "capabilities")) {
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "capabilities");
            while (arg1.isAt("http://jadex.sourceforge.net/jadex", "capability")) {
                arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "capability");
                MCapabilityReference mCapabilityReference = MCapabilityReference.JiBX_src_jadex_model_jibximpl_binding_newinstance_2_0(arg1).JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_1(arg1);
                arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "capability");
                arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "capability");
                this.addCapabilityReference(mCapabilityReference);
            }
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "capabilities");
        } else {
            mCapability = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "beliefs")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "beliefs");
            MBeliefbase mBeliefbase = this.beliefbase;
            if (mBeliefbase == null) {
                mBeliefbase = MBeliefbase.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.beliefbase = mBeliefbase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "beliefs");
            this.beliefbase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "beliefs");
        } else {
            this.beliefbase = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "goals")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "goals");
            MGoalbase mGoalbase = this.goalbase;
            if (mGoalbase == null) {
                mGoalbase = MGoalbase.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.goalbase = mGoalbase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "goals");
            this.goalbase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "goals");
        } else {
            this.goalbase = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "plans")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "plans");
            MPlanbase mPlanbase = this.planbase;
            if (mPlanbase == null) {
                mPlanbase = MPlanbase.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.planbase = mPlanbase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "plans");
            this.planbase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "plans");
        } else {
            this.planbase = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "events")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "events");
            MEventbase mEventbase = this.eventbase;
            if (mEventbase == null) {
                mEventbase = MEventbase.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.eventbase = mEventbase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "events");
            this.eventbase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "events");
        } else {
            this.eventbase = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "expressions")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "expressions");
            MExpressionbase mExpressionbase = this.expressionbase;
            if (mExpressionbase == null) {
                mExpressionbase = MExpressionbase.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.expressionbase = mExpressionbase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "expressions");
            this.expressionbase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "expressions");
        } else {
            this.expressionbase = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "properties")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "properties");
            MPropertybase mPropertybase = this.propertybase;
            if (mPropertybase == null) {
                mPropertybase = MPropertybase.JiBX_src_jadex_model_jibximpl_binding_newinstance_3_0(arg1);
            }
            this.propertybase = mPropertybase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "properties");
            this.propertybase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "properties");
        } else {
            this.propertybase = null;
        }
        if (arg1.isAt("http://jadex.sourceforge.net/jadex", "configurations")) {
            arg1.parseToStartTag("http://jadex.sourceforge.net/jadex", "configurations");
            MConfigurationbase mConfigurationbase = this.configurationbase;
            if (mConfigurationbase == null) {
                mConfigurationbase = MConfigurationbase.JiBX_src_jadex_model_jibximpl_binding_newinstance_4_0(arg1);
            }
            this.configurationbase = mConfigurationbase.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_4_1(arg1);
            arg1.parsePastStartTag("http://jadex.sourceforge.net/jadex", "configurations");
            this.configurationbase.JiBX_src_jadex_model_jibximpl_binding_unmarshal_4_2(arg1);
            arg1.parsePastCurrentEndTag("http://jadex.sourceforge.net/jadex", "configurations");
        } else {
            this.configurationbase = null;
        }
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_1_0(arg1);
        if (this.packagename != null) {
            marshallingContext = marshallingContext.attribute(0, "package", this.packagename);
        }
        boolean bl = this.isabstract;
        if (bl) {
            marshallingContext = marshallingContext.attribute(0, "abstract", Utility.serializeBoolean((boolean)bl));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        arg1.startTagNamespaces(3, "imports", new int[]{3}, new String[]{""}).closeStartContent();
        Iterator var0 = this.iterImports();
        while (var0.hasNext()) {
            void var3_3;
            String var1 = (String)var0.next();
            marshallingContext = marshallingContext.element(3, "import", (String)var3_3);
        }
        arg1.endTag(3, "imports");
        arg1.startTagNamespaces(3, "capabilities", new int[]{3}, new String[]{""}).closeStartContent();
        Iterator var02 = this.iterCapabilityReferences();
        while (var02.hasNext()) {
            MCapabilityReference mCapabilityReference = (MCapabilityReference)var02.next();
            arg1.startTagNamespaces(3, "capability", new int[]{3}, new String[]{""});
            mCapabilityReference.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_2(arg1);
            arg1.closeStartEmpty();
        }
        arg1.endTag(3, "capabilities");
        if (this.beliefbase != null) {
            MBeliefbase mBeliefbase = this.beliefbase;
            arg1.startTagNamespaces(3, "beliefs", new int[]{3}, new String[]{""});
            mBeliefbase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
            arg1.closeStartContent();
            mBeliefbase.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
            arg1.endTag(3, "beliefs");
        }
        if (this.goalbase != null) {
            MGoalbase mGoalbase = this.goalbase;
            arg1.startTagNamespaces(3, "goals", new int[]{3}, new String[]{""});
            mGoalbase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
            arg1.closeStartContent();
            mGoalbase.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
            arg1.endTag(3, "goals");
        }
        if (this.planbase != null) {
            MPlanbase mPlanbase = this.planbase;
            arg1.startTagNamespaces(3, "plans", new int[]{3}, new String[]{""});
            mPlanbase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
            arg1.closeStartContent();
            mPlanbase.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
            arg1.endTag(3, "plans");
        }
        if (this.eventbase != null) {
            MEventbase mEventbase = this.eventbase;
            arg1.startTagNamespaces(3, "events", new int[]{3}, new String[]{""});
            mEventbase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
            arg1.closeStartContent();
            mEventbase.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
            arg1.endTag(3, "events");
        }
        if (this.expressionbase != null) {
            MExpressionbase mExpressionbase = this.expressionbase;
            arg1.startTagNamespaces(3, "expressions", new int[]{3}, new String[]{""});
            mExpressionbase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
            arg1.closeStartContent();
            mExpressionbase.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
            arg1.endTag(3, "expressions");
        }
        if (this.propertybase != null) {
            MPropertybase mPropertybase = this.propertybase;
            arg1.startTagNamespaces(3, "properties", new int[]{3}, new String[]{""});
            mPropertybase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_3(arg1);
            arg1.closeStartContent();
            mPropertybase.JiBX_src_jadex_model_jibximpl_binding_marshal_3_4(arg1);
            arg1.endTag(3, "properties");
        }
        if (this.configurationbase != null) {
            MConfigurationbase mConfigurationbase = this.configurationbase;
            arg1.startTagNamespaces(3, "configurations", new int[]{3}, new String[]{""});
            mConfigurationbase.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_4_3(arg1);
            arg1.closeStartContent();
            mConfigurationbase.JiBX_src_jadex_model_jibximpl_binding_marshal_4_4(arg1);
            arg1.endTag(3, "configurations");
        }
    }
}

