/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import [Ljava.lang.Object;;
import jadex.model.ExpressionParameterInfo;
import jadex.model.IMBDIAgent;
import jadex.model.IMBelief;
import jadex.model.IMBeliefReference;
import jadex.model.IMElement;
import jadex.model.IMReferenceableElement;
import jadex.model.SXML;
import jadex.model.jibximpl.MCapability;
import jadex.model.jibximpl.MPropertybase;
import jadex.model.jibximpl.Report;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class MBDIAgent
extends MCapability
implements IMBDIAgent {
    protected String propertyfile = "jadex.config.runtime";
    protected ArrayList arguments = SCollection.createArrayList();
    public static final String JiBX_bindingList = "|jadex.model.jibximpl.JiBX_src_jadex_model_jibximpl_bindingFactory|";

    protected void init() {
        super.init();
        if (this.propertyfile != null) {
            try {
                ((MPropertybase)this.getPropertybase()).addPropertyBase(SXML.loadPropertiesModel(this.propertyfile, this.getFullImports(), this));
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new RuntimeException(sw.toString());
            }
        }
    }

    protected void doCheck(Report report) {
        super.doCheck(report);
        if (this.propertyfile != null) {
            try {
                SXML.loadPropertiesModel(this.propertyfile, this.getFullImports(), this);
            }
            catch (Exception e) {
                report.addEntry(this, "Could not load property file '" + this.propertyfile + "'.");
            }
        }
        if (this.isAbstract()) {
            report.addEntry(this, "Agents can't be abstract.");
        }
    }

    protected String getFileExtension() {
        return ".agent.xml";
    }

    public String getPropertyFile() {
        return this.propertyfile;
    }

    public void setPropertyFile(String propertyfile) {
        this.propertyfile = propertyfile;
    }

    public List getSystemExpressionParameters() {
        List copy = super.getSystemExpressionParameters();
        copy.add(0, new ExpressionParameterInfo("$agent", (IMElement)this, "jadex.runtime.impl.RBDIAgent"));
        copy.add(0, new ExpressionParameterInfo("$args", null, Object;.class));
        return copy;
    }

    public String[] getArgumentNames() {
        ArrayList al = SCollection.createArrayList();
        IMBelief[] bels = this.getBeliefbase().getBeliefs();
        for (int i = 0; i < bels.length; ++i) {
            if (!bels[i].getExported().equals("true")) continue;
            al.add(bels[i].getName());
        }
        IMBeliefReference[] belrefs = this.getBeliefbase().getBeliefReferences();
        for (int i = 0; i < belrefs.length; ++i) {
            if (!belrefs[i].getExported().equals("true")) continue;
            al.add(belrefs[i].getName());
        }
        return al.toArray(new String[al.size()]);
    }

    public void checkArguments(Map arguments) {
        if (arguments.size() > 0) {
            Iterator it = arguments.keySet().iterator();
            while (it.hasNext()) {
                IMReferenceableElement bel;
                String arg = (String)it.next();
                if (this.getBeliefbase().getBelief(arg) != null) {
                    bel = this.getBeliefbase().getBelief(arg);
                    if ("true".equals(bel.getExported())) {
                        if (bel.getClazz() == null || arguments.get(arg) == null || SReflect.isSupertype(bel.getClazz(), arguments.get(arg).getClass())) continue;
                        throw new RuntimeException("Belief for argument '" + arg + "' does not match type (" + bel.getClazz().getName() + " vs. " + arguments.get(arg).getClass().getName() + ").");
                    }
                    throw new RuntimeException("Belief for argument '" + arg + "' is not exported.");
                }
                if (this.getBeliefbase().getBeliefReference(arg) != null) {
                    bel = this.getBeliefbase().getBeliefReference(arg);
                    if ("true".equals(bel.getExported())) {
                        if (bel.getClazz() == null || arguments.get(arg) == null || SReflect.isSupertype(bel.getClazz(), arguments.get(arg).getClass())) continue;
                        throw new RuntimeException("Belief for argument '" + arg + "' does not match type (" + bel.getClazz().getName() + " vs. " + arguments.get(arg).getClass().getName() + ").");
                    }
                    throw new RuntimeException("Belief for argument '" + arg + "' is not exported.");
                }
                throw new RuntimeException("No such belief for argument '" + arg + "'.");
            }
        }
    }

    public final /* synthetic */ MBDIAgent JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_3_0(UnmarshallingContext arg1) throws JiBXException {
        MBDIAgent mBDIAgent = this;
        this.preset((IUnmarshallingContext)arg1);
        MBDIAgent mBDIAgent2 = this;
        MCapability mCapability = this.JiBX_src_jadex_model_jibximpl_binding_unmarshalAttr_2_0(arg1);
        this.setPropertyFile(arg1.attributeText(null, "propertyfile", "jadex.config.runtime"));
        return this;
    }

    public final /* synthetic */ MBDIAgent JiBX_src_jadex_model_jibximpl_binding_unmarshal_3_0(UnmarshallingContext arg1) throws JiBXException {
        MBDIAgent mBDIAgent = this;
        this.JiBX_src_jadex_model_jibximpl_binding_unmarshal_2_0(arg1);
        return this;
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshalAttr_3_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshalAttr_2_0(arg1);
        if (this.getPropertyFile() != null) {
            String string = this.getPropertyFile();
            if (!Utility.isEqual((Object)string, (Object)"jadex.config.runtime")) {
                marshallingContext = marshallingContext.attribute(0, "propertyfile", string);
            }
        }
    }

    public final /* synthetic */ void JiBX_src_jadex_model_jibximpl_binding_marshal_3_0(MarshallingContext arg1) throws JiBXException {
        MarshallingContext marshallingContext = arg1;
        this.JiBX_src_jadex_model_jibximpl_binding_marshal_2_0(arg1);
    }
}

