/*
 * Decompiled with CFR 0.152.
 */
package jadex.model.jibximpl;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMPropertybase;
import jadex.model.IModelLoader;
import jadex.model.SXML;
import jadex.model.jibximpl.MBDIAgent;
import jadex.model.jibximpl.MCapability;
import jadex.model.jibximpl.MElement;
import jadex.model.jibximpl.MPropertybase;
import jadex.util.CachedObject;
import jadex.util.ObjectCache;
import jadex.util.ResourceInfo;
import jadex.util.Tuple;
import jadex.util.collection.SCollection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class JibxLoader
implements IModelLoader {
    protected ObjectCache cache;
    protected Map filenames = SCollection.createHashMap();

    public JibxLoader() {
        this.cache = new ObjectCache("modelcache.cam", false, false);
    }

    public IMBDIAgent loadAgentModel(String name, String[] imports) throws IOException {
        CachedObject co;
        MBDIAgent ret = null;
        Object[] keys = imports != null ? new Object[imports.length + 1] : new Object[1];
        keys[0] = name;
        if (imports != null) {
            System.arraycopy(imports, 0, keys, 1, imports.length);
        }
        Tuple keytuple = new Tuple(keys);
        String fn = (String)this.filenames.get(keytuple);
        long lastmod = -1L;
        ResourceInfo rinfo = null;
        if (fn == null || Configuration.getConfiguration().isModelCaching() && Configuration.getConfiguration().isModelCacheAutoRefresh()) {
            if (fn != null) {
                rinfo = SXML.getResourceInfo(fn, ".agent.xml", null);
            }
            if (rinfo == null) {
                rinfo = SXML.getResourceInfo(name, ".agent.xml", imports);
                if (rinfo == null) {
                    return ret;
                }
                fn = rinfo.getFilename();
                this.filenames.put(keytuple, fn);
            }
            lastmod = rinfo.getLastModified();
        }
        if (Configuration.getConfiguration().isModelCaching() && (co = this.cache.loadCachedObject(fn.substring(0, fn.length() - 3) + "cam", lastmod)) != null) {
            MElement master = (MElement)co.getObject();
            ret = (MBDIAgent)master.clone();
            if (rinfo != null) {
                rinfo.cleanup();
            }
        }
        if (ret == null) {
            if (rinfo == null) {
                rinfo = SXML.getResourceInfo(name, ".agent.xml", imports);
            }
            try {
                IBindingFactory bfa = BindingDirectory.getFactory((Class)MBDIAgent.class);
                IUnmarshallingContext uc = bfa.createUnmarshallingContext();
                ret = (MBDIAgent)uc.unmarshalDocument(rinfo.getInputStream(), null);
                ret.setFilename(rinfo.getFilename());
                ret.setLastModified(rinfo.getLastModified());
                if (Configuration.getConfiguration().isModelChecking() && ret.getReport().isEmpty()) {
                    ret.setup();
                } else {
                    try {
                        ret.setup();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (Configuration.getConfiguration().isModelCaching()) {
                    if (Configuration.getConfiguration().isModelChecking()) {
                        ret.getReport();
                    }
                    this.cache.add(new CachedObject(rinfo.getFilename().substring(0, rinfo.getFilename().length() - 3) + "cam", rinfo.getLastModified(), (Serializable)ret.clone()));
                }
            }
            catch (JiBXException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new IOException(sw.toString());
            }
            finally {
                rinfo.cleanup();
            }
        }
        return ret;
    }

    public IMCapability loadCapabilityModel(String name, String[] imports, IMElement owner) throws IOException {
        CachedObject co;
        MElement ret = null;
        Object[] keys = imports != null ? new Object[imports.length + 1] : new Object[1];
        keys[0] = name;
        if (imports != null) {
            System.arraycopy(imports, 0, keys, 1, imports.length);
        }
        Tuple keytuple = new Tuple(keys);
        String fn = (String)this.filenames.get(keytuple);
        long lastmod = -1L;
        ResourceInfo rinfo = null;
        if (fn == null || Configuration.getConfiguration().isModelCaching() && Configuration.getConfiguration().isModelCacheAutoRefresh()) {
            if (fn != null) {
                rinfo = SXML.getResourceInfo(fn, ".capability.xml", null);
            }
            if (rinfo == null) {
                rinfo = SXML.getResourceInfo(name, ".capability.xml", imports);
                if (rinfo == null) {
                    return ret;
                }
                fn = rinfo.getFilename();
                this.filenames.put(keytuple, fn);
            }
            lastmod = rinfo.getLastModified();
        }
        if (Configuration.getConfiguration().isModelCaching() && (co = this.cache.loadCachedObject(fn.substring(0, fn.length() - 3) + "cam", lastmod)) != null) {
            MElement master = (MElement)co.getObject();
            ret = (MCapability)master.clone();
            if (rinfo != null) {
                rinfo.cleanup();
            }
        }
        if (ret == null) {
            if (rinfo == null) {
                rinfo = SXML.getResourceInfo(name, ".capability.xml", imports);
            }
            try {
                IBindingFactory bfa = BindingDirectory.getFactory((Class)MCapability.class);
                IUnmarshallingContext uc = bfa.createUnmarshallingContext();
                ret = (MCapability)uc.unmarshalDocument(rinfo.getInputStream(), null);
                ((MCapability)ret).setFilename(rinfo.getFilename());
                ((MCapability)ret).setLastModified(rinfo.getLastModified());
                if (Configuration.getConfiguration().isModelCaching()) {
                    if (Configuration.getConfiguration().isModelChecking()) {
                        ret.getReport();
                    }
                    this.cache.add(new CachedObject(rinfo.getFilename().substring(0, rinfo.getFilename().length() - 3) + "cam", rinfo.getLastModified(), (Serializable)ret.clone()));
                }
                ret.setOwner(owner);
            }
            catch (JiBXException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new IOException(sw.toString());
            }
            finally {
                rinfo.cleanup();
            }
        }
        if (Configuration.getConfiguration().isModelChecking() && ret.getReport().isEmpty()) {
            ret.setup();
        } else {
            try {
                ret.setup();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return ret;
    }

    public IMPropertybase loadPropertyModel(String name, String[] imports, IMElement owner) throws IOException {
        CachedObject co;
        MPropertybase ret = null;
        Object[] keys = imports != null ? new Object[imports.length + 1] : new Object[1];
        keys[0] = name;
        if (imports != null) {
            System.arraycopy(imports, 0, keys, 1, imports.length);
        }
        Tuple keytuple = new Tuple(keys);
        String fn = (String)this.filenames.get(keytuple);
        long lastmod = -1L;
        ResourceInfo rinfo = null;
        if (fn == null || Configuration.getConfiguration().isModelCaching() && Configuration.getConfiguration().isModelCacheAutoRefresh()) {
            if (fn != null) {
                rinfo = SXML.getResourceInfo(fn, ".properties.xml", null);
            }
            if (rinfo == null) {
                rinfo = SXML.getResourceInfo(name, ".properties.xml", imports);
                if (rinfo == null) {
                    return ret;
                }
                fn = rinfo.getFilename();
                this.filenames.put(keytuple, fn);
            }
            lastmod = rinfo.getLastModified();
        }
        if (Configuration.getConfiguration().isModelCaching() && (co = this.cache.loadCachedObject(fn.substring(0, fn.length() - 3) + "cam", lastmod)) != null) {
            MElement master = (MElement)co.getObject();
            ret = (MPropertybase)master.clone();
            if (rinfo != null) {
                rinfo.cleanup();
            }
        }
        if (ret == null) {
            if (rinfo == null) {
                rinfo = SXML.getResourceInfo(name, ".properties.xml", imports);
            }
            try {
                IBindingFactory bfa = BindingDirectory.getFactory((Class)MPropertybase.class);
                IUnmarshallingContext uc = bfa.createUnmarshallingContext();
                ret = (MPropertybase)uc.unmarshalDocument(rinfo.getInputStream(), null);
                if (Configuration.getConfiguration().isModelCaching()) {
                    this.cache.add(new CachedObject(rinfo.getFilename().substring(0, rinfo.getFilename().length() - 3) + "cam", rinfo.getLastModified(), (Serializable)ret.clone()));
                }
            }
            catch (JiBXException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new IOException(sw.toString());
            }
            finally {
                rinfo.cleanup();
            }
        }
        ret.setOwner(owner);
        return ret;
    }

    public IMElement loadModel(ResourceInfo rinfo) throws IOException {
        MElement ret = null;
        try {
            IBindingFactory bfa = BindingDirectory.getFactory((Class)MElement.class);
            IUnmarshallingContext uc = bfa.createUnmarshallingContext();
            ret = (MElement)uc.unmarshalDocument(rinfo.getInputStream(), null);
            if (ret instanceof MCapability) {
                ((MCapability)ret).setFilename(rinfo.getFilename());
                ((MCapability)ret).setLastModified(rinfo.getLastModified());
            }
            if (Configuration.getConfiguration().isModelChecking() && ret.getReport().isEmpty()) {
                ret.setup();
            } else {
                try {
                    ret.setup();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        catch (JiBXException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            throw new IOException(sw.toString());
        }
        finally {
            rinfo.cleanup();
        }
        return ret;
    }

    public ObjectCache getModelCache() {
        return this.cache;
    }

    public void clearModelCache(String filename) {
        if (filename == null) {
            this.cache.clear();
        } else {
            this.cache.remove(filename);
        }
    }
}

