/*
 * Decompiled with CFR 0.152.
 */
package jadex.model;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMElement;
import jadex.model.IMPropertybase;
import jadex.model.IModelLoader;
import jadex.util.ObjectCache;
import jadex.util.ResourceInfo;
import jadex.util.SReflect;
import jadex.util.SUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SXML {
    public static final String FACTORY_JIBX = "jadex.model.jibximpl.JibxLoader";
    public static final String FILE_EXTENSION_AGENT = ".agent.xml";
    public static final String FILE_EXTENSION_CAPABILITY = ".capability.xml";
    public static final String FILE_EXTENSION_PROPERTIES = ".properties.xml";
    public static IModelLoader loader;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void setFactory(String name) {
        try {
            loader = (IModelLoader)SReflect.classForName(name).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Could not initialize Modelloader: " + name);
        }
    }

    public static IModelLoader getFactory() {
        if (loader == null || !loader.getClass().getName().equals(Configuration.getConfiguration().getXMLDatabinding())) {
            SXML.setFactory(Configuration.getConfiguration().getXMLDatabinding());
        }
        return loader;
    }

    public static String getFactoryName() {
        return SXML.getFactory().getClass().getName();
    }

    public static IMBDIAgent loadAgentModel(String xml, String[] imports) throws IOException {
        return SXML.getFactory().loadAgentModel(xml, imports);
    }

    public static IMCapability loadCapabilityModel(String xml, String[] imports, IMElement owner) throws IOException {
        return SXML.getFactory().loadCapabilityModel(xml, imports, owner);
    }

    public static IMPropertybase loadPropertiesModel(String xml, String[] imports, IMElement owner) throws IOException {
        return SXML.getFactory().loadPropertyModel(xml, imports, owner);
    }

    public static IMElement loadModel(String xml, String xslt) throws IOException {
        ResourceInfo rinfo = SXML.getResourceInfo(xml, null, null);
        if (xslt != null) {
            rinfo = SXML.applyXSLT(rinfo, xslt);
        }
        return SXML.getFactory().loadModel(rinfo);
    }

    public static void clearModelCache(String filename) {
        ObjectCache cache = SXML.getFactory().getModelCache();
        if (cache != null) {
            if (filename != null) {
                cache.remove(filename);
            } else {
                cache.clear();
            }
        }
    }

    public static void persistModelCache() throws IOException {
        ObjectCache cache = SXML.getFactory().getModelCache();
        if (cache != null) {
            cache.persist();
        }
    }

    public static ResourceInfo getResourceInfo(String xml, String suffix, String[] imports) throws IOException {
        if (!$assertionsDisabled && xml == null) {
            throw new AssertionError();
        }
        String resstr = xml;
        ResourceInfo ret = SUtil.getResourceInfo0(resstr);
        if (ret == null || ret.getInputStream() == null) {
            resstr = SUtil.replace(xml, ".", "/") + suffix;
            ret = SUtil.getResourceInfo0(resstr);
            for (int i = 0; (ret == null || ret.getInputStream() == null) && imports != null && i < imports.length; ++i) {
                if (imports[i].endsWith(".*")) {
                    resstr = SUtil.replace(imports[i].substring(0, imports[i].length() - 1), ".", "/") + xml + suffix;
                    ret = SUtil.getResourceInfo0(resstr);
                    continue;
                }
                if (!imports[i].endsWith(xml)) continue;
                resstr = SUtil.replace(imports[i], ".", "/") + suffix;
                ret = SUtil.getResourceInfo0(resstr);
            }
        }
        if (ret == null || ret.getInputStream() == null) {
            throw new IOException("File " + xml + " not found in imports: " + SUtil.arrayToString(imports));
        }
        return ret;
    }

    protected static ResourceInfo applyXSLT(ResourceInfo rinfo, String xslt) throws IOException {
        try {
            InputStream template = SUtil.getResource(xslt);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer transformer = tfac.newTransformer(new StreamSource(template));
            transformer.transform(new StreamSource(rinfo.getInputStream()), new StreamResult(result));
            template.close();
            result.close();
            rinfo.cleanup();
            return new ResourceInfo(rinfo.getFilename(), new ByteArrayInputStream(result.toByteArray()), rinfo.getLastModified());
        }
        catch (TransformerException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            throw new IOException(sw.toString());
        }
    }

    public static boolean isJadexFilename(String filename) {
        return filename != null && (filename.toLowerCase().endsWith(FILE_EXTENSION_AGENT) || filename.toLowerCase().endsWith(FILE_EXTENSION_CAPABILITY));
    }

    public static boolean isAgentFilename(String filename) {
        return filename != null && filename.toLowerCase().endsWith(FILE_EXTENSION_AGENT);
    }

    public static boolean isCapabilityFilename(String filename) {
        return filename != null && filename.toLowerCase().endsWith(FILE_EXTENSION_CAPABILITY);
    }

    public static boolean isPropertiesFilename(String filename) {
        return filename != null && filename.toLowerCase().endsWith(FILE_EXTENSION_PROPERTIES);
    }

    public static String stripJadexExtension(String filename) {
        int capend = filename.lastIndexOf(FILE_EXTENSION_CAPABILITY);
        if (capend != -1) {
            return filename.substring(0, capend);
        }
        int agentend = filename.lastIndexOf(FILE_EXTENSION_AGENT);
        if (agentend != -1) {
            return filename.substring(0, agentend);
        }
        int propend = filename.lastIndexOf(FILE_EXTENSION_PROPERTIES);
        if (propend != -1) {
            return filename.substring(0, propend);
        }
        return filename;
    }

    public static String getShortName(String filename) {
        String shortname = SXML.stripJadexExtension(filename);
        int namestart = Math.max(shortname.lastIndexOf(File.separatorChar), Math.max(shortname.lastIndexOf("/"), shortname.lastIndexOf(".")));
        if (namestart != -1) {
            shortname = shortname.substring(namestart + 1);
        }
        return shortname;
    }

    static {
        $assertionsDisabled = !SXML.class.desiredAssertionStatus();
    }
}

