/*
 * Decompiled with CFR 0.152.
 */
package jadex.model;

import jadex.util.collection.MultiCollection;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.Collection;

public interface ISystemEventTypes {
    public static final String TYPE_ANY = "any";
    public static final String EVENT_TYPE_BDI = "BDI";
    public static final String AGENT_EVENT = "agent";
    public static final String AGENT_BORN = "agentBorn";
    public static final String AGENT_TERMINATING = "agentTerminating";
    public static final String AGENT_DIED = "agentDied";
    public static final String CAPABILITY_EVENT = "BDI_capability";
    public static final String CAPABILITY_ADDED = "BDI_capabilityAdded";
    public static final String CAPABILITY_REMOVED = "BDI_capabilityRemoved";
    public static final String BELIEF_EVENT = "BDI_belief";
    public static final String BELIEF_ADDED = "BDI_beliefAdded";
    public static final String BELIEF_REMOVED = "BDI_beliefRemoved";
    public static final String FACT_EVENT = "BDI_fact";
    public static final String FACT_CHANGED = "BDI_factChanged";
    public static final String FACT_READ = "_BDI_factRead";
    public static final String BSFACT_EVENT = "BDI_bsfact";
    public static final String BSFACT_CHANGED = "BDI_bsfactChanged";
    public static final String BSFACTS_CHANGED = "BDI_bsfactsChanged";
    public static final String BSFACT_ADDED = "BDI_bsfactAdded";
    public static final String BSFACT_REMOVED = "BDI_bsfactRemoved";
    public static final String BSFACT_READ = "BDI_bsfactRead";
    public static final String GOAL_EVENT = "BDI_goal";
    public static final String GOAL_ADDED = "BDI_goalAdded";
    public static final String GOAL_REMOVED = "BDI_goalRemoved";
    public static final String GOAL_CHANGED = "BDI_goalChanged";
    public static final String VALUE_CHANGED = "BDI_valueChanged";
    public static final String ESVALUE_EVENT = "BDI_esValue";
    public static final String ESVALUE_CHANGED = "BDI_esValueChanged";
    public static final String ESVALUES_CHANGED = "BDI_esValuesChanged";
    public static final String ESVALUE_ADDED = "BDI_esValueAdded";
    public static final String ESVALUE_REMOVED = "BDI_esValueRemoved";
    public static final String BINDING_EVENT = "BDI_bindingChanged";
    public static final String PLAN_EVENT = "BDI_plan";
    public static final String PLAN_ADDED = "BDI_planAdded";
    public static final String PLAN_REMOVED = "BDI_planRemoved";
    public static final String PLAN_CHANGED = "BDI_planChanged";
    public static final String MESSAGE_EVENT = "message_";
    public static final String MESSAGE_RECEIVED = "message_received";
    public static final String MESSAGE_SENT = "message_sent";
    public static final String INTERNAL_EVENT = "internalevent_";
    public static final String INTERNAL_EVENT_OCCURRED = "internalevent_occurred";
    public static final String CONDITION_TRIGGERED = "condition_triggered";
    public static final String EVENT_TYPE_STEPPABLE = "steppable_";
    public static final String AGENDA_MODE_CHANGED = "steppable_agenda_mode_changed";
    public static final String AGENDA_STEP_DONE = "steppable_agenda_step_done";
    public static final String AGENDA_STEPS_CHANGED = "steppable_agenda_steps_changed";
    public static final String AGENDA_CHANGED = "steppable_agenda_changed";

    public static class Subtypes {
        protected static final MultiCollection subtypes = new MultiCollection();

        public static Collection getSubtypes(String basetype) {
            ArrayList ret = SCollection.createArrayList();
            ret.add(basetype);
            for (int i = 0; i < ret.size(); ++i) {
                ret.addAll(subtypes.getCollection(ret.get(i)));
            }
            return ret;
        }

        public static boolean isSubtype(String event, String[] types) {
            boolean found = false;
            for (int i = 0; !found && i < types.length; ++i) {
                Collection stypes = Subtypes.getSubtypes(types[i]);
                found = stypes.contains(event);
            }
            return found;
        }

        static {
            subtypes.put(ISystemEventTypes.TYPE_ANY, ISystemEventTypes.EVENT_TYPE_BDI);
            subtypes.put(ISystemEventTypes.AGENT_EVENT, ISystemEventTypes.AGENT_BORN);
            subtypes.put(ISystemEventTypes.AGENT_EVENT, ISystemEventTypes.AGENT_TERMINATING);
            subtypes.put(ISystemEventTypes.AGENT_EVENT, ISystemEventTypes.AGENT_DIED);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.CAPABILITY_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.BELIEF_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.FACT_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.BSFACT_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.GOAL_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.VALUE_CHANGED);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.ESVALUE_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.BINDING_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.PLAN_EVENT);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_BDI, ISystemEventTypes.CONDITION_TRIGGERED);
            subtypes.put(ISystemEventTypes.CAPABILITY_EVENT, ISystemEventTypes.CAPABILITY_ADDED);
            subtypes.put(ISystemEventTypes.CAPABILITY_EVENT, ISystemEventTypes.CAPABILITY_REMOVED);
            subtypes.put(ISystemEventTypes.BELIEF_EVENT, ISystemEventTypes.BELIEF_ADDED);
            subtypes.put(ISystemEventTypes.BELIEF_EVENT, ISystemEventTypes.BELIEF_REMOVED);
            subtypes.put(ISystemEventTypes.GOAL_EVENT, ISystemEventTypes.GOAL_ADDED);
            subtypes.put(ISystemEventTypes.GOAL_EVENT, ISystemEventTypes.GOAL_REMOVED);
            subtypes.put(ISystemEventTypes.GOAL_EVENT, ISystemEventTypes.GOAL_CHANGED);
            subtypes.put(ISystemEventTypes.PLAN_EVENT, ISystemEventTypes.PLAN_ADDED);
            subtypes.put(ISystemEventTypes.PLAN_EVENT, ISystemEventTypes.PLAN_REMOVED);
            subtypes.put(ISystemEventTypes.PLAN_EVENT, ISystemEventTypes.PLAN_CHANGED);
            subtypes.put(ISystemEventTypes.FACT_EVENT, ISystemEventTypes.FACT_CHANGED);
            subtypes.put(ISystemEventTypes.FACT_EVENT, ISystemEventTypes.FACT_READ);
            subtypes.put(ISystemEventTypes.BSFACT_EVENT, ISystemEventTypes.BSFACT_READ);
            subtypes.put(ISystemEventTypes.BSFACT_EVENT, ISystemEventTypes.BSFACTS_CHANGED);
            subtypes.put(ISystemEventTypes.BSFACTS_CHANGED, ISystemEventTypes.BSFACT_ADDED);
            subtypes.put(ISystemEventTypes.BSFACTS_CHANGED, ISystemEventTypes.BSFACT_REMOVED);
            subtypes.put(ISystemEventTypes.BSFACTS_CHANGED, ISystemEventTypes.BSFACT_CHANGED);
            subtypes.put(ISystemEventTypes.ESVALUE_EVENT, ISystemEventTypes.ESVALUES_CHANGED);
            subtypes.put(ISystemEventTypes.ESVALUES_CHANGED, ISystemEventTypes.ESVALUE_ADDED);
            subtypes.put(ISystemEventTypes.ESVALUES_CHANGED, ISystemEventTypes.ESVALUE_REMOVED);
            subtypes.put(ISystemEventTypes.ESVALUES_CHANGED, ISystemEventTypes.ESVALUE_CHANGED);
            subtypes.put(ISystemEventTypes.INTERNAL_EVENT, ISystemEventTypes.INTERNAL_EVENT_OCCURRED);
            subtypes.put(ISystemEventTypes.MESSAGE_EVENT, ISystemEventTypes.MESSAGE_RECEIVED);
            subtypes.put(ISystemEventTypes.MESSAGE_EVENT, ISystemEventTypes.MESSAGE_SENT);
            subtypes.put(ISystemEventTypes.TYPE_ANY, ISystemEventTypes.EVENT_TYPE_STEPPABLE);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_STEPPABLE, ISystemEventTypes.AGENDA_MODE_CHANGED);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_STEPPABLE, ISystemEventTypes.AGENDA_STEPS_CHANGED);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_STEPPABLE, ISystemEventTypes.AGENDA_STEP_DONE);
            subtypes.put(ISystemEventTypes.EVENT_TYPE_STEPPABLE, ISystemEventTypes.AGENDA_CHANGED);
        }
    }
}

