/*
 * Decompiled with CFR 0.152.
 */
package jadex.model;

import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.IMCapability;
import jadex.model.IMCapabilityReference;
import jadex.model.IMPropertybase;
import jadex.model.IReport;
import jadex.model.SXML;
import jadex.util.ResourceInfo;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchProcessor {
    protected boolean verbose;
    protected boolean recursive_parse;
    protected boolean recursive_dirsearch;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BatchProcessor(boolean v, boolean rp, boolean rd) {
        this.verbose = v;
        this.recursive_parse = rp;
        this.recursive_dirsearch = rd;
    }

    public void processFiles(FileInfo[] fileinfos) {
        long start = System.currentTimeMillis();
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(Arrays.asList(fileinfos));
        int model_cnt = 0;
        int error_cnt = 0;
        for (int i = 0; i < files.size(); ++i) {
            try {
                CapabilityInfo ci;
                int j;
                IMCapabilityReference[] caprefs;
                FileInfo fi = (FileInfo)files.get(i);
                if (fi instanceof DirectoryInfo) {
                    ResourceInfo rinfo = SUtil.getResourceInfo0(fi.filename);
                    files.addAll(this.findModelsInDir(rinfo.getFilename()));
                    rinfo.cleanup();
                    continue;
                }
                if (fi instanceof AgentInfo) {
                    PropertiesInfo pi;
                    if (this.verbose) {
                        System.out.println("Processing " + fi.filename);
                    }
                    ++model_cnt;
                    IMBDIAgent agent = SXML.loadAgentModel(fi.filename, null);
                    error_cnt += this.processAgentModel(agent);
                    if (!this.recursive_parse) continue;
                    if (agent.getPropertyFile() != null && !files.contains(pi = new PropertiesInfo(agent.getPropertyFile(), agent.getFullImports()))) {
                        files.add(pi);
                    }
                    caprefs = agent.getCapabilityReferences();
                    for (j = 0; j < caprefs.length; ++j) {
                        ci = new CapabilityInfo(caprefs[j].getFile(), agent.getFullImports());
                        if (files.contains(ci)) continue;
                        files.add(ci);
                    }
                    continue;
                }
                if (fi instanceof CapabilityInfo) {
                    if (this.verbose) {
                        System.out.println("Processing " + fi.filename);
                    }
                    ++model_cnt;
                    IMCapability capa = SXML.loadCapabilityModel(fi.filename, null, null);
                    error_cnt += this.processCapabilityModel(capa);
                    if (!this.recursive_parse) continue;
                    caprefs = capa.getCapabilityReferences();
                    for (j = 0; j < caprefs.length; ++j) {
                        ci = new CapabilityInfo(caprefs[j].getFile(), capa.getFullImports());
                        if (files.contains(ci)) continue;
                        files.add(ci);
                    }
                    continue;
                }
                if (!(fi instanceof PropertiesInfo)) continue;
                if (this.verbose) {
                    System.out.println("Processing " + fi.filename);
                }
                ++model_cnt;
                IMPropertybase props = SXML.loadPropertiesModel(fi.filename, null, null);
                error_cnt += this.processPropertiesModel(props);
                continue;
            }
            catch (Throwable e) {
                ++error_cnt;
                System.err.println("Error in processing: " + ((FileInfo)files.get((int)i)).filename);
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        int secs = (int)(end - start) / 1000;
        System.out.println("Processed " + model_cnt + " models in " + secs + " seconds.");
        System.out.println("Found " + error_cnt + " errors.");
    }

    protected int processPropertiesModel(IMPropertybase props) {
        return 0;
    }

    protected int processCapabilityModel(IMCapability capa) {
        IReport report = capa.getReport();
        if (!report.isEmpty()) {
            System.out.println(report.toString());
        }
        return report.getErrorCount();
    }

    protected int processAgentModel(IMBDIAgent agent) {
        IReport report = agent.getReport();
        if (!report.isEmpty()) {
            System.out.println(report.toString());
        }
        return report.getErrorCount();
    }

    protected List findModelsInDir(String dirname) throws IOException {
        if (!$assertionsDisabled && dirname == null) {
            throw new AssertionError();
        }
        ArrayList ret = SCollection.createArrayList();
        File dir = new File(dirname);
        if (!dir.isDirectory()) {
            throw new RuntimeException("Must be directory: " + dirname);
        }
        File[] capas = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return SXML.isCapabilityFilename(name);
            }
        });
        for (int i = 0; i < capas.length; ++i) {
            ret.add(new CapabilityInfo(capas[i].getAbsolutePath(), null));
        }
        File[] agents = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return SXML.isAgentFilename(name);
            }
        });
        for (int i = 0; i < agents.length; ++i) {
            ret.add(new AgentInfo(agents[i].getAbsolutePath(), null));
        }
        File[] properties = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return SXML.isPropertiesFilename(name);
            }
        });
        for (int i = 0; i < properties.length; ++i) {
            ret.add(new PropertiesInfo(properties[i].getAbsolutePath(), null));
        }
        if (this.recursive_dirsearch) {
            File[] subdirs = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            for (int i = 0; i < subdirs.length; ++i) {
                ret.add(new DirectoryInfo(subdirs[i].getAbsolutePath()));
            }
        }
        return ret;
    }

    public static void printUsage() {
        System.out.println("Usage: java jadex.model.BatchProcessor [-v] [-rp] [-rd] (files)+\n");
        System.out.println("-v: Verbose output printing each processed file.");
        System.out.println("-rp: Turn on recusive processing, i.e. process contained capabilities also");
        System.out.println("-rd: Turn on recusive directory search, i.e. process models contained in subdirectories also");
        System.out.println("(files)+: one or more directories, or agent (.agent.xml), capability (.capability.xml), or properties (.properties.xml) files.");
    }

    public static void main(String[] args) throws IOException {
        Configuration.setFallbackConfiguration("jadex/config/batch_conf.properties");
        boolean v = false;
        boolean rp = false;
        boolean rd = false;
        ArrayList files = SCollection.createArrayList();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                v = true;
                continue;
            }
            if (args[i].equals("-rp")) {
                rp = true;
                continue;
            }
            if (args[i].equals("-rd")) {
                rd = true;
                continue;
            }
            if (args[i].endsWith("capability.xml")) {
                files.add(new CapabilityInfo(args[i], null));
                continue;
            }
            if (args[i].endsWith("agent.xml")) {
                files.add(new AgentInfo(args[i], null));
                continue;
            }
            if (args[i].endsWith("properties.xml")) {
                files.add(new PropertiesInfo(args[i], null));
                continue;
            }
            files.add(new DirectoryInfo(args[i]));
        }
        if (files.size() == 0) {
            BatchProcessor.printUsage();
            return;
        }
        BatchProcessor prec = new BatchProcessor(v, rp, rd);
        prec.processFiles(files.toArray(new FileInfo[files.size()]));
    }

    static {
        $assertionsDisabled = !BatchProcessor.class.desiredAssertionStatus();
    }

    public static class AgentInfo
    extends FileInfo {
        public AgentInfo(String filename, String[] imports) throws IOException {
            super(SXML.getResourceInfo(filename, ".agent.xml", imports).getFilename());
        }
    }

    public static class PropertiesInfo
    extends FileInfo {
        public PropertiesInfo(String filename, String[] imports) throws IOException {
            super(SXML.getResourceInfo(filename, ".properties.xml", imports).getFilename());
        }
    }

    public static class CapabilityInfo
    extends FileInfo {
        public CapabilityInfo(String filename, String[] imports) throws IOException {
            super(SXML.getResourceInfo(filename, ".capability.xml", imports).getFilename());
        }
    }

    public static class DirectoryInfo
    extends FileInfo {
        public DirectoryInfo(String filename) {
            super(filename);
        }
    }

    public static abstract class FileInfo {
        public String filename;

        public FileInfo(String filename) {
            this.filename = filename;
        }

        public boolean equals(Object obj) {
            return obj instanceof FileInfo && ((FileInfo)obj).filename.equals(this.filename);
        }

        public int hashCode() {
            return this.filename.hashCode();
        }
    }
}

