/*
 * Decompiled with CFR 0.152.
 */
package jadex.config;

import jadex.model.MessageType;
import jadex.model.SXML;
import jadex.util.ResourceInfo;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class Configuration {
    public static String JADEX_CONFIGURATION;
    public static final String PLATFORMNAME = "platformname";
    public static final String STARTTIME = "starttime";
    public static String MODEL_CACHING;
    public static String MODEL_CACHE_AUTOREFRESH;
    public static String MODEL_CHECKING;
    public static String PARSER_NAME;
    public static String JANINO_WRITE_CACHE;
    public static String JANINO_READ_CACHE;
    public static String JAVACC_PLAN_RELAODING;
    public static String XML_DATABINDING;
    public static String NO_WELCOME;
    public static String JCC_EXIT;
    public static String JCC_EXIT_SHUTDOWN;
    public static String JCC_EXIT_KEEP;
    public static String JCC_EXIT_ASK;
    protected String filename;
    protected Properties properties;
    protected static Configuration instance;
    protected static String fallback_conf;
    protected static Map messagetypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized Configuration getConfiguration() {
        if (instance == null) {
            String filename = null;
            try {
                filename = System.getProperty(JADEX_CONFIGURATION);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (filename == null && SUtil.getResourceInfo0("jadex.properties") != null) {
                filename = "jadex.properties";
            } else if (filename == null && fallback_conf != null) {
                filename = fallback_conf;
            }
            if (filename != null) {
                instance = new Configuration(filename);
            } else {
                throw new RuntimeException("Jadex started without configuration. Please use java -Dconf=<config>.properties");
            }
        }
        return instance;
    }

    public static void setFallbackConfiguration(String filename) {
        fallback_conf = filename;
    }

    protected Configuration(String filename) {
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        Properties versionprops = new Properties();
        InputStream is = SUtil.getResource0("/jadex/config/version.properties");
        if (is != null) {
            try {
                versionprops.load(is);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.filename = filename;
        this.properties = new Properties(versionprops);
        ResourceInfo rinfo = SUtil.getResourceInfo0(filename);
        if (rinfo != null) {
            try {
                this.filename = rinfo.getFilename();
                this.properties.load(rinfo.getInputStream());
                rinfo.cleanup();
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new RuntimeException("Could not load Jadex configuration  file:\n" + sw.toString());
            }
            if (!"true".equalsIgnoreCase(this.properties.getProperty(NO_WELCOME))) {
                System.out.println("\n    This is Jadex " + this.properties.getProperty("jadex.release.number") + " - " + this.properties.getProperty("jadex.release.date"));
                System.out.println("    Using configuration: " + this.filename + "\n");
            }
        } else {
            throw new RuntimeException("Could not find Jadex configuration file: " + filename);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void persist() throws IOException {
        if (!$assertionsDisabled && this.filename == null) {
            throw new AssertionError();
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            this.properties.store(fos, null);
        }
        catch (IOException e) {
            FileOutputStream fos = new FileOutputStream("./jadex.properties");
            this.properties.store(fos, null);
            Logger.getLogger(this.getClass().getName()).info("No write access to '" + this.filename + "' saved jadex.properties to current directory.");
            this.filename = "./jadex.properties";
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        if (name.equals(PARSER_NAME)) {
            SXML.clearModelCache(null);
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public boolean isModelChecking() {
        boolean ret = false;
        String tmp = this.properties.getProperty(MODEL_CHECKING);
        if (tmp != null) {
            ret = new Boolean(tmp);
        }
        return ret;
    }

    public void setModelChecking(boolean check) {
        this.properties.setProperty(MODEL_CHECKING, "" + check);
    }

    public boolean isModelCaching() {
        boolean ret = false;
        String tmp = this.properties.getProperty(MODEL_CACHING);
        if (tmp != null) {
            ret = new Boolean(tmp);
        }
        return ret;
    }

    public void setModelCaching(boolean cache) {
        this.properties.setProperty(MODEL_CACHING, "" + cache);
    }

    public boolean isModelCacheAutoRefresh() {
        boolean ret = false;
        String tmp = this.properties.getProperty(MODEL_CACHE_AUTOREFRESH);
        if (tmp != null) {
            ret = new Boolean(tmp);
        }
        return ret;
    }

    public void setModelCacheAutoRefresh(boolean autorefresh) {
        this.properties.setProperty(MODEL_CACHE_AUTOREFRESH, "" + autorefresh);
    }

    public String getParserName() {
        return this.properties.getProperty(PARSER_NAME);
    }

    public void setParserName(String name) {
        if (!name.equals(this.properties.getProperty(PARSER_NAME))) {
            SXML.clearModelCache(null);
            this.properties.setProperty(PARSER_NAME, name);
        }
    }

    public String getXMLDatabinding() {
        return this.properties.getProperty(XML_DATABINDING);
    }

    public void setXMLDatabinding(String name) {
        this.properties.setProperty(XML_DATABINDING, name);
    }

    public boolean isJaninoReadCache() {
        boolean ret = false;
        String tmp = this.properties.getProperty(JANINO_READ_CACHE);
        if (tmp != null) {
            ret = new Boolean(tmp);
        }
        return ret;
    }

    public void setJavaCCPlanReloading(boolean reloading) {
        this.properties.setProperty(JAVACC_PLAN_RELAODING, "" + reloading);
    }

    public boolean isJavaCCPlanReloading() {
        boolean ret = false;
        String tmp = this.properties.getProperty(JAVACC_PLAN_RELAODING);
        if (tmp != null) {
            ret = new Boolean(tmp);
        }
        return ret;
    }

    public void setJaninoReadCache(boolean cache) {
        this.properties.setProperty(JANINO_READ_CACHE, "" + cache);
    }

    public boolean isJaninoWriteCache() {
        boolean ret = false;
        String tmp = this.properties.getProperty(JANINO_WRITE_CACHE);
        if (tmp != null) {
            ret = new Boolean(tmp);
        }
        return ret;
    }

    public void setJaninoWriteCache(boolean cache) {
        this.properties.setProperty(JANINO_WRITE_CACHE, "" + cache);
    }

    public MessageType getMessageType(String name) {
        String mtname;
        MessageType ret = null;
        if (messagetypes == null) {
            messagetypes = SCollection.createHashMap();
        }
        if ((mtname = this.properties.getProperty(name)) != null && (ret = (MessageType)messagetypes.get(mtname)) == null) {
            try {
                Class mtclass = SReflect.classForName(mtname);
                ret = (MessageType)mtclass.newInstance();
                messagetypes.put(mtname, ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String getReleaseNumber() {
        String ret = null;
        InputStream is = SUtil.getResource0("/jadex/config/version.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
                ret = props.getProperty("jadex.release.number");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public String getReleaseDate() {
        String ret = null;
        InputStream is = SUtil.getResource0("/jadex/config/version.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
                ret = props.getProperty("jadex.release.date");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    static {
        $assertionsDisabled = !Configuration.class.desiredAssertionStatus();
        JADEX_CONFIGURATION = "conf";
        MODEL_CACHING = "model_caching";
        MODEL_CACHE_AUTOREFRESH = "model_cache_autorefresh";
        MODEL_CHECKING = "model_checking";
        PARSER_NAME = "parser_name";
        JANINO_WRITE_CACHE = "janino_write_cache";
        JANINO_READ_CACHE = "janino_read_cache";
        JAVACC_PLAN_RELAODING = "javacc_plan_reloading";
        XML_DATABINDING = "xml_databinding";
        NO_WELCOME = "no_welcome";
        JCC_EXIT = "jcc_exit";
        JCC_EXIT_SHUTDOWN = "jcc_exit_shutdown";
        JCC_EXIT_KEEP = "jcc_exit_keep";
        JCC_EXIT_ASK = "jcc_exit_ask";
    }
}

