/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.fipa;

import jadex.adapter.AbstractMessageAdapter;
import jadex.adapter.IJadexAgent;
import jadex.model.IMExpression;
import jadex.model.IMMessageEvent;
import jadex.model.IMParameter;
import jadex.model.IMParameterSet;
import jadex.runtime.ContentException;
import jadex.runtime.IContentCodec;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RExpression;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.NestedMap;
import jadex.util.collection.SCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public abstract class FipaMessageAdapter
extends AbstractMessageAdapter {
    protected Object content;

    public FipaMessageAdapter(IJadexAgent agent, Object message) {
        super(agent, message);
    }

    public boolean match(IMMessageEvent msgevent) {
        boolean match = "fipa".equals(msgevent.getMessageType().getName());
        RCapability scope = this.agent.lookupCapability(msgevent.getScope());
        IMParameter[] params = msgevent.getParameters();
        for (int i = 0; match && i < params.length; ++i) {
            Object mvalue;
            if (!params[i].getDirection().equals("fixed") || params[i].getDefaultValue() == null) continue;
            Object pvalue = RExpression.evaluateExpression(params[i].getDefaultValue(), scope.getExpressionParameters());
            if (params[i].getName().equals("content-start")) {
                mvalue = this.getValue("content", scope);
                match = pvalue == null && mvalue == null || pvalue instanceof String && mvalue instanceof String && ((String)mvalue).startsWith((String)pvalue);
                continue;
            }
            if (params[i].getName().equals("content-class")) {
                mvalue = this.getValue("content", scope);
                match = pvalue == null || mvalue == null || SReflect.isSupertype((Class)pvalue, mvalue.getClass());
                continue;
            }
            mvalue = this.getValue(params[i].getName(), scope);
            match = SUtil.equals(pvalue, mvalue);
        }
        IMParameterSet[] paramsets = msgevent.getParameterSets();
        for (int i = 0; match && i < paramsets.length; ++i) {
            if (!paramsets[i].getDirection().equals("fixed")) continue;
            ArrayList<Object> vals = new ArrayList<Object>();
            if (paramsets[i].getDefaultValues().length > 0) {
                IMExpression[] dvs = paramsets[i].getDefaultValues();
                for (int j = 0; j < dvs.length; ++j) {
                    vals.add(RExpression.evaluateExpression(dvs[i], null));
                }
            } else if (paramsets[i].getDefaultValuesExpression() != null) {
                Iterator it = SReflect.getIterator(RExpression.evaluateExpression(paramsets[i].getDefaultValuesExpression(), null));
                while (it.hasNext()) {
                    vals.add(it.next());
                }
            }
            Object mvalue = this.getValue(paramsets[i].getName(), scope);
            HashSet mvals = new HashSet();
            Iterator it = SReflect.getIterator(mvalue);
            while (it.hasNext()) {
                mvals.add(it.next());
            }
            match = mvals.containsAll(vals);
        }
        IMExpression matchexp = msgevent.getMatchExpression();
        if (match && matchexp != null) {
            Object mvalue;
            int i;
            NestedMap exparams = SCollection.createNestedMap(scope.getExpressionParameters());
            for (i = 0; i < params.length; ++i) {
                try {
                    mvalue = this.getValue(params[i].getName(), scope);
                    String paramname = "$" + SUtil.replace(params[i].getName(), "-", "_");
                    exparams.put(paramname, mvalue);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < paramsets.length; ++i) {
                try {
                    mvalue = this.getValue(paramsets[i].getName(), scope);
                    String paramsetname = "$" + SUtil.replace(paramsets[i].getName(), "-", "_");
                    exparams.put(paramsetname, mvalue);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                exparams.put("$messagemap", exparams.getLocalMap());
                match = (Boolean)RExpression.evaluateExpression(matchexp, exparams);
            }
            catch (Exception e) {
                match = false;
            }
        }
        return match;
    }

    public Object getValue(String name, RCapability scope) {
        Object val;
        if ("content".equals(name)) {
            if (this.content != null) {
                val = this.content;
            } else {
                val = this.getRawValue(name);
                if (val != null) {
                    String lang = (String)this.getValue("language", scope);
                    String onto = (String)this.getValue("ontology", scope);
                    if (lang != null || onto != null) {
                        IContentCodec codec;
                        Properties props = new Properties();
                        if (lang != null) {
                            props.setProperty("language", lang);
                        }
                        if (onto != null) {
                            props.setProperty("ontology", onto);
                        }
                        if ((codec = scope.getContentCodec(props)) == null && !(val instanceof String)) {
                            throw new ContentException("No content codec found for: " + props);
                        }
                        if (codec != null) {
                            val = codec.decode((String)val);
                        }
                        this.content = val;
                    }
                }
            }
        } else {
            val = this.getRawValue(name);
        }
        return val;
    }

    public abstract Object getRawValue(String var1);
}

