/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.fipa;

import jadex.adapter.fipa.AgentIdentifierData;
import jadex.config.Configuration;

public class AgentIdentifier
extends AgentIdentifierData {
    public AgentIdentifier() {
        this(null, false, null, null);
    }

    public AgentIdentifier(String name) {
        this(name, false, null, null);
    }

    public AgentIdentifier(String name, boolean local) {
        this(name, local, null, null);
    }

    public AgentIdentifier(String name, String[] addresses) {
        this(name, false, addresses, null);
    }

    public AgentIdentifier(String name, boolean local, String[] addresses, AgentIdentifier[] resolvers) {
        int i;
        this.setName(local ? name + "@" + Configuration.getConfiguration().getProperty("platformname") : name);
        for (i = 0; addresses != null && i < addresses.length; ++i) {
            this.addAddress(addresses[i]);
        }
        for (i = 0; resolvers != null && i < resolvers.length; ++i) {
            this.addResolver(resolvers[i]);
        }
    }

    public Object clone() {
        AgentIdentifier clone = new AgentIdentifier(super.getName(), false, this.getAddresses(), null);
        AgentIdentifier[] res = this.getResolvers();
        for (int i = 0; i < res.length; ++i) {
            clone.addResolver((AgentIdentifier)res[i].clone());
        }
        return clone;
    }

    public boolean hasAddress(String address) {
        boolean ret = false;
        for (int i = 0; !ret && i < this.addresses.size(); ++i) {
            ret = address.equals(this.addresses.get(i));
        }
        return ret;
    }

    public String getLocalName() {
        String ret = super.getName();
        int idx = ret.indexOf(64);
        if (idx != -1) {
            ret = ret.substring(0, idx);
        }
        return ret;
    }

    public String getPlatformName() {
        String ret = super.getName();
        int idx = ret.indexOf(64);
        if (idx != -1) {
            ret = ret.substring(idx + 1);
        }
        return ret;
    }
}

