/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter.fipa;

import jadex.adapter.fipa.AgentDescriptionData;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.ServiceDescription;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AgentDescription
extends AgentDescriptionData
implements Cloneable {
    public AgentDescription() {
        this(null);
    }

    public AgentDescription(AgentIdentifier name) {
        this(name, null, null, null, null, null);
    }

    public AgentDescription(AgentIdentifier name, ServiceDescription[] services, String[] protocols, String[] ontologies, String[] languages, Date leasetime) {
        int i;
        this.setName(name);
        this.setLeaseTime(leasetime);
        if (services != null) {
            for (i = 0; i < services.length; ++i) {
                this.addService(services[i]);
            }
        }
        if (protocols != null) {
            for (i = 0; i < protocols.length; ++i) {
                this.addProtocol(protocols[i]);
            }
        }
        if (languages != null) {
            for (i = 0; i < languages.length; ++i) {
                this.addLanguage(languages[i]);
            }
        }
        if (ontologies != null) {
            for (i = 0; i < ontologies.length; ++i) {
                this.addOntology(ontologies[i]);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AgentDescription)) {
            return false;
        }
        AgentDescription ad = (AgentDescription)obj;
        return AgentDescription.eq(ad.name, this.name) && AgentDescription.eq(ad.leasetime, this.leasetime) && AgentDescription.eq(ad.languages, this.languages) && AgentDescription.eq(ad.ontologies, this.ontologies) && AgentDescription.eq(ad.protocols, this.protocols) && AgentDescription.eq(ad.services, this.services);
    }

    private static final boolean eq(Object a, Object b) {
        return a == b || a != null && b != null && a.equals(b);
    }

    public Object clone() {
        try {
            AgentDescription ret = (AgentDescription)super.clone();
            ret.services = new ArrayList();
            ret.protocols = (List)((ArrayList)this.protocols).clone();
            ret.languages = (List)((ArrayList)this.languages).clone();
            ret.ontologies = (List)((ArrayList)this.ontologies).clone();
            for (int i = 0; i < this.services.size(); ++i) {
                ret.services.add(((ServiceDescription)this.services.get(i)).clone());
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Cannot clone: " + this);
        }
    }

    public String toString() {
        return "AgentDescription(" + this.getName() + ")";
    }
}

