/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter;

import jadex.adapter.IAgentAdapter;
import jadex.adapter.IJadexAgent;
import jadex.config.Configuration;
import jadex.model.IMBDIAgent;
import jadex.model.SXML;
import jadex.runtime.AgentCreationException;
import jadex.runtime.impl.JadexInterpreter;
import java.io.IOException;
import java.util.Map;

public class JadexAgentFactory {
    public static IJadexAgent createJadexAgent(IAgentAdapter adapter, String model, String config, Map arguments) {
        try {
            IMBDIAgent magent = SXML.loadAgentModel(model, null);
            if (Configuration.getConfiguration().isModelChecking() && !magent.getReport().isEmpty()) {
                throw new RuntimeException("Cannot start agent " + adapter.getAgentIdentifier().getLocalName() + " due to errors in model:\n" + magent.getReport().toString());
            }
            if (config != null && config.length() != 0 && magent.getConfigurationbase().getConfiguration(config) == null) {
                throw new RuntimeException("Cannot start agent " + adapter.getAgentIdentifier().getLocalName() + " with unknown initial state '" + config + "'.");
            }
            return new JadexInterpreter(adapter, magent, config, arguments);
        }
        catch (IOException e) {
            throw new AgentCreationException("Error loading agent model: " + model + "\n", e);
        }
    }
}

