/*
 * Decompiled with CFR 0.152.
 */
package jadex.adapter;

import jadex.adapter.IJadexAgent;
import jadex.adapter.IMessageAdapter;
import jadex.model.IMExpression;
import jadex.model.IMMessageEvent;
import jadex.model.IMParameter;
import jadex.model.IMParameterReference;
import jadex.model.IMParameterSet;
import jadex.model.IMParameterSetReference;
import jadex.runtime.impl.IRMessageEvent;
import jadex.runtime.impl.IRParameter;
import jadex.runtime.impl.IRParameterSet;
import jadex.runtime.impl.RCapability;
import jadex.runtime.impl.RExpression;
import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.NestedMap;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractMessageAdapter
implements IMessageAdapter,
Serializable {
    protected IJadexAgent agent;
    private Object message_object;
    protected IRMessageEvent inreply;
    protected boolean searched_inreply;

    public AbstractMessageAdapter(IJadexAgent agent, Object message) {
        this.agent = agent;
        this.message_object = message;
    }

    public boolean match(IMMessageEvent msgevent) {
        boolean match = true;
        RCapability scope = this.agent.lookupCapability(msgevent.getScope());
        IMParameter[] params = msgevent.getParameters();
        for (int i = 0; match && i < params.length; ++i) {
            if (!params[i].getDirection().equals("fixed") || params[i].getDefaultValue() == null) continue;
            Object pvalue = RExpression.evaluateExpression(params[i].getDefaultValue(), scope.getExpressionParameters());
            Object mvalue = this.getValue(params[i].getName(), scope);
            match = pvalue == null && mvalue == null || pvalue != null && mvalue != null && pvalue.equals(mvalue);
        }
        IMParameterSet[] paramsets = msgevent.getParameterSets();
        for (int i = 0; match && i < paramsets.length; ++i) {
            if (!paramsets[i].getDirection().equals("fixed")) continue;
            ArrayList<Object> vals = new ArrayList<Object>();
            if (paramsets[i].getDefaultValues().length > 0) {
                IMExpression[] dvs = paramsets[i].getDefaultValues();
                for (int j = 0; j < dvs.length; ++j) {
                    vals.add(RExpression.evaluateExpression(dvs[i], null));
                }
            } else if (paramsets[i].getDefaultValuesExpression() != null) {
                Iterator it = SReflect.getIterator(RExpression.evaluateExpression(paramsets[i].getDefaultValuesExpression(), null));
                while (it.hasNext()) {
                    vals.add(it.next());
                }
            }
            Object mvalue = this.getValue(paramsets[i].getName(), scope);
            HashSet mvals = new HashSet();
            Iterator it = SReflect.getIterator(mvalue);
            while (it.hasNext()) {
                mvals.add(it.next());
            }
            match = mvals.containsAll(vals);
        }
        IMExpression matchexp = msgevent.getMatchExpression();
        if (match && matchexp != null) {
            Object mvalue;
            int i;
            NestedMap exparams = SCollection.createNestedMap(scope.getExpressionParameters());
            for (i = 0; i < params.length; ++i) {
                try {
                    mvalue = this.getValue(params[i].getName(), scope);
                    String paramname = "$" + SUtil.replace(params[i].getName(), "-", "_");
                    exparams.put(paramname, mvalue);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < paramsets.length; ++i) {
                try {
                    mvalue = this.getValue(paramsets[i].getName(), scope);
                    String paramsetname = "$" + SUtil.replace(paramsets[i].getName(), "-", "_");
                    exparams.put(paramsetname, mvalue);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                exparams.put("$messagemap", exparams.getLocalMap());
                match = (Boolean)RExpression.evaluateExpression(matchexp, exparams);
            }
            catch (Exception e) {
                e.printStackTrace();
                match = false;
            }
        }
        return match;
    }

    public Object getMessage() {
        return this.message_object;
    }

    public abstract Object getValue(String var1, RCapability var2);

    public static void prepareReceiving(IRMessageEvent msgevent, IMessageAdapter msg) {
        msgevent.setMessage(msg.getMessage());
        msgevent.setId(msg.getId());
        IRParameter[] params = msgevent.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Object mvalue;
            IMParameter model;
            if (params[i].getModelElement() instanceof IMParameterReference) {
                IMParameterReference pref = (IMParameterReference)params[i].getModelElement();
                model = (IMParameter)pref.getOriginalElement();
            } else {
                model = (IMParameter)params[i].getModelElement();
            }
            if (!model.getDirection().equals("in") && !model.getDirection().equals("inout") || (mvalue = msg.getValue(params[i].getName(), msgevent.getScope())) == null) continue;
            params[i].setValue(mvalue);
        }
        IRParameterSet[] paramsets = msgevent.getParameterSets();
        for (int i = 0; i < paramsets.length; ++i) {
            Object mvalue;
            IMParameterSet model;
            if (paramsets[i].getModelElement() instanceof IMParameterSetReference) {
                IMParameterSetReference psetref = (IMParameterSetReference)paramsets[i].getModelElement();
                model = (IMParameterSet)psetref.getOriginalElement();
            } else {
                model = (IMParameterSet)paramsets[i].getModelElement();
            }
            if (!model.getDirection().equals("in") && !model.getDirection().equals("inout") || (mvalue = msg.getValue(paramsets[i].getName(), msgevent.getScope())) == null) continue;
            Iterator it = SReflect.getIterator(mvalue);
            while (it.hasNext()) {
                paramsets[i].addValue(it.next());
            }
        }
    }
}

