<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * start up script
 * @package Jade
 * @subpackage cms
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp

// Il faut s'assurer que le caractere set d'encodage ISO-8859-1
// soit install sur le serveur
// ajout pour permetre la saisie de caractres accentus
// qui a caus des problmes lors du changements de serveur
// vers Debian.
setlocale(LC_CTYPE, 'fr_CA'); 

if (file_exists("./maintenance.html")) {
  require("./maintenance.html");
  exit();
}
require_once("./cms/lib/util.php");
if (preg_match("/(.*)-(.*)/", gget(action), $matches)) {
    header("Location:http://". $_SERVER['HTTP_HOST'] . get_url_path() . "?action=$matches[1]&index=$matches[2]&frame=fcontent&langue=" . gget("langue"));
}
// read cms & application configuration
include("./cms/cms_config.php");
copin_include("config_application.php");

/* read machine configuration file */
$config_machine_file_name = "./config_" . get_constant("MACHINE_NAME") . ".php";
copin_include($config_machine_file_name);

/* read site configuration file */
$config_site_file_name = "./config_" . get_constant("SITE_NAME") . ".php";
if (file_exists($config_site_file_name)) {
   include_once($config_site_file_name);
}

if (get_constant("DEBUG_FILE") && get_constant("DEBUG") == 1) {
      error_log("\n" . "URL - " . date("Y/m/j H:i:s") . " " . nget("REQUEST_URI") . "\n", 3, get_constant("DEBUG_FILE"));
}

//classes ncessaires avant le session_start
//inclusion des librairies ncessaires localement
copin_include("lib/class.skin.php");
copin_include("lib/class.cookie.php");
copin_include("lib/apputil.php");
require_once("./cms/lib/db.php");

set_language();
aset("no_sequence", true);
aset("controle_sequence_invalide", false);
aset("multifm", true);

/*
  CUSTOM_SESSION est utilis dans le cas ou on ne peut utiliser la session_start(), c'est  dire
  qu'aucun header doit tre envoy avant.
*/
if(gget("custom_session") != "" && function_exists(app_custom_session)){
  app_custom_session(gget("custom_session"));
} else {
  $action = gget("action");
  if ($action == "")
    $action = "top_accueil";
  aset("action", $action);
  copin_include("form/" . $action . "_inc");
  session_start();
  $GLOBALS["files"] = array_merge($GLOBALS["files"], $_SESSION[get_constant("SITE_NAME")]["files"]);
  copin_include("lib/browser.php");
  copin_include("lib/error_handler.php");
  copin_include("context.php");copin_include("lib/session.php");
  copin_include("lib/form_validator.php");
  copin_include("lib/html.php");
  copin_include("lib/menu.php");
  classskin::skin($action);
  $_SESSION[get_constant("SITE_NAME")]["files"] = $GLOBALS["files"];
}

function initialize_site_user($usager){
  $rs = selectsql("SELECT site_user,
               language,
               site_user_type,
               first_name,
               last_name,
               email,
               signature,
               return_address,
               is_administrator(site_user) as administrator
            FROM cms.site_user WHERE site_user='$usager'");
            
    $r = $rs[0];
    set_cargo("user_name", $r["site_user"]);
    set_cargo("email", $r["email"]);
    set_cargo("signature", $r["signature"]);
    set_cargo("salutation", $r["first_name"] . " " . $r["last_name"]);
    set_cargo("from", "\"" . $r["first_name"] . " " . $r["last_name"] 
      . "\"<" .  $r["email"] . ">");
    set_cargo("user_id", md5($r["site_user"] . get_hidden_hash_var()) );
    set_cargo("language", $r["language"]);
    set_cargo("site_user_type", $r["site_user_type"]);
    set_cargo("is_administrator", $r["administrator"] == 1);
    $user_wright = process_user_wright($r["site_user"]);
    set_cargo("user_wright", $user_wright);
    set_cargo("user_actions", user_actions($user_wright));
    if (function_exists(app_initialize_site_user))
      app_initialize_site_user($usager);
}

  function user_actions($wright){
    if (is_array($wright))
      return implode(", ", array_keys($wright));
    else
     return "";
  }
  
?>