<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
 
/**
 * save.php
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

session_start();
$format = $_GET['format'];
$report = $_GET["rapport"];
$str =    $_SESSION[$report]["str"];

$file_name = "rapport_".$format."_".date('Ymd');
Save_String_As_Document($str,$format,$file_name);

function Save_String_As_Document($stream,$document_type,$file_name)
{
	// Content-Type du stream a retourner
	$DOC_TYPE["word"]["content_type"] 	= "application/msword";
	$DOC_TYPE["excel"]["content_type"] 	= "application/x-msexcel";
	$DOC_TYPE["csv"]["content_type"]	= "application/x-msexcel";
	$DOC_TYPE["html"]["content_type"]	= "text/html";
	$DOC_TYPE["htm"]["content_type"]	= "text/html";
	$DOC_TYPE["stream"]["content_type"]	= "octet/stream";

	// Extension du fichier a retourner
	$DOC_TYPE["word"]["extension"] = "doc";
	$DOC_TYPE["excel"]["extension"]= "xls";
	$DOC_TYPE["csv"]["extension"]  = "csv";
	$DOC_TYPE["html"]["extension"]  = "html";
	$DOC_TYPE["htm"]["extension"]  = "htm";
	$DOC_TYPE["stream"]["extension"] = "dat";

	$stream_size = strlen($stream);
	if($stream_size>0)
	{
		$type = $DOC_TYPE["stream"]["content_type"];
		$ext  = $DOC_TYPE["stream"]["extension"];

		if(strlen($DOC_TYPE[strtolower($document_type)]["content_type"]))
		{
			$type = $DOC_TYPE[strtolower($document_type)]["content_type"];
		}
		if(strlen($DOC_TYPE[strtolower($document_type)]["extension"]))
		{
			$ext = $DOC_TYPE[strtolower($document_type)]["extension"];
		}

		header("Content-type: $type");
		if($type == $DOC_TYPE["stream"]["content_type"])
		{
			$forcer_download = "attachment;";
		}
    
		header("Content-disposition:$forcer_download filename=".$file_name.".".$ext.";");
		header("Content-Length: $stream_size");
		
    echo $stream;
		exit();
	}
}
?>