<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * vCalendar display class
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
copin_include("lib/class.vCalendar");
copin_include("lib/pgarrays");
class vCalendar_zoom extends formzoom {
  
  function vCalendar_zoom($sql, $key = "", $connect = null){
    $this->FormZoom($sql, $key, $connect);
    $this->vCalendar = new vCalendar();
    while (list($index, $subarray) = each($this->vCalendar->rfields))
      $this->add_field($subarray, 100, false);
    $this->radio("frequency", get_str("arr_frequency", "vCalendar_zoom"));
    $this->defaut("frequency", "D");
    $this->html_attribut("frequency", "onclick=\"stabilisefrequency(this.value)\"");
    
    $this->width("interval", 50);
    $this->initializevalue("interval", 1);
    $this->between("interval", 1);
    $this->hidden("yday");
    
    $this->label("exceptions", get_str("lbl_exceptions", "vCalendar_zoom"));
    $this->label("wSU", get_str("lbl_wSU", "vCalendar_zoom"));
    $this->label("wMO", get_str("lbl_wMO", "vCalendar_zoom"));
    $this->label("wTU", get_str("lbl_wTU", "vCalendar_zoom"));
    $this->label("wWE", get_str("lbl_wWE", "vCalendar_zoom"));
    $this->label("wTH", get_str("lbl_wTH", "vCalendar_zoom"));
    $this->label("wFR", get_str("lbl_wFR", "vCalendar_zoom"));
    $this->label("wSA", get_str("lbl_wSA", "vCalendar_zoom"));
    $this->label("interval", get_str("lbl_interval", "vCalendar"));
    $this->label("enable", get_str("lbl_enable", "vCalendar_zoom"));
    $this->html_attribut("enable", "onclick=\"activate_all(this, this.checked); stablise_all(this.checked);\"");
    
    $this->radio("ending_type", get_str("arr_ending_type", "vCalendar_zoom"));
    $this->defaut("ending_type", "forever");
    $this->html_attribut("ending_type", "onclick=\"stabilise_ending_type(this.value)\"");
    
    $this->set_property(array("ending_type", "mtype", "ytype"), "seperator", "<br>");
    $this->width("duration", 50);
    $this->calendar("enddate");
    $this->width("enddate", get_constant("STANDARD_WIDTH_DATE"));
    $this->boolean(array("enable", "wSU", "wMO", "wTU", "wWE", "wTH", "wFR", "wSA"));
    $this->ouinon_value(array("enable", "wSU", "wMO", "wTU", "wWE", "wTH", "wFR", "wSA"), 1, 0);
    
    $this->defaut("mtype", "D");
    $this->radio("mtype", get_str("arr_mtype", "vCalendar_zoom"));
    $this->html_attribut("mtype", "onclick=\"stabilise_mtype(this.value);return true;\"");
    $this->pick_list("mday_number", array_flip($this->vCalendar->month_array_numbers));
    $this->width("mday_number", 75);
    $this->pick_list("moccurence", array_flip($this->vCalendar->array_occurence));
    $this->width(array("moccurence", "mweekday", "ymonth"), 100);
    $this->pick_list("mweekday", array_flip($this->vCalendar->array_weekday));
    $this->width(array("mweekday", "mday_number", "ytype", "ymonth", "moccurence"), "");
    $this->defaut("ytype", "M");
    $this->radio("ytype", get_str("arr_ytype", "vCalendar_zoom"));
    $this->html_attribut("ytype", "onclick=\"stabilise_ytype(this.value);return true;\"");
    $this->pick_list("ymonth", get_str("arr_ymonth", "vCalendar_zoom"));
    $this->validation_type("interval", "integer");
    $this->validation_type("enddate", "date");
    $this->required(array("interval", "mday_number", "moccurence", "mweekday", "ymonth"));
  }
  
  function get_fieldtr($index, $value){
    if (!in_array($index, $this->vCalendar->rfields)) {
      parent::get_fieldtr($index, $value);
    }
  }
  
  function get_fieldtd($index, $value, $no_update = null) { 
    if (!in_array($index, $this->vCalendar->rfields)) {
      if ($this->_fields[$index]["html_type"] != "vCalendarrule" &&
      $this->_fields[$index]["html_type"] != "vCalendarexceptions") {
        parent::get_fieldtd($index, $value, $no_update);
      } elseif ($this->_fields[$index]["html_type"] != "vCalendarexceptions") {
        if (preg_match("/^(\d\d\d\d)-(\d\d)-(\d\d)/", $this->_rs["date"], $matches)) {
          $startdate = mktime(0, 0, 0, $matches[2], $matches[3], $matches[1]);
          $longdate = $matches[3] . " " . translate_month($matches[2]) . " " . $matches[1];
          $longdatearray = $matches;
        }
        $this->vCalendar->update_rrule($this->_rs["regle"]);
        $_rs = $this->vCalendar->split_rrule();
	      $lehtml = "<td colspan = 2 style=\"padding:0px 20px 0px 20px\"><div id=\"vCalendar\"><table cellspacing=0 cellpadding=0 width=100%><tr><td><table width=550 cellspacing=0 cellpadding=6><tr><td>";
	      $lehtml .= preg_replace(array("/::year::/", "/::day::/", "/::month::/"), 
	         array($longdatearray[1], ($longdatearray[3] + 0 ), get_language_code() == "enus" ? ucfirst(translate_month($matches[2])) : translate_month($matches[2])), 
	         get_str("lbl_a_compter", "vCalendar_zoom"));
        if ($this->_rs["debut"] != "")
          $lehtml .=  preg_replace(array("/::debut::/", "/::fin::/"), 
            array($this->format($this->_rs["debut"], "shorttime"), $this->format($this->_rs["fin"], "shorttime")), 
            get_str($this->_rs["fin"] != "" ? "lbl_a_compter_fin" : "lbl_a_compter_debut", "vCalendar_zoom"));
        $lehtml .=  "<br><br>";
	      if ($this->debug)
  	      $lehtml .= "$index = $value<br>";
	      $lehtml .= $this->get_control("enable", $this->_rs["regle"] == "" ? 0 : 1, $no_update) . "<label name=\"lbl_enable\" for=\"id_" . $this->_fields["enable"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" . $this->_fields["enable"]['label']. "</label>";
 	      
	      $lehtml .= "</td></tr><tr><td class=\"formbox\" height=125 valign=top>";
	      $lehtml .= $this->get_control("frequency", $_rs["frequency"], $no_update);
	      $lehtml .= "<br><br>&nbsp;&nbsp;<label for=\"id_" . $this->_fields["interval"]["name"] . "\">";
	      $lehtml .= $this->_fields["interval"]['label'] . (is_ie() ? "" : "</label><label>") . "&nbsp;" . $this->get_control("interval", $_rs["interval"], $no_update) . "&nbsp;<span id=\"frequencysub\"></span><label><br><br>";
	      
	      $lehtml .= "<div id=\"weekly_rule\" style=\"display:none\">";
	      $this->set_day($_rs, $startdate);
	      $lehtml .= $this->get_control("wSU", $_rs["wSU"], $no_update) . "<label for=\"id_" . $this->_fields["wSU"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" .  $this->_fields["wSU"]['label'] . "&nbsp;</label>&nbsp;&nbsp;";
	      $lehtml .= $this->get_control("wMO", $_rs["wMO"], $no_update) . "<label for=\"id_" . $this->_fields["wMO"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;"  .  $this->_fields["wMO"]['label'] . "&nbsp;</label>&nbsp;&nbsp;";
	      $lehtml .= $this->get_control("wTU", $_rs["wTU"], $no_update) . "<label for=\"id_" . $this->_fields["wTU"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" .  $this->_fields["wTU"]['label'] . "&nbsp;</label>&nbsp;&nbsp;";
	      $lehtml .= $this->get_control("wWE", $_rs["wWE"], $no_update) . "<label for=\"id_" . $this->_fields["wWE"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" .  $this->_fields["wWE"]['label'] . "&nbsp;</label>&nbsp;&nbsp;";
	      $lehtml .= $this->get_control("wTH", $_rs["wTH"], $no_update) . "<label for=\"id_" . $this->_fields["wTH"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" .  $this->_fields["wTH"]['label'] . "&nbsp;</label>&nbsp;&nbsp;";
	      $lehtml .= $this->get_control("wFR", $_rs["wFR"], $no_update) . "<label for=\"id_" . $this->_fields["wFR"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" .  $this->_fields["wFR"]['label'] . "&nbsp;</label>&nbsp;&nbsp;";
	      $lehtml .= $this->get_control("wSA", $_rs["wSA"], $no_update) . "<label for=\"id_" . $this->_fields["wSA"]['name'] . "\" style=\"cursor: arrow;\">&nbsp;" .  $this->_fields["wSA"]['label']. "&nbsp;</label>";
	      $lehtml .= "</div>";
	      
	      $lehtml .= "<div id=\"monthly_rule\" style=\"display:none\">";
	      $newchoices = $oldchoices = $this->_fields["mtype"]["leschoix"]; //echo 0+substr($this->_rs["date"], 8, 2).$this->_rs["date"];
	      $mday_number = $this->get_control("mday_number", 
	        ($_rs["mday_number"] == "" ? 0+date("j", $startdate) : 0+$_rs["mday_number"]), $no_update);
	      $newchoices["D"] = preg_replace("/\:\:mday_number\:\:/", (is_ie() ? "" : "</label><label>") . $mday_number, $newchoices["D"]);
	      $moccurence = $this->get_control("moccurence", 
	        ($_rs["moccurence"] == "" ? ceil(date("j", $startdate) / 7) . "+" : $_rs["moccurence"]), $no_update);
	      $newchoices["P"] = preg_replace("/\:\:moccurence\:\:/", (is_ie() ? "" : "</label><label>") . $moccurence, $newchoices["P"]);
	      $mweekday = $this->get_control("mweekday", 
	        ($_rs["mweekday"] == "" ? strtoupper(substr(date("D", $startdate), 0, 2)) : $_rs["mweekday"]) , $no_update);
	      $newchoices["P"] = preg_replace("/\:\:mweekday\:\:/", (is_ie() ? "" : "</label><label>") . $mweekday, $newchoices["P"]);
	      $this->_fields["mtype"]["leschoix"] = array_flip($newchoices);
	      $lehtml .= $this->get_control("mtype", $_rs["mtype"], $no_update);
	      $this->_fields["mtype"]["leschoix"] = $oldchoices;
	      $lehtml .= "</div>";
	      
	      $lehtml .= "<div id=\"yearly_rule\" style=\"display:none\">";
	      $newchoices = $oldchoices = $this->_fields["ytype"]["leschoix"];
	      
	      $yday = $this->get_control("yday", 
	        ($_rs["yday"] == "" ? (date("z", $startdate) + 1) : $_rs["yday"]), $no_update);
	      $daynumber = ($_rs["yday"] == "" ? date("z", $startdate) + 1 : $_rs["yday"]);
	      $newchoices["D"] = preg_replace("/\:\:yday\:\:/", $yday . $daynumber . "<sup>" . $this->vCalendar->get_th($daynumber) . "</sup>", $newchoices["D"]);
	      
	      
	      $newchoices["M"] = preg_replace("/\:\:yday\:\:/", date("j", $startdate), $newchoices["M"]);
	      $ymonth = $this->get_control("ymonth",
	        ($_rs["ymonth"] == "" ? date("n", $startdate) : $_rs["ymonth"]), $no_update);
	      $newchoices["M"] = preg_replace("/\:\:ymonth\:\:/", (is_ie() ? "" : "</label><label>") . $ymonth, $newchoices["M"]);
	      $this->_fields["ytype"]["leschoix"] = array_flip($newchoices);
	      $lehtml .= $this->get_control("ytype", $_rs["ytype"], $no_update);
	      $this->_fields["ytype"]["leschoix"] = $oldchoices;
	      $lehtml .= "</div>";
	      
	      $lehtml .= "</td></tr></table><img src=\"cms/image/spacer.gif\" width=\"10\" height=\"10\" border=\"0\"><br>";
	      $lehtml .= "<table width=100% cellspacing=0 cellpadding=6><tr><td valign=top class=\"formbox\">";
	      $lehtml .= "&nbsp;&nbsp;<label>" . get_str("lbl_se_termine", "vCalendar_zoom") . "</label><br><img src=\"cms/image/spacer.gif\" width=\"10\" height=\"5\" border=\"0\"><br>";
	      $newchoices = $oldchoices = $this->_fields["ending_type"]["leschoix"];
	      $duration = $this->get_control("duration", $_rs["duration"], $no_update);
	      $newchoices["nb_occurence"] = preg_replace("/\:\:duration\:\:/", 
	         (is_ie() ? "" : "</label><label>") . $duration, 
	         $newchoices["nb_occurence"]);
	      $newchoices["nb_occurence"] = preg_replace("/\:\:suboccurrence\:\:/", 
	         get_str("suboccurrence") != "" ? get_str("suboccurrence") : get_str("suboccurrence", "vCalendar"),
	         $newchoices["nb_occurence"]);
	      $enddate = $this->get_control("enddate", $_rs["enddate"], $no_update);
	      $newchoices["enddate"] = preg_replace("/\:\:enddate\:\:/",  (is_ie() ? "" : "</label><label>") . $enddate, $newchoices["enddate"]);
	      $this->_fields["ending_type"]["leschoix"] = array_flip($newchoices);
	      $lehtml .= $this->get_control("ending_type", $_rs["ending_type"], $no_update);
	      $this->_fields["ending_type"]["leschoix"] = $oldchoices;
	      $lehtml .= "</td><td width=\"1\"><img src=\"cms/image/spacer.gif\" width=\"1\" height=\"10\" border=\"0\"></td><td class=\"formbox\">";
	      $this->set_exceptions($this->_rs["exceptions"]);
	      $lehtml .= "<label>" . $this->_fields["exceptions"]['label'] . "</label>";
	      $lehtml .= "<input type=\"hidden\" id=\"id_fld_exeptions\" name=\"fld_exceptions\" value=\"$this->exceptions\">
<br><table cellspacing=0 cellpadding=0><tr><td><input type=\"hidden\" id=\"add_fld_exeptions\" name=\"add_fld_exeptions\" onchange=\"add_option('fld_exeptions')\"><select style=\"width:100\" id=\"select_fld_exeptions\" size=\"5\" ondblclick=\"btp_fld_exeptionsplus.onclick();\">"
 . $this->htmloptions . "</select></td><td valign=top style=\"padding-left:3\"><input class=\"formeZoombutton\" type=\"button\" id=\"btp_fld_exeptionsplus\" style=\"width:20;margin-top:0\" value=\"+\" onclick=\"show_popup_calendar('forme.add_fld_exeptions', '', 'YYYY/MM/DD|YYYY-MM-DD', '" . sget("css_dir") . "', '" . sget("calendar_methode") . 
    "', document.forme.add_fld_exeptions.value );\"><br><input class=\"formeZoombutton\" type=\"button\" id=\"btm_fld_exeptions\" style=\"width:20\" value=\"-\" onclick=\"del_option('fld_exeptions')\">";
	      
	      $lehtml .= "</td></tr></table></td></tr></table></td></tr></table></div><br></td>";
	      $lehtml .= "<script>document.getElementById('id_fld_enable').onclick();
  </script>";
	      echo $lehtml;
	      $this->rsrule = $_rs;
      }
    }
  }
  
  function set_day(&$_rs, $date) {
    if ($_rs["frequency"] != "W") {
        $_rs["w" . strtoupper(substr(date("D", $date), 0, 2))] = "1";
    }
  }
  
  function set_exceptions($exceptions) {
    $this->htmloptions = "";
    $this->exceptions = "";
    if ($exceptions) {
      $lesexceptions = preg_split("/,/", substr($exceptions, 1, strlen($exceptions) -1));
      while (list($index, $subarray) = each($lesexceptions)) { 
        $subarray = 
          $this->format(substr($subarray, 1, strlen($subarray) -1), "shortdate");
        $this->htmloptions .= "<option value=\"$subarray\">$subarray</value>";
        $this->exceptions .= $subarray . ",";
      }
      $this->exceptions = substr($this->exceptions, 0, strlen($this->exceptions) -1);
    }
  }
  
  function format($value, $format, $highlightreg = "", $fld_name = ""){
    if ($format == "vCalendarverbose") {
      if ($this->debug)
        $originalvalue = $value . "<br>";
      $value = $originalvalue . $this->vCalendar->vcal2verbose_rrule($value) .
        $this->vCalendar->vcal2verbose_exceptions($this->_rs["exceptions"]);
    }
    return parent::format($value, $format, $highlightreg, $fld_name);
  }
  
  function _display(&$fm, $lindex = null) {
    echo "<script>
  function update_options(field_name) {
  var select_field = document.getElementById('select_' + field_name);
  var hidden_field = document.getElementById('id_' + field_name);
  var nb_options = select_field.options.length;
  var values = '';
  
  if (nb_options > 0) { 
    for (var i = 0; i<nb_options; i++ ) {
      values += select_field.options[i].value + ',';
    }
  }
  values = values.substring(0, values.length-1);
  hidden_field.value = values;
  
}

function add_option(field_name) {
  var select_field = document.getElementById('select_' + field_name);
  var new_value = document.getElementById('add_' + field_name).value;
  var nb_options = select_field.options.length;
  var options = new Array();
  var add = false;
  for (var i = 0; i<nb_options; i++ ) {
    options[i] = select_field.options[i].value;
  } 
  var lesoptions =  '|' + options.join('|') + '|';
  var test = lesoptions.indexOf('|' + new_value + '|');
  if (test < 0) {
    options[nb_options] = new_value;
    add = true;
  }
  options.sort();
  for (var i = 0; i<nb_options; i++ ) { //alert(i);
    select_field.options[i].value = options[i];
    select_field.options[i].text = options[i];
  }
  if (add)
    select_field.options[nb_options] = new Option(options[nb_options], options[nb_options]);
  update_options(field_name);
}

function del_option(field_name) {
  var select_field = document.getElementById('select_' + field_name);
  if (select_field.options.selectedIndex >= 0)
    select_field.options[select_field.options.selectedIndex] = null;
  update_options(field_name);
}

function activate_all(control, value) {
  if (typeof(value) == 'undefined')
    value = false;
  else
    value = !value;
  var masterdiv = document.getElementById('vCalendar');
  var inputs = masterdiv.getElementsByTagName('input');
  var selects = masterdiv.getElementsByTagName('select');
  var labels = masterdiv.getElementsByTagName('label');
  for (var i = 0; i < inputs.length; i++) {
    if (inputs[i] != control)
      if (inputs[i].type == 'button' || inputs[i].type == 'checkbox')
        inputs[i].disabled = value;
      else
        swap_actif_inputbox_actif(inputs[i], '', '', !value);
  }
  for (var i = 0; i < selects.length; i++) {
    if (selects[i] != control)
        swap_actif_inputbox_actif(selects[i], '', '', !value);
  }
}
function radio_value(id) {
 var el = document.forme.elements[id];
 var radiogroup = el;
 var itemvalue;
 for(var j = 0 ; j < radiogroup.length ; ++j) {
  if(radiogroup[j].checked) {
	  itemvalue = radiogroup[j].value;
	  break;
	}
 }
 return itemvalue;
} 

function stablise_all(selected) {
  if (selected) {
    stabilisefrequency(radio_value('fld_frequency'));
	  stabilise_ending_type(radio_value('fld_ending_type'));
    _stabilise_mtype(radio_value('fld_mtype'));
    _stabilise_ytype(radio_value('fld_ytype'));
  }
}

    function stabilisefrequency(frequency) {
      document.getElementById('weekly_rule').style.display = 'none';
      document.getElementById('monthly_rule').style.display = 'none';
      document.getElementById('yearly_rule').style.display = 'none';
      document.getElementById('frequencysub').innerHTML = '" . get_str("lbl_interval_day", "vCalendar") . "';
      if (document.getElementById('toussub'))
        document.getElementById('toussub').innerHTML = '';
      switch (frequency) {
        case 'W':
         document.getElementById('weekly_rule').style.display = 'block';
         document.getElementById('frequencysub').innerHTML = '" . get_str("lbl_interval_week", "vCalendar") . "';
         if (document.getElementById('toussub'))
           document.getElementById('toussub').innerHTML = '" . (is_primary_language() ? "te" : "") . "';
        break;
        case 'M':
         document.getElementById('monthly_rule').style.display = 'block';
         document.getElementById('frequencysub').innerHTML = '" . get_str("lbl_interval_month", "vCalendar") . "';
        break;
        case 'Y':
         document.getElementById('yearly_rule').style.display = 'block';
         document.getElementById('frequencysub').innerHTML = '" . get_str("lbl_interval_year", "vCalendar") . "';
        break;
      } 
    }
function stabilise_ending_type(ending_type) {
    swap_actif_inputbox_actif(document.getElementById('id_fld_duration'), '', '', ending_type == 'nb_occurence');
    swap_actif_inputbox_actif(document.getElementById('id_fld_enddate'), '', '', ending_type == 'enddate');
}
var lastmtype = '" . $this->rsrule["mtype"] . "';
function stabilise_mtype(mtype) {
  if (lastmtype != mtype || mtype == '') {
    lastmtype = mtype;
    _stabilise_mtype(mtype);
  }
  return true;
}
function _stabilise_mtype(mtype) {
    swap_actif_inputbox_actif(document.getElementById('id_fld_mday_number'), '', '', mtype == 'D' || mtype == '');
    swap_actif_inputbox_actif(document.getElementById('id_fld_moccurence'), '', '', mtype == 'P');
    swap_actif_inputbox_actif(document.getElementById('id_fld_mweekday'), '', '', mtype == 'P');
  return true;
}
var lastytype = '" . $this->rsrule["ytype"] . "';
function stabilise_ytype(ytype) {
  if (lastytype != ytype || ytype == '') {
    lastytype = ytype;
     _stabilise_ytype(ytype);
  }
  return true;
}
function _stabilise_ytype(ytype) {
    swap_actif_inputbox_actif(document.getElementById('id_fld_ymonth'), '', '', ytype == 'M' || ytype == '');
}
    </script>";
    parent::_display($fm, $lindex);
    
  }
  
  function get_control($index, $value, $no_update) {
    return get_control(
          $this->_fields[$index],
          $this->format($value, $this->_fields[$index]['display_format'], "", $index),
          $no_update,
          ($this->_fields[$index]['boutonjs_ropresent'] ? $this->get_fieldboutonjs($index) : "" ),
          $this->formname,
          $this->_alt_bd);
  }
  
  function wrap($html_type, $value, $toupper, $non_value, $fieldname = ""){
    if ($html_type == "vCalendarrule") {
      while (list($index, $subarray) = each($this->vCalendar->rfields))
        $rule[$subarray] = pget("fld_$subarray");
      $this->vCalendar->update_rrule($rule);
      $value = $this->vCalendar->get_rrule();
    }  elseif ($html_type == "vCalendarexceptions") {
      if (pget("fld_enable") == 0)
        $value = "";
      if ($value !== "") 
        $value = "{" . $value . "}";
    }
      $value = parent::wrap($html_type, $value, $toupper, $non_value, $fieldname);
   
    return $value;
  }
}
?>