<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * general php function library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
/*
  Routines  buts gnraux
  Novembre 2001

  Validation du Numero assurance sociale

 Modification du 3 juin 2003
    - Enlever_Accents()    Enlever les accents d'une chane de caractres
*/

function msg_erreur($msg, $errno = 1000000) {
   // Traduction et login de lerreur + avertissement par e-mail ?
   // $errno 1000000 est l'erreur gnerique
   echo $msg ;
}

/* 
  functions get et set

  GLOBALS : All, Master Array --> aget, aset
  HTTP_SYSTEM_VARS : Environment --> eget
  HTTP_SESSION_VARS : Session --> sget, sset
  HTTP_GET_VARS : Get --> gget
  HTTP_POST_VARS : Post --> pget
  HTTP_COOKIE_VARS : Cookie --> cget, cset
  HTTP_SERVER_VARS : SERVER --> nget
  
  get_language : retourne la langue, rien si francais et langue si anglais
  get_suffix_langue : retourne le suffix pour le nom des fichiers,
        rien si francais et _langue si anglais
*/


// GLOBALS : All, Master Array --> aget, aset
function aget($var) {
  return $GLOBALS[$var] ;
}

function aset ($var, $value) {
   $GLOBALS[$var] = trim($value) ;
}

// HTTP_SYSTEM_VARS : Environment --> eget
function eget($var) {
  return $_SYSTEM[$var] ;
}

// HTTP_SESSION_VARS : Session  --> sget, sset
function sget($var) {
  return $_SESSION[get_constant("SITE_NAME")][$var] ;
}

function sset ($var, $value) {
   $_SESSION[get_constant("SITE_NAME")][$var] = $value ;
}

// HTTP_GET_VARS : Get --> gget, maintenant $_GET
function gget($var) {
  return isset($GLOBALS["pathget"][$var]) ? $GLOBALS["pathget"][$var] : 
    (isset($_GET[$var]) ? trim($_GET[$var]) : "" );
}

// HTTP_POST_VARS : Post --> pget, maintennant $_POST
// on ne trim que si ce n est pas un array (dans le cas de multiselect)
function pget($var) {
  if (!isset($_POST[$var])) 
    return "";
  else 
    if(is_array($_POST[$var]))
      return $_POST[$var];
    else
      return trim($_POST[$var]) ;
}

// HTTP_COOKIE_VARS : Cookie --> cget, cset, maintenant $_COOKIE
function cget($var) {
   return isset($_COOKIE[$var]) ? trim($_COOKIE[$var]) : "";
}
function cset($var, $value) {
   $_COOKIE[$var] = $value ;
}

function nget($var) { //SERVER VARS
  return (isset($_SERVER[$var])) ? $_SERVER[$var] : "" ;
}

function coalesce() {
  for ($i =0; $i < func_num_args(); $i++) {
      $x = func_get_arg($i);
      if (isset($x)) return $x ;
    }
  return null ;
} 

function coalesce_constant() {
  for ($i =0; $i < func_num_args(); $i++) {
      $x = func_get_arg($i);
      if (defined($x)) return constant($x);
    }
  return null ;
} 

function set_constant($constant_name, $value) {
  $GLOBALS["cms_constants"][$constant_name] = $value;
}

function get_constant($constant_name) {
  return $GLOBALS["cms_constants"][$constant_name];
}


## problmatiques des langues

function get_str($constantname, $name = null){
  if (!isset($name))
    $name = $_GET["action"];
  return $GLOBALS[$_GET["action"]][$constantname];
}

function set_str($constantname, $str, $name = null){
  if (!isset($name))
    $name = $_GET["action"];
  $GLOBALS[$_GET["action"]][$constantname] = $str;
}

// retourne rien si c'est la langue par dfaut sinon "a" pour alternate
function get_language() { 
 return ($_GET["langue"] == "a" || $_GET["langue"] == "en" ? "a" : "");
}

function get_html_language() {
  return get_language() == "a" ? "en" : "fr";
}

function get_language_url() { 
 return get_language() == "" ? "" : "&langue=a";
}

function get_suffix_langue(){ 
  $suffix = get_language();
  if ($suffix != "")
    $suffix = "_" . $suffix;
 return $suffix;
}

function get_prefix_langue(){ 
  $prefix = get_language();
  if ($prefix != "")
    $prefix = $prefix . "_";
 return $prefix;
}

function error_log_dev($msg) {
  if (is_development_server())
    error_log("\n" . $msg, 3, "tt.txt");
}

function set_language($langue = null) {
  if (!isset($langue)) $langue = $_GET["langue"] ;
    isset($_SESSION) ? $_SESSION["langue"] : $GLOBALS["langue"] = $langue ;  
}

function is_primary_language() { // francais = vrai
   return get_language() !== "a";
}

function php_self() {
   return $_SERVER("PHP_SELF");
}

function file_self() {
  $file = php_self();
  $pos = strrpos ($file, "/");
  if ($pos === false) {
    return $file;
  } else 
    return substr($file,$pos+1);
}

// rechercher un fichier dans les rpertoires
function get_full_filename($filename) {
  $paths = explode(":", get_constant("APPLICATION_PATH"));  
  while (list($index, $path) = each($paths)) {
    if (@file_exists($path . $filename)) {
        return $path . $filename;
    }
  }
  return "";
}

function filename_with_path($filename) {
  if (!isset($GLOBALS["files"][$filename])) {
    $GLOBALS["files"][$filename] = get_full_filename($filename);
  }
  return $GLOBALS["files"][$filename];
}

function get_language_code() {
 return is_primary_language() ? get_constant("PRIMARY_LANGUAGE") : get_constant("ALTERNATE_LANGUAGE");
}
function get_invert_language_code() {
 return is_primary_language() ? get_constant("ALTERNATE_LANGUAGE") : get_constant("PRIMARY_LANGUAGE");
}
//--------------------------------------------------------
// Permet l'inclusion de librairies ou de classes sans
// spcifier le path complet
// $filename = Le nom de la lib ou class a inclure
// retourne true si le fichier existe sinon false
//--------------------------------------------------------
function copin_include($filename) {
  if (!preg_match("/\.php$/", $filename)) 
    $filename .= ".php";
  $path_parts = pathinfo($filename);
  preg_match("/^(.*)\." . $path_parts["extension"] . "$/", $path_parts["basename"], $matches);
  $language_file = $path_parts["dirname"] . "/lang/" . $matches[1] . "_" .get_language_code() . ".php";
  $language_file = filename_with_path($language_file);
  if ($language_file != "")
    require_once($language_file);
  
  $filename = filename_with_path($filename);
  if ($filename != "") {
    require_once($filename);
    return true;
  } else {
    return false;
  }
}
/**
  * @todo transfer in language file
  */
//--------------------------------------------------------
// Retourne le nom du mois dans la langue en vigueur
// $month_number    (Le numero du mois EX fevrier = 2)
//--------------------------------------------------------
function translate_month($month_number, $langue = null) {
  if (!isset($langue))
    $langue = get_language();
  $month_number = $month_number * 1;
  $month_name = array(
            1 => array(
                    "" => "janvier",
                    "a" => "january"
                ),
            2 => array(
                    "" => "fvrier",
                    "a" => "february"
                ),
            3 => array(
                    "" => "mars",
                    "a" => "march"
                ),
            4 => array(
                    "" => "avril",
                    "a" => "april"
                ),
            5 => array(
                    "" => "mai",
                    "a" => "may"
                ),
            6 => array(
                    "" => "juin",
                    "a" => "june"
                ),
            7 => array(
                    "" => "juillet",
                    "a" => "july"
                ),
            8 => array(
                    "" => "aout",
                    "a" => "august"
                ),
            9 => array(
                    "" => "septembre",
                    "a" => "september"
                ),
            10 => array(
                    "" => "octobre",
                    "a" => "october"
                ),
            11 => array(
                    "" => "novembre",
                    "a" => "november"
                ),
            12 => array(
                    "" => "dcembre",
                    "a" => "december"
                )
        );

    return $month_name[$month_number][$langue];
}


//--------------------------------------------------------
// Format le numero de la journe dans la langue en vigueur
// $day_number    (la journe)
//--------------------------------------------------------
function format_day_number($day_number) {
    $day_number = $day_number * 1;
    if ( is_primary_language() ) {  // on assume que la langue primaire est le franais
        if ( $day_number == 1 ) {
            $result = $day_number . "<sup>er</sup>";
        } else {
            $result = $day_number;
        }
    } else {
        if ($day_number == 1 || $day_number == 21 || $day_number == 31) {
            $result = $day_number . "<sup>st</sup>";
        } elseif ($day_number == 2 || $day_number == 22) {
            $result = $day_number . "<sup>nd</sup>";
        } elseif ($day_number == 3 || $day_number == 23) {
            $result = $day_number . "<sup>rd</sup>";
        } else {
            $result = $day_number;
        }
    }
    return $result;
}

function format_long_date($day, $month, $year, $langue = null) {  // faudrait avoir des format selon les deux langues
  if (!isset($langue)) 
    $langue = get_language();
  if ($langue != "a") {
    $thedate = format_day_number($day) . " " .
          translate_month($month, $langue) . " " .
          $year;
  } else {
    $thedate = ucfirst(translate_month($month, $langue)) . " " .
          format_day_number($day) . ", " .
          $year;
  }
  return $thedate;
}
/*
 * @todo use language file
 */
function get_day_of_week_name($date){
  $days = is_primary_language() 
  ? array("dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi")
  : array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
  $day_number = is_numeric($date) ? $date : get_day_of_week($date);
  return $days[$day_number];
}

function get_day_of_week($date){
  preg_match("/(\d\d\d\d)-(\d\d)-(\d\d)/", $date, $matches);
  $date2 = mktime(0,0,0,$matches[2], $matches[3], $matches[1]);
  return date("w", $date2);
}

//--------------------------------------------------------
// Retourne le charactere dans le format necessaire au
// navigateur web
// $char2replace = (Le charactere  remplacer)
//--------------------------------------------------------
function get_html_char($char2replace) {
    $str2display = "";
    switch ($char2replace) {
        case "oe":
            if (is_konqueror()) {
                $str2display = "oe";
            } else {
                $str2display = "&#339;";
            }
            break;
        case "OE":
            if (is_konqueror()) {
                $str2display = "OE";
            } else {
                $str2display = "&#338;";
            }
            break;
    }
    return $str2display;
}


function sql2arrayselect($vuename, $where = "", $connect = null){
  $sqlarrayselect = (trim($vuename) !="") ? selectsql("select * from $vuename " . $where . " order by description", $connect) : "";
  if (is_array($sqlarrayselect)) {
    $removeorder = (preg_match("/^#\d\d\d#/", $sqlarrayselect[0]["description"]) ? true : false);
    reset($sqlarrayselect);
    while (list($index, $subbaray) = each($sqlarrayselect)) {
      $description = ($removeorder ? substr($subbaray["description"], 5) : $subbaray["description"]);
      $arrayselect[$description] = $subbaray["code"];
    }
  } else {
    $arrayselect = "";//array("" => "");
  }
  return $arrayselect;
}

/**
 * Affiche un message dans une boite
 *
 * Affichage d'un message dans une boite avec un icone en en-tete.
 * si $message est vide rien n'est affich
 * iconlevel peut prendre quatres valeurs : login, alert(defaut), error, none.
 */
function return_echo_box($the_message, $iconlevel = "alert", $title = "&nbsp;", $classname = null, $width = null) {
  if ($the_message != "") {
    $licon = "echobox_" . $iconlevel;
    if (!isset($classname)) {
      if ($iconlevel == "error")
        $classname = "echobox_error";
      else
        $classname = "echobox";
    }
    if (isset($width))
      $thewidth = " style=\"width=" . $width . "\"";
    return "<table class=\"$classname\" cellpadding=0 cellspacing=0 $thewidth><tr><td>"
    . "<table class=\"formezoomTitle\" border=0 cellspacing=0 width=100%><tr>"
    . "<td class=\"formezoomTitleLeft\"></td><td class=\"formezoomTitleMiddle\">&nbsp;" 
    . ($iconlevel != "none" ? "<img src=\"" . sget("forms_image_dir") .
     "$licon.gif\" border=\"0\">" : "") . 
    " $title</td><td class=\"formezoomTitleRight\"></td></tr></table></td></tr>"
    . "<tr><td><table class=\"echoboxmessage\" border=0 cellpadding=10 width=100%><tr><td>$the_message</td></tr></table></td></tr></table><br>";
  }
}
function echo_box($the_message, $iconlevel = "alert", $title = "&nbsp;", $classname = null, $width = null){
  echo return_echo_box($the_message, $iconlevel, $title, $classname, $width);
}

function get_new_key(){
  static $bruit;
  return md5(date("YmdHis").$bruit++);
}

/**
  * @todo transfer in language file
  */
function get_picklist_array_sexe(){
  return (is_primary_language() ? array("Masculin" => "M", "Fminin" => "F") : array("Male" => "M", "Female" => "F"));
}

//  ===========================================================================
//  Author:  Les consultants interaction.
//  Date:   21 juin 2002
//  Version  Description
//  ------------------------------------------------------------------
//  1.0.0   Modification des parametres dune url
//  ===========================================================================
function update_url_query($url, $param, $value = null) {
  $new_url = "";
  // Si le parametre existe djas 
  if ( preg_match("/[\?&]" . $param . "=/", $url) ) {
    // Si une valeur est fournit
    if ( isset($value) ) {
      $new_url = preg_replace("/([\?&])" . $param . "=[^&]*/", "\\1" . $param . "=" . $value, $url);
    } else {
      $new_url = preg_replace("/[\?&]" . $param . "=[^&]*/", "", $url);
    }
  } else {
    if ( isset($value) ) {
      $new_url = $url . (preg_match("/\?/", $url) ? "&" : "?") . $param . "=" . $value;
    } else {
      $new_url = addslashes($url);
    }
  }
  // retire le deuxieme delimiteur si un parametre est retire && -> &
  $new_url = preg_replace("/\?&/", "?", $new_url);
  $new_url = preg_replace("/&&/", "&", $new_url);
  return $new_url;
}


//-------------------------------------------------
// Retourne une string de validation MD5
//-------------------------------------------------
function url2md5($url_base) {
  // retire le parametre MD5 de validation
  $url_base = preg_replace ("/(\?tag=\w+&*)/i", "?", $url_base);
  $url_base = preg_replace ("/(&tag=\w+)/i", "", $url_base);
  $url_base = preg_replace ("/(\?langue=\w+&*)/i", "?", $url_base);
  $url_base = preg_replace ("/(&langue=\w+)/i", "", $url_base);
  $url_base = preg_replace ("/(\?printerfriendly=O&*)/i", "?", $url_base);
  $url_base = preg_replace ("/(&printerfriendly=O)/i", "", $url_base);
  $url_base = preg_replace ("/(\?printerfriendly=O&*)/i", "?", $url_base);
  $url_base = preg_replace ("/(\?ancien=O&*)/i", "?", $url_base);
  $url_base = preg_replace ("/(&ancien=O)/i", "", $url_base);
  $url2 = $url_base;
  $url2 = preg_replace ("/(\?action=\w+&*)/i", "?", $url2);
  $url2 = preg_replace ("/(&action=\w+)/i", "", $url2);
  $url2 = preg_replace ("/(\?type=\w+&*)/i", "?", $url2);
  $url2 = preg_replace ("/(&type=\w+)/i", "", $url2);
  
  if (preg_match("/\?(\w+)/", $url2)) {
    // detecte les parametres qui ne seront pas valids sp=...|...|...
    preg_match( "/(?<=&sp=)\w+(\|\w+)*/", $url_base, $matches);

    if ($matches[0] != "") {
      $param2skip = preg_split("/\|/", $matches[0]);
      // retire de la url les parametres qui ne seront pas valids
      foreach($param2skip as $param) {
        $url_base = preg_replace ("/(" . $param . "=[\w|-]+&)|(&" . $param . "=[\w|-]*)/", "", $url_base);
      }
    }
    return md5($url_base . get_noise_string());
  } else {
    return "";
  }
}

function get_urlmd5($url) {
  $urlmd5 = url2md5($url);
  return ($urlmd5 != "" 
          ? update_url_query($url, "tag", $urlmd5)
          : $url);
}

//-------------------------------------------------
// Valide le parametre prouf (MD5) d'un url
//-------------------------------------------------
function is_valid_url($url) {
  $prouf = url2md5($url);
  preg_match("/(?>&tag=)([^&]*)/", $url, $matches);
  return $prouf == $matches[1];
}

function get_noise_string() {
  return get_constant("MD5_NOISE");
}

function ia_rand($min = null, $max = null) {
  list($usec, $sec) = explode(" ", microtime());
  srand( (float) $sec + ((float) $usec * 100000) );
  if (isset($min) && isset($max)) {
    return rand($min, $max);
  } else {
    return rand();
  }
}

function addate($nbodays, $from = null, $format = "date"){
  if (!isset($from))
    $from = time(); 
  $in7days = $from + (60 * 60 * 24 * $nbodays); 
  return date("Y-m-d" . ($format == "minutes" ? " H:s" : ""), $in7days); 
}

/**
  * @todo transfer in language file
  */
function get_nb_records_2_str($nb_record){
  $nb_limite = get_constant("MAX_RECORD");

  if ( is_primary_language() ) {
      if ($nb_record == $nb_limite)
        $the_count = "Plus de $nb_limite enregistrements ont t trouvs.";
      elseif ($nb_record == 1)
        $the_count = "Un enregistrement a t trouv.";
      elseif ($nb_record == 0)
        $the_count = "Aucun enregistrement n'a t trouv.";
      else
        $the_count = "$nb_record enregistrements ont t trouvs.";
    } else {
      if ($nb_record == $nb_limite)
        $the_count = "Over $nb_limite entries were found.";
      elseif ($nb_record == 1)
        $the_count = "One entrie was found.";
      elseif ($nb_record == 0)
        $the_count = "No entries were found.";
      else
        $the_count = "$nb_record entries were found.";
    }
    return $the_count;
  }

/**
  * @todo transfer in language file
  */
function get_phrase_critere($where_type_clause) {
  $critere[""][begin_with]= "d&eacute;butant par ";
  $critere["a"][begin_with]= "starting with ";
  $critere[""][string] = "contenant ";
  $critere["a"][string] = "containing ";
  $critere[""][picklist] = "";
  $critere["a"][picklist] = "";
  $critere[""][equal] = "= ";
  $critere["a"][equal] = "= ";
  return $critere[get_language()][$where_type_clause];
}
  
function Enlever_Accents($string) { 
  return strtr($string, 
           "", 
           "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy"); 
}

function upper_vanilla($string) {
    $string = preg_replace("/[\"\(\)\[\]\!\\\<>,.\^\$\/]/", " ", $string);
    $string = preg_replace("/'/", " ", $string);
  return strtoupper(Enlever_Accents($string));
}

// ------------------------------------------------------------------------- /
// Lire un fichier et retourner le contenu de ce fichier sous forme          /
// d'une chane de caractres.                                               /
// ------------------------------------------------------------------------- /
function Read_Template($file) {
  $str = "";
  if(file_exists($file)) {
    $template = file($file);
    for ($i=0;$i<=count($template);$i++) {
      $str.=$template[$i];
    }
  }  elseif(file_exists("lib/".$file)) {
    $template = file("lib/".$file);
    for ($i=0;$i<=count($template);$i++) {
      $str.=$template[$i];
    }
  }
  return $str;
}


// -------------------------------------------------------------------------- /
// Retourne l'adresse ip du client                                            /
// -------------------------------------------------------------------------- /
function get_host_client_ip() { 
  if(getenv("HTTP_CLIENT_IP")) { 
    $ip = getenv("HTTP_CLIENT_IP"); 
  } elseif(getenv("HTTP_X_FORWARDED_FOR")) { 
    $ip = getenv("HTTP_X_FORWARDED_FOR"); 
  } else { 
    $ip = getenv("REMOTE_ADDR"); 
  }
  return $ip;
}


/**
  * @todo language file
  */
function prepare_msg_erreur_user($noError) {
  $errorLevel = array(
    400 => "Bad Request",
    403 => "Forbidden",
    404 => "File not found",
    500 => "Server Error",
    501 => "Not Implemented",
    504 => "Gateway Time-Out",
    505 => "HTTP Version not supported");

  $errorMessage = array(
    400 => "The request had bad syntax or was impossible to be satisfied.",
    403 => "Access to a protected folder was attempted",
    404 => "The requested file was not found.",
    500 => "The server encountered an unexpected condition which prevented it from fulfilling the request",
    501 => "The server does not support the facility required.",
    504 => "The server cannot process the request due to a system overload.  This (should) be a temporary condition.",
    505 => "The service did not respond within the time frame that the gateway was willing to wait.");
    
    $error[error_level] = $errorLevel[$noError];
    $error[error_message] = $errorMessage[$noError];

    return $error;
}

function lexique($motcle) {
  $the_action = gget("action") . get_suffix_langue();
  $lexique = "<a class=\"lexiquea\" href=\"#\" onClick=\"JavaScript:ia_openIT(";
  $lexique .= "'./lib/lexique.php?action=" . gget("action") . "&motcle=$motcle" 
  .  (!is_primary_language() ? "&langue=a" : "") . "', 550, 400, 'ialex$the_action');\">";
  $lexique .= "&nbsp;?&nbsp;</a>&nbsp;";
  return $lexique;
}
  
function crypt_str($str, $type){
  $hash_termes = get_hash_termes();
  $md5 = md5_tab($hash_termes);
  $str = trim(strtolower($str));
  if($type == "E") $str = str_replace($hash_termes,$md5,$str);
  else $str = str_replace($md5,$hash_termes,$str);
  return $str;
}

/*
* 
*/
function get_hash_termes(){
  // mot rserv pour le sql
  $tab_sql = array("and", 
                   "as",
                   "count",
                   "delete",
                   "from",
                   "insert",
                   "is", 
                   "join", 
                   "like",
                   "not",
                   "null",
                   "or", 
                   "update",
                   "select",
                   "set", 
                   "sum",
                   "values",
                   "where",
                   "sql");
  // mot rserv pour les attributs des tables
  $tab_attribut = array("adresse",
                        "banque",
                        "confirmation",
                        "contact",
                        "demande",
                        "droit",
                        "facture",
                        "fax",
                        "instant",
                        "nas",
                        "nom",
                        "note",
                        "province",
                        "service",
                        "site",
                        "telephone",
                        "total",
                        "tps",
                        "tvq",
                        "usager",
                        "utilisateur",
                        "web");
  // mot rserv pour la ponctuation
  $tab_ponctuation = array(
                   "=", 
                   "*", 
                   "_",
                   "(", 
                   ")", 
                   ">",
                   ",", 
                   ".",
                   "'");
                   
  $tab_php_word = array("argument",
                        "array",
                        "at",
                        "character",
                        "compile",
                        "core",
                        "error",
                        "fatal",
                        "incorrect",
                        "line",
                        "near",
                        "of",
                        "parse",
                        "postgresql",
                        "ressource",
                        "result",
                        "supplied",
                        "undefined",
                        "unkown",
                        "valid",
                        "vector",
                        "warning");
                         
  $tab_function_db = array("pg_cmdtuples",
                          "pg_affected_rows",
                          "pg_errormessage",
                          "pg_last_error",
                          "pg_exec",
                          "pg_query",
                          "pg_fieldname",
                          "pg_field_name",
                          "pg_fieldsize",
                          "pg_field_size",
                          "pg_fieldnum",       
                          "pg_field_num",
                          "pg_fieldprtlen",    
                          "pg_field_prtlen",
                          "pg_fieldisnull",    
                          "pg_field_is_null",
                          "pg_freeresult",     
                          "pg_free_result",
                          "pg_getlastoid",     
                          "pg_last_oid",
                          "pg_loreadall",      
                          "pg_lo_read_all",
                          "pg_locreate",       
                          "pg_lo_create",
                          "pg_lounlink",       
                          "pg_lo_unlink",
                          "pg_loopen",         
                          "pg_lo_open",
                          "pg_loclose",        
                          "pg_lo_close",
                          "pg_loread",         
                          "pg_lo_read",
                          "pg_lowrite",        
                          "pg_lo_write",
                          "pg_loimport",       
                          "pg_lo_import",
                          "pg_loexport",       
                          "pg_lo_export",
                          "pg_numrows",        
                          "pg_num_rows",
                          "pg_numfields",
                          "pg_num_fields",
                          "pg_result",
                          "pg_fetch_result");
  
  // construction du tableau final
  $hash_termes = array_merge($tab_sql, 
                     $tab_attribut,
                     $tab_php_word,
                     $tab_function_db,
                     $tab_ponctuation);
  return $hash_termes;
}
function md5_tab($hash_termes){
  foreach($hash_termes as $elm){
    $md5[] = md5($elm);
  }
  return $md5;
}

function picklist_yesno($yes, $no){
  return is_primary_language() ? array("Oui" => $yes, "Non" => $no)
   : array("Yes" => $yes, "No" => $no);
}

function build_date_time($time="00:00", $separator=":", $date=""){
    $t_time = explode($separator,$time);
    $h = $t_time[0];
    $m = $t_time[1];
    if(!$date){
      $t_date[0] = date("Y");
      $t_date[1] = date("M");
      $t_date[2] = date("d");
    } else{
      $t_date = explode("/", $date);
    }
    if($h<=0) $h = 0;
    if($m<=0) $m = 0;
    
    $_date = mktime($h, $m, 0,  $t_date[1],  $t_date[2], $t_date[0]);
    return $_date;
}

/**
*
*/
function datetime_diff($date1, $date2){
  if(($date2-$date1)<0)
    return -1; // date2 est plus petit que date1
  elseif(($date2-$date1) > 0)
    return 1; // date2 est plus grand que date1
  else
    return 0; // meme date
}


function simple_js($js_str){
    return "<script language=\"JavaScript\">
              $js_str;
            </script>";
}

function subscription_avalable() {
 return get_parametre_systeme("user_acceptance") != "NO_FORM";
}

function get_css_overflow(){
  if(is_safari()){
    return "divoverflowsafari";
  }
  return "divoverflow";
}

/**
* a remplacer par l autre version
*/

function get_cms_month($index = 0){
  $sql = "SELECT code, description ";
  $sql .= "FROM v_pl".get_language()."_month ORDER BY code";
  
  $res = selectsql($sql);
  $nb = count($res);
  for($i=0;$i<$nb;$i++){
    $code = $res[$i]["code"] - $index;
    $arr[$code] = $res[$i]["description"];
  }
  return $arr;
}

function get_cms_day($index){
  $sql = "SELECT code, description ";
  $sql .= "FROM v_pl".get_language()."_day ORDER BY code";
  
  $res = selectsql($sql);
  $nb = count($res);
  for($i=0;$i<$nb;$i++){
    $code = $res[$i]["code"] - $index;
    $arr[$code] = $res[$i]["description"];
  }
  return $arr;
}

function is_development_server() {
   return (preg_match("/\b" .$_SERVER["SERVER_NAME"] . "\b/i",get_constant("DEVELOPMENT_SERVERS")));
}

/*
*  Gestion des labels
*/

function beautify($fieldname) {
	return ucfirst(str_replace("_", " ", $fieldname));
}

function get_label($fieldname) {
	
  $unelangue = get_language();
  if (!isset($_SESSION[get_constant("SITE_NAME")]["langueactive"]))  $_SESSION[get_constant("SITE_NAME")]["langueactive"] = "";
  
  if (!isset($_SESSION[get_constant("SITE_NAME")]["label"])
           || get_constant("DEBUG_FIELDS")
	   || $_SESSION[get_constant("SITE_NAME")]["langueactive"] !== $unelangue) {
     copin_include("lib/label_" . get_language_code() . ".php");
     if (function_exists("app_load_label")) {
       $_SESSION[get_constant("SITE_NAME")]["label"] = array_merge($_SESSION[get_constant("SITE_NAME")]["label"], app_load_label());
     }
     $_SESSION[get_constant("SITE_NAME")]["langueactive"] = $unelangue;
  }
  return isset($_SESSION[get_constant("SITE_NAME")]["label"][$fieldname]) 
               ?  $_SESSION[get_constant("SITE_NAME")]["label"][$fieldname] 
	       : beautify($fieldname, $unelangue);
}

function get_language_order($fieldname) {
  return (get_language() == "a" ? "a_$fieldname,
            $fieldname"
            : "$fieldname,
            a_$fieldname"
            );
}

function array_insert($initial_array, $new_item, $position) {
  $array_splice = array_splice($initial_array, $position);
  return array_merge($initial_array, $new_item, $array_splice);
}

// retourne le texte correspondant au message des udf
function get_error_message() { 
  $message_erreur_udf = sget("message_erreur_udf");
  preg_match("/\((.*)\)/", sget("user_error_msg"), $matches);
  return $message_erreur_udf[$matches[1]][get_prefix_langue() . "description"];
}
 
function get_url_path($url = null) {
  if (!isset($url))  {
    $url = $_SERVER["REQUEST_URI"] ;
  }
  $array = parse_url($url);
  return $array["path"];
}

function get_machine_name($url = null) {
  if (!isset($url))  {
    $url = $_SERVER["HTTP_HOST"];
  }
  $array = explode(".",$url);
  return $array[0];
}

function print_r2($larray) {
   $larray2 = addslashes_array($larray);
   ob_start();
   var_export ($larray2);
   $lecontenu = ob_get_contents();
   ob_end_clean();
   ob_flush();
   $lecontenu = preg_replace("/[\\\]{2}/", "", $lecontenu);
   $lecontenu = preg_replace("/\\\\\"/", "\"", $lecontenu);
   return $lecontenu;
}

function addslashes_array($larray) {
  if (is_string($larray)) {
    return addslashes($larray);
  } elseif (is_array($larray)) {
    while (list($index, $subbaray) = each($larray))
      $slashes[addslashes($index)] = addslashes_array($subbaray);
    return $slashes;
  } else {
    return $larray;
  }
}

function get_cargo($var_name) {
  return isset($_SESSION[get_constant("SITE_NAME")]["cargo"][$var_name]) 
    ? $_SESSION[get_constant("SITE_NAME")]["cargo"][$var_name] 
    : "";
}
function set_cargo($var_name, $value) {
  $_SESSION[get_constant("SITE_NAME")]["cargo"][$var_name] = $value;
}

?>