/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * general function library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp
function stabilise() {
  before_onload();
  var url = document.URL;
  if (gget(url, 'frame') == 'fcontent' && gget(url, 'popup') !='O' && 
    gget(url, 'resetframes') !='O' && gget(url, 'printerfriendly') != 'O' 
    && parent.frames.length == 0)
    window.location = update_url_query(url, 'frame');
  after_onload();
  var theabsolutes = getAbsolutePositionElement();
  if (theabsolutes) {
    for (var i=0; i<theabsolutes.length; i++)
    theabsolutes[i].style.position = 'absolute';
  }
}

function before_onload(){
}
function after_onload(){
}

function getAbsolutePositionElement(){
 var classname = 'inputboxselect';
 var j = 0;
 var tags = Array();
 var alltags = document.getElementsByTagName("select");
 for (var i=0; i<alltags.length; i++){
   if (alltags[i].className==classname)
     tags[j++]=alltags[i];
 }
 alltags = document.getElementsByTagName("input");
 for (var i=0; i<alltags.length; i++){
   if (alltags[i].className==classname)
     tags[j++]=alltags[i];
 }
 return tags;
} 

function update_url_query(url, searchedparam, value){
  var pos = url.indexOf('?');
  var takeout = (typeof(value) == 'undefined');
  var result = url.substring(0, pos);
  if (pos != -1) {
    var get = url.substring(pos+1, url.length);
    var params = get.split("&");
    var newparam = new Array();
    var param;
    for (var i = 0; i < params.length; i++) {
      param = params[i].split("=");
      if (param[0] == searchedparam) {
        if (!takeout)
          newparam.push(param[0] + "=" + value);
      } else
        newparam.push(params[i]);
    } 
    result += "?" + newparam.join("&");
  }
  return result;
  
}

function gget(url, searchedparam) {
  var pos = url.indexOf('?');
  var result = '';
  if (pos != -1) { 
    var get = url.substring(pos+1, url.length);
    var params = get.split("&");
    var param;
    for (var i = 0; i < params.length; i++) {
      param = params[i].split("=");
      if (param[0] == searchedparam)
        result = param[1];
    } 
  }
  return result;
}

//  ===========================================================================
//  Author:  Les consultants interaction.
//  Date:   12 avril 2002
//  Version  Description
//  ------------------------------------------------------------------
//  1.0.0   Prompt l'usager pour le numero de page a affich
//  ===========================================================================
function prompt_page_number(prompt_msg, error_msg, url2go, anchor, max_page) {
    var page = prompt(prompt_msg, "");
    page = trim(page);
    if ((page != '') && (page != null)) {
        var no_page = parseInt(page);
        if ((no_page > 0) && (no_page <= max_page)) {
            window.location = url2go + no_page + anchor;
        } else {
            alert(error_msg);
        }
    }
}


//  ===========================================================================
//  Author:  Les consultants interaction.
//  Date:   21 jan 2002
//  Version  Description
//  ------------------------------------------------------------------
//  1.0.0   Ouvre une nouvelle fenetre pour l'affichage d'un array de message
//          fonctionne avec Netscape 4.76 et IE
//          fonctionne PAS avec mozilla et Konqueror
//  1.0.1   Affiche seulement les messages dont le array n'est pas a undefine
//  1.0.2   Traitement spcifique pour les navigateur netscape 5 et +
//  ===========================================================================
function htmlwindows(title, description, msg_array) {
    var l = msg_array.length;

    // Konqueror  et Netscape 5.0 et + ne peut ouvrir une nouvelle fenetre sans avoir
    // de URL comme parametre
    browsername = navigator.appName;
    browserver = navigator.appVersion.charAt(0);
    if ( (browsername.indexOf("Konqueror")!=-1) ||
            ((browsername.indexOf("Netscape")!=-1) && (browserver-0 >= 5)) ) {
        var msg_txt = description + "\n\n";
        for (i=0; i<l; i++) {
            if ( msg_array[i] != 'undefined' ) {
                msg_txt += msg_array[i] + "\n";
            }
        }
        alert(msg_txt);
    } else {
        var html_head = "<html><body><br><h2>" + description + "</h2></body></html>"

        var html_body = "<html><body><table border=\"0\">";
        for (i=0; i<l; i++) {
            if ( msg_array[i] != 'undefined' ) {
                html_body += "<tr><td valign=\"TOP\">=>&nbsp;</td><td>" + msg_array[i] + "</td></tr>";
            }
        }
        html_body += "</table></body></html>"

        var html_button = "<html><body><center><form>" +
            "<input type=\"button\" name=\"close_btn\" value=\"OK\" onclick=\"parent.close();\">" +
            "</form></center></body></html>";

        var frameroot = "<html><head><title>" + title + "</title></head><frameset rows=\"60,*,60\">" +
            "<frame frameborder=\"0\" scrolling=\"no\" name=\"frame_head\" src=\"about:blank\">" +
            "<frame frameborder=\"0\" scrolling=\"auto\" name=\"frame_body\" src=\"about:blank\">" +
            "<frame frameborder=\"0\" scrolling=\"no\" name=\"frame_button\" src=\"about:blank\">" +
            "</frameset></html>";

        var new_win = window.open('','','dependent=1,scrollbars=1,resizable=1,width=400,height=300');

        new_win.document.open("text/html", "replace");
        new_win.document.writeln(frameroot);
        new_win.document.close();

        new_win.frames["frame_head"].document.open("text/html", "replace");
        new_win.frames["frame_head"].document.writeln(html_head);
        new_win.frames["frame_head"].document.close();

        new_win.frames["frame_body"].document.open("text/html", "replace");
        new_win.frames["frame_body"].document.writeln(html_body);
        new_win.frames["frame_body"].document.close();

        new_win.frames["frame_button"].document.open("text/html", "replace");
        new_win.frames["frame_button"].document.writeln(html_button);
        new_win.frames["frame_button"].document.close();

        new_win.moveTo( (screen.availWidth - new_win.outerWidth)/2, (screen.availHeight - new_win.outerHeight)/2 );
    };

} 
function htmlwindows(title, description, msg_array) {
    var l = msg_array.length;

        var msg_txt = description;
        for (i=0; i<l; i++) {
            if (typeof(msg_array[i]) != 'undefined') {
                msg_txt += msg_array[i] ;
            }
        }
        window.alert(msg_txt);

}


//  ===========================================================================
//  Author:  Les consultants interaction.
//  Date:   21 juin 2002
//  Version  Description
//  ------------------------------------------------------------------
//  1.0.0   Ouvre une nouvelle fenetre pour un appercu avant impression
//  ===========================================================================
function show_printerfriendly(estnetscape, forme, url_printer_friendly) {
  if (forme != null) {
    oldaction = forme.action;

    replaceRegExp = /#.*/;
    no_target_action = forme.action.replace(replaceRegExp, "");

    
    forme.action = no_target_action + "&printerfriendly=O";
    if (!estnetscape){
      forme.target = "_blank";
    }

    forme.submit();
    forme.action = oldaction;
    forme.target = "";
  } else {
    window.open( url_printer_friendly );
  }
}

function show_printerfriendly_url(estnetscape, forme, url_printer_friendly, target) {
  if (forme != null) {
    oldaction = forme.action;

    replaceRegExp = /#.* /;
    no_target_action = forme.action.replace(replaceRegExp, "");

    
    if (typeof(url_printer_friendly) != 'undefined') {
      forme.action = url_printer_friendly + "&printerfriendly=O";
    } else {
      forme.action = no_target_action + "&printerfriendly=O";
    }
    if (!estnetscape){
      if (typeof(target) != 'undefined') {
        forme.target = target;
      } else {
        forme.target = "_blank";
      }
    }

    forme.submit();
    forme.action = oldaction;
    forme.target = "";
  } else {
    window.open( url_printer_friendly );
  }
}

function submit_custom(forme, new_action) {
  if (forme != null) {
    forme.action = new_action;
    forme.submit();
  }
}
function clickInput(unlabel) {
  var inputs = unlabel.getElementsByTagName('input');
  inputs[0].checked = true;
  if (inputs[0].onclick) 
    inputs[0].onclick();
}
function clickCheckbox(thecheckboxname) {
  var thecheckbox = document.getElementById(thecheckboxname);
  thecheckbox.checked = !thecheckbox.checked;
  if (thecheckbox.onclick) 
    thecheckbox.onclick();
}

//  ===========================================================================
//  Author:  Les consultants interaction.
//  Date:   21 juin 2002
//    anchor  (Le nom du anchor a recherch)
//  Version  Description
//  ------------------------------------------------------------------
//  1.0.0   Scroll la page par l'appel d'un evenement onLoad="scroll2anchor(...)"
//  ===========================================================================
function scroll2anchor(anchor) {
  for (c=0; c<document.anchors.length; c++) {
    if (document.anchors[c].name == anchor) {
      scroll(1, document.anchors[c].offsetTop);
      return;
    }
  }
} 

function swap_actif_inputbox(thefield, thefieldname, thelabel){
  if (thefield.disabled) {
    thefield.disabled = false;
    thefield.className = 'inputbox';
    change_label(thefieldname, thelabel + "&nbsp;*");
  } else {
    thefield.disabled = true;
    thefield.className = 'nonEditable';
    change_label(thefieldname, thelabel + "&nbsp;<font color=\"#7FA1BD\">*</font>");
  }
}

function swap_actif_inputbox_actif(thefield, thefieldname, thelabel, actif){
  if (actif) {
    thefield.disabled = false;
    if (!(ie5 && mac && thefield.type == 'select-one') && thefield.type != 'radio')
      thefield.className = 'inputbox';
    change_label(thefieldname, thelabel + "&nbsp;*");
  } else {
    thefield.disabled = true;
    if (!(ie5 && mac && thefield.type == 'select-one') && thefield.type != 'radio')
      thefield.className = 'nonEditable';
    change_label(thefieldname, thelabel + "&nbsp;<font color=\"#7FA1BD\">*</font>");
  }
}
function change_label(thefieldname, newlabel){
  if (thefieldname) {
    document.getElementById(thefieldname).innerHTML = newlabel;
  }
}

var ie4 = (document.all) ? true : false;
var ns4 = (document.layers) ? true : false;
var ns6 = (document.getElementById && !document.all) ? true : false;

function writetolayer(lay,txt) {
if (ie4) {
document.all[lay].innerHTML = txt;
}
if (ns4) {
document[lay].document.write(txt);
document[lay].document.close();
}
if (ns6) {
over = document.getElementById([lay]);
range = document.createRange();
range.setStartBefore(over);
domfrag = range.createContextualFragment(txt);
while (over.hasChildNodes()) {
over.removeChild(over.lastChild);
}
over.appendChild(domfrag);
   }
}

function writetolayerparent(lay,txt) {
if (ie4) {
self.opener.document.all[lay].innerHTML = txt;
}
if (ns4) {
self.opener.document[lay].document.write(txt);
self.opener.document[lay].document.close();
}
if (ns6) {
over = self.opener.document.getElementById([lay]);
range = self.opener.document.createRange();
range.setStartBefore(over);
domfrag = range.createContextualFragment(txt);
while (over.hasChildNodes()) {
over.removeChild(over.lastChild);
}
over.appendChild(domfrag);
   }
}

function set_class(nomduchamp, nomclass) {
 if (document.getElementById(nomduchamp)) {
	if (ns6) {
		document.getElementById(nomduchamp).setAttribute('class',nomclass)
  } else {
		document.getElementById(nomduchamp).setAttribute('className',nomclass)
  }
 }
}
function getElementPosition(elemID) {
    var offsetTrail = document.getElementById(elemID);
    var offsetLeft = 0;
    var offsetTop = 0;
    while (offsetTrail) {
        offsetLeft += offsetTrail.offsetLeft;
        offsetTop += offsetTrail.offsetTop;
        offsetTrail = offsetTrail.offsetParent;
    }
    if (navigator.userAgent.indexOf("Mac") != -1 && 
        typeof document.body.leftMargin != "undefined") {
        offsetLeft += document.body.leftMargin;
        offsetTop += document.body.topMargin;
    }
    return {left:offsetLeft, top:offsetTop};
}

function getElementTop(elemID) {
    var offsetTrail = document.getElementById(elemID);
    var offsetLeft = 0;
    var offsetTop = 0;
    while (offsetTrail) {
        offsetLeft += offsetTrail.offsetLeft;
        offsetTop += offsetTrail.offsetTop;
        offsetTrail = offsetTrail.offsetParent;
    }
    if (navigator.userAgent.indexOf("Mac") != -1 && typeof document.body.leftMargin != "undefined") {
        offsetLeft += document.body.leftMargin;
        offsetTop += document.body.topMargin;
    }
    return offsetTop;
}

function getElementLeft(elemID) {
    var offsetTrail = document.getElementById(elemID);
    var offsetLeft = 0;
    var offsetTop = 0;
    while (offsetTrail) {
        offsetLeft += offsetTrail.offsetLeft;
        offsetTop += offsetTrail.offsetTop;
        offsetTrail = offsetTrail.offsetParent;
    }
    if (navigator.userAgent.indexOf("Mac") != -1 && typeof document.body.leftMargin != "undefined") {
        offsetLeft += document.body.leftMargin;
        offsetTop += document.body.topMargin;
    }
    return offsetLeft;
}


function day_of_week(date, mask){
  if (typeof(langue) == 'undefined' || langue == '') {
    langue = "f";
  }
	if (langue == 'f')
	  var days = ["dimanche", "lundi","mardi","mercredi","jeudi","vendredi", "samedi"];
	else
	  var days = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
	var y;
	var m;
	var d;
	var y_index;
	var m_index;
	var d_index;
  if (is_date(date, mask, '', '')) {
    y_index = mask.indexOf('YYYY');
    m_index = mask.indexOf('MM');
    d_index = mask.indexOf('DD');
    
    y = date.substring(y_index, y_index + 4);
    m = date.substring(m_index, m_index + 2);
    d = date.substring(d_index, d_index + 2);
     
    var c = new Date(y,(m-1),d);
    var dayOfWeek = c.getDay();
    return days[dayOfWeek];
  } else {
    return '';
  }
}

function autoformat(thefield, format) {
	var val = trim(thefield.value);
	var thenewvalue;
  if (format == 'time') {
	  var thehour;
	  var theminute;
	  var teststring = /^(0?[0-9]|1[0-9]|2[0-3])[\-:\.\s]*(0[0-9]|[0-5]?[0-9])?$/;
	  if (generic_re_validation(val, new Array(teststring))) {
    val = val.replace(/[\-\. :]/g, '/');
    val = val.replace(/\/\//g, '/');
    var parts = val.split("/"); 
      if (parts.length == 2) { 
	      thehour = parts[0];
  	    theminute = parts[1];
	    } else {
  	    if (val.length == 4) {
  	      thehour = val.substring(0, 2);
  	      theminute = val.substring(2, 4);
  	    } else
  	     if (val.length == 3) {
  	      thehour = '0' + val.substring(0, 1);
  	      theminute = val.substring(1, 3);
  	     }  else
  	       if (val.length <= 2) {
  	         if (parseInt(val) <= 23) {
  	           thehour = val;
  	           theminute = '00';
  	         } else {
  	           thehour = '00';
  	           theminute = val;
  	         }
	       }
	    }
	    if (thehour.length == 1)
	      thehour = '0' + thehour;
	    if (theminute.length == 1)
	      theminute = '0' + theminute;
	    thenewvalue = thehour + ':' + theminute;
	  } else {
	    thenewvalue = val;
	  }
  } else if (format == 'shortdate') {
	  var teststring = /^[1|2]?[0-9]?[0-9]?[0-9]?[\-\/\.\s]*[0-1]?[0-9][\-\/\.\s]+[0-3]?[0-9]$/;
	  var teststring2 = /^[1|2][0-9][0-9][0-9][0-1][0-9][0-3][0-9]$/;
		var theyear;
		var themonth;
		var theday;
	  if (generic_re_validation(val, new Array(teststring))){
		  
	    val = val.replace(/[\-\. ]/g, '/');
	    val = val.replace(/\/\//g, '/');
	    var parts = val.split("/");
	    if (parts.length > 2) {
	      theyear = parts[0];
	      themonth = parts[1];
	      theday = parts[2];
	    } else {
	      // mois et jour
	      theyear = '2004';
	      themonth = parts[0];
	      theday = parts[1];
	    }
	    if (parseInt(theyear) < 1900)
  	    theyear = 2000 + parseInt(theyear);
	    if (themonth.length == 1)
	      themonth = '0' + themonth;
	    if (theday.length == 1)
	      theday = '0' + theday;
	    thenewvalue = theyear + '/' + themonth + '/' + theday;
	    if (!is_date(thenewvalue, 'YYYY/MM/DD', '', ''))
	      thenewvalue = val;
	  } else if (generic_re_validation(val, new Array(teststring2))){
	      theyear = val.substring(0, 4);
	      themonth = val.substring(4, 6);
	      theday = val.substring(6, 8); 
	      thenewvalue = theyear + '/' + themonth + '/' + theday;
	      if (!is_date(thenewvalue, 'YYYY/MM/DD', '', ''))
	        thenewvalue = val;
	    } else {
        thenewvalue = val;
      }
  } else {
	  thenewvalue = val;
  }
  thefield.value = thenewvalue;
}
function setvalue_enddate(control, value) {
  var themax;
  if (control.value <= value) {
    for (var i = 0; i < control.length; i++) {
      if (control[i].value <= value) {
        themax = i;
      }
    }
    if (themax < control.length - 1)
      themax = themax + 1;
    control.selectedIndex = themax;
  }
}

function ia_openIT(url, width, height, target){
  if (typeof(target) == 'undefined')
    target = 'iaaide';
  openIT(url, width, height, null, null, target, 0, false, false, false);
}

function openIT(u,W,H,X,Y,n,b,x,m,r,scroll,resize, original) {
  if (typeof(resize) == 'undefined')
    resize = false;
  if (resize) {
    var wNS ='toolbar=0,location=0,directories=0,status=1,menubar=0,' + (scroll == true ? 'scrollbars=1' : 'scrollbars=0') + ',resizable=1'  //Html parameters for Netscape.
  } else {
    var wNS ='toolbar=0,location=0,directories=0,status=1,menubar=0,' + (scroll == true ? 'scrollbars=1' : 'scrollbars=0') + ',resizable=0'  //Html parameters for Netscape.
  }
  var options = '';
  if (typeof(W) != 'undefined')
    options = 'width='+W;
  if (typeof(H) != 'undefined') {
    if (options != '')
      options += ',';
    options += 'height='+H;
  }
  if (options != '')
      options += ',' + wNS;

  if (typeof(original) == 'undefined')
    original = false;
  if (original) {
  	var thewindow = windowopenoriginal(u, n, options);
  } else {
  	var thewindow = windowopen(u, n, options);
  }
	return thewindow;
}

function windowopenoriginal(arg1, arg2, arg3){
  var thewindow = window.open(arg1, arg2, arg3);
  if (thewindow)
    return (thewindow);
  else
   parent.location = pathdetect;
}

function windowopen(param1, param2, param3){
  return windowopenoriginal(param1, param2, param3);
}
function windowclose() {
  window.close();
}
var selfopener = self.opener;
var thewindow = window;

function wysiwyg_swap(fieldname) {
  var wysiwig_field = document.getElementById('wysiwyg_' + fieldname);
  var html_field = document.getElementById('html_' + fieldname);
  var the_field = document.getElementById('id_' + fieldname);
  var control_panel = document.getElementById('control_' + fieldname);
  var button = document.getElementById('btn_' + fieldname);
  
  if (html_field.style.display == 'block') {
    the_field.value = html_field.value;
    wysiwig_field.innerHTML = html_field.value;
  } else {
    the_field.value = wysiwig_field.innerHTML;
    html_field.value = wysiwig_field.innerHTML;
  }
  wysiwig_field.style.display = html_field.style.display;
  if (control_panel)
    control_panel.style.visibility = wysiwig_field.style.display == 'block' ? 'visible' : 'hidden';
  html_field.style.display = html_field.style.display == 'block' ? 'none' : 'block';
  button.value = html_field.style.display == 'block' ? 'WYSIWYG' : 'HTML';
  
}
var parentftop = self;
var theparent = self;
if (parent) {
    theparent = parent;
	if (parent.ftop) {
	  parentftop = parent.ftop;
	}
}