<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/28 code revision and cleanup sp
/**
 * Module de gestion sessions
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

//------------------------------------------------------
// Version  Description
//---------------------------------------------
// 1.1.0    update_usager       (29 avril 2002)
//          5 tentatives max
// 1.2.0		visite_typeutilisateur	(27 Janvier 2003)
// 					set_cargo() apres le login
// 1.3.0		visite_secteur_activite (11 fev 2003)
// 13/12/2004  - utiliser la constnate MD5_DATABASE_NOISE
//------------------------------------------------------

copin_include("lib/db.php");
copin_include("lib/mime.php");

/*
 Valider la connexion au par usager et motpasse
*/
function login($usager, $motpasse) {
    $log_res = selectsql("SELECT udf_login('".$usager."', 
                                 '".md5($motpasse)."', 
                                 '".session_id()."')");
    if($log_res == 1){
      initialize_site_user($usager);
      return "OK";
    } elseif ($log_res == 2) {
      initialize_site_user($usager);
      return "TEMPORAIRE";
    } else {
      return "ERROR";
    }
}

// ---------------------------------------------------------------/


// Pour rendre public la constante d'encription md5
function get_hidden_hash_var() {
  return get_constant("MD5_DATABASE_NOISE");
}

function send_confirmation($usager, $wizard_id = null) {
  if (!isset($wizard_id)) {
    $wizard_id = selectsql("SELECT w.wizard FROM cms.wizard w 
                             JOIN cms.site_user u ON w.wizard = u.wizard 
                             WHERE u.site_user = '".$usager."df'");
    if ($wizard_id == "") {
      $key = get_new_key();
      if (get_cargo("user_name") == "" ) {
        $user_name = "null";
      } else {
        $user_name = "'" . get_cargo("user_name") . "'";
      }
      $sql = "INSERT INTO cms.wizard 
             (site_user, created, description, wizard_status, key, apache_session, step) 
             VALUES
             (" . $user_name . ", 
             '" . date("Y m d h:i:s") . "', 
             'confirmation', 
             'wait', 
             '" . $key . "', 
             '" . session_id() . "', 
             '" . gget("action") . "');";
      $wizard_OID = execsql($sql);
      $wizard_id = selectsql("SELECT wizard 
                              FROM cms.wizard 
                              WHERE OID = " . $wizard_OID . ";");
      execsql("UPDATE cms.site_user 
               SET wizard = ".$wizard_id." 
               site_user = '".$usager."'");
    }
  }
  $rs = selectsql( "SELECT u.site_user, u.last_name, 
                           u.first_name, u.email, u.site_user_type, w.key
                    FROM cms.site_user u join cms.wizard w on u.wizard = w.wizard
                    WHERE w.wizard =  " . $wizard_id); 
  
  $type_usager = $rs[0]["site_user_type"];
  $url_confirm = batir_href(strtolower($type_usager) . "_inscription") . '&objet=conclusion&usager=' . $rs[0]["usager"] . '&cle=' . $rs[0]["cle"] . "&wizard=" . $wizard_id;
  $url_confirm = get_urlmd5($url_confirm);
  $url_confirmannule = update_url_query($url_confirm, "annuler", "O");
  $url_confirmannule = get_urlmd5($url_confirmannule);
/**
  * @todo use language file
  */

  $msg = is_primary_language() ? "Vous devez confirmer votre adresse de courrier lectronique en cliquant sur le lien suivant : <a href=\"$url_confirm\">confirmer</a>. <br><br>
<hr><br>Si vous recevez ce courriel par erreur ou que vous ne dsirez plus accder au site de " . get_constant("APPLICATION_NAME") . " , veuillez cliquer sur le lien suivant : <a href=\"$url_confirmannule\">annuler</a>.
<br><br><hr><br><br>Vous narrivez pas  confirmer votre adresse de courrier lectronique?<br><br>
La version de votre logiciel de courrier lectronique est peut-tre ancienne, mettez-la  niveau ou copiez ce lien (sans les guillemets) dans la barre dadresses de votre navigateur : \"$url_confirm\"."
 : "You have been registered in " . get_constant("APPLICATION_NAME") . "s secure site.<br>To finalize your registration, please click on this link: <a href=\"$url_confirm\">confirm</a>.<br><br>
<hr><br>If you have been sent this e-mail by mistake or if you no longer want to access the " . get_constant("APPLICATION_NAME") . " site, please click on this link: <a href=\"$url_confirmannule\">cancel</a>.
<br><br><hr><br><br>If you are unable to confirm your registration, your email software may need to be updated or copy the link (without the quotes) into your browsers address bar : \"$url_confirm\"";
  $from = get_constant("MANAGER_EMAIL_SALUTATION") . "<" . get_constant("MANAGER_EMAIL") . ">";
  $headers .= "From: $from\r\n";
  $msg = wrap_mail_body($msg);
  
  if ($_SERVER["HTTP_HOST"] == "vmlinette" || $_SERVER["HTTP_HOST"] == "mobile")
    echo "<a href=\"$url_confirm\">confirmer</a>";
  else 
    return mail($rs[0]["courriel"],
              is_primary_language() ? "Confirmation de votre adresse de courrier lectronique sur le site"
              : "Registration to the site",
              $msg,
              $headers . mime_html());
}

/**
* Vrifier si l'utilisateur s'est correctement dlogger  la
* dernire connexion et ajoute sa connexion dans la table login
*/
function activer_session($usager, $langue = "") {
  $sql_delog = "SELECT 1 
                FROM login 
                WHERE usager='".$usager."'
                AND fin is NULL LIMIT 1";
    
  if(sget("message") != "adel" && selectsql($sql_delog)){
/**
  * @todo use language file
  */

    echo "<script>alert('" . 
    ($langue != "A" ? "Attention!  Vous navez pas mis fin  votre session de travail lors de votre dernire visite.  Pour plus de scurit, quand vous mettrez fin  la session en cours, retournez au menu principal et cliquez sur Fermer la session dans le menu de gauche."
      : "Important! You did not log out during your last visit. For security reasons, you should always click \"Log out\" in the main menu on the left when you are ready to end your session.")
    . "')</script>";
  }
  $sql = "SELECT udf_login('".session_id()."', '".$usager."')";
  execsql($sql);
}


/**
* Dsactiver la session pour ne pas permettre  l'utilisateur
* d'utiliser la meme session pour faire ses manipulation
* Nb: Prsentement utiliser pour le logout.
*/
function desactiver_session() {
  $sql = "SELECT cms.udf_logout('".session_id()."')";
  execsql($sql);
}

/**
* Vrifier si la session prsente est active ou pas
*/
function session_active(){
  $sql = "SELECT cms.udf_session_php_active('".session_id()."')";
  if(selectsql($sql) != 'O') { 
    session_destroy();
    return false;
  } else{
    return true;
  }
}

function process_user_wright($site_user) {
  $wright;
  $result = selectsql(
    "SELECT max_access, action, site_user " .
    "FROM cms.v_user_rights WHERE site_user = '$site_user'"
  );
  if ($result != "")
    while (list($key, $value) = each($result))
      $wright[ $result[$key]["action"] ] = $result[$key]["max_access"];
  else
    $wright[""] = "";
  return $wright;
}

function change_question($usager, $password, $qp1, $rp1){
    $sql =  "SELECT site_user FROM cms.site_user WHERE site_user='" . $usager .
            "' AND password = '" . md5($password) . "'";

    $rs = pg_query(getdb(), $sql);

    if ($rs === FALSE || pg_num_rows($rs) < 1){
        return false;
    } else {
        update_question($usager, $qp1, $rp1);
        return true;
    }
}

function update_question($usager, $qp1, $rp1){
    $sql = "UPDATE cms.site_user SET "
         . "question = '" . $qp1 . "', "
         . "answer = '" . md5($rp1) . "' "
         . "WHERE site_user = '" . $usager . "'";
    $rs = pg_query(getdb(), $sql);
}
function change_password($usager, $oldpassword, $password) {
    $sql =  "SELECT site_user FROM cms.site_user WHERE site_user='" . $usager .
            "' AND password ='" . md5($oldpassword) . "'";

    $rs = pg_query(getdb(), $sql);

    if ($rs === FALSE || pg_num_rows($rs) < 1){
        return false;
    } else {
        update_password($usager, $password);
        return true;
    }
}

function update_password($usager, $password){
    $sql = "UPDATE cms.site_user SET "
         . "password = '" . md5($password) . "' "
         . "WHERE site_user = '" . $usager . "'";
    $rs = pg_query(getdb(), $sql);
}


function change_password_question($usager, $cle, $password) {
    $sql =  "SELECT site_user FROM cms.site_user 
             WHERE site_user='" . $usager . "' AND key='" .
            $cle . "' AND active = 1";
    $rs = pg_query(getdb(), $sql);

    if ($rs === FALSE || pg_num_rows($rs) < 1){
        update_password_question($usager, false);
        return false;
    } else {
        update_password_question($usager, true, $password);
        return true;
    }
}

function update_password_question($usager, $bool_result, $password = null) {
    $sql = "UPDATE cms.site_user SET ";
    if ($bool_result) {
        // valide
        $sql .= "question_count = 0, password = '" . md5($password) . "', key = '" . get_new_key() . "' ";
    } else {
        // pas valide
        $sql .= "question_count = (question_count + 1) ";
    }
    $sql .= "WHERE site_user = '" . $usager . "'";

    $rs = pg_query(getdb(), $sql);
}

function logout() {
  session_destroy();
}


function isloged() { 
    // Nom de l'usager contenue dans la session
    $user_name = get_cargo("user_name");
    // md5(nom de l'usager + phrase trange)
    $id_hash = get_cargo("user_id");
    if ($user_name != "" && $id_hash != "" && get_cargo("open")) {
        $hash=md5($user_name . get_hidden_hash_var());
        if ($hash === $id_hash) {
            return true;
        } else {
            return false;
        }
    } else {
      return false;
    }
}

function fermer_session(){
  /* set_cargo("open", false);
  set_cargo("user_name", "");
  set_cargo("user_id", "");
  set_cargo("site_user_type", ""); */
  unset($_SESSION[get_constant("SITE_NAME")]["cargo"]);
  sset("reinitmenu", true);
  desactiver_session();
  //session_destroy();
  //echo "<pre>"; print_r(array_keys($_SESSION)); echo "</pre>";
  //$_SESSION[get_constant("SITE_NAME")] = "";
  /* echo "<pre>"; print_r($_SESSION); echo "</pre><script>
  clearTimeout(animation);
	document.getElementById(\"splashScreen\").style.display = \"none\";
	clearInterval(theanimate);
	document.getElementById(\"thecontent\").style.display = \"block\";</script>";
  exit(); */
}
/**
  * @todo use language file
  */
function validate_username($value) {
  if (validate($value, 6, 24, false)) {
    $err_msg = is_primary_language() ?
       "Le code de l'utilisateur doit tre constitu d'au moins 6 caractres et d'au plus 24 caractres.&nbsp;&nbsp;" .
        "Il ne doit pas contenir un des caractres suivants : # / \ $ ' &quot; &amp; ! &lt; &gt;."
    :  "The user code must contain at least 6 characters but not more than 24.&nbsp;&nbsp;" .
        "It cannot contain the following characters: # / \ $ ' &quot; &amp; ! &lt; &gt;.";
  }
  return $err_msg;
}

/**
  * @todo use language file
  */
function validate_password($value) {
  if (validate($value, 1, 60, false)) {
    $err_msg = is_primary_language() ? "Le mot de passe doit tre constitu d'au moins 6 caractres et d'au plus 60 caractres.&nbsp;&nbsp;" .
        "Il ne doit pas contenir un des caractres suivants : # / \ $ ' &quot; &amp; ! &lt; &gt;.&nbsp;&nbsp;" .
        "Il doit contenir au moins une lettre et un chiffre."
      : "The password must contain at least 6 characters but not more than 60.&nbsp;&nbsp;" .
        "It cannot contain the following characters: # / \ $ ' &quot; &amp; ! &lt; &gt;.&nbsp;&nbsp;" .
        "It must contain at least one letter and one number.";
  }
  return $err_msg;
}

/**
  * @todo use language file
  */
function validate_reponse($value) {
  if (validate($value, 6, 60, false)) {
    $err_msg = is_primary_language() ? "La rponse  la question pige doit tre constitue d'au moins 6 caractres et d'au plus 60 caractres.&nbsp;&nbsp;" .
        "Elle ne doit pas contenir un des caractres suivants : # / \ $ ' &quot; &amp; ! &lt; &gt;."
      : "The answer to the secret question must contain at least 6 characters but not more than 60.&nbsp;&nbsp;" .
          "It cannot contain the following characters: # / \ $ ' &quot; &amp; ! &lt; &gt;.";
  }
  return $err_msg;
}

function validate($string, $min_len = 6, $max_len = 12, $letternumber = true) {
  $invalid_char = '/#|\/|\\\|\$|\'|&|!|<|>|"/';

  $rules;

  if ( preg_match($invalid_char, $string, $matches) ) {
    $rules["invalid_char"] = $matches[0];
  }
  if ( strlen($string) < $min_len ) {
    $rules["min_len"] = strlen($string);
  }
  if ( strlen($string) > $max_len ) {
    $rules["max_len"] = strlen($string);
  }
  if ($letternumber) {
    if ( !preg_match("/[a-z|A-Z]/", $string) ) {
      $rules["must_have_char"] = "[a-z|A-Z]";
    }
    if ( !preg_match("/[0-9]/", $string) ) {
      $rules["must_have_num"] = "[0-9]";
    }
  }
  return $rules;
}

function type() {
    return get_cargo("visite_typeusager");
}
?>