/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * regex library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
 
//  =============================================================
//  Title:  re.js
//  Author:	Les consultants interaction.
//  Date:   18 Avril 2002
//  Version	Description
//  -------------------------------------------------------------
//  1.0.0   Fonctions de validation par expression rguliere
//  =============================================================


function float_re_validation(val, val_min, val_max) {alert (val);
    if (typeof(val_min) != 'undefined') {
      var val1 = parseFloat(val);
      var val_min1 = parseFloat(val_min);
      if (val1 < val_min1)
        return false; 
    }
    if (typeof(val_max) != 'undefined') {
      var val1 = parseFloat(val);
      var val_max1 = parseFloat(val_max);
      if (val1 > val_max1)
        return false;
    }
    var re_float_space    = /^(((\d{1,3}\s)(\d{3}\s)*\d{3}([.|,]\d{0,2})*)|((\d+)([.|,]\d{0,2})*))$/;
    var re_float_coma     = /^(((\d{1,3}\,)(\d{3}\,)*\d{3}(\.\d{0,2})*)|((\d+)(\.\d{0,2})*))$/;

    return generic_re_validation(val, new Array(re_float_space, re_float_coma));
} 

function float3dec_re_validation(val, val_min, val_max) {
    if (typeof(val_min) != 'undefined') {
      var val1 = parseFloat(val);
      var val_min1 = parseFloat(val_min);
      if (val1 < val_min1)
        return false;
    }
    if (typeof(val_max) != 'undefined') {
      var val1 = parseFloat(val);
      var val_max1 = parseFloat(val_max);
      if (val1 > val_max1)
        return false;
    }
    var re_float_space    = /^(((\d{1,3}\s)*(\d{3}\s)*\d{3}([.|,]\d{0,3}){0,1})|((\d+)([.|,]\d{0,3}){0,1}))$/
    var re_float_coma     = /^(((\d{1,3}\,)*(\d{3}\,)*\d{3}(\.\d{0,3}){0,1})|((\d+)([.|,]\d{0,3}){0,1}))$/

    return generic_re_validation(val, new Array(re_float_space, re_float_coma));
} 


function integer_re_validation(val, val_min, val_max) {
    if (typeof(val_min) != 'undefined') {
      var val1 = parseInt(val);
      var val_min1 = parseInt(val_min);
      if (val1 < val_min1)
        return false; 
    }
    if (typeof(val_max) != 'undefined') {
      var val1 = parseInt(val);
      var val_max1 = parseInt(val_max);
      if (val1 > val_max1)
        return false;
    }
    var re_integer_space    = /^-*(((\d{1,3}\s)(\d{3}\s)*\d{3})|(\d+))$/;
    var re_integer_coma     = /^-*(((\d{1,3}\,)(\d{3}\,)*\d{3})|(\d+))$/;

    return generic_re_validation(val, new Array(re_integer_space, re_integer_coma));
} 

function postal_re_validation(val) {
    var re_postal_ca    = /^[a-z|A-Z]\d[a-z|A-Z]\s\d[a-z|A-Z]\d$/;
    var re_postal_other = /^\d.*$/;

    return generic_re_validation(val, new Array(re_postal_ca, re_postal_other));
} 


//------------------------------------------------------
// Applique une ou plusieurs expression rguliere
// et retoure vrai si une expression est applicable
// val      (La chaine de char a valide)
// re_array (Array d'expression rguliere)
//------------------------------------------------------
function generic_re_validation(val, re_array) {
    var str2test = trim(val);
    var re;

    for (c=0; c<re_array.length; c++) {
        re = eval( re_array[c] );
        if ( re.test(str2test) ) {
            return true;
        }
    }

    return false;
}
