/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * clalendar library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
//---------------------------------------------------------
//  Calendrier pour l'acquisition de date
//  Les consultants interaction
//  16 avril 2002
//  Version Description
//---------------------------------------------------------
//  1.0.0
//---------------------------------------------------------

//-----------------------------------------------------------------------
// Affiche le calendrier
// field    = L'objet html qui doit recevoir la valeur slectionn
// language = La langue d'affichage [A|a] || [ |F|f]
// format   = Le format de la valeur retourne
//            si plusieurs format sont fournit ex: "YYYY/MM/DD|YY-MM-DD"
//            seulement le premier seras conserv
//-----------------------------------------------------------------------
var css_dir;
var showmethod;
var windowopener;
var calselfopener = "self.opener";
var theclose = "window.close()";
var popup;
var originalday;
var originalmonth;
var originalyear;
var aujourdhui;
var todaythis_day;
var todaythis_month;
var todaythis_year;
var title = "";
function show_popup_calendar(field, language, format, dcss_dir, dshowmethod, datedujour, alt_init_value) {

    var lang;
    if (language == "a" || language == "A") {
        lang = "A";
    } else {
        lang = "F";
    }
    
    if (lang == "F") {
        title = " Slectionner une date ";
    } else if (lang == "A") {
        title = " Select a date ";
    }
    
   if (parent.name == 'alertbox') 
     odlcalendar = true;
   if (odlcalendar) {
    calselfopener = "self.opener";
    theclose = "window.close()";
    popup = window.open(urlvide,
                    "Calendar",
                    "width=325,height=275,status=no,resizable=no,top=200,left=200,scrollbars=0");
   } else {
    popup = windowopen(urlvide,
                    "Calendar",
                    "width=300,height=220,status=no,resizable=no,top=200,left=200,scrollbars=0");
    setTimeout("if (parent.parent.alertbox && parent.parent.alertbox.subtop) parent.parent.alertbox.subtop.document.getElementById('title').innerHTML = '&nbsp;" + title + "';", 1000);
     
   }

    popup.document.open();
    css_dir = dcss_dir;
    showmethod = dshowmethod;
    // conserve seulement le premier format
    var format_array = format.split("|");
    format = format_array[0];

    if (typeof(datedujour) == 'undefined' || !is_date(datedujour, format, '', '')) datedujour = alt_init_value;
    if (typeof(datedujour) != 'undefined' && is_date(datedujour, format, '', '')) {
      y_index = format.indexOf('YYYY');
      m_index = format.indexOf('MM');
      d_index = format.indexOf('DD');
    
      this_day = datedujour.substring(d_index, d_index + 2);
      if (this_day < 10) 
        originalday = datedujour.substring(d_index +1, d_index + 2);
      else
        originalday = this_day;
      this_month = datedujour.substring(m_index, m_index + 2);
      if (this_month < 10) 
        originalmonth = datedujour.substring(m_index +1, m_index + 2);
      else
        originalmonth = this_month;
      this_year = datedujour.substring(y_index, y_index + 4);
      originalyear = this_year;
      datedujour = new Date(this_year,(this_month-1),this_day);
      aujourdhui = new Date();
      todaythis_day    = aujourdhui.getDate();
      todaythis_month  = aujourdhui.getMonth() + 1;
      todaythis_year   = aujourdhui.getFullYear();
    } else {
      datedujour = new Date();
      this_day    = datedujour.getDate();
      this_month  = datedujour.getMonth() + 1;
      this_year   = datedujour.getFullYear();
      todaythis_day    = datedujour.getDate();
      todaythis_month  = datedujour.getMonth() + 1;
      todaythis_year   = datedujour.getFullYear();
    }

    calendar(popup.document, field, lang, format, datedujour, this_day, this_month, this_year);

    popup.document.close();
}


function show_calendar(doc,language, year, month, field, format, this_day, this_month, this_year) {
    doc.open();

    calendar(doc, field , language, format, new Date(year, month), this_day, this_month, this_year);

    doc.close();
}


/* tester l'anne bisectile */
function leap(today) {
    return  (((today.getFullYear() % 4 == 0) && (today.getFullYear() % 100 != 0)) || (today.getFullYear() % 400 == 0));
}
 
/* rvision du calcul du nombre de jours */

function MonthDays (today) {
    var monthDays = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
    
    return (today.getMonth() == 1 && leap(today)) ? 29 : monthDays[today.getMonth()];
}

function calendar(popup_doc, field, language, format, today, this_day, this_month, this_year) {
    year = today.getFullYear()

    nDays = MonthDays(today);
    month_display = today.getMonth() + 1


    firstDay = today;
    firstDay.setDate(1);
    testMe = firstDay.getDate();
    if (testMe == 2) { firstDay.setDate(0); }
    startDay = firstDay.getDay();

    popup_doc.write( display_html_header(language) );
    popup_doc.write( display_html_navigation(language, year, month_display, field, format, this_day, this_month, this_year) );

    popup_doc.write("</td></tr><tr><td valign=top>");

    // Affiche le mois et l'anne comme titre
    popup_doc.writeln("<table width=\"100%\">");
    // Affiche les jours en entete de colonne
    popup_doc.write("<tr><th>" + get_day_array(language).join("</th><th>") + "</th></tr>");

    popup_doc.write("<tr>");
    // Affiche des case vide (correspondant au jours du mois prcdent)
    column = 0;
    for (i=0; i<startDay; i++) {
        popup_doc.write("<td class=\"calendarcol" + (column + 1) + "\">&nbsp;</td>");
        column++;
    }
    // Pour chaque journe du mois
    for (i=1; i<=nDays; i++) {/*popup_doc.write("<tr><td>" + year + "</td></tr>");*/
        // Affiche la journe courante d'une autre couleurs
        if ( (i == todaythis_day) && (month_display == todaythis_month) && (year == todaythis_year) ) {
            popup_doc.write("<td class=\"calendarcol" + (column + 1) + "today\">");
        } else if ( (i == parseInt(originalday)) && (month_display == parseInt(originalmonth)) && (year == parseInt(originalyear)) ) {
            popup_doc.write("<td class=\"originaldate\">");
        } else  { 
            popup_doc.write("<td class=\"calendarcol" + (column + 1) + "\">");
        }
        if (showmethod == 'href') {
          popup_doc.write("<a href=\"#\" ");
          popup_doc.write("onClick=\"javascript:" + calselfopener + ".document." +
            field + ".value='" + format_date_to_return(i, month_display, year, format) +
            "' ;" + theclose + ";\">");
          // Affiche la date
          popup_doc.write("&nbsp;" + i + "&nbsp;");
          popup_doc.write("</a>");
        } else {
          popup_doc.write("<input class=\"calendarbutton\" type=\"button\" style=\"height: 19; width: 19;\" ");
          popup_doc.write("onClick=\"javascript:set_parent_date('" + format_date_to_return(i, month_display, year, format) + "');" + theclose + ";\" ");
          // Affiche la date
          popup_doc.write(" value = \"&nbsp;" + i + "&nbsp;\">");
        }

        popup_doc.write("</td>");

        column++;
        if (column == 7) {
            popup_doc.write("</tr><tr>");
            column = 0;
        }

    }

    popup_doc.write("</tr></table>");
    html = "<script>function set_parent_date(date) {";
    html = html + calselfopener + ".document." + field + ".value=date; if ("+ calselfopener + ".document." +
            field + ".onchange) {"+ calselfopener + ".document." +
            field + ".onchange()};" + "}</script>";
    popup_doc.write(html);
    popup_doc.write( display_html_footer() );
}


function format_date_to_return(day, month, year, format) {
    var str2return;
    month   = month + "";
    day     = day + "";
    year    = year + "";

    // pad string
    month.length    == 1 ? month = "0"  + month : month;
    day.length      == 1 ? day = "0"    + day   : day

    if (format == "YYYY/MM/DD") {
        str2return = year + "/" + month + "/" + day;
    } else if (format == "YYYY-MM-DD") {
        str2return = year + "-" + month + "-" + day;
    } else if (format == "YY/MM/DD") {
        str2return = year.substr(2, 2) + "/" + month + "/" + day;
    } else if (format == "YY-MM-DD") {
        str2return = year.substr(2, 2) + "-" + month + "-" + day;
    }

    return str2return;
}


function get_month_name(month_number, langue) {
    var month;
    var month_f = new Array("Janvier", "Fvrier", "Mars", "Avril", "Mai", "Juin",
                "Juillet", "Aot", "Septembre", "Octobre", "Novembre", "Dcembre");
    var month_a = new Array("January", "February", "March", "April", "May", "June",
                "July", "August", "September", "October", "November", "December");

    if (langue == "F") {
        month = month_f[month_number - 1];
    } else if (langue == "A") {
        month = month_a[month_number - 1];
    } else {
        month = "ERROR: get_month_name(month_number, langue)";
    }

    return month;
}


function get_day_array(language) {
    var day_f = new Array("Dim", "Lun", "Mar", "Mer", "Jeu", "Ven", "Sam");
    var day_a = new Array("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");

    if (language == "F") {
        return day_f;
    } else if (language == "A") {
        return day_a;
    } else {
        return "ERROR: get_day_array(language)";
    }
}

function display_html_header(language) {
    var html = "<html><head><title>" + title + "</title>"
    + "<link rel=\"stylesheet\" href=\"" + css_dir + "calendar.css\" type=\"text/css\">"
    + "</head><body onload=\"window.focus();\"><center><form name=\"form_navigation\">"
    + "<img src=\"./cms/image/spacer.gif\" height=\"10\" border=\"0\"><table class=\"calendar\"><tr><td>";

    return html;
}

function display_html_footer() {
    return "</td></tr></table></form></center></body></html>";
}

function display_html_navigation(language, year, month, field, format, this_day, this_month, this_year) {
    var html = "<table class=\"navtable\" width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">";
    html = html + "<tr><th align=\"left\">";
    //  << YEAR
    html = html + "<input class=\"navbutton\" type=\"button\" value=\"&nbsp;&lt;&lt;&nbsp;\" ";
    html = html + "onclick=\"javascript:" + calselfopener + ".show_calendar(document,'";
    html = html + language + "','" + (year - 1) + "','" + (month - 1)  + "','" + field + "','";
    html = html + format + "','" + this_day + "','" + this_month + "','" + this_year + "')\">";
    //  < MONTH
    html = html + "<input class=\"navbutton\" type=\"button\" value=\"&nbsp;&lt;&nbsp;\" ";
    html = html + "onClick=\"javascript:" + calselfopener + ".show_calendar(document,'";
    html = html + language + "','" + year + "','" + (month - 2) + "','" + field + "','" + format + "','";
    html = html + this_day + "','" + this_month + "','" + this_year + "')\">";
    //  SELECT MONTH
    html = html + "</th><th><select class=\"slect\" name=\"select_month\" onChange=\"javascript:" + calselfopener + ".show_calendar(document,'";
    html = html + language + "','" + year + "',(form_navigation.select_month.options";
    html = html + "[form_navigation.select_month.selectedIndex].value - 1),'";
    html = html + field + "','" + format + "','" + this_day + "','" + this_month + "','" + this_year + "')\">";
    // Gnere la slection des mois
    for (c=1; c<13; c++) {
        if (month == c) {
            html = html + "<option selected value=\"" + c + "\">" + get_month_name(c, language) + "</option>";
        } else {
            html = html + "<option value=\"" + c + "\">" + get_month_name(c, language) + "</option>";
        }
    }
    //  SELECT YEAR
    html = html + "</select><select class=\"slect\" name=\"select_year\" onChange=\"javascript:" + calselfopener + ".show_calendar(document,'";
    html = html + language + "',form_navigation.select_year.options[form_navigation.select_year.selectedIndex].value,'";
    html = html + (month - 1) + "','" + field + "','" + format + "','" + this_day + "','" + this_month + "','" + this_year + "')\">";
    // Gnere la slction des annes
    var int_year = 1900;
    for (c=0; c<120; c++) {
        int_year += 1;
        if (year == int_year) {
            html = html + "<option selected value=\"" + int_year + "\">" + int_year + "</option>";
        } else {
            html = html + "<option value=\"" + int_year + "\">" + int_year + "</option>";
        }
    }
	html = html + "</select></th>";
    html = html + "<th align=\"right\">";
    //  > MONTH
    html = html + "<input class=\"navbutton\" type=\"button\" value=\"&nbsp;&gt;&nbsp;\" ";
    html = html + "onClick=\"javascript:" + calselfopener + ".show_calendar(document,'";
    html = html + language + "','" + year + "','" + month + "','" + field + "','" + format + "','";
    html = html + this_day + "','" + this_month + "','" + this_year + "')\">";
    //  >> YEAR
    html = html + "<input class=\"navbutton\" type=\"button\" value=\"&nbsp;&gt;&gt;&nbsp;\" ";
    html = html + "onClick=\"javascript:" + calselfopener + ".show_calendar(document,'";
    html = html + language + "','" + (year + 1) + "','" + (month - 1) + "','" + field + "','" + format + "','";
    html = html + this_day + "','" + this_month + "','" + this_year + "')\">";
	html = html + "</th></tr></table>";

    return html;
}
