/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * cunstom window library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
//===========================================================================
//  Title:  picklist.js
//  Author: Les consultants interaction.
//  Date:   23 Decembre 2002
//  Version Description
//------------------------------------------------------------------
//  1.0.0		Function utilisee par la popup picklist
// 	1.1.0		set_picklist_value() detecte maintenant le type de champ a traite
//===========================================================================


// ------------------------------------------------------------------------------------
// Ouvre une nouvelle fenetre pour permettre une selection sans changez l'eran courant.
// Note: Le formulaire doit contenir un champ input type="hidden" name="sequence"
// page2show		= La page a presenter dans la fenetre popup
// pagetarget		= Le target de la fenetre popup
// width				= pixel
// height				= pixel
// ------------------------------------------------------------------------------------
function popup_picklist(url, pagetarget, width, height) {
	var popup_picklist = openIT(url, width, height, null, null, pagetarget, 0, false, false, false, true, true);
  popup_picklist.focus();
}
function popup_picklistoriginal(url, pagetarget, width, height) {
  selfopener = self.opener;
  thewindow = window;
	var popup_picklist = openIT(url, width, height, null, null, pagetarget, 0, false, false, false, true, true, true);
  popup_picklist.focus();
}

// ------------------------------------------------------------------------------------
// Cette fonction est appele par la fenetre picklist pour completer les valeur du zoom
// sequenceValue		= valeur genere par php pour valider la presence du bon zoom
// formName					= Le nom du formulaire a completer
// fieldNameArray 	= Le nom des champ a completer dans le formulaire 
// fieldValueArray	= La valeur des champ a completer dans le formulaire 
// ------------------------------------------------------------------------------------
function set_picklist_value(sequenceValue, formName, fieldNameArray, fieldValueArray) {
		for (cFld = 0; cFld < fieldNameArray.length; cFld++) {
			// Obtient l'objet a traitee du formulaire
			var formObj = document.forms[formName].elements[fieldNameArray[cFld]];
			// Selectionne le traitement en fonction du type de champ
			switch(formObj.type.toLowerCase()) {
	      case 'text': 
	      case 'textarea':
	      case 'hidden':
	    		formObj.value = fieldValueArray[cFld];  
	      break;
	      case 'checkbox':  
	      	if (fieldValueArray[cFld] == 'O') {
	      		formObj.checked = true;
	      	} else if (fieldValueArray[cFld] == 'N') {
	      		formObj.checked = false;			      	
	      	}
	      break;
	      case 'radio':
	      	// ce traitement est a faire
	      	// je crois que c'pareil comme le checkbox
	      break;
	      case 'select':
	      case 'select-one':
	      case 'select-multiple':
	      	// il faudrait permettre le passage d'un array pour le select-multiple ???
	      	var selectOptionList = formObj.options;
	      	for (cOpt = 0; cOpt < selectOptionList.length; cOpt++) {
		      		if (selectOptionList[cOpt].value == fieldValueArray[cFld]) {
		      			formObj.selectedIndex = cOpt;
		      		}
	      	}
	      break;
   		}					
		}	
}	

function set_stablise_fields(sequenceValue, formName, fieldNameArray, fieldValueArray) {
		var disabled;
		for (cFld = 0; cFld < fieldNameArray.length; cFld++) {
			// Obtient l'objet a traitee du formulaire
			var formObj = document.forms[formName].elements[fieldNameArray[cFld]];
			if (typeof(formObj) != 'undefined') {
				disabled = true;
				if (typeof(fieldValueArray[cFld]) != 'undefined')
				 if (fieldValueArray[cFld] != '' && fieldValueArray[cFld] != 0)
	  			 disabled = false;
				switch(formObj.type.toLowerCase()) {
		      case 'text': 
		      case 'textarea':
	          swap_actif_inputbox_actif(formObj, '', '', disabled);
		      break;
		      case 'hidden':
		      break;
		      case 'checkbox':  
		      break;
		      case 'radio':
		      	// ce traitement est a faire
		      	// je crois que c'pareil comme le checkbox
		      break;
		      case 'select':
		      case 'select-one':
		      case 'select-multiple':
		      break;
     		}				
   		}	
		}		
}	


// ------------------------------------------------------------------------------------
// Appeler sur les evenments onClick() de la picklist
// sequenceValue	Genere par le serveur pour valider la presence de la bonne popup
// formName				Le nom du formulaire a completer
// fieldNameArray	Tout les nom de champ a completer
// fieldValueArray Les valeurs a utilise pour completer le formulaire (dans le meme ordre que les noms)
// ------------------------------------------------------------------------------------
function handle_click(sequenceValue, formName, fieldNameArray,  fieldValueArray, noclose) {
	if (is_ie_5_up || is_netscape_6_up) {
		handle_click_safe(sequenceValue, formName, fieldNameArray,  fieldValueArray);
	} else {
		self.opener.set_picklist_value(sequenceValue, formName, fieldNameArray, fieldValueArray);
	}
  if (typeof(noclose) == 'undefined') 
    noclose = false;
  if (!noclose)
  	window.close();
} 

function handle_click_stable(sequenceValue, formName, fieldNameArray,  fieldValueArray) {
  handle_click(sequenceValue, formName, fieldNameArray,  fieldValueArray, true);
  stablize_fields(sequenceValue, formName, fieldNameArray,  fieldValueArray);
  window.close();
}

function stablize_fields(sequenceValue, formName, fieldNameArray,  fieldValueArray) {
	if (is_ie_5_up || is_netscape_6_up) {
		stablize_fields_safe(sequenceValue, formName, fieldNameArray,  fieldValueArray);
	} else {
		self.opener.set_stablise_fields(sequenceValue, formName, fieldNameArray, fieldValueArray);
	}
}

// ------------------------------------------------------------------------------------
// Utilisee seulement par stablize_fields pour isoler le try catch
// ------------------------------------------------------------------------------------
function stablize_fields_safe(sequenceValue, formName, fieldNameArray, fieldValueArray) {
	// Le try catch doit etre dans une fonction differente qui ne seras pas utilise
	// dans le cas des navigateur ne le supportant pas
	try {
		self.opener.set_stablise_fields(sequenceValue, formName, fieldNameArray, fieldValueArray);
	} catch (errDescription) {
		alert(errDescription+'stablize_fields_safe() La reference au parent n\'est plus disponible');
	}
}
	
// ------------------------------------------------------------------------------------
// Utilisee seulement par handle_click pour isoler le try catch
// ------------------------------------------------------------------------------------
function handle_click_safe(sequenceValue, formName, fieldNameArray, fieldValueArray) {
	// Le try catch doit etre dans une fonction differente qui ne seras pas utilise
	// dans le cas des navigateur ne le supportant pas
	try {
		self.opener.set_picklist_value(sequenceValue, formName, fieldNameArray, fieldValueArray);
	} catch (errDescription) {
	}
}