<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * postgres array data type library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */ 
// 2005/02/22 code revision and cleanup sp
/*
   pgarrays.php : postgres array converter
                  This file contains two functions to convert postgesql arrays and php hash

   Les consultants INTERACTION
   January 2005
     
   asql2aphp : posgtresql array to php hash 
   aphp2asql : php hash to postgresql array
      
   limitations:
        (none for now)
      
      
   versions # 0.1 : please increment when modifying
      30/01/2005   : first version 
      31/01/2005   : bug with 2 level array
      		       : test for the end in included array
      		       : allow null and empty sql array
		       : keep escape char "\" while parsing pgArray in asql2aphp function
*/

/*
   asql2aphp($pgArray)  : Convert a string reprensenting a postgres array into a php array
   
   Parameters: $pgArray : is a postgres array  
   Usage:  asql2php('{{1,2,3,4},{5,6,7,8},{9,10,"this is a string"}}') will 
           return a php hash
   Limitations: $pgArray must be a valid string representig a postgressql array	   
*/
function asql2aphp($pgArray) {
   $position = 0;
   if (isset($pgArray) && trim($pgArray) !== "") 
     return parse_pgarray($pgArray,$position);
   else
     return array();
}

/*
please do not call this function directly unless you know what your doing ...
*/

function parse_pgarray($pgArray, &$position) {
  $array = array();
  $array_end = false;
  
  $element = null;
  $element_end = false;

  $inquote = false;

  $next_escape = false;
  
  // dans tous les cas, le pointeur "position" devrait tre positionn sur "{",
  // si ce n'est pas le cas le tableau n'est pas valid
  if (substr($pgArray, $position, 1) !== "{") {
     die("Syntax error in postgresql array at position: $position" .
         "<br>$pgArray<br>" .
	 "000000000011111111112222222222333333333344444444445555555555666666666677777777778888888888<br>" .
	 "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
  } else {
    $position++;
  }
  
  while ($position < strlen($pgArray) && !$array_end) {
    $char = (string) substr($pgArray,$position,1);
    $escape = $next_escape;
    $next_escape = false;
    switch (true) {
    case ($char === "{") && !$inquote :
      $element = parse_pgarray($pgArray, $position); 
		  $element_end = true;
			// case when we reach the end of the current array
			$array_end = (substr($pgArray, $position, 1) === "}");
      break;
    case ($char === "}") && !$inquote :
      $array_end = true;
    case ($char === ',') && !$inquote :
      $element_end = true;
	    break;
    case ($char === '"') && !$escape :
      $inquote = !$inquote;
		  break;
	  case ($char === '\\') && $inquote && !$escape :
	    $next_escape = true;
    default :
      $element .= $char;
    }
    $position++;
    if ($element_end) { 
      array_push($array,$element);
	    $element = "";
	    $element_end = null;
    }
  }
  return $array;
}

/*
  aphp2asql($array,$with_wrap = true) : convert a php hash into a postgresql array 
  Parameters: $array is a php hash to convert to a string representing a postgresql array
              $with_wrap : true - elements will be double quoted
	                   false - no quoting
  Usage:  aphp2asql($numberHash,false);
          aphp2asql($stringHash);
	  
  Limitations: This fonction does not support formating
*/

function aphp2asql($array, $with_wrap = true) {
  $wrap = ($with_wrap ? '"' : "");
  $isnext = false;

  $result .= "{";
  foreach ($array as $key => $value) {
    $result .= ($isnext ? "," : "" );
    if (is_array($value)) {
      $result .= aphp2asql($value,$with_wrap);
    } else {
      $result .=  $wrap . $value . $wrap;
    }
    $isnext = true;
  }
  $result .= "}";
  return $result;
}
?>