<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/

/**
 * menu library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 * @todo revise to get only one language at the time, simplify function to use only one array.
 */   
/**
 * Retrourne le bon url selon l'action et le site
 *
 */
 
// 2005/02/22 code revision and cleanup sp

function the_url(){
  return batir_href(aget("action"));
}

function batir_href_menu($action, $site = "STATIC", $action_type = "", $useshtml = false){
  	$lepath = get_constant("PATH_" . ($site == "" ? "STATIC" : $site)); 
  	$lepopup = gget("popup");
  	$frame = gget("frame");
  	if ($useshtml) 
  	  $lehref = get_html_language() . "/action.$action.shtml";
  	else
      $lehref = "?" . ($lepopup == "" ? "" : "popup=$lepopup&") 
        . "action=$action" . 
        (is_primary_language() ? "" : "&langue=" . get_language()) . 
        ($frame == "" ? "" : "&frame=$frame");
    $lurl = $lepath . $lehref;
  return get_urlmd5($lurl);
}

/**
*
*/
function batir_href($action){
  return batir_href_menu($action, trouver_site($action));
}

/**
*
*/
function batir_href_anglais_francais($action, $useshtml) {
  $the_url = nget("REQUEST_URI");
  $lurl = (nget("HTTPS") == "on" ? "https://" : "http://") . $_SERVER["HTTP_HOST"] . $the_url;
  if (!$useshtml) {
    $lurl = update_url_query($lurl, "frame", "ftop");
    $lurl = update_url_query($lurl, "action", get_constant("DEFAULT_ACTION"));
    $lurl = update_url_query($lurl, "langue", (is_primary_language() ? "a" : ""));
  } else {
    $lurl = (is_primary_language() ? "en" : "fr") . "/action." . get_constant("DEFAULT_ACTION") . ".shtml";
  }
  
  return get_urlmd5($lurl);
}

/**
*
*/
function trouver_site($action){
	// trouver le site selon l action
	// utiliser un nouveau nom et la nouvelle structure de menu
   return "STATIC";	
}


function get_restriction($menu, $action){
	$restriction = "";
    if(is_array($menu)) {
      reset($menu);
      while ( (list($index, $menus) = each($menu)) && ($restriction == "") ) 
        while ( (list($index2, $subarray) = each($menus)) && ($restriction == "") ) 
          	if ($subarray["name"] == $action)
              	$restriction = $subarray["restriction"];
    }
  return $restriction;	
}

function get_content_name(&$menu, $action, $javascript){
	$content_name = "";
	if ($javascript) {
	  if(is_array($menu))
	    $content_name = $menu[$action]["filename"];
	} else {
	  if(is_array($menu)) {
	    reset($menu);
	    while ( (list($index, $menus) = each($menu)) && ($content_name == "") ) 
	      while ( (list($index2, $subarray) = each($menus)) && ($content_name == "") ) 
	        	if ($subarray["name"] == $action)
	            	$content_name = $subarray[get_prefix_langue() . "filename"];
	  } 
	}
  if ($content_name == "")
    $content_name = $action;
  return $content_name;	
}

function get_action_type(&$menu, $action, $javascript){
	// trouver le action_type selon l'action
	$action_type = "";
	if ($javascript) {
	  if(is_array($menu))
	    $action_type = $menu[$action]["action_type"];
	} else {
	  if(is_array($menu)) {
	    reset($menu);
	    while ( (list($index, $menus) = each($menu)) && ($action_type == "") ) 
	      while ( (list($index2, $subarray) = each($menus)) && ($action_type == "") ) 
	        	if ($subarray["name"] == $action)
	            	$action_type = $subarray["action_type"];
	  }
	}
  if ($action_type == "")
  $action_type = "html";
  return $action_type;	
}

function get_content(&$menu, $action, $javascript){
	// trouver le content selon l'action
	// reviser pour les langues
	$content = "";
	if ($javascript) {
	  if(is_array($menu))
	    $content = $menu[$action][get_prefix_langue()."content"];
	} else {
    if(is_array($menu)) {
    reset($menu);
    while ( (list($index, $menus) = each($menu)) && ($content == "") ) 
      while ( (list($index2, $subarray) = each($menus)) && ($content == "") ) 
        	if ($subarray["name"] == $action)
            	$content = $subarray[get_prefix_langue()."content"];
	  }
  }
  return $content;	
}

function get_lexique_file_name($action) {
  $suffix =  get_suffix_langue();
  $path = get_constant("PATH_LEXIQUE_FILE");
  $suffix =  get_suffix_langue() . ".php";  
  $file_name = "lex_" . $action . $suffix;
  if (!file_exists($path . $file_name)) {
    $file_name = "lex" . $suffix;
    if (!file_exists($path . $file_name)) {
      $file_name = "";
    }
  }
  return $file_name;
}

function action_in_menus(&$menu, $action){
	// savoir si l action est dans le menu
  $is_found = false;
  if(is_array($menu)) {
    reset($menu);
    while ( (list($index, $menus) = each($menu)) && ($is_found == "") ) 
      while ( (list($index2, $subarray) = each($menus)) && ($is_found == "") ) 
        	if ($subarray["name"] == $action)
            	$is_found = true;
  }
  return $is_found;
}

function action_title_menus(&$menu, $action, $javascript){
	// retourner le titre de l'action
  $title = "";
	if ($javascript) {
	  if(is_array($menu))
	    $title = $menu[$action][get_prefix_langue()."title"];
	} else {
	  if(is_array($menu)) {
	    reset($menu);
	    while ( (list($index, $menus) = each($menu)) && ($title == "") ) 
	      while ( (list($index2, $subarray) = each($menus)) && ($title == "") ) 
	        	if ($subarray["name"] == $action)
	            	$title = $subarray["title"];
	  }
	}
  return $title;
}

function get_action_tree($menu, $action){
	// trouver le path selon l'action
	$action_tree = ""; 
  if(is_array($menu)) {
    reset($menu);
    while ( (list($index, $menus) = each($menu)) && ($action_tree == "") )
      if ($menus["name"] == $action)
        $action_tree = $menus["action_tree"];
  }
  return $action_tree;	
}

function get_parent_action($menu, $action) {
	$parent_action = ""; 
  if(is_array($menu)) {
    reset($menu);
    //echo "<pre>"; print_r($menu); echo "</pre>";
    while ( (list($index, $menus) = each($menu)) && ($parent_action == "") )
      if ($menus["name"] == $action)
        $parent_action = $menus["parent_name"];
  }
  return $parent_action;	
}

function get_default_action_name($menu, $action){
	// trouver le default_action_name selon l'action
	$default_action_name = "";
  if(is_array($menu)) {
    reset($menu);
    while ( (list($index, $menus) = each($menu)) && ($default_action_name == "") ) 
      if ($menus["name"] == $action)
        $default_action_name = $menus["default_action_name"];
  }
  return $default_action_name;	
}

function is_selected_action($menu, $action, $actionselected, $actionselected_tree){
  $action_path = get_action_tree($menu, $action);
  if (preg_match("/^top:(\w*)/", $action_path, $matches)) {
    $action = get_default_action_name($menu, $matches[1]);
    return preg_match("/:$action:/", $actionselected_tree);
  } else
    return $action == $actionselected;
}

function in_menu($menu, $action) {
  return isset($menu[$action]);
}
?>