<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * Module de gestion du code html
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

//  Version	Description
//  ------------------------------------------------------------------
//  1.0.0
//  1.0.1   get_textbox() reconnait password || password_confirm
//  1.0.2   get_readonly() retourne un hidden de la valeur affich
//  1.1.0   get_js_script() retourne la string de validation JavaScript
//  ------------------------------------------------------------------

copin_include("lib/browser.php");

function get_control($specs, $value, $no_update = false, $boutonjsro = "", $formename = "forme", $connect = null) {
  if ( ($specs['updatable'] == "O" && !$no_update) || $specs['temphidden']) {
    // les champ ditables
    if ($specs['temphidden'])
      $lehtml = get_hidden($specs, $value);
    else
      switch (strtoupper($specs['html_type'])) {
        case "EDITHTML":
          $lehtml = get_editable($specs, $value);
          break;
        case "MULTIPLESELECT": 
          $lehtml = get_multiple_select($specs, $value, $connect);
          break;
        case "SELECT":
          $lehtml = get_select($specs, $value, $connect);
          break;
        case "SELECTPLUS":
          $lehtml = get_selectplus($specs, $value, $connect);
          break;
        case "SELECTEDIT":
          $lehtml = get_selectedit($specs, $value, $formename, $connect);
          break;
        case "SELECTCOLOR":
          $lehtml = get_selectcolor($specs, $value);
          break;
        case "RADIO":
          $lehtml = get_radio($specs, $value, $connect);
          break;
        case "MEMO":
          $lehtml = get_memo($specs, $value);
          break;
        case "CHECKBOX":
          $lehtml = get_checkbox($specs, $value);
          break;
        case "DATEYEARMONTH":
        case "DATEYEAR":
        case "TEXTBOX":
          $lehtml = get_textbox($specs, $value);
          break;
        case "CALENDAR":
          $lehtml = get_textboxcalendar($specs, $value, $formename);
          break;
        case "DOLLAR":
          $lehtml = get_textboxdollar($specs, $value);
          break;
        case "POURCENTAGE":
          $lehtml = get_textboxpourcentage($specs, $value);
          break;
        case "PASSWORD_CONFIRM":
          $lehtml = get_textboxpassword_confirm($specs, $value);
          break;
        case "PASSWORD":
          $lehtml = get_textboxpassword($specs, $value);
          break;
        case "IMAGE":
          $lehtml = get_image($specs, $value);
          break;
        case "HIDDEN":
          $lehtml = get_hidden($specs, $value);
          break;
      } 
  } else {
    // les champ non ditable
    switch( strtoupper($specs['html_type']) ) {
      case "CHECKBOX":
        $lehtml = get_checkbox_readonly($specs, $value);
        break;
      case "HIDDEN":
        $lehtml = get_hidden($specs, $value);
        break;
      case "DOLLAR":
        $lehtml = get_textboxdollar_readonly($specs, $value);
        break;
      case "IMAGE": 
        $lehtml = get_image($specs, $value);
        break;
      default:
        $lehtml = get_readonly($specs, $value, $boutonjsro, $connect);
    }
  }
  return $lehtml;
} 

function get_hidden($specs, $value) {
  $htmltag = '<input type="hidden" name="'.$specs['name'].$specs['index_zoom']
   . '" id="id_'.$specs['name'].$specs['index_zoom'].'" ' 
   . 'value="'.htmlspecialchars($value). '">';
  return $htmltag;
}

function get_image($specs, $value) {
  $htmltag = "<img src=\"$value\" name=\"" . $specs['name']. $specs['index_zoom']
  . "\" " . 'id="id_'.$specs['name'].$specs['index_zoom'].'" ' 
  . "alt=\"" . htmlspecialchars($value) . "\">";
  return $htmltag;
} 

function get_textboxdollar_readonly($specs, $value) {
  $dollarbefore = is_primary_language() ? "" : "<td>\$&nbsp;</td>";
  $dollarafter = is_primary_language() ? "<td>&nbsp;\$</td>" : "";
  $lehtml = "<table class=\"formeZoom\" cellpadding=\"0\" cellspacing=\"0\"><tr>$dollarbefore<td class=\"nonEditable\" align=\"right\"  width=\"" . ($specs['width'] - 5) . "\"";
  $lehtml .= $specs['html_attribut'] . '>' . htmlspecialchars($value) . "&nbsp;";    
  $lehtml .= "<input type=\"hidden\" name=\"" . $specs['name'] . $specs['index_zoom']. "\" " . 'id="id_'.$specs['name'].$specs['index_zoom'].'" ' . " value=\"" . $value . "\">";
  $lehtml .= "</td>$dollarafter</tr></table>";
    
  return $lehtml;
}

function get_readonly($specs, $value, $boutonjsro = "", $connect = null) {
  $value2 = $value;
  if (strtoupper($specs['html_type']) == "RADIO" || strtoupper($specs['html_type']) == "SELECT" || strtoupper($specs['html_type']) == "SELECTPLUS") {
    if ($specs['leschoixfunction'] != ""){
      $the_function = $specs['leschoixfunction']."_ro";
      $option_list = $the_function();
    } else {
      $option_list = get_options($specs, $value, $connect);
    }
  if ($specs['addself'])
    if (!in_array($value, array_values($option_list)) && $value!="") {
      if ($specs['pick_listdescription'] == "")
        $option_list[$value] = $value;
      else 
        $option_list[$specs['pick_listdescription']] = $value;
    }
  if (is_array($option_list)) {
    $option_list = array_flip($option_list);
    if (isset($option_list[$value]))
      $value2 = $option_list[$value];
    }
  }
  if (strtoupper($specs['html_type']) == "SELECTCOLOR") {
    if ($value == "") {
      $value2 = $specs["lbl_default"];
      $couleur = $specs["default_color"];
    } else {
      $value2 = $_SESSION["colour"][$value];
      $couleur = $value;
    }
    $specs['html_attribut'] = "style=\"color=#000000;background-color:#$couleur\"";
  }
  if (strtoupper($specs['html_type']) == "PASSWORD_CONFIRM" || strtoupper($specs['html_type']) == "PASSWORD") {
    $value2 = preg_replace("/(.)/", "*", $value2);
  }
   
  $html_class = $specs['html_class'] == "" ? "nonEditable" : $specs['html_class'];
  
  $lehtml = "<table id=\"idro_" . $specs['name'].$specs['index_zoom'] . "\" style=\"width:" . ($specs['width']) .  "\" cellpadding=0 cellspacing=0><tr><td class=\"$html_class\" width=100% ";
  $lehtml .= $specs['html_attribut'] . '>' . ($specs["hint"] != "" ? 
       "<div style=\"display:inline\" title=\"" . $specs["hint"] . "\">" : "")
      . $value2 . "&nbsp;" . ($specs["hint"] != "" ? "</div>" : "");
    
  if (strtoupper($specs['html_type']) != "PASSWORD_CONFIRM" && strtoupper($specs['html_type']) != "PASSWORD") 
    $lehtml .= '<input type="hidden" name="'.$specs['name'].$specs['index_zoom'].'" id="id_'.$specs['name'].$specs['index_zoom'].'" value="'.htmlspecialchars($value).'">';
      
  $lehtml .= "</td>" . ($boutonjsro != "" ? "<td>$boutonjsro</td>" : "") . "</tr></table>";
  return $lehtml;
}

function get_editable($specs, $value) {
  $html_class = $specs['html_class'] == "" ? "contenteditable" : $specs['html_class'];
    
  $lehtml = '<input type="hidden" name="' . $specs['name'] . $specs['index_zoom'] 
	  . '" id="id_' . $specs['name'] . $specs['index_zoom'] . '" value="lecontenuoriginal">'
	  . "<textarea id=\"html_" . $specs['name'] . $specs['index_zoom']. "\" onblur=\""
      . $specs['name'] . $specs['index_zoom']. ".value = this.innerHTML;\" style=\"width:400;height:" . $specs['height'] 
	  . ";display:none\"></textarea>"
	  
    . '<div class="' . $html_class . '" CONTENTEDITABLE '
    . ' id="wysiwyg_' . $specs['name'] . $specs['index_zoom'] . '" onblur="'
    . $specs['name'] . $specs['index_zoom']. ".value = this.innerHTML;\" style=\"width:"
	  . $specs['size'] . ';height:' . $specs['height'] . ';" ' 
	  . $specs['html_attribut'] . ' >' . $value . "</div>"
	  
	  . "<table cellpadding=0 cellspacing=0 width=100%><tr><td align=\"right\">
	    <input id=\"btn_" . $specs['name'] . $specs['index_zoom'].  "\" class=\"formeZoombutton\" type=\"button\" value=\"HTML\" onclick=\"wysiwyg_swap('" 
	  . $specs['name'] . $specs['index_zoom']. "')\"></td></tr></table>";

  return $lehtml;
}

function get_radio($specs, $value, $connect = null) {
  $i = 0;
  while( list($opt_name, $opt_value) = each($specs['leschoix']) ) {
    $i++;
    $lehtml .=  "<input type=\"radio\" name=\"" 
      .$specs['name'].$specs['index_zoom'].
       '" id="id_'.$specs['name'].$specs['index_zoom'].$i.'" value="'.$opt_value.'" ';
    if ($value == "") {
      $lehtml .= (($specs['defaut'] != "" && $specs['defaut'] == $opt_value) ? " checked " : " ");
    } else {
      $lehtml .= (($value == $opt_value) ? " checked " : " ");
    }
    $lehtml .= $specs['html_attribut'] . "><label for=\"id_".$specs['name'].$specs['index_zoom'].$i.
      "\" style=\"cursor: arrow;\">$opt_name</label>" . $specs["seperator"];
  }
  return $lehtml;
}

function get_checkbox($specs, $value, $is_readonly = false){
  $lehtml = '<input class="checkbox" type="checkbox" name="'.$specs['name'].$specs['index_zoom']. '" id="id_'.$specs['name'].$specs['index_zoom'].'" ';
  $lehtml .= 'value="' . $specs["oui"] . '" ';
  if ($value == "") {
    $lehtml .= (($specs['defaut'] == $specs["oui"]) ? " checked " : " ");
  } else {
    $lehtml .= (($value == $specs["oui"]) ? " checked " : " ");
  }
  $lehtml .= ($is_readonly ? " disabled " : " ") . $specs['html_attribut'] . " >";
  return $lehtml;
}

function get_checkbox_readonly($specs, $value) {
  $lehtml = "";
  if (is_netscape476()) {
    if ($value == "O") {
      $bool2display = is_primary_language() ?  "oui" : "yes";
    } else {
      $bool2display = is_primary_language() ? "non" : "no";
    }
    $lehtml = get_readonly($specs, $bool2display);
  } else {
    $lehtml = get_checkbox($specs, $value, true);
  }
  return $lehtml;
}

function get_memo($specs, $value) {
  $lehtml = "<textarea name=\"" . $specs['name'] . $specs['index_zoom']
  . "\" id=\"id_" . $specs['name'].$specs['index_zoom'] . "\" "
  . "style=\"width:" . $specs['width'] . ";height:" . $specs['height'] . "\" "
  . $specs['html_attribut'] . " >" . $value . "</textarea>";
  return $lehtml;
}

function get_options($specs, $value, $connect = null){
  if ($specs["leschoixfunction"] != ""){
    $option_list = $specs["leschoixfunction"]($value);
  } else {
    $option_list = $specs["leschoix"];
    if (!is_array($option_list) && $option_list!="") {
      $option_list = sql2arrayselect($option_list, null, $connect);
    }
  }
  return $option_list;
}

/* ajout 07 avril 2004 TTL */
function get_multiple_select($specs, $value, $connect = null) {
  $option_list = get_options($specs, $value, $connect);
  $row = count($option_list);
  if($row > 5)
    $row = 5;
  else
    $row = $row + 1; 
  $htmltag = '<select name="' . $specs['name']
  . $specs['index_zoom'] . '[]" id="id_' . $specs['name']
  . $specs['index_zoom'] . '" style="width:' . $specs['width'] . '" '
  . $specs['html_attribut'];
  
  if ($specs['html_class'] != "")
    $htmltag .= ' class="' . $specs['html_class'] . '" ';
  else
    $htmltag .= ' class="inputbox" ';
  $htmltag .= " size=\"$row\" MULTIPLE>";
  if ($specs['null'] == "O") {
    $htmltag .= '<option value=""></option>';
  }
  
  if (is_array($option_list)){
    reset($option_list);
    if(!$value){
      $value = array();
    }
    while( list($opt_name, $opt_value) = each($option_list) ) {
      if( in_array($opt_value, $value) || ($value == "" && $specs['defaut'] == $opt_value) ) {
        $htmltag .= '<option value="' . $opt_value . '" selected>' . $opt_name."</option>";
      } else {
        $htmltag .= '<option value="' . $opt_value.'">' . $opt_name . "</option>";
      }
    }
  }
  $htmltag .= "</select>";

  return $htmltag;
}



function get_select($specs, $value, $connect = null) {
  $width = $specs['html_type'] == "selectplus" ? $specs['width'] - 20 : $specs['width'] ;
  $htmltag = '<select name="'.$specs['name'].$specs['index_zoom']. '" id="id_'.$specs['name'].$specs['index_zoom'].'" style="width:'.$width.";" . $specs['style'].'" ';
  $htmltag .= $specs['html_attribut'];
  
  if ($specs['html_class'] != "")
    $htmltag .= ' class="'.$specs['html_class'].'" ';
  else
    $htmltag .= '';
  $htmltag .= " >";
  if ($specs['null'] == "O") {
    $htmltag .= '<option value=""></option>';
  }
  $option_list = get_options($specs, $value, $connect); 
  if ($value != "" && $specs['addself'])
    if (!in_array($value, array_values($option_list))) {
      if ($specs['pick_listdescription'] == "")
        $option_list[$value] = $value;
      else 
        $option_list[$specs['pick_listdescription']] = $value;
    }
  
  if (is_array($option_list)){
    reset($option_list);
    while( list($opt_name, $opt_value) = each($option_list) ) {
      if( ($value === $opt_value) || ($value == "" && $specs['defaut'] == $opt_value) ) {
        $htmltag .= '<option value="'.$opt_value.'" selected>'.$opt_name."</option>";
      } else {
        $htmltag .= '<option value="'.$opt_value.'">'.$opt_name."</option>";
      }
    }
  }
  $htmltag .= "</select>";

  return $htmltag;
}

function get_selectcolor($specs, $value) {

  if ($specs["default_color"] != "")
    $options .= "<option style=\"color:#000000;background-color:#" . $specs["default_color"] . "\" value=\"\"" 
  . ($value == "" && $specs["defaut"] == "" ? " selected" : "") . ">" . $specs["lbl_default"];
  if ($value == "" && $specs["defaut"] == "") $backgroundcolor = $specs["default_color"];
  reset($_SESSION["colour"]);
  while (list($index, $subarray) = each($_SESSION["colour"])) {
    $selected = ($value == $index) || ($value == "" && $specs["defaut"] == $index) ? " selected" : "";
    if ($selected != "") 
      $backgroundcolor = $index;
    $options .= "<option style=\"color:#000000;background-color:#$index;\" value=\"$index\"$selected>" . $subarray;
  }
  $backgroundindex = $value != "" ? $value != "" : $specs["defaut"];
  $htmltag = "<select name=\"" . $specs["name"] . $specs["index_zoom"]. "\" id=\"id_" . $specs["name"] . $specs["index_zoom"]
    . "\"  onclick=\"this.style.backgroundColor = this.value != '' ? this.value : '" . $specs["default_color"] 
    . "'\" style=\"color:#000000;background-color:#$backgroundcolor;width:" . $specs["width"] . ";" . $specs["style"] . "\" ";
  $htmltag .= $specs["html_attribut"];
  
  if ($specs["html_class"] != "")
    $htmltag .= " class=\"" . $specs["html_class"] . "\" ";
  else
    $htmltag .= "";
  $htmltag .= " >" . $options . "</select>";
  return $htmltag;
}

function get_selectplus($specs, $value, $connect = null) {
  $htmltag = get_select($specs, $value, $connect);
  $htmltag .= '<input type="button"  class="formeZoombutton" name="btn_add_option2select" value="&nbsp;+&nbsp;" ';
  $htmltag .= "onClick=\"add_option2select(" . $specs["name"] . $specs["index_zoom"].", ";
  $htmltag .= "'" . addslashes($specs["prompt_msg"]) . "', ";
  $htmltag .= "'" . $specs["maxlen"] . "', ";
  $htmltag .= "'" . addslashes($specs["msg"]) . "')\" ";
  $htmltag .= $specs["html_attribut"] . " >";

  return $htmltag;
}
/*
 * absolute positionning will be made by javascript with the class name
 */
function get_selectedit($specs, $value, $formename, $connect = null){
  $selectname = "slc" . $specs["name"];
  $txtname = $specs["name"];
  $selectwidth = $specs["width"];
  $txtwidth = $specs["width"] - 20;
  
  $specs["width"] = $txtwidth;
  if ($specs["html_class"] == "")
    $specs["html_class"] = "inputboxselect";
  $specs["style"] = "border-right:0";
  if ($value === "") {
    if ($specs["defaut"] !== "")
      $value = $specs["defaut"];
    else {
      if ($specs["null"] != "O") {
        $option_list = array_keys(get_options($specs, $value, $connect)); 
        $value = $option_list[0];
      }
    }
  }
  $thetextbox = get_textbox($specs, $value);
  
  $specs["name"] = $selectname;
  $specs["width"] = $selectwidth;
  $specs["html_attribut"] = " onclick=\"" . ($specs["pick_listedit_jsonclick"] != "" ? $specs["pick_listedit_jsonclick"] . "; " : "") . "document.$formename.$txtname" . $specs["index_zoom"] . ".value=this.options[this.selectedIndex].value\" tabindex=\"1000\"";
  $specs["style"] = "clip:rect(0 $selectwidth auto $txtwidth)";
  $theselect = get_select($specs, $value, $connect);
  
  $htmltag = $thetextbox . $theselect . "<input type=\"text\" name=\"texte\" style=\"visibility:hidden;width:1\">";
  return $htmltag;
}

function get_textbox($specs, $value) {
  $html_type = "text";
  if (strtoupper($specs["html_type"]) == "PASSWORD" ||
    strtoupper($specs["html_type"]) == "PASSWORD_CONFIRM") {
    $html_type = "password";
  }

  $htmltag = '<input type="' . $html_type . '" name="'.$specs["name"].$specs["index_zoom"].'" '
    . '" id="id_'.$specs["name"].$specs["index_zoom"].'" ';
  $htmltag .= 'value="'.htmlspecialchars($value).'" maxlength="'.$specs["maxlen"].'" ';

  if ( is_netscape476() ) {
    $htmltag .= "size=\"" . floor($specs["width"] / 5) . '" ';
  } else {
    $htmltag .= 'style="width:'.$specs["width"]. ";" . $specs["style"].'" ';
  } 
  if ($specs["html_class"] != "")
    $htmltag .= 'class="'.$specs["html_class"].'" ';
  else
    $htmltag .= 'class="inputbox" ';
    
  $htmltag .= $specs["html_attribut"] . 
    (strtoupper($specs["html_type"]) == "CALENDAR" ?  " onFocus=\"if (this.value == '" . get_constant("CALENDAR_DISPLAY_MASK") . "') {this.value='';return false;}\" onblur=\"if (this.value == '') {this.value='" . get_constant("CALENDAR_DISPLAY_MASK") . "';} else {autoformat(this, 'shortdate');} \" ": "")  . ' >';
  return $htmltag;
}

function get_textboxdollar($specs, $value) {
  $htmltag = get_textbox($specs, $value);

  if ( is_netscape476() ) {
  // Forcer le '$' a apparaitre a droite du champ
    $dollarbefore = is_primary_language() ? "" : "<td>\$&nbsp;</td>";
    $dollarafter = is_primary_language() ? "<td>&nbsp;\$</td>" : "";
    $htmltag = "<table><tr>$dollarbefore<td>" . $htmltag . "</td>$dollarafter</tr></table>";
  } else {
    $htmltag = is_primary_language() ? $htmltag . "&nbsp;\$" : "\$&nbsp;" . $htmltag;
  }
  return $htmltag;
}

function get_textboxpourcentage($specs, $value) {
  $htmltag = get_textbox($specs, $value);

  // Forcer le '%' a apparaitre a droite du champ
  if ( is_netscape476() ) {
    $htmltag = "<table><tr><td>" . $htmltag . "</td><td>&nbsp;%</td></tr></table>";
  } else {
    $htmltag .= "&nbsp;%";
  }
  return $htmltag;
}

function get_textboxpassword($specs, $value) {
    return get_textbox($specs, "");
}

function get_textboxpassword_confirm($specs, $value) {
  $htmltag_pass = get_textbox($specs, "");

  $htmltag_conf = '<input type="PASSWORD" name="' . $specs['name'] . $specs['index_zoom'].'_confirm" class="inputbox" ';
  $htmltag_conf .= 'value="" maxlength="' . $specs['maxlen'] . '" ';
  $htmltag_conf .= 'style="width:'.$specs['width'].'" '.$specs['html_attribut'].' >';

  $htmltag = "<table border=0 cellpadding=0 cellspacing=0><tr><td>".$htmltag_pass."</td></tr>";
  $htmltag .= "<tr><td>".$htmltag_conf."</td></tr></table>";
  return $htmltag;
}

function get_textboxcalendar($specs, $value, $formename = "forme") {
  if ($value == "")
    $value = get_constant("CALENDAR_DISPLAY_MASK");
  $htmltag = get_textbox($specs, $value);
  if (file_exists(sget("forms_image_dir")."icon_calendar.gif"))
    $btvalue = " style=\"background-image: url(" . 
    sget("forms_image_dir") . "icon_calendar.gif);height: 19; width: 19;\" ";
  else
    $btvalue = " value=\"&nbsp;...&nbsp;\" ";
  $name = "bt_" . $specs['name'] . $specs['index_zoom'];
  $htmlbuton = "<input class=\"formeZoombutton\" type=\"BUTTON\" id=\"$name\" $btvalue" .
    "onClick=\"show_popup_calendar('$formename." . $specs['name'] .$specs['index_zoom']."', '" .
    get_language() . "', '" .
    $specs['mask'] . "', '" . sget("css_dir") . "', '" . sget("calendar_methode") . 
    "', document.$formename." . $specs['name'] .$specs['index_zoom'].".value" . 
    ($specs['calendar_alternate_initfield'] != "" ?  
    ",  document.$formename." . $specs['calendar_alternate_initfield'] .$specs['index_zoom'].".value" : "") .
    " );\" " . $specs['html_attribut'] . 
    " alt=\"Choisir une date\" tabindex=\"1000\">";
  if (is_konqueror()) {
    // pas de bouton, le calendrier ne fonctionne pas
    // Konqueror 2.1.1 ne peut ouvir une nouvelle fenetre sans URL
  } else {
    $htmltag .= $htmlbuton;
  }
  return $htmltag;
}


function get_js_script($fields_list, $htmlwindows_title = "", $htmlwindows_desc = "", $form_name = "forme", $buttontype = "") {
  $js_script = get_js_script_no_submit($fields_list, $form_name, $buttontype);
  return ($buttontype == "submit" ? $js_script : $js_script . " else { "  . $form_name . ".submit(); }");
}

function get_js_script_no_submit($fields_list, $form_name = "forme", $buttontype = "") {
  $js_script = "var msg = new Array();";
  $c = 0;
  if (is_array($fields_list)) {
  reset($fields_list);
  while ( list($index, $param) = each($fields_list) ) {
    // Si une validation est necessaire ou si le champ doit etre complte
    // et le champ est editable et visible
    if (($param["validation_type"] != "" || $param["null"] == "N") &&
            ($param["updatable"] == "O" && $param["visible"] == "O" && !$param["temphidden"])) {
      if ($param["validation_js"] != ""){
        $js_script .= $param["validation_js"];
        $js_script .= " { msg[".$c."] = '".addslashes($param["msg"])."\\n'; }";
        $js_script .= "\n";
        $c++;
      } else
        switch (strtoupper($param['html_type'])) {
        case "CALENDAR":
        case "TEXTBOX":
          $validation = ($param["nospace"] ? "nospace" : $param["validation_type"]);
          $js_script .= "if (!validate_textbox(document." . $form_name . ".elements['".$param["name"].$param['index_zoom']."'], ";
          $js_script .= "'".$validation."' ,";
          $js_script .= ($param["null"] == "O" ? "false" : "true" ) . ", '";
          $js_script .= $param["min"]."', '".$param["max"]."', '".$param["mask"]."') )";
          if ($param["msg_js"] != "")
            $js_script .= " { " . preg_replace("/\[lavariablec\]/", "[$c]" ,$param["msg_js"]) . "; }";
          else
            $js_script .= " { msg[".$c."] = '".addslashes($param["msg"])."\\n'; }";
          $js_script .= "\n";
          $c++;
          break;
        case "PASSWORD_CONFIRM": 
          $js_script .= "if (!validate_password_confirm(document." . $form_name . ".elements['".$param["name"].$param['index_zoom']."'], ";
          $js_script .= "document." . $form_name . ".elements['".$param["name"].$param['index_zoom']."_confirm'], ";
          $js_script .= ($param["null"] == "O" ? "false" : "true" );
          $js_script .= ", '".$param["mask"]."') ) ";
          $js_script .= "{ msg[".$c."] = '".addslashes($param["msg"])."\\n'; }";
          $js_script .= "\n";
          $c++;
          break;
        case "PASSWORD":
          break;
        case "RADIO":
          break;
        case "CHECKBOX":
          break;
        case "HIDDEN":
          break;
        case "SELECT":
          break;
        case  "SELECTPLUS":
        default:
          $js_script .= "if (!validate_textbox(document." . $form_name . ".elements['".$param["name"].$param['index_zoom']."'], ";
          $js_script .= "'".$param["validation_type"]."' ,";
          $js_script .= ($param["null"] == "O" ? "false" : "true" ) . ", '";
          $js_script .= $param["min"]."', '".$param["max"]."', '".$param["mask"]."') )";
          $js_script .= " { msg[".$c."] = '".addslashes($param["msg"])."\\n'; }";
          $js_script .= "\n";
          $c++;
        }
      }
    }
  }
  $js_script .= "if (msg.join('') != '') { htmlwindows('".$htmlwindows_title;
  $js_script .= "', '".$htmlwindows_desc."', msg); " 
    . ($buttontype == "submit" ? "return false;" : "") . "}";
  return $js_script;
}


function get_formbutton($fields_list, $button_title = "Sauvegarder", $size = "",
  $htmlwindows_title = "", $htmlwindows_desc = "", $buttontype = "") {
  $lehtml = "<input class=\"formeZoombutton\" type=\"" . ($buttontype == "" ? "BUTTON" : $buttontype) . "\" ";
  $lehtml .= (($size == "") ? "" : "style=\"width:$size\" ") . 'name="nom_du_bouton_soumettre" value="';
  $lehtml .= $button_title . '" onClick="' . get_js_script($fields_list, $htmlwindows_title, $htmlwindows_desc, "forme", $buttontype) . "\">";
  return $lehtml;
}

function get_deletebutton($str_url, $has_child_record, $button_title = "Supprim",
  $prompt_msg = "Etes vous certain?", 
  $prompt_msg_childs = "La desctruction de cet enregistrement causeras la destruction de d'autre.",
  $size = "") {

  if ($has_child_record) {
    $msg = $prompt_msg . "\\n" . $prompt_msg_childs;
  } else {
    $msg = $prompt_msg;
  }

  $str_html = '<input class="formeZoombutton" type="button" ';
  $str_html .= 'name="nom_du_bouton_supprimer" ';
  $str_html .= 'value="' . $button_title . '" ';
  $str_html .= (($size == "") ? "" : 'style="width:' . $size . '" ');
  $str_html .= "onclick=\"javascript:if (confirm('" . $msg . "')) {window.location='" . $str_url . "'}\" ";
  $str_html .= ">";

  return $str_html;
}
?>