<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * Module de validation php
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

function valid_value(&$field, $value) {
  if ($field["visible"] != "O" || $field['html_type'] == "hidden")
    $result = true;
  else
  if (isEmpty($value)) {
    $result = $field["null"] == "O";
  } else {
    switch (strtoupper($field["validation_type"])) {
    case "INTEGER":
      $result = is_numeric($value)
        && ($field["min"] != "" ? $value >= $field["min"] : true) 
        && ($field["max"] != "" ? $value <= $field["max"] : true);
      break;
    case "REAL":
      $result = ok_float($value) 
        && ($field["min"] != "" ? $value >= $field["min"] : true) 
        && ($field["max"] != "" ? $value <= $field["max"] : true);
      break;
    case "DATE":
    case "DATEYEAR":
    case "DATEYEARMONTH":
      $result = ok_date($value);
      break;
    case "TIME":
      $result = ok_time($value);
      break;
    case "EMAIL": 
      $result = email_valide($value);
      break;
    case "NOSPACE":
      $result = !preg_match("/\s+/", $value);
      break;
    case "DOLLAR":
      $result = ok_money($value);
      break;
    case "STRING":
      $result = $field["maxlen"] == -1 || strlen($value) <= $field["maxlen"];
      break;
    case "ARRAY":
      $result = $field["maxlen"] == -1 || strlen($value) <= $field["total_maxlen"];
      break;
    default :
      $result = true;
    }
  }
  return ($result ? "" : $field['msg' . get_suffix_langue()] . "<br>");
}


function isEmpty($value) {
  return (!isset($value) || trim($value) === "");
}

function ok_money($value) {
  return preg_match("/^(((\d{1,3}\s)(\d{3}\s)*\d{3}([.|,]\d{0,2})*)|((\d+)([.|,]\d{0,2})*))$/", 
     $value) || preg_match("/^(((\d{1,3}\,)(\d{3}\,)*\d{3}(\.\d{0,2})*)|((\d+)(\.\d{0,2})*))$/", 
     $value) ;
}

function ok_float($value) {
  return is_float($value) || is_numeric($value);
}

function ok_time($value) {
  return preg_match("/^'?(0?[0-9]|1[0-9]|2[0-3])[:\.]?(0[0-9]|[0-5]?[0-9])?'?$/", $value);
}

function ok_string($value) {
  $result = preg_match("/^'.*'$/", $value, $matches);
  if ($result) {
    $result = checkdate($matches[2], $matches[3], $matches[1]);
  }
  return $result;
}

function ok_date($value) {
  $result = preg_match("/^'?(\d{4})[\/\-](\d{2})[\/\-](\d{2})'?$/", $value, $matches);
  if ($result) {
    $result = checkdate($matches[2], $matches[3], $matches[1]);
  }
  return $result;
}

function email_valide($str_email) {
  return ereg("^.+@.+\\..+$", $str_email);
}


function email_alias_valide($val){
  $valide = true;
  if(!preg_match("/^[-a-zA-Z0-9_\.]+@[a-zA-Z0-9\-]+\.[a-zA-Z0-9\-\.]+$/", $val))
    return preg_match("/^[-a-zA-Z0-9\s]+<[-a-zA-Z0-9_\.]+@[a-zA-Z0-9\-]+\.[a-zA-Z0-9\-\.]+>$/", $val);
  return $valide;
}


?>