/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
//  ===========================================================================
//  Title:  form_validator.js
//  Author:	Les consultants interaction.
//  Date:   10 Janvier 2002
//  Version	Description
//  ------------------------------------------------------------------
//  1.0.0   Fonctions JavaScript pour la validation des formulaire
//          bas sur l'example FormChek.js fournit par Netscape.
//  1.1.0   is_email    Valide la syntaxte d'un adresse de courier
//  1.2.0   is_number   Valide si le parametre est un entier ou un rel
//          is_between  Valide si le parametre est compris dans un RANGE numerique
//  1.3.0   is_date     Valide si le parametre est une date valide
//  1.4.0   add_option2select Ajoute des options dans un input type="select"
//  1.5.0   is_money    Valide une valeur numerique avec seulement 2 decimales
//  1.5.1   add_option2select  Longueur maximale avec message d'avertissement
//  1.6.1   add_option2select  Retire les caractre 'espace' au debut et a la fin
//          trimAfter() trimBefore() trim()
//  1.7.0   is_valid_mask() peut recevoir plusieurs mask spar par un "|"
//  1.7.1   is_date()   YYYY doit etre suprieur a 999
//  1.8.0   swap_select_array() Remplace les options d'un select html
//  1.9.0   validate_password() validation d'un password et de son champ confirmation
//          password2reject()   Cherche le mot de passe dans une liste a rejet
//  1.10.0  is_date() peut trait un range de date
//  1.11.0  validate_password_confirm et validate_password
//  1.11.1  is_date() patch, retire le leading 0 dans le jour et le mois
// 	1.12.0	Si l'objet html n'existe pas la validation retourne true (validate_textbox)
//  ===========================================================================

/**
 * ja data validation library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

function validate_textbox(form_field, validation_type, is_require, val_min, val_max, mask) {
    //return true;
		if (typeof(form_field) == 'undefined') { return true; }
    if (form_field.disabled) { return true; }
    var val = form_field.value;
    if (isEmpty(val)) { return !is_require; }

    switch (validation_type.toUpperCase()) {
//**support time
        case "TIME":
            var tt = /^(0?[0-9]|1[0-9]|2[0-3])[:\.]?(0[0-9]|[0-5]?[0-9])?$/;
            if (generic_re_validation(val, new Array(tt))) { return true; }
        break;
        case "DATE":
            if (val == calendar_display_mask)  { return !is_require; }
            if (is_date(val, mask, val_min, val_max)) { return true; }
        break;
        case "DATEYEAR":
            if (is_date(val, mask, val_min, val_max)) { return true; }
        break;
        case "DATEYEARMONTH":
            if (is_date(val, mask, val_min, val_max)) { return true; }
        break;
        case "INTEGER":
            if (integer_re_validation(val, val_min, val_max)) { return true; }
        break;
        case "REAL":
            if (float3dec_re_validation(val, val_min, val_max)) { return true; }
        break;
        case "EMAIL":
            if (is_email(val)) { return true; }
        break;
        case "RANGE":
            if (integer_re_validation(val) || float_re_validation(val)) {
                if (is_between(val, val_min, val_max)) { return true; }
            }
        break;
        case "DOLLAR":
            if (is_money(val)) { return true; }
        break;
        case "ISBNISSN":
            return is_valid_ISBNISSN(val);
        break;
        case "NOSPACE":
            var tt = /\s+/;
            if (!generic_re_validation(val, new Array(tt))) { return true; }
        break;
        default:
            return true;
    } 
} 

function is_valid_ISBNISSN(val) {
  var tt = /^(d|r|n|p)*(\d|\-)*x?$/; 
  return generic_re_validation(val.toLowerCase(), new Array(tt));
}

function get_invalid_chars() {
  return new Array(/\#/, /\s+/, /\$/, /&/, /</, />/, /!/, /\//, /\\/, /\'/, /"/);
}

function validate_usager(field, is_require, mask) {
    var usager = field.value;
    if ((field.value.length < 1) ||
    		generic_re_validation(usager, get_invalid_chars())) { return false; }
    return true;
} 

function validate_reponse(field, is_require, mask) {
    var reponse = field.value;
    if ((field.value.length < 6) || 
    		generic_re_validation(reponse, get_invalid_chars())) { return false; }
    return true;
} 

function validate_password(field, is_require, mask) {
    var password = field.value;
    if (is_require && isEmpty(password)) { return false; }
    if ((password < 1)  ||
    		generic_re_validation(password, get_invalid_chars())) { return false; }
    // si le mot de passe doit etre rejet
    if ( password2reject(password) ) { return false; }
    return true;
} 


function validate_password_confirm(password_field, confirm_field, is_require, mask) {
    var password = password_field.value;

    if (is_require && isEmpty(password)) { return false; }

    // si le mot de passe doit etre rejet
    if ( password2reject(password) ) {
        return false;
    } else if ( password != confirm_field.value ) {
        return false;
    }
    return true;
}

function is_email(s) {
    var i = 0;
    var s_len = s.length;
    var flag_a = false;
    var flag_dot = false;
    var flag_espace = false;
    var flag_virgule = false;
    if ( s_len < 4 ) { return false; }

    while ( i < s_len ) { 
        // si on trouve un espace
        if (s.charAt(i) == " ") { return false; }
        // si on trouve une virgule
        if (s.charAt(i) == ",") { return false; }
        // si on trouve un deuxieme @
        if (s.charAt(i) == "@") {
            if (flag_a) { return false; }
            flag_a = true;
        }

        // s'il y as un point apres le @
        if ( (s.charAt(i) == ".") && (s.charAt(i-1) == "@") ) { return false; }
        // s'il y as deux point conscutif "adresse..reste@serveur.com"
        if ( (s.charAt(i) == ".") && (s.charAt(i-1) == ".") ) { return false; }
        // si le premier ou le dernier caractere est un "."
        if ( (s.charAt(i) == ".") && ((i == s_len-1) || (i == 0)) ) { return false; }

        i++

    }
    return true;
}


function is_between(str, min, max) {
    if ( ((str-0) >= (min-0)) && ((str-0) <= (max-0)) ) { return true; }
}


function is_date(str, mask, min, max) {
    if ( !is_valid_mask(str, mask) ) { return false; }

    y_index = mask.indexOf('YYYY');
    m_index = mask.indexOf('MM');
    d_index = mask.indexOf('DD');

    y_val = str.substring(y_index, y_index + 4);
    
    if (m_index > 0) {
      m_val = str.substring(m_index, m_index + 2);
    } else {
      m_val = "1";
    }
    
    if (d_index > 0) {
      d_val = str.substring(d_index, d_index + 2);
    } else {
      d_val = "1";
    }

    // retire les leading 0 dans la journee et le mois
    if (m_val.substring(0,1) == 0) { m_val = m_val.substring(1, m_val.length) }
    if (d_val.substring(0,1) == 0) { d_val = d_val.substring(1, d_val.length) }

    m_val = parseInt(m_val);
    d_val = parseInt(d_val);
    y_val = parseInt(y_val);

    if (m_val > 12 || m_val == 0) { return false; }
    if (d_val == 0) { return false; }
    if (y_val < 1000) { return false; }

    if (m_val == 1 ||
        m_val == 3 ||
        m_val == 5 ||
        m_val == 7 ||
        m_val == 10 ||
        m_val == 12) {
            if (d_val > 31) { return false; }
    }

    if (m_val == 4 ||
        m_val == 6 ||
        m_val == 9 ||
        m_val == 11) {
            if (d_val > 30) { return false; }
    }

    if (m_val == 2) {
        if (inLeapYear(y_val)) {
            if (d_val > 29) { return false; }
        } else {
            if (d_val > 28) { return false; }
        }
    }

    date_to_test = new Date(y_val, m_val-1, d_val);

    // YYYY/MM/DD
    if (min != "") {
        date_min = new Date(min.substring(0, 4),
                            (min.substring(5, 7) - 1),
                            min.substring(8, 10));
        if (date_min > date_to_test) { return false; }
    }
    if (max != "") {
        date_max = new Date(max.substring(0, 4),
                            (max.substring(5, 7) - 1),
                            max.substring(8, 10));
        if (date_max < date_to_test) { return false; }
    }

    return true;
}
/**
* why two time the same call
*/
function is_money(val2test) {
    if (!float_re_validation(val2test) && 
        !float_re_validation(val2test)) {
        return false;
    }
    return true;
} 

//------------------------------------------------------------------------
//  Retourne vraie si le mask est applicable
//  str     (La chaine de char a valide)
//  mask    (Les diffends mask a utiliss pour la validation
//          spar par "|" EX: "YYYY/MM/DD|YYYY-MM-DD")
//      - # (Un chiffre obligatoire)
//------------------------------------------------------------------------
function is_valid_mask(str, mask_list) {
    var mask_array = mask_list.split("|");
    // pour chaque mask a tester
    for (cnt=0; cnt<mask_array.length; cnt++) {
        var mask = mask_array[cnt];
        var is_valid = false;

        if (str.length == mask.length) {
            // pour chaque char du mask tester
            for (c=0; c<mask.length; c++) {
                if (mask.charAt(c) == '#' || mask.charAt(c) == 'M' ||
                        mask.charAt(c) == 'D' || mask.charAt(c) == 'Y') {
                    // chiffre obligatoire
                    if ( !parseInt(str.charAt(c)) && str.charAt(c) != '0' ) {
                        is_valid = false;
                        break;
                    } else {
                        is_valid = true;
                    }
                } else {
                    // caractere litral obligatoire
                    if ( mask.charAt(c) != str.charAt(c) ) {
                        is_valid = false;
                        break;
                    } else {
                        is_valid = true;
                    }
                }
            }
        }
        // Le premier mask valid termine le traitement
        if (is_valid) { return true; }
    }
    return false;
} 


//-----------------------------------------------------------------
//  Ajoute des options dans un <select>
//  select_field    (L'objet select qui recoit la valeur a ajout)
//  prompt_msg      (La question sur la fenetre popup)
//  maxlength       (La longueur maximal de la nouvelle option)
//  validation_msg  (Le message pour la validation de la longueur)
//-----------------------------------------------------------------
function add_option2select(select_field, prompt_msg, maxlength, validation_msg) {
    var result = prompt(prompt_msg, '');
    result = trim(result);
    if ( (result != '') && (result != null) ) {
        if (result.length > maxlength) {
            alert(validation_msg);
        } else {
            var sel_index = select_field.options.length;
            select_field.options[sel_index]=new Option(result, result);
            select_field.selectedIndex = sel_index;
        }
    }
}


//----------------------------------------------------------------
//  Remplace les option d'un select html
//  sel_field       (Le select a remplac)
//  sel_default     (La slection par default)
//  array2swap      (Le array a utilis pour le swap)
//----------------------------------------------------------------
function swap_select_array(sel_field, sel_default, array2swap) {
    var len = sel_field.length;
    for (i=0; i<len; i++) { sel_field.remove(0); }

    var default_index = 0;
    for (c=0; c<array2swap.length; c++) {
        var opt_array = array2swap[c].split("|");
        if ( opt_array[1] == sel_default ) {
            default_index = c;
        }
        sel_field.options[c] = new Option(opt_array[0], opt_array[1]);
    }
    sel_field.selectedIndex = default_index;
}



// ------------------- HELPER ---------------------------

// Retourne TRUE si le parametre est un chiffre (0 a 9)
function isDigit(c) {
    return ((c >= "0") && (c <= "9"));
}

// Retourne TRUE si le parametre s est vide ou constit d'espace.
function isEmpty(s) {
    if ((s == null) || (s.length == 0)) {
        return true;
    } else {
        var is_valid_char = true;
        for (i = 0; i < s.length; i++) {
            var c = s.charAt(i);
            if ( c != " " ) {
                is_valid_char = false;
            }
        }
        return is_valid_char;
    }
}

function inLeapYear(aYear) {
    if((aYear % 4) != 0) { return false; }

    if(((aYear % 100) != 0) || ((aYear % 400) == 0)) {
        return true;
    }
    return false;
}

// Retire les espaces au dbut d'une chaine de charactere
function trimBefore(str) {
  if (str == null) { return null; }
    for (c=0; c<str.length; c++) {
        if ( str.charAt(c) != " " ) {
            return str.substring(c);
        }
    }
    if (c == str.length) { return ""; }
} 

// Retire les espaces a la fin d'une chaine de charactere
function trimAfter(str) {
  if (str == null) { return null; }
    for (c=str.length; c>0; c--) {
        if ( str.charAt(c-1) != " " ) {
            return str.substring(0, c);
        }
    }
    if (c == str.length) { return ""; }
}

// Retire les espaces au dbut et a la fin
function trim(str) {
    return trimBefore( trimAfter(str) );
}
/**
* @todo test and put back in production
*/
// Retourne true si le password doit etre rejet
function password2reject(password) {
    /*var pass_array = new Array("root", "bin", "daemon", "adm", "lp", "sync",
                            "shutdown", "halt", "mail", "uucp", "operator",
                            "games", "mysql", "httpd", "nobody", "dummy",
                            "www", "cvs", "shell", "ftp", "irc", "debian",
                            "ns", "download");

    for (c=0; c<pass_array.length; c++) {
        if (pass_array[c] == password) { return true; }
    }
    return false;*/
}