<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * custum error handler library
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */      
if (!is_development_server()) {
  error_reporting(0); 
  set_error_handler("customErrorHandler");
}

function customErrorHandler ($errno, $errmsg, $filename, $linenum, $vars) {
	$time = date("d M Y H:i:s");

	// Get the error type from the error number 
	$errortype = array (
			1 =>  	"Error",
			2 =>  	"Warning",
			4 =>  	"Parsing Error",
			8 =>  	"Notice",
			16 => 	"Core Error",
			32 => 	"Core Warning",
			64 => 	"Compile Error",
			128 => 	"Compile Warning",
			256 => 	"User Error",
			512 => 	"User Warning",
			1024=> 	"User Notice");
	$errlevel = $errortype[$errno];
 
	$GLOBALS['numero_erreur'] = $errno;

	$template_error = read_template(filename_with_path("lib/error_html.dat"));
	// Information sur l'erreur
	$template_error = str_replace("::DATE::",$time,$template_error);
	$template_error = str_replace("::MESSAGE::",$errmsg,$template_error);
	$template_error = str_replace("::FILENAME::",$filename,$template_error);
	$template_error = str_replace("::LIGNE::",$linenum,$template_error);
	$template_error = str_replace("::LEVEL::",$errlevel,$template_error);

	// Variables d'environnement Server Apache
    $template_error = str_replace("::SERVER_VARIABLES::",
                                build_variables_list($_SERVER),
                                $template_error); 
  
	// Variables POST
	$template_error = str_replace("::POST_VARIABLES::",
                                "",
                                $template_error);
	// Variables GET	
	$template_error = str_replace("::GET_VARIABLES::",
                                build_variables_list($_GET),
                                $template_error);	
	
	// dtection client
	$template_error = str_replace("::NAVIGATOR::",get_browserkind()." ".get_browserversion(),$template_error);
	$template_error = str_replace("::SYSTEME::",get_system(),$template_error);
	$template_error = str_replace("::USER::",get_cargo("user_name"),$template_error);

	if($errno != 8 && $errno != 2) {
    copin_include("lib/mime");
		send_mail(get_constant("MACHINE_NAME"), get_constant("MACHINE_NAME"), "Groupe Erreur", get_constant("WEBERROR"), 
               "Erreur [".time()."] sur ".getenv("SERVER_NAME"), $template_error, 0, "HTML");
	}
}

/**
* Construit les informations d'une liste de variables
* pour la dtection d'erreurs
*/
function build_variables_list($variables) {
	$i=0;
  while (list ($key, $val) = each ($variables)) {
    if(!strstr($key,"SSL")){
 		  if($i%2 != 0)
        $tmpl .= "<tr><td class=\"bleu\">$key</td><td class=\"bleu\">$val </td></tr>\n";
 	    else
        $tmpl .= "<tr><td class=\"blanc\">$key</td><td class=\"blanc\">$val </td></tr>\n";
    }
    $i++;
  }
	return $tmpl;
}
?>