<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * interface with postgres database
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */                        
/*
  db.php : gestion de l'interface avec la bd
  Les consultants interaction

-  Ajout de selectsql_type
-  Test de la prsence d'un seul enregistrement ou vide
-  Ajout de std_type, isnumber, isstring
-  wrap_re_accent() Traitement des caractres accentus pour SQL
-  getdb() Utilise les parametre de locald pour la connection
-  patch wrap_re_accent() Traitement du 
-  wrap_re_char  remplace aussi sanitize
-  Remplace les caracteres accentu par une expression rguliere
-  valide pour la clause WHERE nomduchamp ~* wrap_re_char("param")

-  2004/12/3 jjg - nouvelle fonction log_db
                 - envoyer les email de log a WEBMASTER
*/
// ces constantes permettent aux objet de savoir quel type d'erreur est gnre pour ragir selon le cas
define("PRECOMPILATIONERREUR", -1);
define("ERREUR", -2);
define("DUPLICATEKEY", -3);
define("USER_ERROR", -4);
define("FOREIGNKEY", -5);

function wrap_re_char($str2replace) {
    $patterns = array(
                    "/[aA]/",
                    "/[eE]/",
                    "/[iI]/",
                    "/[oO]/",
                    "/[uU]/",
                    "/[cC]/"
                    );
    $replace = array(
                    "[a]",
                    "[e]",
                    "[i]",
                    "[o]",
                    "[u]",
                    "[c]"
                    );

    $str2replace = preg_replace('/["\(\)\[\]\!\\\<>,.\^\$\/]/', " ", $str2replace);
    $str2replace = preg_replace("/'/", " ", $str2replace);

    return preg_replace($patterns, $replace, trim($str2replace));
} 

//--------------------------------------------------------
// Permet de doubler les simples guillemets dans le cas
// de requete a la bd.
//--------------------------------------------------------
function wrap($data) {
  if (is_string($data) ) {
    return "'" . pg_escape_string($data) . "'";
  } else {
    return $data;
  }
}

//--------------------------------------------------------
// Permet de doubler les simples guillemets dans le cas
// de requete a la bd.
// force le type de donne
// basetype => btString, btNumeric, btDate
//--------------------------------------------------------
function wrapdata($data, $basetype, $permitnull = "O"){
  $basetype = std_type(strtolower($basetype));
  switch (std_type($basetype)) {
    case "datetime" :
    case "time" :
    case "string" :
      if($data == ""){
        if($permitnull == "O")
          $data = "NULL";
        else
          $data = "''''";
      } else{
        $data = "'" . pg_escape_string($data) . "'"; 
      }
      break;
    case "real" :
      $data = preg_replace("/ /", "", $data);
      if ($data == "") {
        if ($permitnull == "N")
          $data = 0.00;
        else
          $data = "NULL";
      }
      break;
    case "integer" :
      $data = preg_replace("/ /", "", $data);
      if ($data == "") {
        if ($permitnull == "N")
          $data = 0;
        else
          $data = "NULL";
      }
      break;
  }
  return $data;
}


//--------------------------------------------------------
// Permet de changer les caracteres '%' par des '*' et
// les caracteres '_' pour '$'
//--------------------------------------------------------
function StandardLike($data){
  return  str_replace("*", "%", str_replace("$", "_", $data));
}

function getdb($connect = null) {
    static $dbs;
    if (!isset($connect)) {
      $connect = get_constant("DATABASE");
    }
    if (!isset($dbs[$connect])) {
      $dbs[$connect] = pg_pconnect($connect);
      if (!$dbs[$connect]) {
        echo get_constant("HORS_SERVICE_ACTION");
      }
    }
    return $dbs[$connect];
}

function is_duplicatekey($msg) {
  return preg_match("/duplicate key/i", $msg);
}

function is_foreignkey($msg){
  return preg_match("/foreign key constraint/i", $msg);
}

function is_user_error($msg) {
  return preg_match("/user_error/i", $msg);
}

function analyse_error($msg){
  if (is_duplicatekey($msg)) {
    $errornumber = DUPLICATEKEY;
  } elseif (is_foreignkey($msg)) {
    $errornumber = FOREIGNKEY;
  } elseif (is_user_error($msg)) {
    $errornumber = USER_ERROR;
  } else {
    $errornumber = ERREUR;
  }  
  return $errornumber;
}

function log_message($msg, $sql, $crypt){
   $error = get_constant("MACHINE_NAME") . " - " . date("Y/m/j  H:i:s") ."\n " . crypt_str($msg,'E') ."<br>";
   if($crypt)
     $error .= crypt_str($sql, 'E') . "<br>";
   else
     $error .= $sql . "<br>";
   
   $error.= "<a href=\"http://outils_php.interaction.lan/decryptmd5.php\">decrypter</a>";
   return $error;
}

function log_db(&$db, &$rs, $sql) {
  $msg = pg_last_error($db);
  if ($msg == "") {
	  $msg = pg_last_oid($rs);
    if (get_constant("DEBUG_FILE") && (get_constant("DEBUG_DATABASE") == 2)) 
      error_log("ok - " . date("Y/m/j H:i:s") . " " .$sql . "\n", 3, get_constant("DEBUG_FILE"));
  } else {
    // utilis par get_error_message
    sset("user_error_msg", $msg);
    $error_code = analyse_error($msg);
    if (get_constant("DEBUG_DATABASE") > 0) {
      if (get_constant("DEBUG_FILE")) {
        error_log("=> " . date("Y/m/j H:i:s") ." - " . $msg . "=> " . $sql . "\n", 3, get_constant("DEBUG_FILE"));
      } else {
	   	  switch ($error_code) {
				  case DUPLICATEKEY :
				  case FOREIGNKEY :
		        break;
				  case USER_ERROR :
				    customErrorHandler (256, "user error  - " . log_message($msg, $sql, 1), __FILE__, __LINE__, $vars);
	   				break;
	  			default: 
	  				customErrorHandler (256, log_message($msg, $sql, 1), __FILE__, __LINE__, $vars);
				  }
			 }
   	}
   	return $error_code;
  }
  return $msg;
}

// Execute une requete SQL et retourne l erreur s il y en a
function execsql($sql, $connect = null) {
  $db = getdb($connect);
  $rs = pg_query($db, $sql);
  return log_db($db, $rs, $sql);
}

// Execute une requete SQL et retourne le row_affected 
function execsql_affected($sql, $connect = null) {
  $db = getdb($connect);
  $rs = pg_query($db, $sql);
  $result = log_db($db, $rs, $sql);
  if ($result >= 0) {
    $result = pg_affected_rows($rs);
  }
  return $result;
}

// Retourne un array contenant le resultat de la requete
// avec l index et le nom du champ.
function selectsql($sql, $connect = null) {
  return selectsql_type($sql, PGSQL_ASSOC, $connect) ;
}

// Retourne vrai si la vue existe dans la bd
function view_exists($table_name, $connect = null) {
  if (preg_match("/(.*\.)(.*)/", $table_name, $matches)) {
    $schema = $matches[1];
    $table = $matches[2];
  } else {
    $schema = "";
    $table = $table_name;
  }
  return selectsql("select 1 where exists (select 1 from " 
    . $schema . "v_data_dictionary where table_name = '$table')", $connect) == 1;
    
}

// Retourne un array contenant le resultat de la requete
// $sql         Requete SQL SELECT
// $result_type PGSQL_ASSOC (le nom du champ est l index)
//              PGSQL_NUM,  (le numero du champ est l index)
//              PGSQL_BOTH  (le nom et le numero du champ est l index)
function selectsql_type($sql, $result_type, $connect = null) {

  $db = getdb($connect);
  $rs = pg_query($db, $sql);

  log_db($db, $rs, $sql);  
  if($rs !== FALSE){
    $nf = pg_num_fields($rs);
    $nr = pg_num_rows($rs);
    if (($nr == 1) and ($nf == 1)) {
       $r = pg_fetch_row($rs, 0);
       $r = $r[0];
    }
    else {
      for ($i = 0 ; $i < $nr ; $i++) {
        $r[$i] = pg_fetch_array($rs, $i, $result_type);
      }
    }
  } else{
    $nf = 0;
    $nr = 0;
    $r = "";
  }
  return $r;
  
}



function std_type($dbtype) {
    switch ($dbtype) {
        case "int":
        case "int2":
        case "int4":
        case "bigint":
        case "smallint":
        case "integer":
            $std_type = "integer";
            break;

        case "date":
        case "datetime":
        case "timestamp":
        case "timestamptz":
            $std_type = "datetime";
            break;
//**support time
        case "time":
        case "interval":
            $std_type = "time";
            break;

        case "double":
        case "numeric":
        case "real":
            $std_type = "real";
            break;

        case "varchar":
        case "bpchar":
        case "char":
        case "text":
        case "caracter":
        case "_timestamptz":
        case "_varchar":
        case "timestamptz[]":
        case "varchar[]":
            $std_type = "string";
            break ;

        default:
            $std_type = $dbtype;
    }
    return $std_type;
}

/**
* Verifier que c'est un type numeric
*/
function isnumber($dbtype) {
    $result = false ;
    switch (std_type($dbtype)) {
        case "real":
            $result = true;
            break;
        case "integer":
            $result = true;
            break;
        case "string":
            $result = false;
            break;
    }
    return $result;
}

/**
* Verifier que c'est un type chaine de caracteres
*/
function isstring($dbtype) {
    $result = false ;
    switch (std_type($dbtype)) {
        case "real":
            $result = false;
            break;
        case "integer":
            $result = false;
            break;
        case "string":
            $result = true;
            break;
    }
    return $result;
}

// Vrifie la prsence du message derreur suivant
// ERROR: Cannot insert a duplicate key into unique index usager_pkey
// Retourne "" sil ny as pas derreur ou le nom du champ en erreur
function is_valid_key($shema, $connect = null) {
  $field_name = "";
  $error = pg_last_error( getdb($connect) );
  
  if (is_duplicatekey($error)) { 
    preg_match("/\"(\w+)\"$/", $error, $index_name);
    $field_name = SelectSql("select field_name from " . $shema . "v_index_dictionary where index_name = '" . $index_name[1] . "' limit 1");
  }
  return $field_name;
}

/**
* Dbuter une transaction
*/
function begin_transaction(){
  execsql("BEGIN");
}

/**
* Conclure une transaction
* 16/06//2004
*/
function commit_transaction(){
  execsql("COMMIT");
}

/**
* Rollback pour une transaction qui n'a pas fonctionne
* on revient en arriere pour remettre la BD comme avant l'execution du sql
* 16/06//2004
*/
function rollback_transaction(){
  execsql("ROLLBACK");
}

/**
* Execution de la transaction SQL
*/
function execute_within_transaction($sql){
  $db = getdb(); 
  $rs = pg_query($db, $sql) or die(rollback_transaction());

  log_db($db, $rs, $sql);
  
  if($rs !== FALSE){
    $nf = pg_num_fields($rs);
    $nr = pg_num_rows($rs);
    if (($nr == 1) and ($nf == 1)) {
       $r = pg_fetch_row($rs, 0);
       $r = $r[0];
    }
    else {
      for ($i = 0 ; $i < $nr ; $i++) {
        $r[$i] = pg_fetch_array($rs, $i, $result_type);
      }
    }
  } else{
    $nf = 0;
    $nr = 0;
    $r = "";
  }
  return $r;
}
?>