<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * vCalendar class
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
copin_include("lib/pgarrays");
/**
 * vCalendar class
 * 
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class vBase {
  var $container;
  var $original_string;
  
  function vBase($v_string = null){
    if (isset($v_string)) {
      $this->orgininal_string = $v_string;
      $this->parse($v_string);
    }
  }
  
  function update($v_string){
    $this->parse($v_string);
    // il faudrait modifier le orginal_string aussi
  }
  
  function parse($v_string) {
    $a = preg_split("/\n/", $v_string);
    foreach ($a as $line) {
      if (preg_match("/(^[^:]+):(.*)/",$line, $larray)) {
        $variable = $larray[1];
        $value = $larray[2];
        if (preg_match("/^(BEGIN|END)/", $variable)) {
          continue;
        } elseif (preg_match("/^(.*);ENCODING=QUOTED-PRINTABLE/", $variable, $larray)) {
             // question aux gars d'interaction !
             // dans le cas d'une variable ENCODING=QUOTED-PRINTABLE devrions nous garder seulement 
             // en format dcod, seulement en format cod telle qu' l'origine et dcod seulement  la
             // demande grace  la fonction v_value.  Votre opinion serait intressante.  Pour l'instant
             // je stoke la varible en format cod et dcod 
             // JJG
          $this->container[$larray[1]] = quoted_printable_decode($value);
        }
        $this->container[$variable] = $value;
      }
    }
  }
  
  /**
  *
  */
  function php2v($val = "", $type = "string"){
    $type = strtolower($type);  
    switch($type){
      case 'date':
        $val = $this->php2v_date($val);
      break;
      case 'datetime':
        $val = $this->php2datetime($val);
      break;
      case 'integer':
        $val = $this->php2v_integer($val);
      break;
      case 'float':
        $val = $this->php2v_float($val);
      break;
      case 'boolean':
        $val = $this->php2v_boolean($val);
      break;
      default:
      break;
    }
    return $val;
  }
  
  /**
  * Format retourn :
  * - YYYYMMDD
  
  $session = "m/d/Y"
  01/03/2004
  
  $ar[m] = 01;
  $ar[]
  */
  function php2v_date($val){
    if (strtoupper($val) != strtoupper(get_constant("CALENDAR_DISPLAY_MASK"))) {
	    $d_pattern = "Y/d/m";
	    $separator = '/[\-|\/]/';   
	    /*
	    preg_match($separator, $d_pattern, $ar);
	    $t_pattern = explode($ar[0], $d_pattern);
	    $t_val = explode($ar[0], $val);
	    
	    for($i=0;$i<count($t_pattern);$i++){
	      $t_date[$t_pattern[$i]] = $t_val[$i];
	    }
	  
	    return date('Ymd', mktime(0, 0, 0, $t_date['m'], $t_date['d'], $t_date['y']));
	    */
	    $ar = preg_split("/\-|\//", $val); 
	    $vdate = $ar[0] . $ar[1] . $ar[2] . "T000000Z";
	  }
    return $vdate;
  }
  function php2v_datetime($val){
    $d_pattern = array(".", "/", "-");
    $t_pattern = array(":");
    
    return $year."".$month."/".$day.":".$hour.":";
  }
  function php2v_integer($val){
  }
  function php2v_boolean($val){
  }
  function php2v_float($val){ 
  }
  function php2v_string($val){
  }

  /**
  *
  */
  function v2php($val = "", $type = "string"){
    $type = strtolower($type);  
    switch($type){
      case 'date':
        $val = $this->v2php_date($val);
      break;
      case 'datetime':
        $val = $this->v2php_datetime($val);
      break;
      case 'integer':
        $val = $this->v2php_integer($val);
      break;
      case 'float':
        $val = $this->v2php_float($val);
      break;
      case 'boolean':
        $val = $this->v2php_boolean($val);
      break;
      default:
      break;
    }
    return $val;
  }

  function v2php_date($val){
    preg_match("/^(\d{4})(\d{2})(\d{2})/", $val, $matches);
    return $val != "" ? $matches[1] . "/" . $matches[2] . "/"  . $matches[3] : "";
  }
  function v2php_datetime($val){
  }
  function v2php_integer($val){
  }
  function v2php_float($val){
  }
  function v2php_boolean($val){ 
  }
 
  function show() {
    echo "<pre> ";
    print_r($this->container);
    "</pre>";  
  }
   
  function v_value($field_name) {
    return $this->container[$field_name];
  }
}
   
class vCalendar extends vBase {
  /*var $rrule; rgle de rptition
  var $exdate;   date d exceptions, tableau de date
 
	    la rgle contient chacun des champs spars
	     W2 TU TH o
	    $this->rrule["frequency"] = "";  W (D, W, M, Y)
	    $this->rrule["frequency_type"] = "";  non present ici (P by-position, D by-day, utilis pour le mois)
	    $this->rrule["interval"] = "";   2 (chiffre,  tous les 2 semaines)
	    $this->rrule["frequency_modifiers"] = "";   TU TH (jours et chiffre )
	    $this->rrule["duration"] = "";   (nombre d occurrence)
	    $this->rrule["enddate"] = "";   (date de fin)
	  }*/
  var $rfields = array (
    "enable",
    "frequency",
    "interval",
    "ending_type", 
    "duration", 
    "enddate",
    /* week */
    "wSU",
    "wMO",
    "wTU",
    "wWE",
    "wTH",
    "wFR",
    "wSA",
    /* month */
    "mtype",
    "mday_number",
    "moccurence",
    "mweekday",
    /* year */
    "ytype",
    "ymonth",
    "yday");
  function vCalendar($v_string = null) {
    $this->vBase($v_string);
    $this->month_array_numbers = $this->get_array_numbers(31);
    $this->array_occurence = get_str("array_moccurence", "vCalendar");
    $this->array_weekday = get_str("array_weekday", "vCalendar");
    
	    $this->frequency_type = array("D" => get_str("lbl_interval_day" , "vCalendar"), 
	      "W" => get_str("lbl_interval_week" , "vCalendar"),
	      "M" => get_str("lbl_interval_month" , "vCalendar"), 
	      "Y" => get_str("lbl_interval_year" , "vCalendar"));
  }
  
  /*
  *  rrule
  */
  
  function get_clear_rrule() {
	  $rrule["string"] = "";
	  $rrule["enable"] = "0";
	  $rrule["frequency"] = "";
	  $rrule["frequency_type"] = "";
	  $rrule["interval"] = "1";
	  $rrule["frequency_modifiers"] = "";
	  $rrule["duration"] = "";
	  $rrule["enddate"] = "";
    return $rrule;
  }
  
  function split_rrule() {
    $therule = strtoupper($this->container["RRULE"]);
    if ($therule != "") {
	    $frequency = substr($therule, 0, 1);
	    switch($frequency){
	      case 'D':
	        $rrule = $this->split_daily_rrule($therule);
	      break;
	      case 'W':
	        $rrule = $this->split_weekly_rrule($therule);
	      break;
	      case 'M':
	        $rrule = $this->split_monthly_rrule($therule);
	      break;
	      case 'Y':
	        $rrule = $this->split_yearly_rrule($therule);
	      break;
	      default:
	      break;
	    }
		  $rrule["string"] = $therule;
	    if (preg_match("/[.^\s]*\s(.*)\s(.*)/", $therule, $matches)) {
			  $duration = $matches[2];
			} elseif (preg_match("/[.^\s]*\s(.*)/", $therule, $matches)) {
			  $duration = $matches[1];
			}
			if ($duration != "#0") {
				if (preg_match("/#(\d*)/", $duration, $matches))
				  $rrule["duration"] = $matches[1];
				else
				  $rrule["enddate"] = $this->v2php_date($duration);
			}
	    $rrule["ending_type"] = $rrule["enddate"] != "" ? "enddate" : 
	      ($rrule["duration"] != "" ? "nb_occurence" : "forever");
	  } else {
      $rrule = $this->get_clear_rrule();
	  }
    return $rrule;
  }
  
  function split_daily_rrule($therule) {
    $rrule = $this->get_clear_rrule();
    $rrule["frequency"] = substr($therule, 0, 1);
    $rrule["interval"] = substr($therule, 1, strpos($therule, " ") -1);
    return $rrule;
  }
  function split_weekly_rrule($therule) {
    $rrule = $this->get_clear_rrule();
    $rrule["frequency"] = substr($therule, 0, 1);
    $rrule["interval"] = substr($therule, 1, strpos($therule, " ") -1);
    if (preg_match("/[.^\s]*\s(.*)\s(.*)/", $therule, $matches)) {
		  $rrule["frequency_modifiers"] = $matches[1];
		  if (strpos($rrule["frequency_modifiers"], "SU") !== false)
        $rrule["wSU"] = 1;
		  if (strpos($rrule["frequency_modifiers"], "MO") !== false)
        $rrule["wMO"] = 1;
		  if (strpos($rrule["frequency_modifiers"], "TU") !== false)
        $rrule["wTU"] = 1;
		  if (strpos($rrule["frequency_modifiers"], "WE") !== false)
        $rrule["wWE"] = 1;
		  if (strpos($rrule["frequency_modifiers"], "TH") !== false)
        $rrule["wTH"] = 1;
		  if (strpos($rrule["frequency_modifiers"], "FR") !== false)
        $rrule["wFR"] = 1;
		  if (strpos($rrule["frequency_modifiers"], "SA") !== false)
        $rrule["wSA"] = 1;
        
		}
    return $rrule;
  }
  function split_monthly_rrule($therule) {
    $rrule = $this->get_clear_rrule();
    $rrule["frequency"] = substr($therule, 0, 1);
	  $rrule["frequency_type"] = substr($therule, 1, 1);
	  $rrule["mtype"] = $rrule["frequency_type"];
    $rrule["interval"] = substr($therule, 2, strpos($therule, " ") -2);
    if (preg_match("/[.^\s]*\s(.*)\s(.*)/", $therule, $matches)) {
		  $rrule["frequency_modifiers"] = $matches[1];
      if ($rrule["mtype"] == "D") { 
        $rrule["mday_number"] = $rrule["frequency_modifiers"];
      } else {
        preg_match("/(.*)\s(.*)/", $rrule["frequency_modifiers"], $matches);
        $rrule["moccurence"] = $matches[1];
        $rrule["mweekday"] = $matches[2];
      }
		}
    return $rrule;
  }
  function split_yearly_rrule($therule) {
    $rrule = $this->get_clear_rrule();
    $rrule["frequency"] = substr($therule, 0, 1);
	  $rrule["frequency_type"] = substr($therule, 1, 1);
	  $rrule["ytype"] = $rrule["frequency_type"];
    $rrule["interval"] = substr($therule, 2, strpos($therule, " ") -2);
    if (preg_match("/[.^\s]*\s(.*)\s(.*)/", $therule, $matches)) {
		  $rrule["frequency_modifiers"] = $matches[1];
      if ($rrule["ytype"] == "M") {
        $rrule["ymonth"] = $rrule["frequency_modifiers"];
      }  else {
        $rrule["yday"] = $rrule["frequency_modifiers"];
      }
		}
    return $rrule;
  }
  
  
  function update_rrule($therules) {
    $this->parse($therules);
    $vrule = "RRULE:";
    if (is_array($therules)) {
      if ($therules["enable"] == 1) {
        $vrule .= $therules["frequency"]
          . ($therules["frequency"] == "M" ? $therules["mtype"]
             : ($therules["frequency"] == "Y" ? $therules["ytype"] : ""))
          . $therules["interval"]
      . " " . $this->get_frequency_modifiers($therules) 
      . " " . ($therules["ending_type"] == "forever" ? "#0" :
        ($therules["ending_type"] == "nb_occurence" ?  "#" . $therules["duration"] : $this->php2v_date($therules["enddate"])));
      }
    } else {
      $vrule .= $therules;
    }
    $this->update($vrule);
  }
  function get_frequency_modifiers($rrule){
    if ($rrule["frequency"] == "W") {
      if ($rrule["wSU"])
        $frequency_modifiers .= "SU";
      if ($rrule["wMO"])
        $frequency_modifiers .= " MO";
      if ($rrule["wTU"])
        $frequency_modifiers .= " TU";
      if ($rrule["wWE"])
        $frequency_modifiers .= " WE";
      if ($rrule["wTH"])
        $frequency_modifiers .= " TH";
      if ($rrule["wFR"])
        $frequency_modifiers .= " FR";
      if ($rrule["wSA"])
        $frequency_modifiers .= " SA";
    } elseif ($rrule["frequency"] == "M") {
      if ($rrule["mtype"] == "D") {
        $frequency_modifiers = $rrule["mday_number"];
      } else {
        $frequency_modifiers = $rrule["moccurence"] . " " . $rrule["mweekday"];
      }
    } elseif ($rrule["frequency"] == "Y") {
      if ($rrule["ytype"] == "M") {
        $frequency_modifiers =  $rrule["ymonth"];
      } else {
        $frequency_modifiers = $rrule["yday"];
      }
    }
    return trim($frequency_modifiers);
  }
  
  function get_rrule() {
    return $this->container["RRULE"];
  }
  
  function vcal2verbose_rrule($therrule){
    if ($therrule != "") {
	    $this->update_rrule($therrule);
	    $rrule = $this->split_rrule();
	    $verbose = preg_replace("/\:\:toussub\:\:/", $rrule["frequency"] == "W" ? "te" : "", 
	       get_str("v_interval", "vCalendar")). "<b>" . ($rrule["interval"] > 1 ? $rrule["interval"] : "") 
	      . " " . $this->frequency_type[$rrule["frequency"]] 
	      . "</b>." . $this->get_verbose_modifiers($rrule)
	      . "<br>" . $this->get_verbose_ending($rrule) ;
    }
    return $verbose;
  }
  function get_verbose_ending($rrule) {
	  if ($rrule["ending_type"] == "forever")
	    $verbose_ending = "<b>" . get_str("v_noending", "vCalendar") . "</b>";
	  elseif ($rrule["ending_type"] == "nb_occurence")
	    $verbose_ending = sprintf(get_str("v_nboccurrence", "vCalendar"), 
	      $rrule["duration"], get_str("vsuboccurrence". ($rrule["duration"] > 1 ? "s" : "")) ) ;
	  else
	    $verbose_ending = sprintf(get_str("v_endate", "vCalendar"), $rrule["enddate"]);
	  return $verbose_ending . ".";
  }
  function get_verbose_modifiers($rrule) {
    if ($rrule["frequency"] == "W") {
      if ($rrule["wSU"])
        $arrayjours[0] = get_day_of_week_name(0) . "s";
      if ($rrule["wMO"])
        $arrayjours[1] =  get_day_of_week_name(1) . "s";
      if ($rrule["wTU"])
        $arrayjours[2] =  get_day_of_week_name(2) . "s";
      if ($rrule["wWE"])
        $arrayjours[3] =  get_day_of_week_name(3) . "s";
      if ($rrule["wTH"])
        $arrayjours[4] =  get_day_of_week_name(4) . "s";
      if ($rrule["wFR"])
        $arrayjours[5] =  get_day_of_week_name(5) . "s";
      if ($rrule["wSA"])
        $arrayjours[6] =  get_day_of_week_name(6) . "s";
        if (count($arrayjours) > 0)
          $verbose_modifiers = "<br>" . get_str("v_les", "vCalendar") . "<b>" . implode(", ", $arrayjours) . "</b>.";
    } elseif ($rrule["frequency"] == "M") {
      if ($rrule["mtype"] == "D") {
        $verbose_modifiers = "<br>" . sprintf(get_str("v_jour", "vCalendar"), $rrule["mday_number"] . "<sup>" . $this->get_th($rrule["mday_number"]). "</sup>") ;
      } else {
        $verbose_modifiers = "<br>" . get_str("v_le", "vCalendar") . "<b>" 
        . $this->array_occurence[$rrule["moccurence"]] . " " . $this->array_weekday[$rrule["mweekday"]] . "</b>.";
      }
    } elseif ($rrule["frequency"] == "Y") {
      if ($rrule["ytype"] == "M") {
        $verbose_modifiers = "<br>" . get_str("v_le", "vCalendar") . "<b>" . (0+substr($this->container["DTSTART"], 6, 2))
          . " " . translate_month($rrule["ymonth"]) . "</b>.";
      } else {
        $verbose_modifiers = "<br>" . sprintf(get_str("v_yjour", "vCalendar"), $rrule["yday"] . "<sup>" . $this->get_th($rrule["yday"]). "</sup>");
      }
    }
	  return ($verbose_modifiers != "" ? $verbose_modifiers : "");
  }
  function vcal2verbose_exceptions($exceptions) {
    if ($exceptions != "") {
	    $theexceptions = asql2aphp($exceptions);
	    while (list($index, $subarray) = each($theexceptions)) 
	      $theexceptions[$index] = preg_replace("/-/", "/", substr($subarray, 0, 10));
	    if (count($theexceptions) > 1)
  	    $verbose_exceptions = get_str("v_exceptes", "vCalendar") 
  	      . "<b>" . implode(", ", $theexceptions);
  	  else
  	    $verbose_exceptions = get_str("v_excepte", "vCalendar") 
  	      . "<b>" . $theexceptions[0];
    }
    return $verbose_exceptions != "" ? "<br>" . $verbose_exceptions . "</b>." : "";
  }
  
  function get_array_numbers($imax) {
    for ($i = 1; $i <= $imax; $i++) {
      $array_numbers[$i] = $i . $this->get_th($i);
    }
    return $array_numbers;
  }
  
  function get_th($i){
    if (is_primary_language()){
      if ($i == 1)
        $th = "ier";
      else
        $th = "ime";
    } else {
      if (preg_match("/^1$|[^1]1$/", $i))
        $th = "st";
      elseif (preg_match("/^2$|[^1]2$/", $i))
        $th = "nd";
      elseif (preg_match("/^3$|[^1]3$/", $i))
        $th = "rd";
      else
        $th = "th";
    }
    return $th;
  }
}

class vCard extends vBase {
  function vCard($v_string) {
    $this->vBase($v_string);
  }
} 
   
?>