<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * Module de gestion sql
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
copin_include("lib/db.php");
copin_include("lib/util.php");

/**
 * Module de gestion sql
 * 
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class SqlClass {
    var $_base_sql;
    var $_base_select;
    var $_base_from;
    var $_base_where;
    var $_base_groupby;
    var $_base_orderby;
    var $_base_having;
    var $_base_limit;
    var $_base_offset;
    var $_key;

    var $_base_table_update;
    var $_base_alias_update;
    
    var $_alt_update_table;
    var $_alt_insert_table;
    var $_alt_delete_table;

    var $modifie_sql;
    var $_modifie_select;
    var $_modifie_from;
    var $_modifie_where;
    var $_modifie_groupby;
    var $_modifie_orderby;
    var $_modifie_having;
    var $_modifie_limit;
    var $_modifie_offset;

    var $_modifie_table_update;
    var $_modifie_alias_update;

    // traitement des pages
    var $_row_per_page = 10;
    var $_nombre_de_page;
    var $_nb_enregistrement;

    var $field_description;

    // ----------------------------------------------------
    // constructeur
    // ----------------------------------------------------
    function SqlClass($requete, $connect = null) {
		    if (isset($connect)) { 
		      $this->_alt_bd = $connect;
		    } else
		      $this->_alt_bd = null;
        $this->_base_sql = $this->StripSql($requete);
        $this->Parse(); 
        $this->ResetSql();
        $this->ParseField();
        $this->_alt_update_table = "";
        $this->_alt_insert_table = "";
        $this->_alt_delete_table = "";
    } 
    
    // ----------------------------------------------------
    // ajouter un champ
    // ----------------------------------------------------
    function AddField($field) {
      $this->_modifie_select = $this->_modifie_select . ", " . $field;
      $this->RebuiltSql();
		  $old_alt_bd = $this->_alt_bd;
      $old_alt_update_table = $this->_alt_update_table;
      $old_alt_insert_table = $this->_alt_insert_table;
      $old_alt_delete_table = $this->_alt_delete_table;
      $old_index_schema = $this->_index_schema;
      $this->SqlClass($this->modifie_sql);
		  $this->_alt_bd = $old_alt_bd;
      $this->_alt_update_table = $old_alt_update_table;
      $this->_alt_insert_table = $old_alt_insert_table;
      $this->_alt_delete_table = $old_alt_delete_table;
      $this->_index_schema = $old_index_schema;
    }
    
    // ----------------------------------------------------
    // strip tab
    // ----------------------------------------------------
    function StripSql($sql) 
    {
      return preg_replace('/[\t\r\n]/', ' ', $sql);
    }
    
    // ----------------------------------------------------
    // Retour au valeur de base
    // ----------------------------------------------------
    function ResetSql()
    {
        $this->_modifie_select = $this->_base_select;
        $this->_modifie_from = $this->_base_from;
        $this->_modifie_where = $this->_base_where;
        $this->_modifie_groupby = $this->_base_groupby;
        $this->_modifie_orderby = $this->_base_orderby;
        $this->_modifie_having = $this->_base_having;
        $this->_modifie_limit = $this->_base_limit;
        $this->_modifie_offset = $this->_base_offset;
        $this->_modifie_alias_update = $this->_base_alias_update;
        $this->_modifie_table_update = $this->_base_table_update;
        $this->RebuiltSql();
    }

    // ----------------------------------------------------
    // Concatenation du sql dans les variables _modifie
    // ----------------------------------------------------
    function RebuiltSql()
    {
        $this->modifie_sql = $this->_modifie_select . ' ' .
                             $this->_modifie_from . ' ' .
                             $this->_modifie_where . ' ' .
                             $this->_modifie_groupby . ' ' .
                             $this->_modifie_orderby . ' ' .
                             $this->_modifie_having . ' ' .
                             $this->_modifie_limit . ' ' .
                             $this->_modifie_offset;
    }

    // ----------------------------------------------------
    // fonction de decoupage du sql
    // ----------------------------------------------------
    function Parse() 
    {
     // variable uppersql pour rechercher les mots cle
     // variable sql pour ne pas alterer le script original.
     $uppersql = strtoupper($this->_base_sql);
     $sql = $this->_base_sql;
     $this->_base_select = $this->extract_select($sql, $uppersql);
     $this->_base_from = $this->extract_from($sql, $uppersql);
     $this->_base_schema = $this->extract_schema($this->_base_from);
     $this->_index_schema = $this->_base_schema;
     $this->_base_where = $this->extract_where($sql, $uppersql);
     $this->_base_groupby = $this->extract_groupby($sql, $uppersql);
     $this->_base_orderby = $this->extract_orderby($sql, $uppersql);
     $this->_base_limit = $this->extract_limit($sql, $uppersql);
     $this->_base_offset = $this->extract_offset($sql, $uppersql);
     $this->extract_alias_update($this->_base_from);
    }

    // ----------------------------------------------------
    // fonction pour aller chercher le type des champs
    // dans v_data_dictionary
    // ----------------------------------------------------
    function ParseField() 
    {
     $this->field_description = $this->extract_field_description();
    }

    // ----------------------------------------------------
    // extraction du select
    // ----------------------------------------------------
    function extract_select(&$sql, &$uppersql){
      
       $result = '';
       $p1 = strpos($uppersql, 'SELECT ');
       $p2 = strpos($uppersql, ' SELECT ' );
     
       if (($p1 === false) && ($p2 === false))
       {
          // non trouve
          $result = $sql;
          $sql = '';
          $uppersql = '';
       }
       else
       {
           $pos = strpos($uppersql, ' FROM ');
           if ($pos > 0) 
           {
               $result = substr($sql, 0, $pos);
               $len = strlen($sql);
               $sql = substr($sql, $pos + 1, $len);
               $uppersql = substr($uppersql, $pos + 1, $len);
           }
           else
           {
              $result = $sql;
              $sql = '';
              $uppersql = '';
           }
       }
       return $result;
    }

    // ----------------------------------------------------
    // extraction du from 
    // ----------------------------------------------------
    function extract_from(&$sql, &$uppersql)
    {
       $result = '';
       $p1 = strpos($uppersql, 'FROM ');
       $p2 = strpos($uppersql, ' FROM ' );
     
       if (($p1 === false) && ($p2 === false))
       {
          // non trouve
          $result = '';
          $sql = '';
          $uppersql = '';
       }
       else
       {
           $len = strlen($sql);
           $pos = strpos($uppersql, ' WHERE ');
           if ($pos === false) $pos = strpos($uppersql, ' GROUP BY ');
           if ($pos === false) $pos = strpos($uppersql, ' ORDER BY ');
           if ($pos === false) $pos = strpos($uppersql, ' LIMIT ');
           if ($pos === false) $pos = strpos($uppersql, ' OFFSET ');
           if ($pos === false) $pos = $len;
           $result = substr($sql, 0, $pos);
           $sql = substr($sql, $pos + 1, $len);
           $uppersql = substr($uppersql, $pos + 1, $len);
       }
       return $result;
    }
    
    
    // ----------------------------------------------------
    // extraction du from 
    // ----------------------------------------------------
    function extract_schema(&$base_from)
    {
       preg_match("/\w*\./", $base_from, $matches);
       return $matches[0];
    }

    // ----------------------------------------------------
    // extraction du where
    // ----------------------------------------------------
    function extract_where(&$sql, &$uppersql)
    {
       $result = '';
       $p1 = strpos($uppersql, 'WHERE ');
       $p2 = strpos($uppersql, ' WHERE ' );
     
       if (!(($p1 === false) && ($p2 === false)))
       { 
          $len = strlen($sql);
          $pos = strpos($uppersql, 'GROUP BY ');
          if ($pos === false) $pos = strpos($uppersql, 'ORDER BY ');
          if ($pos === false) $pos = strpos($uppersql, 'LIMIT ');
          if ($pos === false) $pos = strpos($uppersql, 'OFFSET ');
          if ($pos === false) {$pos = $len;} else {$pos--;} 
          $result = substr($sql, 0, $pos);
          $sql = substr($sql, $pos + 1, $len);
          $uppersql = substr($uppersql, $pos + 1, $len);
       }
       return $result;
    }

    // ----------------------------------------------------
    // extraction du group by
    // ----------------------------------------------------
    function extract_groupby(&$sql, &$uppersql)
    {
       $result = '';
       $p1 = strpos($uppersql, 'GROUP BY ');
       $p2 = strpos($uppersql, ' GROUP BY  ' );
     
       if (!(($p1 === false) && ($p2 === false)))
       { 
          $len = strlen($sql);
          $pos = strpos($uppersql, 'ORDER BY ');
          if ($pos === false) $pos = strpos($uppersql, 'LIMIT ');
          if ($pos === false) $pos = strpos($uppersql, 'OFFSET ');
          if ($pos === false) {$pos = $len;} else {$pos--;}
          $result = substr($sql, 0, $pos);
          $sql = substr($sql, $pos + 1, $len);
          $uppersql = substr($uppersql, $pos + 1, $len);
       }
       return $result;
    }

    // ----------------------------------------------------
    // extraction du order by
    // ----------------------------------------------------
    function extract_orderby(&$sql, &$uppersql)
    {
       $result = '';
       $p1 = strpos($uppersql, 'ORDER BY ');
       $p2 = strpos($uppersql, ' ORDER BY  ' );

       if (!(($p1 === false) && ($p2 === false)))
       { 
          $len = strlen($sql);
          $pos = strpos($uppersql, 'LIMIT ');
          if ($pos === false) $pos = strpos($uppersql, 'OFFSET ');
          if ($pos === false) {$pos = $len;} else {$pos--;}
          $result = substr($sql, 0, $pos);
          $sql = substr($sql, $pos + 1, $len);
          $uppersql = substr($uppersql, $pos + 1, $len);
       }
       return trim($result);
    }

    // ----------------------------------------------------
    // extraction du champ du order by
    // version 1 : on tient compte seulement du premier champ
    // ----------------------------------------------------
    function get_champ_orderby() 
    {
       $champ = '';
       $orderby = strtoupper($this->_modifie_orderby);
       $pos = strpos($orderby, ',');
       if (!($pos === false))  
          $orderby = substr($orderby, 0, $pos);

       $pos = strpos($orderby, 'ORDER BY ');
       if (!($pos === false)) 
       {
           $champ = substr($orderby, $pos + 9, strlen($orderby));
           if (preg_match("/(.*)\s* (desc|asc)\s*$/i", $champ, $matches))
             $champ = $matches[1];
       }
       return trim($champ);
    }

    // ----------------------------------------------------
    // extraction de la direction (ASC, DESC) du 
    // order by 
    // version 1 : on tient compte seulement du premier champ
    // ----------------------------------------------------
    function get_direction_orderby() 
    {
       $orderby = strtoupper($this->_modifie_orderby);
       $pos = strpos($orderby, ',');
       if (!($pos === false))  
          $orderby = substr($orderby, 0, $pos);
          
       if (preg_match("/(.*)\s* ([desc|asc]*)\s*$/i", $orderby, $matches))
           return $matches[2];
       else
          return 'ASC';
    }

    // ----------------------------------------------------
    // Changer la direction du order by 
    // version 1 : on tient compte seulement du premier champ
    // ----------------------------------------------------
    function switch_orderby() 
    {
       $orderby = strtoupper($this->_modifie_orderby);
       $pos = strpos($orderby, ',');
       $av_vir = $orderby;
       $ap_vir = '';
       if (!($pos === false))
       {
          $av_vir = substr($orderby, 0, $pos);
          $ap_vir = substr($orderby, $pos, strlen($orderby));
       }
       $direction = $this->get_direction_orderby();
       if ($direction === "ASC")
          $this->_modifie_orderby = 'ORDER BY ' . $this->get_champ_orderby() . ' DESC' . $ap_vir;
       else 
          $this->_modifie_orderby = 'ORDER BY ' . $this->get_champ_orderby() . ' ASC' . $ap_vir;
       $this->RebuiltSql();
    }

    // ----------------------------------------------------
    // extraction du limit
    // ----------------------------------------------------
    function extract_limit(&$sql, &$uppersql)
    {
       $result = '';
       $p1 = strpos($uppersql, 'LIMIT ');
       $p2 = strpos($uppersql, ' LIMIT  ' );
     
       if (!(($p1 === false) && ($p2 === false)))
       { 
          $len = strlen($sql);
          $pos = strpos($uppersql, 'OFFSET ');
          if ($pos === false) {$pos = $len;} else {$pos--;}
          $result = substr($sql, 0, $pos);
          $sql = substr($sql, $pos + 1, $len);
          $uppersql = substr($uppersql, $pos + 1, $len);
       }
       return $result;
    }

    // ----------------------------------------------------
    // extraction du offset
    // ----------------------------------------------------
    function extract_offset(&$sql, &$uppersql)
    {
       $result = '';
       $p1 = strpos($uppersql, 'OFFSET ');
       $p2 = strpos($uppersql, ' OFFSET  ' );
     
       if (!(($p1 === false) && ($p2 === false)))
       { 
          $len = strlen($sql);
          $pos = $len;
          $result = substr($sql, 0, $pos);
          $sql = substr($sql, $pos + 1, $len);
          $uppersql = substr($uppersql, $pos + 1, $len);
       }
       return $result;
    }

    // ----------------------------------------------------
    // Extraction de la table de mise a jour.
    // Nous gardons le nom de la table ssi il y a une seule 
    // table de mise  jour. Dans les autres cas aucun update
    // ou delete ne peut etre generer.
    // ----------------------------------------------------
    function extract_alias_update($FromClause)
    {
       if ((!(strpos(strtoupper($FromClause), ' JOIN ') === false)) || 
           (!(strpos(strtoupper($FromClause), ',') === false)))
          return; // on ne peut pas faire de update

       $table_name = '';
       $alias_name = '';

       // extraction de l'alias. 
       $pos_from = strpos(strtoupper($FromClause), 'FROM ');
       $len = strlen($FromClause);

       if ((!($pos_from === false)) && ($pos_from + 5 <> $len))
       {         
          // enlever le 'from ' de la chaine 
          $chaine = substr($FromClause, $p + 5, $len);
          $chaine = trim($chaine);
          // recherche du mot ' as '
          $pos_as = strpos(strtoupper($chaine), ' AS ');
          if (!($pos_as === false))
          {
             $table_name = substr($chaine, 0, $pos_as);
             $alias_name = substr($chaine, $pos_as + 4, strlen($chaine));
          }
          else  // pas de mot 'as' dans le from clause
          {
             $pos_espace = strpos($chaine, ' ');
             if ($pos_espace === false)
             {
                 $table_name = $chaine;
             }
             else
             {
                 $table_name = substr($chaine, 0, $pos_espace);
                 $alias_name = substr($chaine, $pos_espace + 1, strlen($chaine));
             }
          }
       }
       $this->_base_table_update = $table_name;
       $this->_base_alias_update = $alias_name;
    }

    // ----------------------------------------------------
    // function qui extrait le nom des champs de 
    // v_data_dictionnary. Conserver seulement les champs 
    // qui sont interessant.
    // ----------------------------------------------------
    function extract_field_description()
    {
      // select de base avec un limit 1 pour
      // retrouver l'entete des colonnes selectionn
      // seulement
      if (preg_match("/^select \s*\*/", trim($this->_base_select))){
        $nom_champ = pg_query(getdb($this->_alt_bd), 
                             $this->_base_select . ' ' .
                             $this->_base_from . ' ' .
                             'order by 1 limit 1');

        if($nom_champ !== FALSE) {
          $nf = pg_num_fields($nom_champ);
          for ($i = 0 ; $i < $nf ; $i++)
          {
             $array_champ[$i] = pg_field_name($nom_champ, $i);
          }
        }
      } else {
        $array_champ = explode(",", preg_replace("/select /i", "", $this->_base_select));
      }
      // Recherche des donnes dans la vue
      // v_data_dictionary.
      $table_name = $this->_modifie_table_update;
      if (preg_match("/\w*\.(\w*)/", $table_name, $matches))
      $table_name = $matches[1];
      $res = pg_query(getdb($this->_alt_bd), "select field_name, " .
                       "field_num, " .
                       "field_type, " .
                       "field_len, " .
                       "field_null " .
                       "from " . $this->_base_schema . "v_data_dictionary " .
                       "where table_name = " . wrapdata(strtolower($table_name), 'string') . 
                       " order by field_num");
                       
      if($res !== FALSE)
        $rows = pg_num_rows($res);
      else
       $rows = 0;
       
      if ($rows == 0){
       $schemas = pg_query("show search_path");
       $schemas = pg_fetch_array($schemas, 0, PGSQL_ASSOC);
       $schemas = preg_split("/[\s,]+/", $schemas["search_path"]);
       if ($this->_base_schema == "")
         $this->_base_schema = $schemas[1].".";
       // on devrait continuer le prochain shema si on n'en a deja un qui n est pas bon
       return $this->extract_field_description();
       
      } else {
      
	      for ($i = 0 ; $i < $rows ; $i++)
	      {
	         $dicbook[$i] = pg_fetch_array($res, $i, PGSQL_ASSOC);
	      }
	      // cration d'un seul array qui contient
	      // le nom du champ et l'information sur le champ
	      reset($array_champ);
	      while (list($index) = each($array_champ)) 
	      {
	         $trouve = false;
	         for ($j=0;$j<count($dicbook);$j++)
	         {
	            if (trim($array_champ[$index]) == $dicbook[$j]['field_name'])
	            {
	               $trouve = true;
	               $result[trim($array_champ[$index])] = $dicbook[$j];
	            }
	            //if ($trouve) break;
	         }
	      }
	      return $result;
	    }
    }

    // ----------------------------------------------------
    // Ajout d'une clause where au select
    // ----------------------------------------------------
    function WhereAnd ($AppendWhereClause) 
    {
       if (strpos(strtoupper($this->_base_where), 'WHERE') === false)
       {
           $this->_modifie_where = 'WHERE (' . $AppendWhereClause . ')';
       }
       else
       {
           $this->_modifie_where .= ' AND (' . $AppendWhereClause . ')';
       }
       $this->RebuiltSql();
    }

    // ----------------------------------------------------
    // Changer la clause where 
    // ----------------------------------------------------
    function WhereSet($NewWhereClause) 
    {
       $this->_modifie_where = 'WHERE ' . $NewWhereClause;
       $this->RebuiltSql();
    }

    // ----------------------------------------------------
    // Ajouter une clause 'or'  
    // ----------------------------------------------------
    function WhereOr($AppendWhereClause) 
    {
       $pos = strpos(strtoupper($this->_base_where), 'WHERE');
       if ($pos === false)
           $this->_modifie_where = 'WHERE (' . $AppendWhereClause . ')';
       else
       {
           $len = strlen($this->_modifie_where);
           $oldw = substr($this->_modifie_where, $pos + 6, $len);
           $this->_modifie_where = 'WHERE (' . $oldw . ') OR (' . 
                                  $AppendWhereClause . ')';
       }
       $this->RebuiltSql();
    }
 
    // ----------------------------------------------------
    // Met des champs non null, dans le cas de vues 
    // ----------------------------------------------------
    function sql_notnull($fieldname){
      if (is_array($fieldname)) {
        while (list($index, $subarray) = each($fieldname))
          if (isset($this->field_description[$subarray])) {
            $this->field_description[$subarray]['field_null'] = 'N';
           }
      } else {
        if (isset($this->field_description[$fieldname]))
          $this->field_description[$fieldname]['field_null'] = 'N';
      }
    }
    
    // ----------------------------------------------------
    // Changer le order by 
    // ----------------------------------------------------
    function SetOrderByToggle($NewOrderByClause) 
    {
       if (('ORDER BY ' . strtoupper($NewOrderByClause)) == strtoupper($this->_modifie_orderby))
       {
          $this->switch_orderby();
       }
       else
       {
          $this->_modifie_orderby = 'ORDER BY ' . $NewOrderByClause;
          $this->RebuiltSql();
       }
    }

    // ----------------------------------------------------
    // Changer le order by  NewOrderByClause inclu la direction
    // ----------------------------------------------------
    function SetOrderBy($NewOrderByClause) 
    {
          $this->_modifie_orderby = 'ORDER BY ' . $NewOrderByClause;
    }
    
    // ----------------------------------------------------
    // Changer le index par new_index
    // ----------------------------------------------------
    function SetKey($new_key) 
    {
          $this->_key = $new_key;
    }
    
    // ----------------------------------------------------
    // UpdateFactory :
    // On passe un array avec le nom du champ et sa valeur
    // en parametre. Le resultat est le update generer. 
    // Le updatefactory ne fonctionne seulement lorsqu'il y
    // a seulement 1 table de mentionn.
    // ----------------------------------------------------
    function UpdateFactory($setvalue, $whereindex) 
    {
       if (!is_array($whereindex))
       return '';

       if (!is_array($setvalue))
          return '';

       if (count($setvalue) == 0)
          return '';

       if (($this->get_update_table_name() == '') ||
           (!($this->_modified_group_by == '')))
          return ''; // impossible de generer un update


       // generer la clause set 
       $set_update = 'SET ';
       while (list ($ColumnName, $ColumnValue) = each ($setvalue)) 
       {
         $set_update .= $ColumnName . ' = ' .  
                         wrapdata($ColumnValue, 
                                  $this->field_description[strtolower($ColumnName)]['field_type'],
                                  $this->field_description[strtolower($ColumnName)]['field_null']) . 
                         ', ';
       }
       $set_update = substr($set_update, 0, strlen($set_update) - 2);


       // transformer la clause where s'il y a un alias
       $mod_where = str_replace($this->_modifie_alias_update . '.',
                                $this->_modifie_table_update . '.',
                                $this->_modifie_where);

       // ajouter la clause where passe en parametre
       $index_update = '';
       while (list ($ColumnName, $ColumnValue) = each ($whereindex)) 
       {
         $index_update .= $ColumnName . ' = ' . 
                         wrapdata($ColumnValue, $this->field_description[strtolower($ColumnName)]['field_type']) . 
                         ' AND ';
       }
       $index_update = substr($index_update, 0, strlen($index_update) - 5);

       if ($index_update != '') 
       {
          if (strpos(strtoupper($mod_where), 'WHERE') === false)
             $mod_where = 'WHERE (' . $index_update . ')';
          else
          {
             $mod_where .= ' AND (' . $index_update . ')';
          }
       }

        // concatenation du update.
        $result = 'UPDATE ' . $this->get_update_table_name() . ' ' .
                  $set_update . ' ' .
                  $mod_where;


        return $result;
    }

    // ----------------------------------------------------
    // executer directement la mise a jour
    // ----------------------------------------------------
    function UpdateFactoryExec($setvalue)
    {
       $query = $this->UpdateFactory($setvalue);
       if ($query <> '') ExecSql($query);
    }

    // ----------------------------------------------------
    // Generer un insert () value ()
    // ----------------------------------------------------
    function InsertFactory($insertfields)
    {
       $fields = '';
       $values = '';
       while (list($index, $subarray) = each($insertfields)) 
       {
          $fields .= $index . ", ";
          $values .= wrapdata($subarray, $this->field_description[strtolower($index)]['field_type'],
                                  $this->field_description[strtolower($index)]['field_null']) . ", ";
       }
       $lesql = "INSERT INTO " . $this->get_insert_table_name() . 
             " (" . substr($fields, 0, strlen($fields) - 2) . 
             ") values (" . substr($values, 0, strlen($values) - 2) .
             ")";
       return $lesql;
    }


    // ----------------------------------------------------
    // DeleteFactory :
    // Genere le delete 
    // ----------------------------------------------------
    function DeleteFactory() 
    {
        if (($this->_modifie_table_update == '') ||
            (!($this->_modified_group_by == '')))
           return ''; // impossible de generer un update

        // transformer la clause where s'il y a un alias
        $mod_where = str_replace($this->_modifie_alias_update . '.',
                                 $this->_modifie_table_update . '.',
                                 $this->_modifie_where);

        // concatenation du update.
        $result = 'DELETE ' . $this->_modifie_table_update . ' ' .
                  $mod_where;

        return $result;
    }


    // ----------------------------------------------------
    // Transforme le script sql en un select count(*) 
    // ----------------------------------------------------
    function SelectCount() {
       $result = '';
       if (strpos(strtoupper($this->_modifie_select), ' DISTINCT ') === false)
       {
          $result = 'SELECT COUNT(*) FROM (SELECT 1 ';
          $result .= $this->_modifie_from . ' ';
          $result .= $this->_modifie_where . ' ';
          $result .= " ORDER BY " . ($this->_key != "" ? $this->_key : "1");
          $result .= ') AS CNT_SELECT';
       }
       else 
       {
          $result = 'SELECT COUNT(*) FROM (';
          $result .= $this->_modifie_select . ' ';
          $result .= $this->_modifie_from . ' ';
          $result .= $this->_modifie_where . ' ';
          $result .= ') AS CNT_SELECT';
       }
       return $result;
    }

    // ----------------------------------------------------
    // Transforme le script sql en un select count(*) 
    // ----------------------------------------------------
    function SelectCountComplete() 
    {
       $result = '';
       if (strpos(strtoupper($this->_modifie_select), ' DISTINCT ') === false)
       {
          $result = 'SELECT COUNT(*) ';
          $result .= $this->_modifie_from . ' ';
          $result .= $this->_modifie_where . ' ';
       }
       else 
       {
          $result = 'SELECT COUNT(*) FROM (';
          $result .= $this->_modifie_select . ' ';
          $result .= $this->_modifie_from . ' ';
          $result .= $this->_modifie_where . ' ';
          $result .= ') AS CNT_SELECT';
       }
       return $result;
    }

    // ----------------------------------------------------
    // modifier la clause limit
    // ----------------------------------------------------
    function SetLimit($limit) 
    {
       $this->_modifie_limit = 'LIMIT ' . $limit;
       $this->RebuiltSql();
    }

    // ----------------------------------------------------
    // modifier la clause offset
    // ----------------------------------------------------
    function SetOffset($offset) 
    {
       $this->_modifie_offset = 'OFFSET ' . $offset;
       $this->RebuiltSql();
    }

    // ----------------------------------------------------
    // retourne le nombre d'enregistrement par page
    // ----------------------------------------------------
    function row_per_page($nb) 
    {
      $this->_row_per_page = $nb;
    }

    // ----------------------------------------------------
    // compte le nombre d enregistrement et change le 
    // nombre de page
    // ----------------------------------------------------
    function set_page_count() 
    {
       $this->ExecCount();
       $this->_nombre_de_page = 1;
       if ($this->_row_per_page != 0) 
       {    
         $this->_nombre_de_page = ceil($this->_nb_enregistrement / $this->_row_per_page);
       }
    }

    // ----------------------------------------------------
    // retourne le nombre de page
    // ----------------------------------------------------
    function get_page_count()
    {
      return $this->_nombre_de_page;
    }

    // ----------------------------------------------------
    // execute le select modifier selon la page demander
    // ----------------------------------------------------
    function SelectPage($page)
    {
      return SelectSql($this->SelectPageSql($page), $this->_alt_bd);
    }
    
    function SelectPageSql($page) {
      $this->SetLimit($this->_row_per_page);
      $this->SetOffset( ( $page == 0 ? 0 : ($page - 1) ) * $this->_row_per_page );
      return $this->modifie_sql;
    }


    // ----------------------------------------------------
    // execute le select modifier
    // ----------------------------------------------------
    function Select()
    {
       return SelectSql($this->modifie_sql, $this->_alt_bd);
    }

    // ----------------------------------------------------
    // retourne la premiere valeur valeur d'un select
    // selon la valeur du order by.
    // ----------------------------------------------------
    function SelectFirst($cle)
    {
       if ($this->_modifie_orderby != '')
       {
          $sqltmp = 'SELECT ' . $cle . ' ' . 
                    $this->_modifie_from . ' ' .
                    $this->_modifie_where . ' ' .
                    $this->_modifie_orderby . ' ' .
                    'LIMIT 1';
       }
       return SelectSql($sqltmp, $this->_alt_bd);
    }

    // ----------------------------------------------------
    // retourne la derniere valeur valeur dun select
    // selon la valeur du order by.
    // ----------------------------------------------------
    function SelectLast($cle)
    {
  
       if ($this->_modifie_orderby != '')
       {
          $sqltmp = 'SELECT ' . $cle . ' ' . 
                    $this->_modifie_from . ' ' .
                    $this->_modifie_where . ' ' .
                    'ORDER BY ' . $this->get_champ_orderby() . ' ' .
                    ($this->get_direction_orderby() == 'ASC' ? 'DESC' : 'ASC') . ' ' .
                    'LIMIT 1';
       }
       return SelectSql($sqltmp, $this->_alt_bd);
    }


    // ----------------------------------------------------
    // execute le select count(*) et met la valeur dans
    // _nb_enregistrement
    // ----------------------------------------------------
    function ExecCount() 
    {
      $nb = SelectSql($this->SelectCount(), $this->_alt_bd);
       if($nb > get_constant("MAX_RECORD"))
        $this->_nb_enregistrement = get_constant("MAX_RECORD");
       else
        $this->_nb_enregistrement = $nb;
       return $this->_nb_enregistrement;
    }

    function ToggleOrderBy() 
    {
    }

    function SortKeyExpression() {
    }

    function SetSortKeyExpression() {
    }


    Function RegisteredCompareClause() {
    }


    Function FactoryPreviousPage($FirstKeyOnPage, $LastKeyOnPage) 
    {
    }
   
    Function FactoryNextPage($FirstKeyOnPage, $LastKeyOnPage) 
    {
    }

    function get_table_name() {
      return $this->_modifie_table_update;
    }

    function SetAltDeleteTable($table_name) {
      $this->_alt_delete_table = $table_name;
    }
    function get_delete_table_name() {
      return ($this->_alt_delete_table != ""
               ? $this->_alt_delete_table
               : $this->get_table_name());
    }
    
    function SetAltUpdateTable($table_name) {
      $this->_alt_update_table = $table_name;
      $this->set_index_schema($table_name);
    }
    function set_index_schema($table_name) {
      if (preg_match("/\w*\./", $table_name, $matches))
        $this->_index_schema = $matches[0];
    }
    
    function get_update_table_name() {
       return ($this->_alt_update_table != ""
               ? $this->_alt_update_table
               : $this->get_table_name());
    }
    
    function SetAltInsertTable($table_name) {
      $this->_alt_insert_table = $table_name;
      $this->set_index_schema($table_name);
    }
    function get_insert_table_name() {
       return ($this->_alt_insert_table != ""
               ? $this->_alt_insert_table
               : $this->get_table_name());
    }
    
    function get_modifie_select() {
       return $this->_modifie_select;
    }

    function get_modifie_from() {
       return $this->_modifie_from;
    }

    function get_modifie_where() {
       return $this->_modifie_where;
    }

    function get_modifie_groupby() {
       return $this->_modifie_groupby;
    }

    function get_modifie_orderby() {
       return $this->_modifie_orderby;
    }
 

    function get_sql_path($tablename, $parent_key, $search_value, $value_field, $display_field){
      $sql = "SELECT * FROM cms.udf_get_path('".$tablename."', 
                                '".$this->_key."', 
                                '".$parent_key."', 
                                '".$search_value."', 
                                '".$value_field."', 
                                '".$display_field."') ORDER BY sort_order";

      return $sql;
    }
 
    function get_sql_exist_child($tablename, $parent_key, $parent_id){
      $sql = "SELECT 1 FROM ".$tablename.
             " WHERE ".$parent_key." = ".$parent_id." LIMIT 1";
      return $sql;
    }
}
?>