<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * Skin class
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
/*Le skin
Le skin est un array des skiny ncessaires  fabriquer les pages selon un 
thme.  Prvoir un skin par dfaut pour tous les projets s'il n'est pas spcifi.

Les skiny <td>::nom::</td>
Les skiny sont des parcelles de html correspondant  une section de page.
Ils portent un nom et un contenu dans un array.  Un skiny doit tre complter
par un ou plusieurs tags et il doit  l'origine tre complet sans remplacement
ex: <td>::nom::</td> est valide mais <td>::nom::/td> ne l'est pas.
Il y aura une version de chaque skiny lecture seule qui portera le mme nom 
que le skiny suivi de "_RO" et une version printerfriendly suivi de "_PF" qui 
si c'est le mme que ro appellera celui qu'il faut.

Les tags ::nom::
Les tag seront crit en majuscules, prcds et suivis de "::".  S'ils 
correspondent  des proprits html ils auront le mme nom que la proprit.
Le tag "::VALUE::" servira aussi  dfinir le contenu d'un td.  Si un tag est 
rpt, toutes les occurrences sont remplaces par la mme valeur.  Si le tag 
est absent, la valeur par dfaut est utilise sinon aucun remplacement n'est fait.


Le dveloppement se fera par tapes
-  les contrles
-  l'index
-  en-tte et pied
-  les objets


Fonctions ncessaires et modifications
-  Fonction d'affichage selon un skin, le nom du skin est sauvegard dans la 
session, paramtres : nom du skiny, array de paramtres, valeurs.  
Regex : /(.*)::nom::(.*)/  (utiliser gredy?)
-  Fonction de test de skiny:  appel affichage mais donne le rsultat 
seulement d'un skiny.
-  Fonction get_tag_names: retourne tous les tags disponibles.
-  Sauvegarde et lecture du dernier skin dans le cookie
-  Application du skin par dfaut pour tous les projets, pour le projet et 
pour l'utilisateur.  Fonctionne comme les css en effectuant un merge pour 
permettre d'overrider seulement une partie.
-  Les skiny sont conservs dans un fichier par skin.  Ce fichier inclus 
optionnellement un nom de css.
*/


class classskin {
  var $cssname;
  var $name;
  var $skinies;
  var $skin_path;
/**
 * Skin class
 * 
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
function skin($action) {
  if (!isset($_SESSION[get_constant("SITE_NAME")]["skin"]) || pget("skin") != "" || get_constant("DEBUG_SKINS")) {
    if(get_constant("SKIN_MACHINE_LEVEL"))
      while ( list($index, $subarray) = each($_SESSION) )
        unset($_SESSION[$index]["skin"]);
    $skiname = pget("skin");
    $skin = new classskin($skiname);
    $_SESSION[get_constant("SITE_NAME")]["skin"] = $skin;
  } else {
    $skiname = $_SESSION[get_constant("SITE_NAME")]["skiname"];
    $skin = $_SESSION[get_constant("SITE_NAME")]["skin"];
  }
  $skin->_display($action);
  $_SESSION[get_constant("SITE_NAME")]["skiname"] = $skiname;
  $_SESSION[get_constant("SITE_NAME")]["skin"] = $skin;
}
  
  function classskin($skiname){
    $this->load_skin($skiname);
  }

	function get_default_skinname() {
    if (get_constant("USE_COOKIES_FOR_DEFAULT_SKIN"))
	   $skiname = Cookie::get_cookie("default_skin", true);
	  if (!isset($skiname) || filename_with_path("skin/$skiname/default.ini") == "") {
	    $skiname = get_parametre_systeme("theme");
	    if (filename_with_path("skin/$skiname/default.ini") == "")
	      $skiname = get_constant("DEFAULT_SKIN");
	  }
	  return $skiname;
	}
	
  function set_skiname($skiname) {
    Cookie::set_cookie("default_skin", $skiname, true);
    $_SESSION[get_constant("SITE_NAME")]["skiname"] = $skiname;
    $this->name = $skiname;
    $this->prefix = preg_replace("/^sk_/", "", $this->name);
    $this->skin_path = dirname(filename_with_path("skin/$skiname/default.ini"));
  }
  
  //loader un skin demand, utilis  l'initialisation 
  //et au changement de skin
  function load_skin($skiname){
    if (is_webot()) {
    	$skiname = get_constant("DEFAULT_SKIN_NO_FRAME");
	  } else {
	    if ($skiname == "")
	      $skiname = $this->get_default_skinname();
	  }
	  $this->set_skiname($skiname);
    sset("skin_path", "$this->skin_path/");
    sset("image_dir", "$this->skin_path/image/");
    sset("forms_image_dir", "$this->skin_path/forms/image/");
    sset("css_dir", "$this->skin_path/css/");
    sset("calendar_methode", "button");
    sset("css_string", $this->get_css_string("$this->skin_path/css/"));
    sset("js_string", $this->get_js_string("$this->skin_path/js/"));
    
    $this->ini_array = parse_ini_file("$this->skin_path/default.ini", true);
    $dir_name = "$this->skin_path/skiny/";
    $dir = opendir($dir_name);
    while ($file_name = readdir($dir)) {
      if (ereg(".html", $file_name)) { 
        $skinyname = substr($file_name,0,strlen($file_name)-5);
        $skiny = Read_Template($dir_name . $file_name);
        if (preg_match("/([\w|\W|\s|\S|.]*)::CONTENT::([\w|\W|\s|\S|.]*)/", $skiny, $matches)) {
          $this->skinies[$skinyname."_start"] = $matches[1];
          $this->skinies[$skinyname."_end"] = $matches[2];
        } else {
          $this->skinies[$skinyname] = $skiny;
        }
      }
    }
    closedir($dir);
    $this->set_logo_top();
    $this->set_logo_foot();
  }
  
  function get_js_string($path){
    $dir = opendir($path);
    while ($file_name = readdir($dir)) {
      if (ereg(".js", $file_name))
        $js_string .= "  <script language='javascript' src='$path$file_name' type='text/javascript'></script>\n";
    }
    $js_file_name = "lib/splash.js";
    $js_string .= (file_exists($js_file_name) 
       ? "  <script language='javascript' src='$js_file_name' type='text/javascript'></script>\n"
       : "");
    return $js_string;
  }
  
  function get_css_string($path){
    $dir = opendir($path);
    while ($file_name = readdir($dir)) {
      if (ereg(".css", $file_name) && $file_name != "calendar.css")
      $css_string .= "  <link rel=\"stylesheet\" href=\"$path$file_name\" type=\"text/css\">\n";
    }
    return $css_string;
  }
  
  function init_menus(&$action, $action_type) {
    $user_actions = get_cargo("user_actions");
    if (isloged() && $user_actions)
      $restricted_where = "or action in ($user_actions)";
    $menus = selectsql("select cms.get_default_action('$action') as laction, * from cms.v_action_menu v 
        where ((v.action_selected = cms.get_default_action('$action')) or 
        ( v.action_selected = substring(v.action_tree, 1, position(':' in v.action_tree)-1)  and 
        v.action_selected <> substring( cms.udf_action_tree(cms.get_default_action('$action')) 
          , 1, position(':' in cms.udf_action_tree(cms.get_default_action('$action')) )-1) )) 
          and (action not in (select action from cms.acces_rights)
        $restricted_where) and v.active = 1");
    $action = $menus[0][laction];
    unset($this->menus);
    if (is_array($menus)) {
      while ( list($index, $subarray) = each($menus) ) { 
        $menu = preg_split("/:/", $subarray["action_tree"]);
        $this->menus[$menu[0]][$index] = $subarray;
      }
      $this->action_tree = get_action_tree($this->menus["main"], $action);
    }
    return $action;
  }
  
  function init_menus_javascript($action) {
    $site_user_type = get_cargo("site_user_type");
    // fichier menus
    
    if (get_constant("FILE_MENUS")) {
      $filename = "menu/" . ($site_user_type ? $site_user_type : "UE") . "_" . get_language_code() .".php";
      copin_include($filename);
      $this->menus = $GLOBALS["menus"];
		} else {
		  $menu = selectsql("select * from cms.v_main_menus 
       where site_user_type = '$site_user_type' and " . get_prefix_langue() . "active = 1
       order by sort_order", get_constant("DATABASE_MAIN"));
	    unset($this->menus);
		  reset($menu);
		  while (list($index, $option) = each($menu)) 
		    $this->menus[$option["name"]] = $option;
		}
        
    if (function_exists(app_fix_menus))
      $this->menus = app_fix_menus($this->menus);
	  reset($this->menus);
	  unset($this->menutree);
	  while (list($index, $option) = each($this->menus)) {
	    if ($option["action_type"] != "submenu" && $option["action_type"] != "menu" && $option["parent_name"] != 'top') {
	      $root = preg_split("/:/", $option["action_tree"]);
	      $this->menutree[$root[0]][$option["parent_name"]]["menus"][$option["name"]] = $option;
	    } elseif ($option["action_type"] == "menu" && !isset($this->menutree[$option["name"]])) {
	      $this->menutree[$option["name"]] = "";
	    } elseif ($option["action_type"] == "submenu" || $option["parent_name"] == 'top') {
	      $root = preg_split("/:/", $option["action_tree"]);
	      if (!isset($this->menutree[$root[0]][$option["name"]]))
	        $this->menutree[$root[0]][$option["name"]] = $option;
	      else
	        $this->menutree[$root[0]][$option["name"]] = array_merge($this->menutree[$root[0]][$option["name"]], $option);
	      $this->menutree[$root[0]][$option["parent_name"]]["menus"][$option["name"]] = $option;
	    }
	  }
    
    if (get_constant("FILE_MENUS"))
      $menusystem = $GLOBALS["menussystem"];
    else
      $menusystem = selectsql("select * from cms.v_actions 
       where root = 'system' and user_right <> 'n' and site_user_type = '$site_user_type' and " . get_prefix_langue() . "active = 1
       order by sort_order", get_constant("DATABASE_MAIN"));
    unset($this->menutreesystem);
    if (is_array($menusystem)) {
	    unset($this->menusystems);
		  reset($menusystem);
		  while (list($index, $option) = each($menusystem)) 
		    $this->menusystems[$option["name"]] = $option;
        
      if (function_exists(app_fix_menusystem))
        $this->menusystems = app_fix_menusystem($this->menusystems);
      reset($this->menusystems);
      while (list($index, $option) = each($this->menusystems)) {
        if ($option["action_type"] != "submenu" && 
          $option["action_type"] != "menu") {
          $this->menutreesystem[$option["name"]] = $option;
        } 
      }
    }
    
    if ($action == "top_accueil")
      $action = get_constant("DEFAULT_ACTION");
	  return $action;
  }
   
  function get_swap_js($menu){
    if (is_array($menu)) {
      reset($menu);
    while ( list($index, $subarray) = each($menu) ) 
       if ($subarray['visible'] &&  
        ( !(isloged() && $subarray['name'] == "cms_connexion") &&
         !(!isloged() && $subarray['name'] == "cms_deconnexion")
        ))
        $js .= "set_class('mnu_" . $subarray['name'] . "', 'vmenu'); ";
      $js .= "set_class(this.id, 'selectedvmenu');"; 
    }
    return $js;
  } 
  
  function get_parent_name(&$action) {
    $parent_menu = "";
    if (isset($this->menus[$action])) {
	    while ($parent_menu == "") {
	      $parent_menu1 = $this->menus[$action]["parent_name"];
	      if ($parent_menu1 == "main")
	        $parent_menu = $action;
	      else 
	        $action = $parent_menu1;
	    }
	  }
    return $parent_menu;
  }
  function onloadsub($action) {
    if ($this->ini_array["menu"]["type"] == "javascript") {
	    if ($action == "top_accueil" || $action == "cms_deconnexion"  || $action == get_constant("CONNECT_ACTION") ) {
	      $onloadtop = "activate_menu('mnu_top_accueil', 'mainmnu_main_accueil');";
	      if ($action == "top_accueil")
	      $onloadtop .= "parent.fcontent.location = '?action=" . get_constant("DEFAULT_ACTION") . "&frame=fcontent'";
	    } else {
        if (isset($this->menus[$action])) {
  	      if ($this->menus[$action]["action_type"] == "submenu")
  	        $action = $this->menus[$action]["sub_default_action"];
  	      $parent_menu = $this->get_parent_name($action);
  	      $onloadtop = "activate_submenu('mainmnu_$parent_menu');";
  	    }
	    }
	  }
    return $onloadtop;
  }
  function onloadtop($action) {
    if ($this->ini_array["menu"]["type"] == "javascript") {
	    if ($action == "top_accueil" || $action == "cms_deconnexion"  || $action == get_constant("CONNECT_ACTION") ) {
	      $onloadtop = "activate_menu('mnu_top_accueil', 'mainmnu_main_accueil');";
	      if ($action == "top_accueil")
	      $onloadtop .= "parent.fcontent.location = '?action=" . get_constant("DEFAULT_ACTION") . "&frame=fcontent'";
	    } else {
        if (isset($this->menus[$action])) {
  	      if ($this->menus[$action]["action_type"] == "submenu")
  	        $action = $this->menus[$action]["sub_default_action"];
  	      $parent_menu = $this->get_parent_name($action);
  	      preg_match("/main_(.*)/", $parent_menu, $matches);
  	      $onloadtop = "activate_menu('mnu_top_$matches[1]', 'mainmnu_main_$matches[1]');";
  	    }
	    }
	  }
    return $onloadtop;
  }
  
  function onloadcontent($action) {
    $onloadcontent = "stabilise();scroll2anchor('" .  gget('ancre') . "');";
    return $onloadcontent;
  }
  
  function get_sessiontimeout() {
    if (!isset($this->sessiontimeout))
      $this->sessiontimeout = "";
    return $this->sessiontimeout;
  }
  
  function _display($action){
    if ($this->ini_array["menu"]["type"] == "javascript")  {
      if (!is_array($this->menus) || sget("reinitmenu") || $this->langue != get_language()) {
        $action = $this->init_menus_javascript($action);
        $this->langue = get_language();
        unset($this->systemmenu);
        unset($this->menusystem);
        sset("reinitmenu", false);
      }
      if (!isset($this->menus[$action]) && $action != get_constant("CONNECT_ACTION")) {
        $rsaction = selectsql("select action from cms.action where name = '$action'", get_constant("DATABASE_MAIN"));
        if ($rsaction != "") {
	        $action = get_constant("CONNECT_ACTION");
	        aset("action", $action);
	     	  $this->visite_url_action = gget("action");
		      if (in_array(gget("mode"), array("zoom", "unzoom")))
		        $this->visite_url = "http://" . $_SERVER["HTTP_HOST"] . nget('REQUEST_URI');
	        $this->hastoconnecte = true;
	      } else {
	        $action = get_constant("DEFAULT_ACTION");
	        $this->hastoconnecte = false;
	      }
      } elseif ($this->menus[$action]["action_type"] == "submenu")
        $action = $this->menus[$action]["sub_default_action"];
      $this->set_logo_app();
    } else {
      if (!is_array($this->menus)) {
        $this->init_menus($action, $action_type);
      }
      $action_type = get_action_type($this->menus, $action, $this->ini_array["menu"]["type"] == "javascript");
      if ($action_type == "submenu" || !action_in_menus($this->menu, $action)) { 
        $this->init_menus($action, $action_type);
      }
    }
    if (gget("report") != "O") {
	    $le_titre = trim(strip_tags(action_title_menus($this->menus, $action, $this->ini_array["menu"]["type"] == "javascript")));
	    if ($le_titre == "" ) {
			  $le_titre = get_constant("APPLICATION_NAME") . " - " . get_constant("APPLICATION_DESCRIPTION" . strtoupper(get_suffix_langue())) ;
		  } else {
		    $le_titre = get_constant("APPLICATION_NAME") . " - " . $le_titre;
      }
        
      entete($le_titre, $description,
        get_constant("KEYWORDS". strtoupper(get_suffix_langue())), "");
      if ($this->ini_array["menu"]["type"] == "javascript")  {
	      reset($this->menutree[top]);
	      $mnu_vars .= "var top_menu = new Array('mnu_"
	        . implode("', 'mnu_",  array_keys($this->menutree[top])) . "');\n";
	      $the_hmenu = $this->get_menu(hmenu, $this->menutree[top], $action, $this->action_tree, "", "");
	      reset($this->menutree[main]);
	      $mnu_vars .= "var main_menu = new Array('mainmnu_"
	        . implode("', 'mainmnu_",  array_keys($this->menutree[main])) . "');\n";
	      while (list($index, $option) = each($this->menutree[main])) {
	        if (is_array($option["menus"])) {
	         $mnu_vars .= "var mainmnu_" . $option[name] . " = new Array('mnu_"
	           . implode("', 'mnu_",  array_keys($option["menus"])) . "');\n";
	          $the_vmenu .= "<div id=\"mainmnu_" . $index . "\" style=\"display:none\">"
	            . $this->get_menu("vmenu", $option["menus"], $action, 
	            $this->action_tree, "", $this->ini_array["general"]["mainmenuimage"] == 1 ? $option[name] : "") . "</div>";
	      }
      }
      $this->js_menu = "<script>$mnu_vars</script>";
    } else {
      $the_hmenu = $this->get_menu(hmenu, $this->menus[top], $action, $this->action_tree);
      $the_vmenu = $this->get_menu(vmenu, $this->menus[main], $action, 
      $this->action_tree, $this->get_swap_js($this->menus[main]));
      $this->js_menu = "";
    } 
    $the_url = update_url_query("?" . nget('QUERY_STRING'), "action", $action);
    $the_url = update_url_query($the_url, "frame");
    $the_url = $the_url . "&";
    $footer = $this->get_skiny("footer", array(
        "ASTUCE" => get_str("lbl_top_of_page", "skin"),
        "SKINCHOICE" => $this->get_skin_choice(),
        "TRADEMARK" => get_str("lbl_trademark", "skin")
        ));
    $the_menusystem = $this->get_menusystem();
    $the_systemmenu = $this->get_systemmenu();
    $sessiontimeout = $this->get_sessiontimeout();
    $frame = gget("frame");
     
    $altcontent = function_exists("app_get_altcontent") ? app_get_altcontent() : "";
    if (gget("resetframes") == "O") {
      $the_url = update_url_query($the_url, "resetframes");
      $frame = ""; 
    }
     if (gget("popup") == "O" || gget("printerfriendly") == "O")
      $boddy_name = "popup";
    else 
      $boddy_name = $frame == "" || $this->ini_array["general"]["frame"] == 0 ? "body" : $frame . "_body";
    $inprogress = get_str("lbl_in_progress", "skin");
    sset("skin", $this);
    if (isset($this->skinies[$boddy_name."_start"])) {
      echo $this->get_skiny($boddy_name."_start", array( 
                "FOOTER" => $footer,
                "HMENU" => $the_hmenu,
                "VMENU" => $the_vmenu,
                "SYSTEMMENU" => $the_systemmenu,
                "MENUSYSTEM" => $the_menusystem,
                "URL" => $the_url,
                "SKINCHOICE" => $this->get_skin_choice(),
                "JSMENU" => $this->js_menu,
                "ONLOADTOP" => $this->onloadtop($action),
                "ONLOADTOPSUB" => $this->onloadsub($action),
                "ONLOADCONTENT" => $this->onloadcontent($action),
                "INPROGRESS" => $inprogress,
                "SUFFIXLANGUE" => get_suffix_langue(),
                "LOGOAPP" => $this->logo_app,
                "LOGOTOP" => $this->logo_top,
                "LOGOFOOT" => $this->logo_foot,
                "ALTCONTENT" => $altcontent
                ));

      $this->content($action);

      echo $this->get_skiny($boddy_name . "_end", array( 
                "FOOTER" => $footer,
                "HMENU" => $the_hmenu,
                "VMENU" => $the_vmenu,
                "SYSTEMMENU" => $the_systemmenu,
                "MENUSYSTEM" => $the_menusystem,
                "URL" => $the_url,
                "SKINCHOICE" => $this->get_skin_choice(),
                "JSMENU" => $this->js_menu,
                "ONLOADTOP" => $this->onloadtop($action),
                "ONLOADTOPSUB" => $this->onloadsub($action),
                "ONLOADCONTENT" => $this->onloadcontent($action),
                "INPROGRESS" => $inprogress,
                "SUFFIXLANGUE" => get_suffix_langue(),
                "LOGOAPP" => $this->logo_app,
                "LOGOTOP" => $this->logo_top,
                "LOGOFOOT" => $this->logo_foot,
                "ALTCONTENT" => $altcontent
                )); 
    } else {
      echo $this->get_skiny($boddy_name, array(
                "FOOTER" => $footer,
                "HMENU" => $the_hmenu,
                "VMENU" => $the_vmenu,
                "SYSTEMMENU" => $the_systemmenu,
                "MENUSYSTEM" => $the_menusystem,
                "URL" => $the_url,
                "SKINCHOICE" => $this->get_skin_choice(),
                "JSMENU" => $this->js_menu,
                "ONLOADTOP" => $this->onloadtop($action),
                "ONLOADTOPSUB" => $this->onloadsub($action),
                "ONLOADCONTENT" => $this->onloadcontent($action),
                "INPROGRESS" => $inprogress,
                "SUFFIXLANGUE" => get_suffix_langue(),
                "LOGOAPP" => $this->logo_app,
                "LOGOTOP" => $this->logo_top,
                "LOGOFOOT" => $this->logo_foot,
                "ALTCONTENT" => $altcontent
                ));
    }
    if ((gget("popup") == "O" || gget("mode") == "report") && gget("noclose") != "O")
          echo "</td></tr></table><br><br>
          <center><input type=\"button\" class=\"formeZoombutton\" value=\"" . get_str("btn_close_window", "skin") . "\" onclick=\"windowclose();\"></center><br><br>";
    pied();
    } else {   
      $this->content($action);
      echo "<br><br>";
    }
  }
  function get_master_logo($foot = false) {
    $email = get_constant("MASTER_LOGO_LINK");
    $logo = filename_with_path("image/" . $this->prefix . "_masterlogo" . ($foot ? "_foot" : "") . ".gif");
    return $this->get_skiny("masterlogo", array( 
            "SRC" => $logo,
            "EMAIL" => $email,
            "COMMENTLINKA" => $email == "" ? "<!-- " : "",
            "COMMENTLINKB" => $email == "" ? " -->" : "",
            "COMMENTLOGOA" => $logo == "" ? "<!-- " : "",
            "COMMENTLOGOB" => $logo == "" ? " -->" : ""
            ));
  }
  function set_logo_top() {
    if (!isset($this->logo_top)) {
      $logoclient = filename_with_path("image/" . $this->prefix . "_logoclient.gif");
	    if ($logoclient != "") {
        $this->logo_top = $this->get_client_logo();
        $this->logo_client = "top";
      } else {
        $this->logo_top = $this->get_master_logo();
        $this->logo_client = "";
      }
	  }
    return $this->logo_top;
  }
  
  function get_client_logo($foot = false) {
    $logoclient = filename_with_path("image/" . $this->prefix . "_logoclient" . ($foot ? "_foot" : "") . ".gif");
    return $this->get_skiny("logoclient", array(  
            "SRC" => $logoclient
            ));
  }
  
  function set_logo_foot() { 
    if (!isset($this->logo_foot)) {
      $logoclient = filename_with_path("image/" . $this->prefix . "_logoclient_foot.gif");
	    if ($logoclient != "")
        $this->logo_foot = $this->get_client_logo(true);
      else
        if ($this->logo_client == "top")
          $this->logo_foot = $this->get_master_logo(true);
    }
    return $this->logo_foot;
  }
  function set_logo_app() {
      $this->logo_app = filename_with_path("image/" . $this->prefix . "_app_logotop" . get_suffix_langue() . ".gif");
      if ($this->logo_app == "")
        $this->logo_app = filename_with_path("image/spacer.gif");
    return $this->logo_app;
  }
  
  function get_menu($menu_name, &$menu, $action, $action_tree, $js = "", $imagename = ""){
    reset($menu);
    while ( list($index, $subarray) = each($menu) ) {
       if ($subarray['visible'] && 
        ( !($subarray['name'] == "cms_connexion" && isloged()) &&
         !($subarray['name'] == "cms_deconnexion" && !isloged())
        ))  {
        if (!is_selected_action($menu, $subarray['name'], $action, $action_tree)) {
          $classname = $menu_name;
        } else { 
          $classname = "selected$menu_name";
        }
        if ($subarray['action_type'] == "url")
          $the_url = $subarray[get_prefix_langue() . 'url'];
        elseif ($subarray['action_type'] == "submenu") {
            $the_url = "#";
        } else 
            $the_url = batir_href_menu($subarray['name'], $subarray['alternate_path'], $subarray['action_type'], $this->ini_array["general"]["useshtml"] == 1);
        $the_target = "";
        if ($this->ini_array["general"]["frame"] || $subarray['target'] == "_blank") {
          if ($subarray['target'] != "")
            $the_target = $subarray['target'];
          else
            $the_target = ($subarray['action_type'] == "url" ||
              $subarray['action_type'] == "menu" ||
              (nget("HTTPS") != "" && !preg_match("/^https/", $the_url)) ||
              (nget("HTTPS") == "" && preg_match("/^https/", $the_url))
              ) ? "_top" : ($subarray['action_type'] == "submenu" ? gget("frame") : "fcontent");
        }
        if ($this->ini_array["general"]["frame"]) {
          $the_frame = ($subarray['target'] != "" ||
             $subarray['action_type'] == "url" ||
             $subarray['action_type'] == "menu" ||  
            (nget("HTTPS") != "" && !preg_match("/^https/", $the_url)) ||
            (nget("HTTPS") == "" && preg_match("/^https/", $the_url))
             )  ? "" : $the_target;
          
        }
        if ($this->ini_array["menu"]["type"] == "javascript") {
          if ($subarray['action_type'] == "url")
            $onclick = $subarray['target'] != "" ? "swap_class('mnu_" . $subarray[name] . "', mainmnu_" . $subarray[parent_name] . ");" : 
              "top.location='".$subarray[get_prefix_langue() . 'url']."'";
          elseif ($menu_name == "hmenu") {
            if (get_constant("AUTO_DEFAULT_ACTION")) {
              preg_match("/top_(.*)/", $subarray['name'], $matches);
              $onclick = "click_menu_full('" . $matches[1] . 
              "', 'mnu_" . $subarray[sub_default_action] ."');";
            } else
              $onclick = "swap_menu('mnu_" . $subarray['name'] . 
              "', 'mainmnu_" . $subarray[default_action_name] ."');";
          } elseif ($menu_name == "vmenu") {
            if ($subarray['action_type'] == "submenu") {
              $onclick = "activate_submenu('mainmnu_" . $subarray['name'] ."');" . (get_constant("AUTO_DEFAULT_ACTION") ? "click_menu('mnu_" . $subarray[default_action_name] ."');" : "");
            } else
              $onclick = "swap_class('mnu_" . $subarray[name] . "', mainmnu_" . $subarray[parent_name] . ");";
          }
        } else
          $onclick = $js;
        
        $the_html .= $this->get_skiny($menu_name . "s", array( 
          "CLASSNAME" => $classname, 
          "ASTUCE" => $subarray[get_prefix_langue().'hint'],
          "STATUS" => addslashes($subarray[get_prefix_langue().'hint']),
          "HREF" => $subarray['action_type'] == "url" ? $subarray[get_prefix_langue().'url']
            : ($the_frame == "" ? update_url_query($the_url, "frame") 
            : update_url_query($the_url, "frame", $the_frame)),
          "ETIQUETTE" => $subarray[get_prefix_langue().'label'],
          "TARGET" => $the_target,
          "NAME" => "mnu_" . $subarray['name'],
          "ONCLICK" => $js,
          "ID" => "mnu_" . $subarray['name'],
          "ONCLICK" => $onclick
          ));
      }}
    if ($imagename != "") {
      $imagename = filename_with_path("image/" . $this->prefix . "_" . $imagename . ".gif");
      if ($imagename != "")
        $image = "<img src=\"$imagename\" border=\"0\" alt=\"\">";
    }
    return $this->get_skiny($menu_name, array( 
          strtoupper($menu_name . "s") => $the_html,
          "IMAGE" => $image));
  }
  
  function content($action) {
    $action_type = get_action_type($this->menus, $action, $this->ini_array["menu"]["type"] == "javascript");
    if (!isloged() && ($this->ini_array["menu"]["type"] == "javascript" 
       ? $this->hastoconnecte : get_restriction($this->menus, $action)  != "")){
	    set_cargo("visite_url_action", isset($this->visite_url_action) ? $this->visite_url_action : gget("action"));
	    if (in_array(gget("mode"), array("zoom", "unzoom"))) {
	      set_cargo("visite_url", isset($this->visite_url) ? $this->visite_url : "https://" . $_SERVER["HTTP_HOST"] . nget('REQUEST_URI'));
	    } 
	    copin_include("form/" . get_constant("CONNECT_ACTION") . "_inc.php");
	    copin_include("form/" . get_constant("CONNECT_ACTION") . ".php"); 
	    show_connexion();
    } else {
      if ($action_type == "html") {
        $content = stripslashes(get_content($this->menus, $action, $this->ini_array["menu"]["type"] == "javascript"));
        $content = preg_replace("/::SKINPATH::/", $this->skin_path . "/", $content);
        $content = preg_replace("/::SKINPREFIX::/", $this->prefix, $content);
        
        echo_box($content, "none", 
          "<big>" . action_title_menus($this->menus, $action, $this->ini_array["menu"]["type"] == "javascript") . "</big>");
      } else { 
        $file_name = "form/" . get_content_name($this->menus, $action, $this->ini_array["menu"]["type"] == "javascript");
        if (copin_include($file_name)) {
          if (function_exists('show')) show($this->menus[$action]["user_right"]);
          elseif (function_exists('show_connexion')) show_connexion();
        } else {
            echo_box(get_str("msg_not_available", "skin"));
        }
      }
    }
  }
  
  function get_skin_array() {
    $paths = explode(":", get_constant("APPLICATION_PATH"));  
    while (list($index, $path) = each($paths)) {
	    $dir = @opendir($path . "skin/");
	    if ($dir){
	      while (false !== ($file_name = readdir($dir)))
	      if (preg_match("/^sk_(.*)/", $file_name, $matches)) {
	        $list[$matches[0]][name] = $matches[0];
	        $list[$matches[0]][label] = $matches[1];
	      } 
	    }
	  }
    sort($list);
    return $list;
  }
  
  function get_skin_choice(){
    if (get_constant("WITH_SKIN_CHOICE")) {
      if (!isset($this->skin_choice)) {
        $the_html = '<form name=skinchoice action="' . get_constant("PATH_STATIC") . '" method=post target="_top"><select name="skin" class="skin" onchange="skinchoice.submit()">';
        $list = $this->get_skin_array();
        reset($list);
        while ( list($index, $subarray) = each($list) ) {
            $the_html .= "<option value=\"$subarray[name]\" " . 
             ($this->name == $subarray["name"] ? "selected" : "") . ">" .
             ucfirst(str_replace("_", " ", $subarray[label]));
        }
        $the_html .= '</select></form>';
        $this->skin_choice = $the_html;
      }
    } else {
      $this->skin_choice = "";
    }
    return $this->skin_choice;
  }
  function get_systemmenu() {
    if (!isset($this->systemmenu)) {
      if (is_array($this->menutreesystem)) {
        reset($this->menutreesystem);
        while ( list($index, $subarray) = each($this->menutreesystem) ) {
          if ($subarray[get_prefix_langue()."image"] != "") {
            $label = "<img name=\"" . $subarray["name"] .
              "\" border=\"0\" src=\"" . $subarray[get_prefix_langue()."image"] . "\">";
            $onmouseover = $subarray["name"] . ".src='"  . $subarray[get_prefix_langue()."image_over"] .  "'";
            $onmouseout = $subarray["name"] . ".src='"  . $subarray[get_prefix_langue()."image"] .  "'";;
          } else {
            $label = $subarray[get_prefix_langue()."label"];
            $onmouseover = "";
            $onmouseout = "";
          }
          if ($subarray['action_type'] == "url") {
            if ($subarray['target'] == "")
              $target = "window";
            else
              $target = $subarray['target'];
            $onclick = "$target.location='" . $subarray[get_prefix_langue() . 'url'] . "'";
          } else {
            preg_match("/main_(.*)/", get_parent_action($this->menus,  $subarray[filename]), $matches);
            $onclick = "click_menu_full('" . $matches[1] . 
                "', 'mnu_" . $subarray[get_prefix_langue() .filename] ."');";
          }
           $systemmenus .= $this->get_skiny("systemmenus", array(
            "ETIQUETTE" =>  $label,
            "ASTUCE" => $subarray[get_prefix_langue()."hint"],
            "ONCLICK" => $onclick,
            "ONMOUSEOVER" => $onmouseover,
            "ONMOUSEOUT" => $onmouseout
            ));
        }
        $this->systemmenu = $this->get_skiny("systemmenu", array(
                  "SYSTEMMENUS" => $systemmenus
                  ));
      }
    }
    return $this->systemmenu;
    
  }
  
	function get_menusystem(){
  if (!isset($_SESSION["label_system"]) || get_constant("DEBUG_FIELDS")) {
     copin_include("lib/label_" . get_language_code() . ".php");
  }
	  if (!isset($this->menusystem)) {
		  $this->menusystem = $this->get_skiny("menusystem", array(
            "FERMER_COMMENTA" => (isloged() ? "" : "<!-- "),
            "FERMER_COMMENTB" => (isloged() ? "" : " -->"),
            "FERMER_ASTUCE" => is_primary_language() ? "Fermer la session" : "Log Off",
            "ACCUEIL_ASTUCE" => is_primary_language() ? "Accueil" : "Home",
            "ACCUEIL_URL_ACTION" => get_constant("DEFAULT_ACTION"),
		        "EMAIL_ASTUCE" => get_constant("SYSTEM_MAILTO") != "" ? get_label('system_email') : "",
		        "EMAIL_SUBJECT" => get_constant("SYSTEM_MAILTO") != "" ? get_str("msg_email_subject", "skin") : "",
		        "EMAIL_MAILTO" => get_constant("SYSTEM_MAILTO") != "" ? get_constant("SYSTEM_MAILTO") : "",
		        "EMAIL_COMMENTA" => get_constant("SYSTEM_MAILTO") != "" ? "" : "<!-- ",
		        "EMAIL_COMMENTB" => get_constant("SYSTEM_MAILTO") != "" ? "" : " -->",
		        "LANGUE_ASTUCE" => $_SESSION["label_system"]["lbl_".get_invert_language_code()],
		        "LANGUE_URL" => batir_href_anglais_francais("cms_accueil", $this->ini_array["general"]["useshtml"] == 1),
		        "LANGUE_URL_FOOTER" => update_url_query(batir_href_anglais_francais("cms_accueil", $this->ini_array["general"]["useshtml"] == 1), "frame", "fbottom"),
		        "ONCLICK" => "location='" . batir_href_anglais_francais("cms_accueil", $this->ini_array["general"]["useshtml"] == 1) . "'",
		        "LANGUE_LANGUE" => get_suffix_langue(),
		        "LANGUAGE_COMMENTA" => (get_constant("ALTERNATE_LANGUAGE_PRESENT") ? "" : "<!-- "),
		        "LANGUAGE_COMMENTB" => (get_constant("ALTERNATE_LANGUAGE_PRESENT") ? "" : " -->"),
		        "DIAGNOSTIC_ASTUCE" => is_primary_language() ? "Diagnostic" : "Troubleshooting",
		        "DIAGNOSTIC_URL" => update_url_query(batir_href("cms_diagnostic"), "frame", $this->ini_array["general"]["frame"] ? "fcontent" : null)
		        ));
	   }
	   return $this->menusystem;
	}
  
  //retourne le html d'un skiny
  function get_skiny($skiny, $tags){
    /*
    effectue le remplacement des tags dans le skiny demand
    retoune le html rsultant
    */
    $skiny = $this->skinies[$skiny];
    while (list($tag, $value) = each($tags)) { 
      $skiny = preg_replace("/::$tag::/", $value, $skiny);
    }
    $skiny = preg_replace("/::SKIN_PATH::/", $this->skin_path, $skiny);
    return $skiny;
  }
} 
?>