<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * Formulaire ditable
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp
copin_include("lib/class.formbase.php");
copin_include("lib/html_control.php");

/**
 * Formulaire ditable
 *
 * Sur deux colonnes
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */

class FormZoom extends FormBase {
  var $_rs;
  var $_fields;
  var $_default_width = 200;
  var $_sections;
  var $_spacers;
  var $_use_parent_where;

  var $_validation_js;
  var $_form_action; 
  var $_hide_header = false;
  var $_hide_footer = false;

  var $_error_update = false;
  var $outlineclass = "formeZoom";
  var $_use_parent_where = false;
  var $use_autoinitialise = false;
  var $autoinitialisevar = "";
  var $tabulatorwidth = "100%";
  var $detailedon = false;
  var $detailed = false;
  var $formname = "forme";
  var $get_post = false;
  var $use_master_filter_value = false;
  var $handelsavedetails = false;
  var $back_in_title = true;

  function FormZoom($sql, $key = "", $connect = null) {
    $this->FormBase($sql, $key, $connect);
    // chargement du fichier lexique correspondant a l'action
    $this->action4lexique = gget("action");
    // inclusion du array $index_array
    $lexique_file = get_lexique_file_name(gget("action"));
    if ($lexique_file != "") 
      include get_constant("PATH_LEXIQUE_FILE") . $lexique_file;
    else 
      $index_array = array();
    $this->index_array = $index_array;
    
    if(is_array($this->_fields)) {
      reset($this->_fields);
      while (list($index) = each($this->_fields)) {
        $this->_init_field($index);
      }
      if ($this->_fields[$key]["validation_type"] == "string") {
        $this->_fields[$key]["nospace"] = true;
        $this->_fields[$key]["msg"] = $this->_get_error_msg($this->_fields[$key]);
      }
    }
    $this->globaltable();
  }
  
  function _init_field($index) {
    $this->_fields[$index]["name"] = "fld_" . $index;
    $this->_fields[$index]["defaut"] = "";
    $this->_fields[$index]["defautfunction"] = "";
    $this->_fields[$index]["initializevalue"] = "";
    $this->_fields[$index]["initializefunction"] = "";
    $this->_fields[$index]["value"] = "";
    $this->_fields[$index]["mask"] = "";
    $this->_fields[$index]["height"] = 150;
    $this->_fields[$index]["width"] = $this->_default_width;
    $this->_fields[$index]["default_width"] = true;
    $this->_fields[$index]["html_type"] = "textbox";
    $this->_fields[$index]["html_class"] = "";
    $this->_fields[$index]["leschoix"] = array ();
    $this->_fields[$index]["leschoixfunction"] = "";
    $this->_fields[$index]["updatable"] = "O";
    $this->_fields[$index]["visible"] = "O";
    $this->_fields[$index]["ro_save"] = false;
    $this->_fields[$index]["msg"] = $this->_get_error_msg($this->_fields[$index]);
    $this->_fields[$index]["prompt_msg"] = get_str("prompt_msg", "FormZoom") . $this->_fields[$index]["label"] . "&quot;";
    $this->_fields[$index]["hint"] = "";
    $this->_fields[$index]["unique_error_msg"] = $this->unique_error_msg($index);
    $this->_fields[$index]["validation_js"] = "";
    $this->_fields[$index]["separate_save"] = "";
    $this->_fields[$index]["separate_insert"] = "";
    $this->_fields[$index]["toupper"] = false;
    $this->_fields[$index]["compare"] = false;
    $this->_fields[$index]["lexique"] = $this->_is_found_in_lexique($index, $this->index_array, $this->action4lexique);
    $this->_fields[$index]["boutonjs"] = "";
    $this->_fields[$index]["boutonjs_ropresent"] = false;
    $this->_fields[$index]["index_zoom"] = null;
    $this->_fields[$index]["detailed"] = false;
    $this->_fields[$index]["nospace"] = false;
    $this->_fields[$index]["tabulator"] = "";
    $this->_fields[$index]["temphidden"] = false;
    $this->_fields[$index]["use_autoinitialise"] = false;
    $this->_fields[$index]["showrequired"] = false;
    $this->_fields[$index]["max"] = "";
  }
  
  function add_field($fieldname, $position, $binded = true) {
    parent::add_field($fieldname, $position, $binded);
    $this->_init_field($fieldname);
  }
  
  function handelsavedetails(){
    $this->handelsavedetails = true;
  }
  
  function use_master_filter_value($fieldname = null) {
    $this->use_master_filter_value = true;
    $this->quick_filter = $fieldname;
  }
  
  function unique_error_msg($fieldname, $langue = null){
    return sprintf(get_str("msg_duplicate", "FormZoom"), $this->_fields[$fieldname]["label"]);
  }
  
  function back_in_title($value = true){
    $this->back_in_title = $value;
  }
  
  function validation_type($fieldname, $validation_type){
    $this->set_property($fieldname, "validation_type", $validation_type);
    $this->_fields[$fieldname]["msg"] = $this->_get_error_msg($this->_fields[$fieldname]);
  }
  
  function tabulatorwidth($width){
    $this->tabulatorwidth = $width;
  }
  
  function tabulator($fieldname, $tabulator, $titre = ""){
    if (!isset($this->tabulators))
      $this->activtab = $tabulator;
    $this->tabulators[$tabulator]["titre"] = $titre;
    if (is_array($fieldname)){
      while (list($index, $subarray) = each($fieldname))
       if (isset($this->_fields[$subarray]))
         $this->_fields[$subarray]["tabulator"] = $tabulator;
    } else {
      if (isset($this->_fields[$fieldname]))
        $this->_fields[$fieldname]["tabulator"] = $tabulator;
    }
  }


  // Verifie si le champ possede une entree dans le lexique
  function _is_found_in_lexique($nomduchamp, $index_array, $action) {
    $lexique_target = "";
    reset($index_array);
    while (list($index, $subarray) = each($index_array)){
        if ($subarray["target"] == $action . $nomduchamp) {
            $lexique_target = $action . $nomduchamp;
        } else if ($subarray["target"] == $nomduchamp) {
            $lexique_target = $nomduchamp;
        }
    }

    return $lexique_target;
  }


  function g_custom($function_name, $alt, $label, $with_submit = false){
    FormBase::g_custom($function_name, $alt, $label);
    $this->_g_custom[$function_name]["with_submit"] = $with_submit;
  }
  
  function set_validation_js($fieldname, $validation_js){
    $this->set_property($fieldname, "validation_js", $validation_js);
  }
  
  function boutonjs($fieldname, $js){
    $this->set_property($fieldname, "boutonjs", $js);
  }
  
  function boutonjs_icon($fieldname, $icon){
    $this->set_property($fieldname, "boutonjs_icon", $icon);
  }
  function boutonjs_title($fieldname, $boutonjstitle){
    $this->set_property($fieldname, "boutonjstitle", $boutonjstitle);
  }
  
  function boutonjs_ropresent($fieldname, $ropresent){
    $this->set_property($fieldname, "boutonjs_ropresent", $ropresent);
  }
  
  function set_unique_error_msg($fieldname, $unique_error_msg){
    $this->set_property($fieldname, "unique_error_msg", $unique_error_msg);
  }

  function set_form_action($form_action) {
    $this->_form_action = $form_action;
  }

  function auto_format($fieldname, $format){
    $this->set_property($fieldname, "html_attribut", " onblur=\"autoformat(this, '$format');\"");
  }
  
  function get_validation_js($htmlwindows_title = "", $htmlwindows_desc = "") {
    return get_js_script($this->_fields, $htmlwindows_title, $htmlwindows_desc);
  }

  function use_parent_where(){
    $this->_use_parent_where = true;
  }

  function use_autoinitialise($fieldname, $autoinitialisevar = null){
    $this->use_autoinitialise = true;
    if (!isset($autoinitialisevar))
      $this->autoinitialisevar = $this->_name;
    else
      $this->autoinitialisevar = $autoinitialisevar;
    $this->set_property($fieldname, "use_autoinitialise", true);
  }
  
  function detailed($fieldname){
    $this->detailed = true;
    $this->set_property($fieldname, "detailed", true);
  }
  
  function resetdetailedhidden(){
    reset($this->_fields);
    while (list($index) = each($this->_fields))
      if ($this->_fields[$index]["detailed"])
        $this->_fields[$index]["temphidden"] = !$this->detailedon;
  }
  
  function url_detailed(&$fm){
    $this->detailedon = !$this->detailedon;
    $this->resetdetailedhidden($newtab);
    
    $this->get_post = true;
    $this->_display($fm, $this->_index);
    $this->get_post = false;
  }
  
  function permit_null($fieldname){ 
    $this->set_property($fieldname, "null", "O");
  }
  function temphidden($fieldname, $value){ 
    $this->set_property($fieldname, "temphidden", $value);
  }

  function hidden($fieldname){
    $this->set_property($fieldname, "html_type", "hidden");
  }

  function maxlen($fieldname, $max){
    $this->set_property($fieldname, "maxlen", $max);
  }

  function no_update($fieldname = ""){
    if ($fieldname == "") {
      $this->_no_update = true;
    } else {    
      $this->set_property($fieldname, "updatable", "N");
    }
  }
 
  function yes_update($fieldname = null) {
    if (isset($fieldname))
      $this->set_property($fieldname, "updatable", "O");
    else
      parent::yes_update();
  }
  
  function no_insert_button($value = true) {
    $this->no_insert_button = $value;
  }
  
  function set_compare($fieldname){
    $this->set_property($fieldname, "compare", true);
  }

  function yes_save() {
    $this->_no_save = false;
  }
  
  function yes_delete() {
    $this->_no_delete = false;
  }
  
  function ro_save($fieldname) {
    $this->set_property($fieldname, "ro_save", true);
  }

  function get_prev(){
    $lindex = gget("index");
    if ($this->_index != "")
      $lindex = selectsql(
                  "SELECT " . $this->get_key() .
                  " FROM " . $this->_sql->get_table_name() .
                  " WHERE " . $this->get_key() . " = (SELECT MAX(" .
                  $this->get_key() . ") FROM " . $this->_sql->get_table_name() .
                  " WHERE " . $this->get_key() . " < " . wrap($this->_index) . ")", $this->_alt_bd);
    return $lindex;
  }

  function get_next(){
    $lindex = gget("index");
    if ($this->_index != "")
      $lindex = selectsql(
                  "SELECT " . $this->get_key() .
                  " FROM " . $this->_sql->get_table_name() .
                  " WHERE " . $this->get_key() . " = (SELECT MIN(" .
                  $this->get_key() . ") FROM " . $this->_sql->get_table_name() .
                  " WHERE " . $this->get_key() . " > " . wrap($lindex) . ")", $this->_alt_bd);
    return $lindex;
  }

  function get_first() {
    return $this->_sql->SelectFirst($this->get_key());
  }

  function get_last(){
    return $this->_sql->SelectLast($this->get_key());
  }

  function url_zoom(&$fm){
    if ($this->detailed) {
      $this->resetdetailedhidden();
    }
    if (isset($this->tabulators)){
      $tabulators = array_keys($this->tabulators);
      $this->activtab = $tabulators[0];
      $this->resettabhidden($this->activtab);
    }
    $this->_index = gget("index");
    $this->show($fm);
  }

  function url_unzoom(&$fm){
    $fm->dispatch($this->_parent);
  }
  
  function url_saveunzoom(&$fm){
    $result = $this->{$this->_mode}($fm);
    if ($result == "") {
      $this->url_unzoom($fm);
    } else {
      $this->restore_save($fm, $result);
    }
  }
  
  function _get_error_msg(&$field){
    if ($field["validation_type"] == "time") {
	    $error_msg .= get_str("error_time", "FormZoom");
	  } elseif ($field["validation_type"] == "real"){
	    $error_msg .= get_str("error_real", "FormZoom");
	  } elseif ($field["validation_type"] == "integer"){
	    $error_msg .= get_str("error_integer", "FormZoom");
	  } elseif ($field["validation_type"] == "date"){
	    $error_msg .= get_str("error_date", "FormZoom");
	  } elseif ($field["validation_type"] == "email"){
	    $error_msg .= get_str("error_email", "FormZoom");
	  } elseif ($field["nospace"]){
	    $error_msg .= get_str("error_nospace", "FormZoom");    
	  }
	  if (isset($field["min"])) { 
	    $error_msg .= ($field["null"] == "N" ? ", " : get_str("error_and", "FormZoom"))
	      . get_str("error_min", "FormZoom") . $field["min"];
	  }
	  if ($field["null"] == "N") {
	    if ($error_msg != "")
	      $error_msg .= get_str("error_andcompulsory", "FormZoom");
	    else
	      $error_msg .= get_str("error_compulsory", "FormZoom");
	  }
	  $error_msg = sprintf(get_str("error_field", "FormZoom"), trim(preg_replace("/\*/", "", strip_tags($field["label"])))) . $error_msg . ".";
    return $error_msg;
  }
  
  function insert_section_before($fieldname, $titre = ""){
    if (isset($this->_fields[$fieldname])) {
      $this->_sections[$fieldname]["before"] = $titre;
    }
  }
  function insert_section_after($fieldname, $titre = ""){
    if (isset($this->_fields[$fieldname])) {
      $this->_sections[$fieldname]["after"] = $titre;
    }
  }
  function insert_phantomsection_before($fieldname, $titre = ""){
    if (isset($this->_fields[$fieldname])) {
      $this->_phantomsections[$fieldname]["before"] = $titre;
    }
  }
  
  function insert_spacer_before($fieldname){
    if (isset($this->_fields[$fieldname]))
    $this->_spacers[$fieldname]["before"] = "O";
  }
  function insert_spacer_after($fieldname){
    if (isset($this->_fields[$fieldname]))
    $this->_spacers[$fieldname]["after"] = "O";
  }
  function insert_phantomspacer_before($fieldname, $titre = ""){
    if (isset($this->_fields[$fieldname]))
    $this->_phantomspacer[$fieldname]["before"] = $titre;
  }

  function edithtml($fieldname){
    $this->set_property($fieldname, "html_type", "edithtml");
  }

  function hint($fieldname, $hint) {
    $this->set_property($fieldname, "hint", $hint);
  }

  function memo($fieldname){
    $this->set_property($fieldname, "html_type", "memo");
  }

  function boolean($fieldname){
    $this->set_property($fieldname, "html_type", "checkbox");
  }

  function radio($fieldname, $leschoix){
    $this->set_property($fieldname, "html_type", "radio");
    $this->set_property($fieldname, "leschoix", $leschoix);
  }
  
  function pick_listplus($fieldname, $leschoix){
    $this->set_property($fieldname, "html_type", "selectplus");
    $this->set_property($fieldname, "leschoix", $leschoix);
  }

  function pick_listedit($fieldname, $leschoix){
    $this->set_property($fieldname, "html_type", "selectedit");
    $this->set_property($fieldname, "leschoix", $leschoix);
  }
  
  function pick_listeditfunction($fieldname, $leschoixfunction){
    $this->set_property($fieldname, "html_type", "selectedit");
    $this->set_property($fieldname, "leschoixfunction", $leschoixfunction);
  }
  
  function pick_listedit_jsonclick($fieldname, $value){
    $this->set_property($fieldname, "pick_listedit_jsonclick", $value);
  }
  
  function showrequired($fieldname, $value){
    $this->set_property($fieldname, "showrequired", $value);
  }
  
  function calendar($fieldname){
    $this->set_property($fieldname, "html_type", "calendar");
    $this->set_property($fieldname, "mask", get_constant("CALENDAR_VALIDATION_MASK"));
  }
  
  function textbox($fieldname){
    $this->set_property($fieldname, "html_type", "textbox");
    $this->set_property($fieldname, "mask", "");
  }

  // pour les arrays dans les champs.
  function text_array($fieldname, $nb = 1){
    $this->set_property($fieldname, "html_type", "array");
    $this->set_property($fieldname, "validation_type", "array");
    $maxlen = $this->_fields[$fieldname]["maxlen"];
    $this->set_property($fieldname, "total_maxlen",$nb * $maxlen); 
  }

//*support image
  function image($fieldname){
    $this->set_property($fieldname, "html_type", "image");
    $this->set_property($fieldname, "updatable", "N");
  }
  
  function dateyear($fieldname){
    $this->set_property($fieldname, "html_type", "dateyear");
    $this->set_property($fieldname, "display_format", "dateyear");
    $this->set_property($fieldname, "validation_type", "dateyear");
    $this->set_property($fieldname, "mask", "YYYY");
  }

  function dateyearmonth($fieldname){
    $this->set_property($fieldname, "html_type", "dateyearmonth");
    $this->set_property($fieldname, "display_format", "dateyearmonth");
    $this->set_property($fieldname, "validation_type", "dateyearmonth");
    $this->set_property($fieldname, "mask", "YYYY/MM");
  }
  
  function dollar($fieldname){
    $this->set_property($fieldname, "html_type", "dollar");
    $this->set_property($fieldname, "html_class", "number");
    $this->set_property($fieldname, "display_format", "dollar");
  }
  
  function toupper($fieldname){
    $this->set_property($fieldname, "toupper", true);
  }

  function pourcentage($fieldname){
    $this->set_property($fieldname, "html_type", "pourcentage");
    $this->set_property($fieldname, "display_format", "pourcentagezoom");
  }

  function password_confirm($fieldname){
    $this->set_property($fieldname, "html_type", "password_confirm");
  }

  function password($fieldname){
    $this->set_property($fieldname, "html_type", "password");
  }

  function required($fieldname, $required = true){
    $permitnull = $required ? "N" : "O";
    if (is_array($fieldname)){
      while (list($index, $subarray) = each($fieldname))
        if (isset($this->_fields[$subarray])){
          $this->set_property($subarray, "null", $permitnull);
          $this->_fields[$subarray]["msg"] = $this->_get_error_msg($this->_fields[$subarray]);
        }
    } else {
      if (isset($this->_fields[$fieldname])) {
        $this->set_property($fieldname, "null", $permitnull);
        $this->_fields[$fieldname]["msg"] = $this->_get_error_msg($this->_fields[$fieldname]);
      }
    }
  }

  function mask($fieldname, $mask){
    $this->set_property($fieldname, "mask", $mask);
  }
  function sql_notnull($fieldname){
    $this->_sql->sql_notnull($fieldname);
  }
  
  function defaut($fieldname, $defaut){
    $this->set_property($fieldname, "defaut", $defaut);
  }
  function defautfunction($fieldname, $defautfunction){
    $this->set_property($fieldname, "defautfunction", $defautfunction);
  }
  
  function initializevalue($fieldname, $value){
    $this->set_property($fieldname, "initializevalue", $value);
  }
  
  function initializefunction($fieldname, $function){
    $this->set_property($fieldname, "initializefunction", $function);
  }
  
  function nospace($fieldname, $value = true){
    $this->set_property($fieldname, "nospace", $value);
    // arranger pour les array
    $this->_fields[$fieldname]["msg"] = $this->_get_error_msg($this->_fields[$fieldname]);
  }

  function prompt_msg($fieldname, $prompt_msg){
    $this->set_property($fieldname, "prompt_msg", $prompt_msg);
  }

  function between($fieldname, $min = null, $max = null){
    $this->set_property($fieldname, "min", $min);
    $this->set_property($fieldname, "max", $max);
    if (is_array($fieldname)){
      while (list($index, $subarray) = each($fieldname)) { 
       if (isset($this->_fields[$subarray]))
         $this->_fields[$subarray]["msg"] = $this->_get_error_msg($this->_fields[$subarray]);
      }
    } else {
      if (isset($this->_fields[$fieldname]))
        $this->_fields[$fieldname]["msg"] = $this->_get_error_msg($this->_fields[$fieldname]);
    }
  }
  

  function label($fieldname, $nouveaulabel){
    if (isset($this->_fields[$fieldname])) {
      FormBase::label($fieldname, $nouveaulabel);
      $this->_fields[$fieldname]["msg"] = $this->_get_error_msg($this->_fields[$fieldname]);
      $this->_fields[$fieldname]["prompt_msg"] = get_str("prompt_msg", "FormZoom") . $this->_fields[$fieldname]["label"] . "&quot;";
    }
  }
  
  function get_section($titre){
    echo "<tr><td class=\"formeSection\">$titre&nbsp;</td><td class=\"formeSection\">&nbsp;</td></tr>";
  }

  function get_spacer(){
    echo "<tr><td class=\"formeSpacer\">&nbsp;</td><td class=\"formeSpacer\">&nbsp;</td></tr>";
  }

  function get_left($lindex){
    if (!$this->_no_navigate) {
      echo "<td><input class=\"formeZoombutton\" type=\"button\" value=\"&nbsp;|&lt;&nbsp;\" " .
       ($this->_sql->SelectFirst($this->_key) == $lindex ? "DISABLED" : "") . " onclick=\"window.location='".
       $this->add_parametre($this->_url, "mode=move_first") . "'\">
         <input class=\"formeZoombutton\" type=\"button\" value=\"&nbsp;&lt;&nbsp;\" " .
         ($this->_sql->SelectFirst($this->_key) == $lindex ? "DISABLED" : "") . " onclick=\"window.location='" .
          $this->add_parametre($this->_url, "mode=move_prev&index=" . $lindex) . "'\"></td>";
    }
  }
  function get_right($lindex){
    if (!$this->_no_navigate) {
      echo "<td align=right><input class=\"formeZoombutton\" type=\"button\" value=\"&nbsp;&gt;&nbsp;\" " .
      ($this->_sql->SelectLast($this->_key) == $lindex ? "DISABLED" : "") . " onclick=\"window.location='" .
       $this->add_parametre($this->_url, "mode=move_next&index=" . $lindex) . "'\">
          <input class=\"formeZoombutton\" type=\"button\" value=\"&nbsp;&gt;|&nbsp;\" " .
           ($this->_sql->SelectLast($this->_key) == $lindex ? "DISABLED" : "") . " onclick=\"window.location='" .
           $this->add_parametre($this->_url, "mode=move_last") . "'\"></td>";
    }
  }
  function get_backbutton($small = false){
    if (isset($this->_parent)) {
	    $size = $small ? 27 : 34;
	    $sml = $small ? "sml" : "";
	    return "<input class=\"formeZoombutton\" type=\"BUTTON\" style=\"background-image: url(" . sget("forms_image_dir") . "saveunzoom.gif); height: $size; width: $size;\"
	    onclick=\"" . get_js_script_no_submit($this->_fields, $this->formname) .  " else {document.$this->formname.action='" . $this->add_parametre($this->_url, "mode=saveunzoom&ancre=" . $this->_parent). "'; document.$this->formname.submit();}\"
	    title=\"" . get_str("alt_saveandgo", "FormZoom") . "\">"
	    . "<input class=\"formeZoombutton\" type=\"BUTTON\" style=\"background-image: url(" . sget("forms_image_dir") . "unzoom.gif); height: $size; width: $size;\"
	    onclick=\"window.location='" . $this->add_parametre($this->_url, "mode=unzoom&ancre=" . $this->_parent). "'\"
	    title=\"" . get_str("alt_go", "FormZoom") . "\">";
	  } else
	    return "";
  }

  function get_header(&$fm, $lindex){
    if (!$this->_no_navigate || (isset($this->_parent) && !$this->back_in_title) || $this->detailed) {
      echo "<tr><td colspan=2 align=center>
        <table width=100%>
        <tr>";
      $this->get_left($lindex);
      if ($this->detailed && $this->_mode != "insert") { 
        echo "<td width=35%>&nbsp;</td>";
      }
      if (isset($this->_parent) && !$this->back_in_title) { 
        echo "<td align=center>";
        echo $this->get_backbutton();
        echo "</td>";}
        if ($this->detailed && $this->_mode != "insert") { 
          $onclick = " onclick=\"" . $this->formname . ".action='" . $this->add_parametre($this->_url, "mode=detailed&ancre=" . $this->_name)  . "';$this->formname.submit();\""; 
          echo "<td align=right width=35% nowrap>
              <input type=\"radio\" name=\"ee\" class=\"inputradio\" " .
               (!$this->detailedon ? "checked"  : $onclick) .
               "> <label style=\"cursor:arrow\" control=\"ee\"" .
                (!$this->detailedon ? ""  : $onclick) . ">" .
                get_str("alt_summary", "FormZoom") .
                 "</label>&nbsp;<input type=\"radio\" name=\"ee\" class=\"inputradio\" " .
                 ($this->detailedon ? "checked"  : $onclick) . "><label style=\"cursor:arrow\" " .
                 ($this->detailedon ? ""  : $onclick) . ">" . 
                 get_str("alt_detail", "FormZoom") . "</label></td>";
        }
        $this->get_right($lindex);
        echo "</tr></table></td></tr>";
    }
  }

  function get_footer(&$fm, $lindex){
    $this->get_left($lindex);
    echo "<td align=center>";
    if (!$this->_no_update && (($this->_no_save && $this->_mode == "insert") || !$this->_no_save))
      echo get_formbutton($this->_fields, $this->_buttonlabel_save);

    if (!$this->_no_insert && !$this->_no_update && $this->_mode != "insert" && !$this->no_insert_button) {
      echo "<input class=\"formeZoombutton\" type=\"button\" value=\"" .
      $this->_buttonlabel_add . "\" onclick=\"window.location='" .
      $this->add_parametre($this->_url, "mode=add") . "'\">";
    }
     
    if (!$this->_no_delete && !$this->_no_update && $this->_mode != "insert")  {
      $multi_delete = false;
      $count = 0;
      if (isset($fm->_forms[$this->_name][details])){
        reset($fm->_forms[$this->_name][details]);
        while (list($index, $subarray) = each($fm->_forms[$this->_name][details])){
          $the_form = &$fm->get_form($subarray);
          $count += $the_form->_sql->_nb_enregistrement;
        }
      }
      $multi_delete = ($count > 0);
      echo get_deletebutton($this->add_parametre($this->_url, "mode=erase"),
                              $multi_delete,
                              $this->_buttonlabel_erase,
                              $this->_buttonlabel_erase_msg,
                              $this->_buttonlabel_multierase_msg, "");
    }
    
    if (!$this->_no_update && !$this->_no_cancel) {
      echo "<input class=\"formeZoombutton\" type=\"button\" value=\"" .
      $this->_buttonlabel_cancel . "\" onclick=\"window.location='" .
      $this->add_parametre($this->_url, "mode=cancel") . "'\">";
    }
    echo "</td>";
    
    $this->get_right($lindex);
  }
  
  function get_fieldboutonjs($index){
    if ($this->_fields[$index]["boutonjs"] != "") {
      $js = $this->_fields[$index]["boutonjs"];
      if (preg_match_all("/(.*)\*\*\*(.*)\*\*\*(.*)/U", $js, $matches)){
        $js1 = ""; 
        while (list($index, $subarray) = each($matches[1])){
          $js1 .= $subarray . addslashes($this->format($this->_rs[$matches[2][$index]], $this->_fields[$matches[2][$index]]["display_format"], "", $matches[2][$index]));
        }
        preg_match("/.*\*\*\*.*\*\*\*(.*)/", $js, $matches);
        $js = $js1 . $matches[1];
      } 
      $value = $this->_fields[$index]["boutonjs_icon"] == "" ? "value=\"&nbsp;...&nbsp;\"" : " style=\"background-image: url(" . 
      sget("forms_image_dir") . $this->_fields[$index]["boutonjs_icon"] . "); background-repeat: no-repeat; background-position: center; height: 19; width: 19;\" ";
      return "<input class=\"formeZoombutton\" type=\"button\" " . ($this->_fields[$index]["boutonjstitle"] != "" ? " title=\"" . $this->_fields[$index]["boutonjstitle"] . "\"" : "") . "
         $value onclick=\"" . $js . "\">";
    }
  }
  function get_fieldtd($index, $value, $no_update = null) {  
    if (!isset($no_update))
      $no_update = (($this->_fields[$index]["ro_save"] 
        && $this->_mode != "insert") ? true : 
        ($this->_no_update || ($this->_mode != "insert" && $this->_no_save)));
    $hint = $this->_fields[$index]["hint"];
    $hint_div = "";
    if ($hint != "") {
      $hint_div = "<div id=\"lbl_$index" . $this->_fields[$index]["index_zoom"]. "\" title=\"" . $hint . "\">";
    } else
      $hint_div = "<div id=\"lbl_$index" . $this->_fields[$index]["index_zoom"] . "\">";
    $lexique = "";
    if ($this->_fields[$index]["lexique"] != "" && !$this->printerfriendly) {
      $lexique = lexique($this->_fields[$index]["lexique"]);
    }
    $withlabel = $this->_fields[$index]["html_type"] != "select" 
      && $this->_fields[$index]["html_type"] != "selectcolor" 
      && $this->_fields[$index]["updatable"] == "O" && !$no_update;
    echo "<td class=\"formeZoomCol1\"" . (($this->_fields[$index]["html_type"] == "memo") ? " style=\"vertical-align:top;\"" : "") . ">" .
          $hint_div . $lexique . ($withlabel ? "<label for=\"id_" . $this->_fields[$index]['name']. "\" style=\"cursor: arrow;\">" : "") . $this->_fields[$index]["label"]
          . ($this->_fields[$index]["updatable"] != "N" 
             && !$this->_no_update 
             && $this->_fields[$index]["html_class"] != "nonEditable"
             && $this->_fields[$index]["null"] == "N"
             && (!in_array($this->_fields[$index]["html_type"],
             array("checkbox", "password_confirm", "selectplus",  "selectedit", "select"))
             || $this->_fields[$index]["showrequired"])
            ? "&nbsp;*" : "&nbsp;&nbsp;")  .
          ($withlabel ? "<label>" : "") . "</div></td>";
    $lehtml = $this->get_tdcontrol(
          $this->_fields[$index],
          $this->format($value, $this->_fields[$index]["display_format"], "", $index),
          $no_update,
          ($this->_fields[$index]["boutonjs_ropresent"] ? $this->get_fieldboutonjs($index) : "" ),
          $this->formname, $this->_alt_bd);
      
    if (!$no_update && $this->_fields[$index]["updatable"] == "O") {
      $lehtml .= $this->get_fieldboutonjs($index);
    }
    $lehtml = "<td" . (($this->_fields[$index][html_class] != "" && 
         $this->_fields[$index]["html_type"] != "textbox" && 
         $this->_fields[$index]["html_type"] != "select" && 
         $this->_fields[$index]["html_type"] != "selectplus") ? " class=" . 
         $this->_fields[$index][html_class] : "") . ">" .
         $hint_div . $lehtml . "</div></td>";
    echo $lehtml;
  }
  
  function get_fieldtr($index, $value){
    if ($this->_fields[$index]["compare"])
      $value = "";
    $no_update = (($this->_fields[$index]["ro_save"] && 
      $this->_mode != "insert") ? true : ($this->_no_update
      || ($this->_mode != "insert" && $this->_no_save)));
    if (($this->_fields[$index]["html_type"] != "password" 
      && $this->_fields[$index]["html_type"] != "password_confirm" 
      && $no_update) || !$no_update) {
      if ($this->_fields[$index]["html_type"] == "hidden" 
        || $this->_fields[$index]["temphidden"]) {
        $lehtml = get_control(
           $this->_fields[$index],
           $this->format($value, $this->_fields[$index]["display_format"], "", $index),
           false, null, null, $this->_alt_bd);
        echo $lehtml;
      } else {
        echo "<tr>";
        $this->get_fieldtd($index, $value, $no_update);
        echo "</tr>\n";
      }
    }
  }
  
  function set_rs($lindex = null){
    if ($this->_error_update || $this->printerfriendly || $this->get_post) {
      if(is_array($this->_fields)) {
        reset($this->_fields);
        while (list($index, $subarray) = each($this->_fields)){
          $value = pget($subarray["name"].$subarray["index_zoom"]);
          $value = ($subarray["validation_type"] == "real" ? preg_replace("/,/", "", $value) : $value );
          if ($subarray["html_type"] == "checkbox"){
              if ($value == "")
                $value = $subarray["non"];
          } elseif ($subarray["html_type"] == "edithtml" && $value == "lecontenuoriginal") {
            $value = $this->_rs[$index];
          } elseif (preg_match("/prefix:(.+)/", $this->_fields[$index]["display_format"], $matches)) {
            $value = preg_replace("/^".$matches[1]."/", "", $value);
          }
          $this->_rs[$index] = $value;
        }
        if ($this->use_autoinitialise) {
          $autoinitialisevar = sget($this->autoinitialisevar);
          reset($this->_fields);
          while (list($index, $subarray) = each($this->_fields))
           if ($subarray["use_autoinitialise"])
             $autoinitialisevar[$index] = $this->_rs[$index];
          sset($this->autoinitialisevar, $autoinitialisevar);
        }
      }
    } elseif ($this->_mode != "insert") {
      $rs = selectsql($this->select_enregistrement($this->_key . " = " . wrap($lindex)), $this->_alt_bd);
      $this->_rs = $rs[0];
      $this->_ors = $this->_rs;
      if ($this->use_autoinitialise) {
        $autoinitialisevar = sget($this->autoinitialisevar);
        reset($this->_fields);
        while (list($index, $subarray) = each($this->_fields)) {
         if ($subarray["use_autoinitialise"])
           $autoinitialisevar[$index] = $this->_rs[$index];
        }
        sset($this->autoinitialisevar, $autoinitialisevar);
      }
      reset($this->_fields);
      while (list($index, $subarray) = each($this->_fields)) {
        if ($subarray["addself"] && $subarray["field_description"] != "")
          $this->_fields[$index]["pick_listdescription"] = $this->_rs[$subarray["field_description"]];
      }
    } elseif ($this->_mode == "insert") {
    
      $this->_rs = array();
      if(is_array($this->_fields)){
        reset($this->_fields);
        while (list($index, $subarray) = each($this->_fields)) {
          if ($subarray["defaut"] != "" && $subarray["html_type"] == "checkbox")
            $this->_rs[$index] = $subarray["defaut"];
          if ($subarray["initializevalue"] != "")
            $this->_rs[$index] = $subarray["initializevalue"];
          if ($subarray["initializefunction"] != "")
            $this->_rs[$index] = $subarray["initializefunction"]();
        }
        if ($this->use_autoinitialise) {
          $autoinitialisevar = sget($this->autoinitialisevar);
          if(is_array($this->_fields)){
            reset($this->_fields);
            while (list($index, $subarray) = each($this->_fields))
             if ($subarray["use_autoinitialise"] && $subarray["initializevalue"] == "")
               $this->_rs[$index] = $autoinitialisevar[$index];
          }
        }
      }
    }
  }
  
  function get_g_custom($small = false){
    if (isset($this->_g_custom) && !$this->printerfriendly) {
		  $size = $small ? 27 : 34;
	    reset($this->_g_custom);
	    while (list($index, $subarray) = each($this->_g_custom)){
	      $g_custom .= "<input type=\"button\" style=\"height:$size\" class=\"formeZoombutton\"";
	      if ($subarray["with_submit"])
	        $g_custom .= "onclick=\"" . get_js_script_no_submit($this->_fields) . " else {submit_custom(document.forms['$this->formname'], '" . 
	           $this->add_parametre($this->_url, "mode=gcustom&fn=" . $index . "&index=" . $lindex) . "')} \"";
	      else 
	        $g_custom .= "onclick=\"window.location='" . $this->add_parametre($this->_url, "mode=gcustom&fn=" . $index . "&index=" . $lindex) . "'\"";
	      $g_custom .= " title=\"" . $subarray["alt"] . "\" value=\"&nbsp;&nbsp;" . $subarray["label"] . "&nbsp;&nbsp;\">";
	    }
	    return $g_custom . (isset($this->_parent) ? "&nbsp;" : "");
    } else 
      return "";
  }
  
  function _display(&$fm, $lindex = null) {
    echo "<!-- debut -->";
    if (is_primary_language())
      $this->_url = update_url_query($this->_url, "langue");
    else
      $this->_url = update_url_query($this->_url, "langue", get_language());
    $lindex = (isset($lindex) ? $lindex : (($this->_index != "") ? $this->_index : 0));
    $this->_mode = (($lindex !== 0) ? "save" : "insert");
    $this->_index = $lindex;
    if ($this->_use_parent_where)
      if (isset($this->_parent))
        $this->_sql->_modifie_where =
          $fm->_forms[$this->_parent]["form"]->_sql->get_modifie_where();
    $this->set_rs($lindex);
    /* iii 
    if (($this->_help_wanted && !$this->printerfriendly) 
        if ($this->_help_wanted)
          echo "<td>" . $this->help_me_button() . "</td>";
     */
    if (!$this->no_form)
      echo $this->get_form();
    if ($this->context != "") {
      echo_box($this->context, $this->contexticon);
    }
    echo "<table class=\"$this->outlineclass\" border=0 cellspacing=0 cellpadding=0 width=100%>
    <tr>
    <td><table class=\"formezoomTitle\" border=0 cellspacing=0 cellpadding=0 width=100%><tr><td class=\"formezoomTitleLeft\"></td>";
        echo "<td class=\"formezoomTitleMiddle\">" . $this->_title . "</td>";
    if (isset($this->_parent) || (isset($this->_g_custom) && !$this->printerfriendly))
    echo "<td align=\"right\"  class=\"formezoomTitleMiddle\">" . $this->get_g_custom(true) . $this->get_backbutton(true) . "</td>";
        
        echo "<td class=\"formezoomTitleRight\"></td></tr></table></td>";
    echo "</tr><tr><td align=center><table>";
    if (!$this->_hide_header && !$this->printerfriendly) {
      $this->get_header($fm, $lindex);
    }

    if ( (!isset($this->_rs) && $this->_mode != "insert") && $lindex != "" ) {
      echo "<tr><td><b>Enregistrement non trouv</b></td></tr>";
    } else {
      if ($this->_subtitle != "")
      echo "<tr><td></td><td>" . $this->_subtitle . "</td></tr>";
      // valider dans le cas du $fm patch
      $this->get_fieldscontent($this->_rs, "", null, $fm);
      if (isset($this->tabulators) && !$this->hidetabs) {
        $tab = $this->tabulators;
        reset($this->tabulators);
        while (list($tindex) = each($tab)){
          if ($tindex == $this->activtab){
            echo "<tr><td>&nbsp;</td></tr><tr><td><table width=\"" . $this->tabulatorwidth . "\" cellspacing=0 cellpadding=0><tr><td>" .
             $this->get_tabulators($tindex) . "</td></tr><tr><td><table width=100% class=\"tabulator\" cellpadding=10><tr><td><table width=100%>";
            $this->get_fieldscontent($this->_rs, $tindex, null, $fm);
            echo "</table></td></tr></table></td></tr></table></td></tr>";
          } else {
            $this->get_fieldscontent($this->_rs, $tindex, null, $fm);
          }
        }
      }
      
      if (!$this->_hide_footer && !$this->printerfriendly){
        echo "<tr><td height=50 colspan=2 align=center>";
        echo "<table width=100%><tr>";
          $this->get_footer($fm, $lindex);
        echo "</tr></table></td></tr>";
      }
      if ($this->mandatory_field && !$this->printerfriendly) 
        echo "<tr><td colspan=2 align=center>
              <table width=100%><tr><td class=\"champobligatoire\">" . get_str("msg_compulsory", "FormZoom") . "</td>
              </tr></table></td></tr>";
    }
    echo "</table>";
    
    if (!$this->no_form && (!$this->handelsavedetails || $this->_mode == "insert"))
      echo "</form>";
    if (!$this->globaltable || $this->_mode == "insert")
    echo "</td></tr></table>";
    echo "<!-- fin -->";
  } 
  
  function get_form() {
    echo "<form name=\"forme\" action=\"" .
      (isset($this->_form_action) ? $this->_form_action : $this->add_parametre($this->_url, "mode=" . $this->_mode)) .
      "\" method=\"post\">\n<input type=\"hidden\" name=\"sequence\" value=\"" . $this->_sequence . "\">\n";
  }
  
  function get_tabulators($tabulator){
    if(is_array($tabulator)) {
      reset($this->tabulators);
      while (list($index, $subarray) = each($this->tabulators)){
        if ($tabulator == $index) {
          $tab .= "<td class=\"tabselected\">" . $subarray["titre"] . "</td>"; 
        } else {
          if (!$this->printerfriendly) {
            $onclick = "$this->formname.action='" . $this->add_parametre($this->_url, "mode=tab&tab=" . $index)  . "';$this->formname.submit();";
            $tab .= "<td class=\"tab\" onmouseout=\"this.className='tab'\" onmouseover=\"this.className='tabover'\" onclick=\"$onclick\"><a href=\"#\" onClick=\"$onclick\">" . $subarray["titre"] . "</a></td>"; 
          } else {
            $tab .= "<td class=\"tab\">" . $subarray["titre"] . "</td>"; 
          }
        }
      }
    }
    return "<table width=100% cellspacing=0 cellpadding=3><tr>" . $tab . "</tr></table>";
  }
  
  function resettabhidden($tabulator = null, $hide = null){
      reset($this->_fields);
      if (!isset($tabulator)) {
        while (list($index) = each($this->_fields))
            $this->_fields[$index]["temphidden"] = $hide;
      } else {
        while (list($index) = each($this->_fields))
          if ($this->_fields[$index]["tabulator"] != "")
            $this->_fields[$index]["temphidden"] = ($this->_fields[$index]["tabulator"] != $tabulator);
      }
  }
  
  function url_tab(&$fm) {
    $newtab = gget("tab");
    if ($this->activtab != $newtab){
      $this->resettabhidden($newtab);
    }
    $this->activtab = $newtab;
    $this->get_post = true;
    $this->_display($fm, $this->_index);
    $this->get_post = false;
  }
  
  function get_fieldscontent(&$rs, $tabulator, $index_zoom = null){
    if(is_array($this->_fields)) {
      reset($this->_fields);
      $this->mandatory_field = false;
      while (list($index, $subarray) = each($this->_fields)){
        if ($this->_fields[$index]["tabulator"] == $tabulator){
          if (isset($this->_phantomsections[$index]["before"]))
            $this->get_section($this->_phantomsections[$index]["before"]);
          if (isset($this->_phantomspacer[$index]["before"]))
            $this->get_spacer();
          if ($subarray["visible"] != "N"){
            if ($subarray["null"] == "N" && $subarray["updatable"] == "O" && !$this->_no_update)
               $this->mandatory_field = true;
            if (isset($this->_sections[$index]["before"]) && !$this->_fields[$index]["temphidden"])
              $this->get_section($this->_sections[$index]["before"]);
            if (isset($this->_spacers[$index]["before"]) && !$this->_fields[$index]["temphidden"])
              $this->get_spacer();
            if (isset($index_zoom)) 
              $this->_fields[$index]["index_zoom"] = $index_zoom;
            $this->get_fieldtr($index, $rs[$index]);
            if (isset($this->_sections[$index]["after"]) && !$this->_fields[$index]["temphidden"])
              $this->get_section($this->_sections[$index]["after"]);
            if (isset($this->_spacers[$index]["after"]) && !$this->_fields[$index]["temphidden"])
              $this->get_spacer();
          }
        }
      }
    }
  }
  
  function set_default_width($newwidth){
    reset($this->_fields);
    while (list($index) = each($this->_fields)) {
      if ($this->_fields[$index]["default_width"])
        $this->_fields[$index]["width"] = $newwidth;
    }
    $this->_default_width = $newwidth;
  }

  function msg_js($fieldname, $newmsg){
    $this->set_property($fieldname, "msg_js", $newmsg);
  }
  function msg($fieldname, $newmsg){
    $this->set_property($fieldname, "msg", $newmsg);
  }

  function height($fieldname, $newheight){
    $this->set_property($fieldname, "height", $newheight);
  }

  function set_value($fieldname, $newvalue){
    if (isset($this->_fields[$fieldname]))
    $this->_fields[$fieldname]["value"] = $newvalue;
  }

  // ----------------------------------------------------
  // Modifier l enregistrement
  // ---------------------------------------------------- 
  function url_save(&$fm) {
    $result = $this->save($fm);
    if ($result == "") {
      $this->show($fm);
    } else {
      $this->restore_save($fm, $result);
    }
  }
  function restore_save(&$fm, $result){
      $this->_error_update = true;
      echo_box($this->msg_error, "error");
      $this->show($fm);
      $this->_error_update = false;
  }
  function separate_save($fieldname, $functionname){
    if (isset($this->_fields[$fieldname]))
      $this->_fields[$fieldname]["separate_save"] = $functionname;
  }
  
  function is_equal(&$setvalue){
    $is_equal = true;
    while ((list($index, $subarray) = each($setvalue)) && $is_equal) {
      if ($this->format($this->_ors[$index], $this->_fields[$index]["display_format"], "", $index)
         != $subarray) {
        $is_equal = false; 
      }
    }
    return $is_equal;
  }
  
  function save(&$fm, $i = null) {
    $result_execsql = "";
    if (!$this->_no_update && !$this->_no_save) {
      reset($this->_fields);
      $setvalue = array();
      while (list($index, $subarray) = each($this->_fields))
        if ($subarray["separate_save"] === "") {
          if ($subarray["updatable"] != "N" && $subarray["visible"] != "N" && $subarray["binded"]) {
            if ($subarray["html_type"] != "edithtml" || ($subarray["html_type"] == "edithtml" && pget($subarray["name"]) != "lecontenuoriginal")) {
              $setvalue[$index] = $this->wrap($subarray["html_type"], pget($subarray["name"].$i), $subarray["toupper"], $subarray["non"], $index);
              $validation_errors .= valid_value($subarray, $setvalue[$index]);
            }
          } else {
            if ($subarray["value"] != "") {
              $setvalue[$index] = $this->wrap($subarray["html_type"], $subarray["value"], $subarray["toupper"], $subarray["non"], $index);
              $validation_errors .= valid_value($subarray, $setvalue[$index]); 
            }
          }
        }
	      if ($validation_errors !== "") {
	        $result_execsql = PRECOMPILATIONERREUR;
	        $this->msg_error = $validation_errors;
	      } else {
	        $this->msg_error = "";
	        if (count($setvalue) > 0){
	          $whereindex[$this->_key] = $this->_index;
	          if (!$this->is_equal($setvalue)) {
	            $lesql = $this->_sql->UpdateFactory($setvalue, $whereindex) . ";";
  	          $result_execsql = execsql($lesql, $this->_alt_bd);
  	        } else {
  	          $result_execsql = 0;
  	        }
	        
	          if ($result_execsql < 0) {
	            if ($result_execsql == USER_ERROR) {
		            $this->msg_error = get_error_message();
	            } elseif ($result_execsql == DUPLICATEKEY) {
	              $this->msg_error = ($msg_error == "" ?
	                 $this->_fields[is_valid_key($this->_sql->_index_schema)]["unique_error_msg"]
	                 : $msg_error);
	            }
	            if ($this->msg_error == "")
	              $this->msg_error = get_str("msg_erreur_save", "FormZoom");
	          } else {
	            reset($this->_fields);
	            while ((list($index, $subarray) = each($this->_fields)) && $result_execsql == "")
	              if ($subarray["separate_save"] != "") {
	                $this->msg_error = $subarray["separate_save"]($fm);
	                if ($this->msg_error != "")
	                  $result_execsql = "erreur";
	              }
	          }
	        }
	      }
	      $result_execsql = $result_execsql == 0 ? "" : "erreur";
    } 
    if ($result_execsql == "" && $this->handelsavedetails) {
      $the_form = &$fm->get_form($this->details[0]);
      $result_execsql = $the_form->save($fm);
      if ($result_execsql != "") {
        $this->msg_error = $result_execsql;
        $result_execsql = "erreur";
      }
    }
    return $result_execsql;
  } 
  
  function hidetabs($hide){
    $this->hidetabs = $hide;
  }
  
  // ----------------------------------------------------
  // Ajouter un enregistrement
  // ---------------------------------------------------- 
  
  function url_add(&$fm, $resethidden = true){
    
    if (!$this->_no_update && !$this->_no_insert) {
      if (isset($this->_parent)) {
        $the_parent = &$fm->get_form($this->_parent);
        if ($the_parent->_type_formulaire == "detail") {
          $this->set_value($the_parent->_joinfield, $the_parent->_filter_value);
          if ($this->use_master_filter_value) {
            $the_master = &$fm->get_form($the_parent->_master);
            $this->initializevalue(coalesce($this->quick_filter, $the_master->quick_filter), $the_master->_fields[$the_master->quick_filter]["value"]);
          }
        }
      }
      if ($this->detailed && $resethidden) {
        $this->detailedon = true;
        $this->resetdetailedhidden();
      }
      if (isset($this->tabulators) && $resethidden){
        $tabulators = array_keys($this->tabulators);
        $this->activtab = $tabulators[0];
        $this->resettabhidden($this->activtab);
      }
      $this->_display($fm, 0);
      if ($this->on_insert_focus != "")
        echo "<input type=\"hidden\" id=\"focuscontrol\" value=\"id_fld_" . $this->on_insert_focus . "\">";
        
    } else {
      $this->show($fm);
    }
  }
   
  
  function url_insert(&$fm) {
    if ($this->_mode != "insert") {
      $this->show($fm);
    } else {
       
      $result = $this->insert($fm);
      if ($result == "") {
        if (isset($this->_parent)){
          $the_parent = &$fm->get_form($this->_parent);
          $the_parent->_sql->set_page_count();
        }
        $this->show($fm);
        $this->_mode = "save";
      } else {
        $this->restore_insert($fm, $result);
      } 
    }
  }
  function separate_insert($fieldname, $functionname){
    if (isset($this->_fields[$fieldname]))
    $this->_fields[$fieldname]["separate_insert"] = $functionname;
  }
  function restore_insert(&$fm, $result){
      $this->_error_update = true;
      echo_box($this->msg_error, "error");
      $this->_display($fm, 0);
      $this->_error_update = false;
  }
  function insert(&$fm, $i = null) {
    $result_execsql = "";
    if (!$this->_no_update && !$this->_no_insert) {
      reset($this->_fields);
      $insertfields = array();
      if ($this->use_autoinitialise)
        $autoinitialisevar = sget($this->autoinitialisevar);
      while (list($index, $subarray) = each($this->_fields)) {
        $the_value = pget($subarray["name"] . $i);
        if ($subarray["separate_insert"] === "" && $subarray["binded"]) {
          if ($subarray["html_type"] != "checkbox" && $the_value === "" && ($subarray["defaut"] !== "" || $subarray["defautfunction"] != "")) {
            if ($subarray["defautfunction"] != "")
              $the_default = $subarray["defautfunction"]();
            else
              $the_default = $subarray["defaut"];
            $insertfields[$index] = $this->wrap($subarray["html_type"], $the_default, $subarray["toupper"], $subarray["non"], $index);
            $validation_errors .= valid_value($subarray, $insertfields[$index]);
          } elseif ($subarray["updatable"] != "N" && $subarray["visible"] != "N"){
            if ($subarray["html_type"] != "edithtml" || ($subarray["html_type"] == "edithtml" && pget($subarray["name"]) != "lecontenuoriginal")) {
              $insertfields[$index] = $this->wrap($subarray["html_type"], $the_value, $subarray["toupper"], $subarray["non"], $index);
              $validation_errors .= valid_value($subarray, $insertfields[$index]);
            }
          } else {
            //reviser pour les 0  
            if ($subarray["value"] != "") {
              $insertfields[$index] = $this->wrap($subarray["html_type"], $subarray["value"], $subarray["toupper"], $subarray["non"], $index);
              $validation_errors .= valid_value($subarray, $insertfields[$index]);
            }
          }
          
        }
        if ($subarray["use_autoinitialise"]) 
          $autoinitialisevar[$index] = $the_value;
      }
      
      if ($validation_errors !== "") {
        $result_execsql = PRECOMPILATIONERREUR;
        $this->msg_error = $validation_errors;
      } else {
        $this->msg_error = "";      
        if (!$this->valide_key($insertfields[$this->_key])) {
          $msg_error = "Le champ &quot;" . trim(preg_replace("/\*/", "", strip_tags($this->_fields[$this->_key]["label"]))) . "&quot; ne doit pas contenir d'espaces.";
          $result_execsql = ERREUR; 
        } else {
          $linsert = $this->_sql->InsertFactory($insertfields);
          $pg_oid = @execsql($linsert, $this->_alt_bd);
          if ($pg_oid < 0) {
            $result_execsql = $pg_oid;
            if ($result_execsql == USER_ERROR) {
	            $this->msg_error = get_error_message();
            } elseif ($result_execsql == DUPLICATEKEY) {
              $this->msg_error = ($msg_error == "" ?
                 $this->_fields[is_valid_key($this->_sql->_index_schema)]["unique_error_msg"]
                 : $msg_error);
            }
            if ($this->msg_error == "")
              $this->msg_error = get_str("msg_erreur_insert", "FormZoom");
          } else {
            // Recueil la valeur de la cle primaire qui vient d etre gnre
            // pour afficher a nouveau le zoom sur cet enregistrement
            if (($this->_key != "") && ($pg_oid != "")) {
              $lindex = selectsql("SELECT " . $this->get_key() .
                            " FROM " . $this->_sql->get_insert_table_name() .
                            " WHERE OID = " . $pg_oid, $this->_alt_bd);
              $this->_index = $lindex;
            }
            if ($this->use_autoinitialise)
              sset($this->autoinitialisevar, $autoinitialisevar);
            reset($this->_fields);
            while (list($index, $subarray) = each($this->_fields))
              if ($subarray["separate_insert"] != "") 
                $subarray["separate_insert"]($fm);
          } 
        }
      }
    }
    return $result_execsql;
  }
  
  
  function valide_key($value){
    if ($this->_fields[$this->_key]["nospace"]){
      return !preg_match("/\s+/", $value, $matches);
    } else
      return true;
  }
  
  // ----------------------------------------------------
  // Detruire l enregistrement 
  // ----------------------------------------------------
  function url_erase(&$fm){
    if (!$this->_no_update && !$this->_no_delete) {
      $result = $this->erase($fm);
      if ($result == "") {
        if (isset($this->_parent)){
          $the_parent = &$fm->get_form($this->_parent);
          $the_parent->_sql->set_page_count();
          $this->url_unzoom($fm);
        } else {
          $this->show($fm);
        }
      } else {
	      echo_box($this->msg_error, "error");
        $this->show($fm);
      }
    } else {
      $this->show($fm);
    }
  }
  
  function erase(&$fm){
    if (isset($fm->_forms[$this->_name]["details"])){
      reset($fm->_forms[$this->_name]["details"]);
      while (list($index, $subarray) = each($fm->_forms[$this->_name]["details"])){
        $the_form = &$fm->get_form($subarray);
        $lesql .= $the_form->_erase_all();
      }
    }
    $lesql .= $this->delete_enregistrement();
    $result = execsql($lesql, $this->_alt_bd);
    if ($result == "") {
      $this->msg_error = "";
    } elseif ($result == FOREIGNKEY) {
      $this->msg_error = get_str("msg_foreign");
    } else {
      $this->msg_error = get_str("msg_destroy_impossible");
    }
    return $result;
  }

  function delete_enregistrement(){
    $select_enr = "DELETE FROM " . $this->_sql->get_delete_table_name() . " " .
                  $this->_sql->get_modifie_where() . " ";
    $AppendWhereClause =
      $this->get_key() . " = " .
      wrapdata($this->wrap($this->_fields[$this->_key]["html_type"], $this->_index, false, $this->_fields[$this->_key]["non"], $index),
              $this->_sql->field_description[$this->_key]["field_type"]);
    if (strpos(strtoupper($select_enr), "WHERE") === false){
      $select_enr .= "WHERE (" . $AppendWhereClause . ")";
    } else {
      $select_enr .= " AND (" . $AppendWhereClause . ")";
    }
    return $select_enr;
  }

  function url_cancel(&$fm){
    if (isset($this->_parent)){
      $the_parent = &$fm->get_form($this->_parent);
      $this->url_unzoom($fm);
    } else {
      echo_box(get_str("msg_cancel"));
    }
  }
  // ----------------------------------------------------
  // Retourne le select de lenregistrement dsir
  // ----------------------------------------------------
  function select_enregistrement($AppendWhereClause){
    $select_enr = $this->_sql->get_modifie_select() . " " .
                  $this->_sql->get_modifie_from() . " " .
                  $this->_sql->get_modifie_where() . " ";
     if (strpos(strtoupper($select_enr), "WHERE") === false){
        $select_enr .= "WHERE (" . $AppendWhereClause . ")";
     } else {
        $select_enr .= " AND (" . $AppendWhereClause . ")";
     }
     return $select_enr;
  }
  
  function cleanHTML($html) {
    $html = ereg_replace ("<\?[x|X][m|M][l|L][^>]*>", "", $html);
    $html = strip_tags($html, "<img><b><i><u><a><p><strong><big><sup><em><br><h1><h2><h3><h4><h5><table><tr><td><th><ul><li><script><input>");
    $html = preg_replace("/(<img .* src=\")http:\/\/trex\/usagers\/.*\/gil_sites\/.[^\/]*(.*\" .*>)/i", "\\1.\\2", $html);
    $html = preg_replace("/(<b><\/b>)/i", "", $html);
    $html = preg_replace("/(<p><\/p>)/i", "", $html);
    $html = preg_replace("/<\s*(br?|i|ul?|p|h[1-5]|li)\s[^>]*>/i", "<\\1>", $html); 
    //$html = preg_replace("/[&nbsp;]*/i", "<li>", $html);

    return $html;
  }
  
  function wrap_field($fieldname, $value) {
      return $this->wrap($this->_fields[$fieldname]["html_type"], 
                         $value, $this->_fields[$fieldname]["toupper"], $this->_fields[$fieldname]["non"], $fieldname);
  }
  
  function get_formated($fieldname){
    if ($this->_fields[$fieldname]["value"] != "")
      return wrapdata($this->wrap($this->_fields[$fieldname]["html_type"], 
                         $this->_fields[$fieldname]["value"], $this->_fields[$fieldname]["toupper"], $this->_fields[$fieldname]["non"], $fieldname), 
                         $this->_sql->field_description[strtolower($fieldname)]["field_type"]) . ", ";
    else
      return wrapdata($this->wrap($this->_fields[$fieldname]["html_type"], 
                         pget($this->_fields[$fieldname]["name"]), $this->_fields[$fieldname]["toupper"], $this->_fields[$fieldname]["non"], $fieldname), 
                         $this->_sql->field_description[strtolower($fieldname)]["field_type"]) . ", ";
  }
  
  function wrap($html_type, $value, $toupper, $non_value, $fieldname = ""){
    switch ($html_type) {
      case "calendar":
        if ($value == get_constant("CALENDAR_DISPLAY_MASK"))
          $value = "";
        break;
      case "checkbox":
        if (($value == "") || (!isset($value)))
          $value = $non_value;
        break;
      case "edithtml":
          $value = $this->cleanHTML(html_entity_decode($value));
        break;
      case "dateyear":
          if ($value != "")
            $value = "" . substr($value, 0 , 4) . "/01/01";
        break;
      case "dateyearmonth":
          if ($value != "")
            $value = "'" . preg_replace("/-/", "\/", substr($value, 0, 7)) . "/01'";
        break;
      case "password":
      case "password_confirm":
        $value = md5($value);
        break;
      case "pourcentage":
        $value = $value;
        break;
      case "dollar":
        $value = number_format(preg_replace("/,/", "", $value), 2, ".", "");
        break;
    }
    if ($toupper)
      $value = strtoupper($value);
    
    return $value;
  }
}
?>