<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * Wizard class
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp
copin_include("lib/class.formmaster.php");

/**
 * Wizard class
 * 
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class FormWizard extends FormMaster{
  var $_wiz;
  var $_wizard_id;
  var $title;
  var $title_prefix;
  var $_key;
  var $conclusion_yes;
  var $conclusion_no;
  var $_help_wanted;
  var $_help_anchor;
  var $_help_height;  
  var $_status;
  
  function formwizard() {
    $user_name = "";
    $object_name = "";
    $this->first_time = true;
    $this->reset_first_time = false;
    $this->title = "";
    $this->title_prefix = "";
    $this->conclusion_yes = "";
    $this->conclusion_no = "";
    $this->_help_wanted = false;
    $this->_help_anchor = "";
    $this->_help_height = 400;
    $this->_status = 'open';
    $this->_noheader = false;

    if ( get_cargo("user_name") == "" ) {
        $user_name = "null";
    } else {
        $user_name = "'" . get_cargo("user_name") . "'";
    }
    $this->_key = gget("cle");
    if ($this->_key != "") {
      $this->_wizard_id = gget("wizard");
      $rs = selectsql("select wizard from cms.wizard where wizard = " . $this->_wizard_id .
          " and key = '" . $this->_key . "';");
      if (!isset($rs) || $rs == "")
        $this->_key = "";
    }
    if ($this->_key == "") {
      $this->_key = get_new_key();
      $sql = "INSERT INTO cms.wizard 
             (site_user, 
              created, 
              description, 
              wizard_status, 
              key, 
              apache_session, 
              step) 
             VALUES
             (" . $user_name . ", 
             '" . date("Y m d h:i:s") . "', 
             'description', 
             '" . $this->_status . "', 
             '" . $this->_key . "', 
             '" . session_id() . "', 
             '" . gget("action") . "');";
      $wizard_OID = execsql($sql);
      $this->_wizard_id = selectsql("SELECT wizard 
                                     FROM cms.wizard 
                                     WHERE OID = " . $wizard_OID . ";");
    }
    
  }

  
	function get_next_wiz($wiz_index){
	  $wiz_array = array_keys($this->_wiz);
		$next_wiz = "";
    if(is_array($wiz_array)) {
  		reset($wiz_array);
  		while($next_wiz == ""){
  	    $the_wiz = $wiz_array[++$wiz_index];
  			if ($this->_wiz[$the_wiz]['on'])
    			$next_wiz = $the_wiz;
  		}
    }
		return $the_wiz;
	}
	
	function get_prev_wizard($wiz_index){
	  $wiz_array = array_keys($this->_wiz);
		$next_wiz = "";
		reset($wiz_array);
		while($next_wiz == ""){
	    $the_wiz = $wiz_array[--$wiz_index];
			if ($this->_wiz[$the_wiz]['on'])
  			$next_wiz = $the_wiz;
		}
		return $the_wiz;
	}

  function help_height($new_height){
    $this->_help_height = $new_height;
  }
  function help_wanted($an_anchor = null){
    $this->_help_anchor = $an_anchor;
    $this->_help_wanted = true;
  }
  
  function help_me_button(){
    $the_action = gget("action") . get_suffix_langue();
    if ($the_action == "") $the_action = "helpme";
    return "<a href=\"#\" onclick=\"javascript:ia_openIT('" . get_constant("PATH_HELP") . "?action=$the_action&hauteur=" . $this->_help_height  . "', 563, " . $this->_help_height . ", 'iaaide$the_action');\"><img src=\"".sget('image_dir')."but_moduleaide_sml" . get_suffix_langue() . ".gif\" width=\"108\" height=\"51\" border=\"0\"></a>";
  }
  
  function update_wizard_table($statut, $description) {
    $sql = "UPDATE cms.wizard " .
           "SET created = '" . date("Y m d h:i:s") . "', " .
           "description = '" . $description . "', " .
           "wizard_status = '" . $statut . "' " .
           "WHERE wizard = " . $this->get_wizard_id() . ";";
    execsql($sql);
  }

  function get_wizard_id() {
    return $this->_wizard_id;
  }

  function get_wizard_key() {
    return $this->_key;
  }

  function dispatch_wiz($object_name = null, $mode = null) {
    if (!isset($this->_wiz))
      init_wizard($this);
      
    if ($this->first_time || $this->reset_first_time) {
      if ($this->first_time_object_name != "") {
        $object_name = $this->first_time_object_name;
        $mode = $this->first_time_mode;
      }
      $this->first_time = false;
      $this->reset_first_time = false;
    } 
    if (!isset($object_name))
      $object_name = gget('objet');
    if ($object_name == "" || !isset($this->_forms[$object_name]))
      $object_name = $this->_entry;
    
    if (gget("noheader") != "O") {
        echo "<table class=\"formewizard\" border=0 cellspacing=0 cellpadding=0 width=100%><tr><td>";
	    if ($this->title != "" || $this->_help_wanted) {
	      echo "<table width=100% class=\"formewizardtitle\"><tr>";
	      if ($this->title != "")
	        echo '<td>' . $this->title .  '</td>';
	      if ($this->_help_wanted)
	        echo '<td align=right>' . $this->help_me_button() . '</td>';
	      echo "</tr></table>";
	    }
       echo $this->get_header($object_name);
    }
    
    $the_wiz = $this->get_wizard_name($object_name);
    
    if ($this->_wiz[$the_wiz]["first_time"]) {
      if ($this->_wiz[$the_wiz]["first_time_mode"] != "")
        $mode = $this->_wiz[$the_wiz]["first_time_mode"];
      $this->_wiz[$the_wiz]["first_time"] = false;
    }
    
    if ($this->_wiz[$the_wiz]["is_conclusion"] || $this->_wiz[$the_wiz]["is_summary"]) {    
      if ($this->_forms[$object_name]['status'] == "undefined"){
        $this->_forms[$object_name]['init_function']($this);
        $this->_forms[$object_name]['status'] = "defined";
      }
      if ($this->_wiz[$the_wiz]["is_summary"]) {
        $this->get_summary();
        $the_form = &$this->get_form($object_name); 
        $the_form->show($this);
        $this->_status = "open";
      } else {
        $the_form = &$this->get_form($object_name);
        $the_form->show($this);
      }
      // Indique dans la table wizard l'etape courrante
      $the_wiz_index = $this->get_wizard_index($object_name);
      $thekeys = array_keys($this->_wiz);
      $this->update_wizard_table($this->_status, $thekeys[$the_wiz_index]);
    } else {
      $the_mode = gget("mode");
      if ($this->_wiz[$the_wiz]["can_go_next"] != "select" && ($the_mode == "insert" || $the_mode == "save")) {
        $the_form = &$this->get_form($object_name);
        $result = $the_form->{$the_mode}($this);
        if ($result == "") {
          $wiz_index = $this->get_wizard_index($object_name);
          $wiz_array = array_keys($this->_wiz);
          $the_exit = $this->_wiz[$wiz_array[$wiz_index]]['exit'];          
          if (($the_exit == $object_name && $the_mode != "unzoom" && $the_mode != "delete")
              || ($the_exit == $the_form->zoom && ($the_mode == "zoom" || $the_mode == "add"))) {
            $the_wiz = $this->get_next_wiz($wiz_index);
            $the_form = &$this->get_form($the_wiz);
            $the_form->inc_sequence($this);
            echo "<META HTTP-EQUIV=\"refresh\" CONTENT=0;URL=\"" . $the_form->add_parametre($the_form->_url) . "\">";
          } else {
            $the_form->inc_sequence($this);
            $the_form->show($this);
          }
        } else { 
          $the_form->inc_sequence($this);
          $the_form->{"restore_" . $the_mode}($fm, $result);
        }
      } else {
       
        $this->dispatch($object_name, $mode);
      }
      // Indique dans la table wizard l'etape courrante
      $the_wiz_index = $this->get_wizard_index($object_name);
      $thekeys = array_keys($this->_wiz);
      $this->update_wizard_table($this->_status, $thekeys[$the_wiz_index]);
    }
    
    echo "</td></tr><tr><td align=center >";
    $this->display_navigation($object_name);

    if (gget("noheader") != "O")
       echo "</td></tr></table>";

  }

  function first_time_action_wiz($wiz, $mode){
    $this->_wiz[$wiz]["first_time_mode"] = $mode;
  }
  
  function get_header($object_name){
    $object_name = $this->get_wizard_name($object_name);
    reset($this->_wiz);
    $header = "<table class=\"formewizardheader\" border=0 cellspacing=0 cellpadding=0 width=100%>";
    $done = "selected";
    while (list($index, $subarray) = each($this->_wiz)){
      if ($object_name == $index) 
        $done = "";
      $selected = ($object_name == $index ? "selected" : "");
      if ($subarray["title"] != "" && $subarray["on"]) {
        $header .= "<tr><td><img src=\"".sget('forms_image_dir')."wiz" . $done . ".gif\" border=\"0\"></td><td class=\"wiz" . $selected . "\">" . $subarray["title_prefix"] . $subarray["title"] . "</td></tr>";
        if ($subarray["comment"] != "" && $object_name == $index)
          $header .= "<tr><td></td><td class=\"wizcomment\">" . $subarray["comment"] . "</td></tr>";
      }
    }
    $header .= "</table>";
    return $header;
  }

  function get_summary(){
    echo (is_primary_language() ? "<h2>Rsum</h2>" : "<h2>Summary</h2>");
    reset($this->_wiz);
    while (list($index, $subarray) = each($this->_wiz)){
      if ($subarray["is_part_of_summary"] && $subarray["on"]){
        echo $subarray["title"];
        $the_form = $this->get_form($subarray["exit"]);
        $old_no_update = $the_form->_no_update;
        $the_form->no_update();
        $the_form->show($this);
        $the_form->_no_update = $old_no_update;
      }
    }
  }
  
  function register_wizard($wiz, $init_function){
    $this->_forms[$wiz]['status'] = "undefined";
    $this->_wiz[$wiz]["can_go_back"] = "";
    $this->_wiz[$wiz]["back_manuel"] = false;
    $this->_wiz[$wiz]["back_confirm"] = "";
    $this->_wiz[$wiz]["can_go_next"] = "";
    $this->_wiz[$wiz]["next_manuel"] = false;
    $this->_wiz[$wiz]["next_confirm"] = "";
    $this->_wiz[$wiz]["exit"] = "";
    $this->_wiz[$wiz]["title"] = "";
    $this->_wiz[$wiz]["title_prefix"] = "";
    $this->_wiz[$wiz]["comment"] = "";
    $this->_wiz[$wiz]["is_part_of_summary"] = false;
    $this->_wiz[$wiz]["is_summary"] = false;
    $this->_wiz[$wiz]["is_conclusion"] = false;
    $this->_wiz[$wiz]["first_time_mode"] = "";
    $this->_wiz[$wiz]["first_time"] = true;
    $this->_wiz[$wiz]["on"] = true;
		$this->_wiz[$wiz]['forms'] = array ();
    array_push($this->_wiz[$wiz]['forms'], $wiz);
    $this->_forms[$wiz]['init_function'] = $init_function;
  }
  /**
  * @todo laguage file
  */
  
  function display_navigation_button(&$the_form, $wiz_index, $direction, $select = false) {
    $wiz_array = array_keys($this->_wiz);

    $js_script = "";
    $the_form2 = $the_form;
    $here = $wiz_array[$wiz_index];
    if ($direction == "back") {	
			$the_wiz = $this->get_prev_wizard($wiz_index);
			if ($this->_wiz[$here]["is_summary"]) 
        $the_form2 = $this->get_form($the_wiz);
      $html_button = "&nbsp;<< " . (is_primary_language() ? "Prcdent" : "Previous") . "&nbsp;";
      $confirm = $this->_wiz[$wiz_array[$wiz_index]]['back_confirm'];
      
		} else if ($direction == "next") {
			$the_wiz = $this->get_next_wiz($wiz_index);
			$html_button = "&nbsp;" . (is_primary_language() ? "Suivant" : "Next") . " >>&nbsp;";
      $confirm = $this->_wiz[$wiz_array[$wiz_index]]['next_confirm'];
      
		}

    if ($the_wiz != ""){
        $the_url = update_url_query($the_form2->_url, "objet", $the_wiz);
        $the_url = get_urlmd5($the_url);
      if ($confirm != "") {
        $js_script .= "if (confirm('" . $confirm . "'))";
      }
      if ($select) {
        $js_script .= (!$this->_wiz[$here]["is_summary"]
                       ? 
                       ($this->_wiz[$here]["validationjs"] ? 
                        get_js_script($the_form2->_fields, "", "", "forme")
                        : " forme.submit();")
                       : " formeagreement.submit(); ");
      } else {
        $js_script .= " window.location='" . $the_url . "';";
      }

      echo "\n<input class=\"wizbutton\" type=\"button\" id=\"but_$direction\" value=\"&nbsp;" . 
        $html_button . "&nbsp;\" onclick=\"" . $js_script . "\"" 
        . ($this->_wiz[$here][$direction."_manuel"] ? " disabled" : "") .">\n";
    }
  }


  function display_navigation($object_name){
    $the_wiz_index = $this->get_wizard_index($object_name);
    $thekeys = array_keys($this->_wiz);
    $the_form = &$this->get_form($object_name);

    // Vrifie si nous sommes sur le dernier cran de l'tape courrante du wizard 
    $the_exit = $this->_wiz[$thekeys[$the_wiz_index]]['exit'];
    $the_mode = gget("mode");
    $looking_at_exit = false;
    if (($the_exit == $object_name && $the_mode != "unzoom" && $the_mode != "delete")
          || ($the_exit == $the_form->zoom && ($the_mode == "zoom" || $the_mode == "add"))) {
      $looking_at_exit = true;
    }

    // le bouton PRECEDENT
    switch ($this->_wiz[$thekeys[$the_wiz_index]]['can_go_back']) {
      case "yes":
        $this->display_navigation_button($the_form, $the_wiz_index, "back");
        break;
      case "no":
        break;
      case "select":
      case "save":
        if ( $this->exit_is_ok($the_exit) && $can_go ) {
          $this->display_navigation_button($the_form, $the_wiz_index, "back");
        }
        break;
    }

    // le bouton SUIVANT
    switch ($this->_wiz[$thekeys[$the_wiz_index]]['can_go_next']) {
      case "yes":
        $this->display_navigation_button($the_form, $the_wiz_index, "next");
        break;
      case "no":
        break;
      case "select":
        if ( $this->exit_is_ok($the_exit) && $looking_at_exit ) {
          $this->display_navigation_button($the_form, $the_wiz_index, "next", true);
        }
        break;
      case "save":
        if ( $this->exit_is_ok($the_exit) && $looking_at_exit ) {
          $this->display_navigation_button($the_form, $the_wiz_index, "next", true);
        }
        break;
    }

  }

  function exit_is_ok($the_exit_name) {
    return ($this->_forms[$the_exit_name]["status"] == "defined");
  }


  function get_wizard_index($object_name){
    reset($this->_wiz);
    $i=0;
    while (list($index, $subarray) = each($this->_wiz)) {
      if (in_array($object_name, $subarray['forms'])) {
        return $i;
      }
      $i++;
    }
  }

  function get_wizard_name($object_name){
    reset($this->_wiz);
    while (list($index, $subarray) = each($this->_wiz)) {
      if (in_array($object_name, $subarray['forms'])) {
        return $index;
      }
    }
  }

  function set_back_confirm($wiz, $msg) {
    $this->_wiz[$wiz]["back_confirm"] = $msg;
  }

  function set_next_confirm($wiz, $msg) {
    $this->_wiz[$wiz]["next_confirm"] = $msg;
  }
  
  function set_next_manuel($wiz, $manuel) {
    $this->_wiz[$wiz]["next_manuel"] = $manuel;
  }
  
  function set_back_manuel($wiz, $manuel) {
    $this->_wiz[$wiz]["back_manuel"] = $manuel;
  }
  
  function set_back($wiz, $type) {
    $this->_wiz[$wiz]["can_go_back"] = $type;
  }

	
  function set_on($wiz, $on = true) {
    $this->_wiz[$wiz]["on"] = $on;
  }  

  function set_next($wiz, $type, $validationjs = true) {
    $this->_wiz[$wiz]["can_go_next"] = $type;
    $this->_wiz[$wiz]["validationjs"] = $validationjs;
  }

  function set_exit($wiz, $exit) {
    $this->_wiz[$wiz]["exit"] = $exit;
  }

  function set_comment($wiz, $comment){
    $this->_wiz[$wiz]["comment"] = $comment;
  }  
  
  function set_title_prefix($wiz, $title){
    if ($wiz == "")
      $this->title_prefix = $title;
    else
      $this->_wiz[$wiz]["title_prefix"] = $title;
  } 
  
  function set_title($wiz, $title){
    if ($wiz == "")
      $this->title = $title;
    else
      $this->_wiz[$wiz]["title"] = $title;
  } 
  
  function link_form($wiz, $form) {
    array_push($this->_wiz[$wiz]['forms'], $form);
  }
  
  function is_summary($wiz){
    $this->_wiz[$wiz]["is_summary"] = true;
  }
  function is_conclusion($wiz){
    $this->_wiz[$wiz]["is_conclusion"] = true;
  }
  
  function is_part_of_summary($wiz, $is_part_of_summary){
    $this->_wiz[$wiz]["is_part_of_summary"] = $is_part_of_summary;
  }
}
?>