<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
/**
 * tree display class
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/28 code revision and cleanup sp

/**
 * tree display class
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class formtree extends formlist {
  
  function formtree($sql, $key = "", $parent_key = "", $connect = null) {
    $this->FormList($sql, $key, $connect);
    if (!isset($this->_fields[$key])) {
      $this->add_field($key, 100);
      $this->hide($key);
    }
    if (!isset($this->_fields[$parent_key])) {
      $this->add_field($parent_key, 100);
      $this->hide($parent_key);
    }
    $this->_sql->row_per_page(1000);
    $this->parent_key = $parent_key;
  }
  
  function _display(&$fm, $lindex = null) {
    if (is_primary_language())
      $this->_url = update_url_query($this->_url, "langue");
    else
      $this->_url = update_url_query($this->_url, "langue", get_language());
    $lindex = isset($lindex) ? $lindex : 
              (isset($this->_index) ? $this->_index : 1);
    $this->set_rs($lindex);
    if (is_array($this->_rs)) {
      $lehtml .= "<a name=\"" . $this->_name . "\"></a>"
	   . $this->get_form()
	   . "<script>
	function showsection(thebouton) {
	  var parent = document.getElementById&&!document.all ? thebouton.parentNode.parentNode.parentNode : thebouton.parentElement.parentElement.parentElement ;
	  var subs = parent.getElementsByTagName('div');
	  subs[0].style.display = subs[0].style.display == 'none' ? 'block' : 'none';
	  thebouton.value = thebouton.value == '+' ? '-' : '+';
	}
  function doaction(thevalue) {
    var buttons = document.getElementsByName('plusbutton');
    for (var i = 0; i < buttons.length; i++) {
      if (buttons[i].value == thevalue)
        buttons[i].onclick();
    }
  }
	</script>
	<table border=\"0\" cellpadding=10 cellspacing=0 class=\"$this->outlineclass\">";
	    unset($this->rs);
	    $this->c = 0;
	    $this->level = 0;
	    reset($this->_rs);
	    while (list ($index, $subarray) = each($this->_rs) ) {
	        $this->rs[$subarray[$this->parent_key]][done] = false;
	        $this->rs[$subarray[$this->parent_key]][$subarray[$this->_key]] = $subarray;
	    }
	    while (list ($index) = each($this->rs) ) {
	        $lehtml .= $this->show_tree($index);
	    }
	    $lehtml .= "</table>";
	  }
	  if (!$this->no_form && !$this->hidden)
	    $lehtml .= "</form>";
	  $thebuttons = "<input class=\"formeZoombutton\" type=\"button\" style=\"width:20\" value=\"+\" name=\"plusbuttonmaster\" onclick=\"doaction('+')\">
	  <input class=\"formeZoombutton\" type=\"button\" style=\"width:20\" value=\"-\" name=\"minusbuttonmaster\" onclick=\"doaction('-')\">";
    echo "<table class=\"$this->outlineclass\" width=100%><tr><td>
    <table class=\"formeListe\" width=100%><tr><td> " . $this->_title . "</td></tr></table>
    <table width=100% cellpadding=0 cellspacing=0 style=\"background:url(" . sget("image_dir") . "grad1.gif) repeat-x\"><tr height=25>
     <td align=right>" . $thebuttons . "&nbsp;<td></tr></table><br>
     <table class=\"formeListe\" width=100% cellpadding=0  cellspacing=\"2\" cellpadding=\"2\">" .$lehtml . "</table>";
  }
  
  function show_tree($branchnum) {
	if ($this->level === 0)
	  $this->level++;
	else
	  $classname = "class=\"formtree\"";
    if (!$this->rs[$branchnum][done]) {
	  $this->rs[$branchnum][done] = true;
      $branch .= "<tr><td colspan=2><table class=\"formtree\" width=100% cellpadding=0 cellspacing=0>";
	  while (list ($index, $subarray) = each($this->rs[$branchnum]) ) {
	    $this->c++;
	    if ($index != "done") {
		  $branch .= "<tr id=\"" . $this->_name . $this->c  . "\">"
		   . $this->get_branch_detail($subarray) . $this->get_zoomtd($subarray[$this->_key], $this->c) . "</tr>";
		  if (isset($this->rs[$index]) && !$this->rs[$index][done]) {
		    $branch .= $this->show_tree($index, $this->rs[$index]);
		  }
		}
	  }
	  $branch .= $this->get_addbranch($branchnum);
	  $branch .= "</table><br></td></tr>";
    } else {
	  $branch = null;
	}
    return $branch;
  }
  
  function get_branch_detail($subarray) {
    $thehtml = "<td><table width=\"100%\" cellpadding=0 cellspacing=0><tr><td width=10 valign=\"top\"><img src=\"" . sget("image_dir") 
			. "icon_menutop.gif\" alt=\"\" width=\"6\" height=\"6\" border=\"0\" style=\"margin-top:4\"></td>";
    while (list($index2, $subarray2) = each($subarray)) {
      $thehtml .= $this->get_fieldtd($index2, $subarray2, $this->c);
    }
    $thehtml .= "</tr></table></td>";
    return $thehtml;
  }
  
  function get_fieldtd($index2, $subarray2, $c){
    if ($this->_fields[$index2]["visible"] != "N"){
      if ($this->_fields[$index2]["html_type"] == "select") {
        if (!is_array($this->_fields[$index2]["leschoix"])) {
          $choix = sql2arrayselect($this->_fields[$index2]["leschoix"]);
          $this->_fields[$index2]["leschoix"] = $choix;
        } else {
          $choix = $this->_fields[$index2]["leschoix"];
        }
        $choix = (is_array($choix)) ? array_flip($choix) : array(""=>"");
          
        $subarray2 = $choix[$subarray2];
        if ($subarray2 == "" && $this->_fields[$index2]["addself"] && $this->_fields[$index2]["field_description"] != "")
          $subarray2 = $this->_rs[$c][$this->_fields[$index2]["field_description"]];
      }
      $fieldvalue = $this->format($subarray2, $this->_fields[$index2]["display_format"], $this->_fields[$index2]["highlightreg"], $index2) . "&nbsp;";
        
      $thehtml .= "<td" . ($this->_fields[$index2]["html_class"] != "" ? " class=" . $this->_fields[$index2]["html_class"] : ($this->listofzoom ? " class=\"formeZoom\"" : "")) .
         ($this->_fields[$index2]["html_attribut"] != "" ? " " . $this->_fields[$index2]["html_attribut"] : "") .
        ">$fieldvalue</td>";
    }
    return $thehtml;
  }
  
  function get_addbranch($parent) {
    if (!$this->_no_update) {
        $this->c++;
        $thehtml .= "<tr id=\"" . $this->_name . $this->c  
    	 . "\"><td>&nbsp;&nbsp;&nbsp;</td><td align=right><table cellpadding=0 cellspacing=0><tr>" 
    	 . $this->get_addtable($parent, $this->c) . "</tr></table></td></tr>";
    }
    return $thehtml;
  }
  
  function get_addtable($parent, $c) {
    if (!$this->_no_update) {
        $classname = "";
        $classnemeselected = "formezoomListeselected";
        $the_url = $this->add_parametre($this->_url, 'mode=addbranch&index=' . $parent);
        $thehtml .= "<td class=\"formeListeCol1\" align=\"center\"  style=\"margin:0;padding:0\" onclick=\"window.location='$the_url'\"
         onmouseover=\"document.getElementById('iconeedit" . $c . "').src='" . sget('forms_image_dir') 
        . "plusover.gif'; document.getElementById('" . $this->_name.$c 
        . "').className='$classnemeselected';\" onmouseout=\"document.getElementById('iconeedit" . $c . "').src='" 
        . sget('forms_image_dir') . "plus.gif'; document.getElementById('"
        . $this->_name.$c ."').className='$classname';\"><img id=\"iconeedit" . $c . "\" style=\"margin:4\" onmouseover=\"this.src='" . sget('forms_image_dir') 
        . "plusover.gif'; document.getElementById('" . $this->_name.$c 
        . "').className='$classnemeselected';\" onmouseout=\"this.src='" 
        . sget('forms_image_dir') . "plus.gif'; document.getElementById('"
        . $this->_name.$c ."').className='$classname';\" src=\""
        . sget('forms_image_dir') . "plus.gif\" border=\"0\" alt=\""
        . get_str("alt_addbranch", "formtree") . "\"></td>";
    }
    return $thehtml;
  }
  
  function url_addbranch(&$fm) {
    $theparent = gget("index");
    $the_form = &$fm->get_form($this->zoom);
    $the_form->initializevalue($this->parent_key, $theparent);
    $the_form->url_add($fm);
    $the_form->initializevalue($this->parent_key, "");
  }
  
  function get_zoomtd($key, $c) {
    if (isset($this->zoom)) {
        $classname = "";
        $classnemeselected = "formezoomListeselected";
        $the_url = $this->add_parametre($this->_url, 'mode=zoom&index=' . $key);
        $html = "<td align=right style=\"margin:0;padding:0\"><table cellpadding=0 cellspacing=0 height=100% style=\"margin:0;padding:0\"><tr>";
        $html .= $this->get_addtable($key, $c) . "<td class=\"formeListeCol1\" align=center style=\"margin:0;padding:0\" onclick=\"window.location='$the_url'\"
         onmouseover=\"document.getElementById('iconezoom" . $c . "').src='" . sget('forms_image_dir') 
        . "zoomover.gif'; document.getElementById('" . $this->_name.$c 
        . "').className='$classnemeselected';\" onmouseout=\"document.getElementById('iconezoom" . $c . "').src='" 
        . sget('forms_image_dir') . "zoom.gif'; document.getElementById('"
        . $this->_name.$c ."').className='$classname';\"><img id=\"iconezoom" . $c . "\" style=\"margin:4\" onmouseover=\"this.src='" . sget('forms_image_dir') 
        . "zoomover.gif'; document.getElementById('" . $this->_name.$c 
        . "').className='$classnemeselected';\" onmouseout=\"this.src='" 
        . sget('forms_image_dir') . "zoom.gif'; document.getElementById('"
        . $this->_name.$c ."').className='$classname';\" src=\""
        . sget('forms_image_dir') . "zoom.gif\" border=\"0\" alt=\""
        . get_str("alt_edit", "FormList") . "\"></td>";
        $html .= "</tr></table></td>";
    }
    return $html;
  }
}
?>