<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp
/**
 * Base class
 * Display content compatible with FormWizard.
 * 
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
/**
 * Base class
 * Display content compatible with the other forms but without the 
 * need of the data base.  Used mostly with FormWizard.
 * 
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class FormRoot {
  var $_url;
/**
 * @var string form name
 */
  var $_name = "master";
  var $_title;
  var $_content;
  var $_g_custom;

  function FormRoot() { 
    $this->_url = $this->the_url();
  }
  function the_url(){
    return batir_href(aget("action"));
  }
   
/**
 * Change la valeur de la squence
 * 
 */
  function set_sequence(&$fm, $newsequence){
    $this->_sequence = $newsequence;
  }
  
/**
 * Incrmente la squence
 * @uses set_sequence() appel 
 */
  function inc_sequence($fm){    
    $this->set_sequence($fm, next_sequence());
  }
  
/**
 * Change la valeur du nom de la forme
 * @param string $newname
 */
  function set_name($newname){
    $this->_name = $newname;
  }
  
/**
 * Change la valeur du contenu de la forme
 *
 * @param string contient le texte de la forme, aussi du html, le _content
 * est affich directement dans {@link _display}
 */
  function set_content($newcontent){
    $this->_content = $newcontent;
  }
  
  function url_printerfriendly(&$fm){
    $this->show($fm);
  }
  
  function g_custom($function_name, $alt, $label){
    $this->_g_custom[$function_name]["function_name"] = $function_name;
    $this->_g_custom[$function_name]["label"] = $label;
    $this->_g_custom[$function_name]["alt"] = $alt;
  }
  function url_gcustom(&$fm){
    $function_name = gget("fn");
    $this->_g_custom[$function_name]["function_name"]($fm);
  }
  
  function show(&$fm){
    $this->_display($fm);
  }
  
  function set_title($title){
    $this->_title = $title;
  }
  function set_subtitle($title){
    $this->_subtitle = $title;
  }
  
  function get_url(){
    return $this->_url;
  }
  
  function _display(&$fm) {
    echo $this->_title;
    echo $this->_content;
  }

  function add_parametre($url, $param = "") {
    $str_url = "";

    if ( !preg_match("/\?/", $url) ) {
      $str_url = $url . "?";
    } else if ( !preg_match('/&$/', $url) ) {
      $str_url = $url . "&";
    } else {
      $str_url = $url;
    }
    if (!preg_match("/objet=/", $param))
      $str_url .= "objet=" . $this->_name . ($param == "" ? "" : "&" . $param);
    else
      $str_url .= $param;
    $str_url = update_url_query($str_url, "sequence", $this->_sequence);

    return get_urlmd5($str_url);
  } 

}?>