<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/

/**
 * Formulaire de recheche
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
 
 //31 mars 2003 ajout du support du where de base

// 2005/02/17 code revision and cleanup sp
/**
 * Formulaire de recheche
 *
 * Sur deux colonnes
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
 
class FormRecherche extends FormZoom {
  // contient les valeurs de recherche poster pour les champs picklist
  var $_where;
  // contient le type de recherche [string(default), begin_with, equal, picklist]
  var $_where_type;
  
  function FormRecherche($sql, $key = "", $connect = null){
    $this->FormZoom($sql, $key, $connect);
    $this->_buttonlabel_search = get_str("btn_buttonlabel_search", "FormRecherche"); 
    $this->_buttonlabel_newsearch = get_str("btn_buttonlabel_newsearch", "FormRecherche");
    $this->_subtitle = get_str("ttl_subtitle", "FormRecherche");  
    $this->no_navigate();
    $this->no_update();
    $this->search_on_request();
    $this->globaltable();
    $this->quick_filter = "";
    if(is_array($this->_fields)) {
      reset($this->_fields);
      while (list($index, $subarray) = each($this->_fields)) {
        $this->_where_type[$index]["search_type"] = "string";
      }
    }
    $this->no_recount = false;
  }
  
  function quick_filter($fieldname) {
    $this->hide($fieldname);
    $this->html_attribut($fieldname, " onchange=\"" . $this->formname . ".submit()\"");
    $this->quick_filter = $fieldname;
    /* il faudrait trouver le defaut selon si est un array ou un select v_pl
        if ($this->_fields[$this->quick_filter]["defaut"] == "") 
      $this->defaut($this->quick_filter, "H");*/
  }
  
  // ne pas afficher le critere s il n est pas significatif
  function no_criteria($fieldname, $value = true) {
    $this->set_property($fieldname, "no_criteria", $value);
  }
  
  function get_quick_filter() {
    if ($this->quick_filter != "")
    $the_quick_filter = ($this->_title != "" ? "&nbsp;&nbsp;" : "") . 
      get_control(
          $this->_fields[$this->quick_filter],
          $this->format($this->_fields[$this->quick_filter]["value"], 
            $this->_fields[$this->quick_filter]["display_format"], "", $this->quick_filter),
          false, null, $this->formname, $this->_alt_bd);
    return $the_quick_filter;
  }
  
  function set_subtitle($subtitle){
    $this->_subtitle = $subtitle;
  }

  function set_buttonlabel_search($buttonlabel) {
    $this->_buttonlabel_search = $buttonlabel;
  }
  
  function set_buttonlabel_newsearch($buttonlabel) {
    $this->_buttonlabel_newsearch = $buttonlabel;
  }
  
  function search_on_request($value = true){
    $this->search_on_request = $value;
    $this->visible = !$value;
  }
  
  function no_recount(){
    $this->no_recount = true;
  }
  
  function search_upper_vanilla($fldname){
    $this->_where_type[$fldname]["upper_vanilla"] = true;
  }
  function search_begin_with($fldname){
    $this->_where_type[$fldname]["search_type"] = "begin_with";
  }
  function search_equal($fldname){
    $this->_where_type[$fldname]["search_type"] = "equal";
  }
  function search_picklist($fldname, $operator = array()){
    $this->_where_type[$fldname]["search_type"] = "picklist";
    if ( count($operator) > 0 ) {
      $this->_where_type[$fldname]["operator"] = $operator;
    } else {
      $this->_where_type[$fldname]["operator"] = 
        array("=" => "=", "<=" => "<=", ">=" => ">=", ">" => ">", "<" => "<");
    }
  }

  function set_label_report($report,$label){
    $this->reports[$report]["label"] = $label;
  }
  function set_title_report($report,$title) {
    $this->reports[$report]["title"] = $title;
  }
  /**
    * @todo substitute value of pick lists
    */
  function get_criteres() {
    if (!$this->visible) { 
      reset($this->_fields);
      while (list($index, $subarray) = each($this->_fields)) {
        if($subarray["value"] != "" && !$subarray["no_criteria"]) {
          $critere = $subarray["label"];
          $valeur  = $subarray["value"];
          $type_where_clause = $this->_where_type[$index][search_type];
          $type_where_clause2 = $this->_where[$index][value]; 
          $type_recherche = get_phrase_critere($type_where_clause);
          if ($type_where_clause == "picklist")
            $type_recherche = $type_where_clause2;
          $str_criteres .= "<b>$critere</b> $type_recherche <b>$valeur</b>, ";
        }
      }
      return ($str_criteres != "" 
        ? "<br>" . substr($str_criteres, 0, strlen($str_criteres) -2) . "."
        : "");
    }
  }
  
  function _display_count($nb_record, $bouton = "", $siblings_select = null){
    $the_count = get_nb_records_2_str($nb_record);
    echo "<img src=\"./".sget("image_dir")."spacer.gif\" height=\"6\" border=\"0\"><br><a name=\"resultat\"></a>";
    if (isset($this->reports)){
      while (list($index, $subarray) = each($this->reports)){
        $url_printer_friendly = $this->add_parametre($this->_url, "report=O&mode=report&rapport=" . $index);
        $boutonreport .= "&nbsp;<input class=\"formeZoombutton\" type=\"button\" value=\"".$this->reports[$index]["label"]."\"  title=\"" . $this->reports[$index]["title"] . "\" onclick=\"show_printerfriendly_url(false, document.forms['forme'], '$url_printer_friendly', '" . $index . "');\" >";
      }
    } 
    $bouton = ($bouton != "" || $boutonreport != "" ? "<td align=\"right\">$boutonreport&nbsp;&nbsp;$bouton</td>" : "");
    
    echo "<table width=100% class=\"formeListeEntete\" cellpadding=5>
        <tr>
          <td>$the_count" . $this->get_criteres() . (isset($siblings_select) ? "</td><td align=right nowrap>$siblings_select" : "") . "</td>$bouton</tr>
      </table>";
  }
  
  function show(&$fm){
    if (gget("printerfriendly") == "O") {
      $old_no_update = $this->_no_update;
      $old_hide_header  = $this->_hide_header;
      $old_hide_footer  = $this->_hide_footer;
      $this->_no_update = true;
      $this->_hide_header = true;
      $this->_hide_footer = true;
      $this->printerfriendly = true;
    } 
    $this->_display($fm);
    if (gget("printerfriendly") == "O") {
      $this->printerfriendly = false;    
      $this->_no_update = $old_no_update; 
      $this->_hide_header = $old_hide_header;
      $this->_hide_footer = $old_hide_footer;
    }
    if (isset($this->_where)) 
      if (isset($fm->_forms[$this->_name]["details"]) || isset($fm->_forms[$this->_name]["searchsiblings"])){
        if (isset($fm->_forms[$this->_name]["searchsiblings"])) {
          $detailtype = "searchsiblings";
          if (!isset($this->activesearchsibling))
            $this->activesearchsibling = $fm->_forms[$this->_name][$detailtype][0];
        } else
          $detailtype = "details";
        reset($fm->_forms[$this->_name][$detailtype]);
        while (list($index, $subarray) = each($fm->_forms[$this->_name][$detailtype])){
          if ($detailtype != "searchsiblings" || $this->activesearchsibling == $subarray) {
          	 $the_form = &$fm->get_form($subarray);
          	 $the_form->insertbutton_in_title(false);
          	 if (!$this->no_recount)
             	$the_form->_sql->set_page_count();
            
          	 if (!$the_form->_no_update && $the_form->insertbutton_in_count && gget("printerfriendly") != "O") {
             	$bouton = "<input class=\"formeZoombutton\" type=\"button\" value=\"&nbsp;" . 
               		$the_form->_buttonlabel_add . 
               		"&nbsp;\" onclick=\"if (validate_form_" . $the_form->formname . "()) {document." . $the_form->formname . ".elements['mode'].value = 'add'; document." . $the_form->formname . ".submit();}\">";
               if (!$the_form->_no_insert && !$the_form->_no_update && 
                $the_form->listofzoom) {
                 $bouton .= "<input  class=\"formeZoombutton\"  type=\"button\" 
                 name=\"save\" value=\"" . $the_form->_buttonlabel_save . 
                 "\" onclick=\"if (validate_form_" . $the_form->formname . "()) {document." . $the_form->formname . ".elements['mode'].value = 'save'; document." . $the_form->formname . ".submit();}\">";
               }
			 } else
              $bouton = "";
          $this->_display_count($the_form->_sql->_nb_enregistrement, $bouton, $this->get_siblings_select($fm));
          
          if (gget("printerfriendly") == "O") {
            $old_no_update = $the_form->_no_update;
            $old_hide_header  = $the_form->_hide_header;
            $the_form->_no_update = true;
            $the_form->_hide_header = true;
            $the_form->printerfriendly = true;
          }
          $the_form->_display($fm);
          if (gget("printerfriendly") == "O") {
            $the_form->printerfriendly = false;    
            $the_form->_no_update = $old_no_update; 
            $the_form->_hide_header = $old_hide_header;
          }
          }
        }
      }
      if ($this->globaltable)
        echo "</td></tr></table>";
  }
  function get_siblings_select($fm) {
    if (isset($fm->_forms[$this->_name]["searchsiblings"])) {
      reset($fm->_forms[$this->_name]["searchsiblings"]);
      while (list($index, $subarray) = each($fm->_forms[$this->_name]["searchsiblings"])) {
        $onclick = " onclick=\"window.location='" . $this->add_parametre($this->_url, "mode=activesearchsibling&index=$subarray&ancre=$this->_name" ) . "';\""; 
        $html .= "<input type=\"radio\" name=\"activesearchsibling\" class=\"inputradio\"" . 
        ($this->activesearchsibling == $subarray ? "checked"  : $onclick). "><label style=\"cursor:pointer\"" . 
        ($this->activesearchsibling == $subarray ? ""  : $onclick) 
        . ">" . $fm->_forms[$subarray]["label"] . 
        "</label>&nbsp;";
      }
    }
    return $html;
  }
  
  function url_activesearchsibling(&$fm) {
    $this->activesearchsibling = gget("index");
    $this->show($fm);
  }
  
  function url_report(&$fm){
    $this->save_values(); 
    $this->thewhere = $this->get_where();
    $report = gget("rapport");
    if (isset($this->_where))
      if (isset($report)){
        $the_form = &$fm->get_form($report);
        if ($this->thewhere != "") {
          if ($the_form->_sql->_base_where != "") 
            $the_form->_sql->_modifie_where = $the_form->_sql->_base_where . " and ";
          else
            $the_form->_sql->_modifie_where = " where ";
          $the_form->_sql->_modifie_where .= $this->thewhere;
        } else {
          $the_form->_sql->_modifie_where = $the_form->_sql->_base_where;
        }
        $the_form->_sql->RebuiltSql();
        if (gget("printerfriendly") == "O") {
          $the_form->printerfriendly = true;
        }
    
        $the_form->i = 0;
        $url_printer_friendly = $the_form->add_parametre($the_form->_url, "nstop=O&popup=O&mode=list&index=1");
        sset("fm".gget("action"), $fm);
     echo "<frameset rows=\"*,0\"  FRAMEBORDER=yes FRAMESPACING=0 BORDER=1>
    <frame name=\"ttop\" src=\"$url_printer_friendly\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"auto\" noresize>
    <frame name=\"tbuttom\" src=\"./lib/vide.html\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"auto\" noresize>
    </frameset>
    <noframes>
    <!-- insert links here for people using browsers without frames capability -->
    </noframes>";
      }
  }
  
  function url_reset(&$fm){
    reset($this->_fields);
    while (list($index, $subarray) = each($this->_fields)){
      if (($this->_fields[$index]["updatable"] != "N") && ($this->_fields[$index]["visible"] != "N")) {
        $this->_fields[$index]["highlightreg"] = "";
        $this->_fields[$index]["value"] = "";
        $this->_where[$index]["value"] = "";
      }
    }
    $this->thewhere = $this->get_where();
    $this->url_find($fm, true);
  }

/*
   Bouton de recherche du formulaire
*/
  function url_find(&$fm, $no_save = false) {
    if (!$no_save) {
      $this->save_values();
      $this->thewhere = $this->get_where();
    }
    // ajout du support du where de base
    if (isset($fm->_forms[$this->_name]["details"]) || isset($fm->_forms[$this->_name]["searchsiblings"])){
      if (isset($fm->_forms[$this->_name]["searchsiblings"])) {
        $detailtype = "searchsiblings";
        if (!isset($this->activesearchsibling))
          $this->activesearchsibling = $fm->_forms[$this->_name][$detailtype][0];
      } else
          $detailtype = "details";
      reset($fm->_forms[$this->_name][$detailtype]);
      while (list($index, $subarray) = each($fm->_forms[$this->_name][$detailtype])){
        $the_form = &$fm->get_form($subarray);
        if ($this->thewhere != "") {
          if ($the_form->_sql->_base_where != "") 
            $the_form->_sql->_modifie_where = $the_form->_sql->_base_where . " and ";
          else
            $the_form->_sql->_modifie_where = " where ";

          $the_form->_sql->_modifie_where .= $this->thewhere;
        } else {
          $the_form->_sql->_modifie_where = $the_form->_sql->_base_where;
        }
        $the_form->_sql->RebuiltSql();
        $the_form->_sql->set_page_count();
        reset($this->_fields);
        //* support champs optionels
        while (list($index, $subarray) = each($this->_fields)){
          if (isset($the_form->_fields[$index])){
            $the_form->highlightreg($index, $subarray["highlightreg"]);
            if ($the_form->_fields[$index]["optional_search"]){
              if ($this->_fields[$index]["value"] != "")
                $the_form->_fields[$index]["visible"] = "O";
              else
                $the_form->_fields[$index]["visible"] = "N";
            }
          }
        }
        $the_form->set_index(1);
      }
    }
    $this->show($fm);
  }
  function no_highlightreg($fieldname, $no_highlightreg = true){
    $this->set_property($fieldname, "no_highlightreg", $no_highlightreg);
  }
  function stabilize_detailedfields(){
    reset($this->_fields);
    while (list($index, $subarray) = each($this->_fields))
      if (!$this->detailedon){
        if ($subarray["detailed"]){
          $this->_fields[$index]["value"] = "";
          $this->_where[$index]["value"] = "";
        }
      }
  }
  function cleanregex($value){
    return preg_replace("/[^-\s\w]*/", "", $value);
  }
  function url_detailed(&$fm){
    $this->detailedon = !$this->detailedon;
    $this->stabilize_detailedfields();
    $this->url_find($fm, true);
  }
  //---------------------------------------------------------
  // Retourne une concatennation de tout les clause where
  //---------------------------------------------------------
  function get_where(){
    $thewhere = "";
    if(is_array($this->_fields)) {
      reset($this->_fields);
      // pour chaque champ du zoom
      while (list($index, $subarray) = each($this->_fields)) {
        // si le champ est utilis dans la recherche
        if (($this->_fields[$index]["visible"] != "N") || $index == $this->quick_filter) {
          $this->_fields[$index]["highlightreg"] = "";
          if ($this->_where_type[$index]["search_type"] == "string" || 
                $this->_where_type[$index]["search_type"] == "begin_with")
            $thevalue = wrap_re_char(trim( $this->cleanregex($this->_fields[$index]["value"]) ));
          else
            $thevalue = wrap_re_char(trim( $this->_fields[$index]["value"] ));
          
          if ($this->_where_type[$index]["upper_vanilla"])
            $uv_thevalue = upper_vanilla(trim( $this->_fields[$index]["value"] ));
          // utilise le champ pour batir la requete seulement si une valeur est fournit
          if ($thevalue != "") {
            // [string(default), begin_with, equal, picklist]
  
            switch ($this->_where_type[$index]["search_type"]) {
              case "string":
                if ($thewhere != "") {
                  $thewhere .= " and (";
                } else {
                  $thewhere .= " (";
                }
                $highlightreg = "";
                // Au moin un des key word spcifi doit etre trouv dans le champ
                $array_result = preg_split("/\s/" , $thevalue, -1, PREG_SPLIT_NO_EMPTY);
                if ($this->_where_type[$index]["upper_vanilla"])
                  $uv_array_result = preg_split("/\s/" , $uv_thevalue, -1, PREG_SPLIT_NO_EMPTY);
                
                $result_count = count($array_result);
                for ($c=0; $c<$result_count; $c++) {
                  if ($c > 0) {
                    $thewhere .= " and "; 
                    $highlightreg .= "|";
                  }
                  if ($this->_where_type[$index]["upper_vanilla"])
                    $value = "%" . strtoupper($uv_array_result[$c]) . "%";
                  else
                    $value = $array_result[$c];
                  
                  $key_word_wraped = wrapdata(
                    $this->wrap($this->_fields[$index]["html_type"], $value, $this->_fields[$index]["toupper"], $this->_fields[$index]["non"], $index),
                    $this->_sql->field_description[strtolower($index)]["field_type"]
                  );
                  if ($this->_where_type[$index]["upper_vanilla"])
                    $thewhere .= "uv_" . $index . " like " . $key_word_wraped;
                  else 
                    $thewhere .= $index . " ~* " . $key_word_wraped;
                  $highlightreg .= $array_result[$c];
                }
                $this->_fields[$index]["highlightreg"] = $highlightreg;
                $thewhere .= ") ";
              break;
              case "begin_with":
                if ($thewhere != "") { $thewhere .= " and "; }
  
                $thevalue_wraped = wrapdata($this->wrap($this->_fields[$index]["html_type"], 
                        "^" . $thevalue, $this->_fields[$index]["toupper"], $this->_fields[$index]["non"], $index),
                                $this->_sql->field_description[strtolower($index)]["field_type"]);
                $thewhere .= $index . " ~* " . $thevalue_wraped;
                
                $this->_fields[$index]["highlightreg"] = "^" . $thevalue;
              break;
              case "equal":
                if ($thewhere != "") { $thewhere .= " and "; }
                if ($this->_fields[$index]["validation_type"] == "string") {
                  $thevalue = "^" . $thevalue . "$";
                  $theequal = " ~* ";
                } else {
                  $theequal = " = ";
                }
                $thevalue_wraped = wrapdata(
                  $this->wrap($this->_fields[$index]["html_type"], $thevalue, 
                $this->_fields[$index]["toupper"], $this->_fields[$index]["non"], $index),
                  $this->_sql->field_description[strtolower($index)]["field_type"]
                );
  
                $thewhere .= $index . $theequal . $thevalue_wraped;
                $this->_fields[$index]["highlightreg"] = $thevalue;
              break;
              case "picklist":
                if ($thewhere != "") { $thewhere .= " and "; }
  
                $thevalue_wraped = wrapdata(
                  $this->wrap($this->_fields[$index]["html_type"], $thevalue, 
                $this->_fields[$index]["toupper"], $this->_fields[$index]["non"], $index),
                  $this->_sql->field_description[strtolower($index)]["field_type"]
                );
                   //utiliser la variable where
                $thewhere .= $index . " " . pget("where_" . $index) . " " . $thevalue_wraped;
              break;
            }
            if ($this->_fields[$index]["no_highlightreg"])
                $this->_fields[$index]["highlightreg"] = "";
          }
        }
      } 
      if ($this->_sql->_base_where != ""){
        if ($thewhere != "")
          $thewhere = preg_replace("/where /i", "", $this->_sql->_base_where) . " and " . $thewhere;
        else
          $thewhere = preg_replace("/where /i", "", $this->_sql->_base_where);
      }
    }
    return $thewhere;
  }


  function get_fieldtr($index, $value){
    if ($this->_fields[$index]["html_type"] == "hidden") {
       $lehtml = get_control(
         $this->_fields[$index],
         $this->format($value, $this->_fields[$index]["display_format"]),
         false, $this->formname, $this->_alt_bd);
      echo $lehtml;
    } else {
      $hint = $this->_fields[$index]["hint"];
      $hint_div = "";
      if ($hint != "") {
        $hint_div = "<div title=\"" . $hint . "\">";
      }

      echo "<tr>\n";

      // LABEL
      echo "<td align=\"right\" valign=\"bottom\" ><table width=100% cellpadding=0 cellspacing=0><tr><td valign=\"bottom\" class=\"formeZoomCol1\"" . (($this->_fields[$index]["html_type"] == "memo") ? " style=\"vertical-align:top;\"" : "") . ">" .
        $hint_div . $this->_fields[$index]["label"] . (($this->_where_type[$index]["search_type"] != "picklist" && $this->_fields[$index]["updatable"] != "N" && !$this->_no_update) ? (($this->_fields[$index]["null"] == "N" && $this->_fields[$index]["html_type"] != "checkbox") ? "&nbsp;*" : "&nbsp;&nbsp;") : ($this->_where_type[$index]["search_type"] != "picklist" ? "&nbsp;&nbsp;" : "")) .
        ($hint != "" ? "</div>" : "");
      // TYPE DE RECHERCHE (pick_list)
      if ($this->_where_type[$index]["search_type"] == "picklist"){
        if ($this->printerfriendly) {
          echo "&nbsp;" . $this->_where[$index]["value"];
        } else {
          $operator = $this->_where_type[$index]["operator"];
          echo $hint_div . "&nbsp;</td><td width=\"50\" valign=\"bottom\" align=right><select name=\"where_" . $index . "\">\n";
          while ( $oper = each($operator) ) {
              echo "<option value=\"" . htmlentities($oper[1]) . "\" " .
                (($this->_where[$index]["value"] == $oper[1]) ? " SELECTED" : "") .
                ">" . htmlentities($oper[0]) . "</option>\n";
          }
          echo "</select>&nbsp;&nbsp;\n" . ($hint != "" ? "</div>" : "");
        }
      } 

      echo "</td></tr></table></td>\n";

      // CHAMP D'ACQUISITION
      $lehtml = $this->get_tdcontrol(
        $this->_fields[$index],
        $value,        
        $this->printerfriendly, null,
        $this->formname, $this->_alt_bd);
        
      $lehtml .= $this->get_fieldboutonjs($index);
      $lehtml = "<td" . (($this->_fields[$index][html_class] != "") ? " class=" . $this->_fields[$index][html_class] : "") . " valign=\"bottom\">" .
        $hint_div . $lehtml . ($hint != "" ? "</div>" : "") . "</td>";
      echo $lehtml;
      echo "</tr>\n";
    }
  }


  function get_header(&$fm, $lindex){
  }
  
  function get_displaybutton(){
    if ($this->search_on_request) {
      if (file_exists(sget("forms_image_dir")."minimize.gif")) {
       $btmin = " style=\"background-image: url(" . 
         sget("forms_image_dir") . ($this->visible ? "minimize" : "minimize_off") .".gif); background-repeat: no-repeat; background-position: center;height: 27; width: 27;\" ";
       $btmax = " style=\"background-image: url(" . 
         sget("forms_image_dir") . ($this->visible ? "maximize_off" : "maximize") .".gif); background-repeat: no-repeat; background-position: center;height: 27; width: 27;\" ";
      } else {
        $btmin = " value=\"&nbsp;-&nbsp;\" ";
        $btmax = " value=\"&nbsp;+&nbsp;\" ";
      }
      $btmin .= $this->visible ? "" : " disabled ";
      $btmax .= $this->visible ? " disabled " : "";
      $urlmin = $this->add_parametre($this->_url, "&mode=minimize");
      $urlmax = $this->add_parametre($this->_url, "&mode=maximize");
      
      $htmlbuton = "<input class=\"formeZoombutton\" type=\"BUTTON\" $btmin
        onClick=\"window.location='$urlmin'\" title=\"" . get_str("hnt_hide") . "\"><input 
        class=\"formeZoombutton\" type=\"BUTTON\" $btmax
        onClick=\"window.location='$urlmax'\" title=\"" . get_str("hnt_display") . "\">";
      return $htmlbuton;
    }
  }
  
  function url_change_vibility(&$fm){
    $this->visible = !$this->visible;
    $this->show($fm);
  }
  function url_minimize(&$fm){
    $this->visible = false;
    $this->show($fm);
  }  
  function url_maximize(&$fm){
    $this->visible = true;
    $this->show($fm);
  }
  
  
  function _display(&$fm, $lindex = null) {
     $this->_url = update_url_query($this->_url, "langue", is_primary_language() ? null : get_language());
    echo "<form name=\"$this->formname\" action=\"" . 
      $this->add_parametre($this->_url, "mode=find&ancre=resultat") . "\" method=post>
    <input type=\"hidden\" name=\"sequence\" value=\"$this->_sequence\">";
    if ($this->visible) { 
    if ($this->context != "") {
      echo "<table class=\"context\" width=100% cellpadding=10><tr><td>\n";
      echo $this->context;
      echo "</td></tr></table>";
    }
    
    echo "<table class=\"$this->outlineclass\" width=100% border=0 cellpadding=0 cellspacing=0>
    <tr>
    <td><table class=\"formezoomTitle\" border=0 cellspacing=0 width=100%><tr><td class=\"formezoomTitleLeft\"></td>";
        echo "<td class=\"formezoomTitleMiddle\">" . $this->_title . $this->get_quick_filter() . "</td>";
    if ($this->search_on_request || (isset($this->_g_custom) && !$this->printerfriendly))
    echo "<td align=\"right\" class=\"formezoomTitleMiddle\">" . $this->get_g_custom(true) . $this->get_displaybutton() . "</td>";
        
        echo "<td class=\"formezoomTitleRight\"></td></tr></table></td>";
    echo "</tr><tr><td align=center><table>";
    if (!$this->_hide_header) {
      $this->get_header($fm, $lindex);
    } 
    if ($this->detailed) { 
      echo "<tr><td></td><td><span class=\"critere\">" . get_str("lbl_recherche") . "</span>";
      $onclick = " onclick=\"window.location='" . $this->add_parametre($this->_url, "mode=detailed&ancre=" . $this->_name) . "';\""; 
      echo "<input type=\"radio\" name=\"detailed\" class=\"inputradio\"" . 
        (!$this->detailedon ? "checked"  : $onclick). "><label style=\"cursor:pointer\" " . 
        (!$this->detailedon ? ""  : $onclick) 
        . ">" . get_str("lbl_summary") . 
        "</label>&nbsp;<input type=\"radio\" name=\"detailed\" class=\"inputradio\"" 
        . ($this->detailedon ? "checked"  : $onclick) . "><label style=\"cursor:pointer\" " . 
        ($this->detailedon ? ""  : $onclick) . ">" .
        get_str("lbl_detailed", "FormRecherche") . "</label>";
    } else {
      echo "<tr><!--<td></td>--><td colspan=\"2\" align=\"center\"><span class=\"critere\">" . 
      $this->_subtitle . "</span>";
    }
    echo "<br><br></td></tr>";
    reset($this->_fields);
    while (list($index, $subarray) = each($this->_fields)){
       if ($this->_fields[$index]["visible"] != "N" && ($this->detailedon || (!$this->detailedon && !$subarray["detailed"]))){
          if (isset($this->_sections[$index][before]))
            $this->get_section($this->_sections[$index][before]);
          if (isset($this->_spacers[$index][before]))
            $this->get_spacer();
          $this->get_fieldtr($index,$this->_fields[$index]["value"]);
          if (isset($this->_sections[$index][after]))
            $this->get_section($this->_sections[$index][after]);
          if (isset($this->_spacers[$index][after]))
            $this->get_spacer();
      }
    }
    if (!$this->_hide_footer){
      $this->get_footer($fm, $lindex);
    }
    echo "</table></form>";
    if (!$this->globaltable)
      echo "</td></tr></table>";
    } else {   
      if ($this->globaltable) {
        echo "<table class=\"$this->outlineclass\" width=100% border=0 cellpadding=0 cellspacing=0>
        <tr>
        <td><table class=\"formezoomTitle\" border=0 cellspacing=0 width=100%><tr><td class=\"formezoomTitleLeft\"></td>";
        echo "<td class=\"formezoomTitleMiddle\">" . $this->_title . $this->get_quick_filter() . "</td>";
        if ($this->search_on_request)
          echo "<td class=\"formezoomTitleMiddle\" align=\"right\">" . $this->get_g_custom(true) .  $this->get_displaybutton() . "</td>";
        
        echo "<td class=\"formezoomTitleRight\"></td></tr></table></td>";
        echo "</tr><tr><td align=center colspan=2>";
      }
    echo "</form>";
    }
    sset("fm", $fm);
  }

  function get_footer(&$fm, $lindex){
    echo "<tr><td height=50 colspan=3 align=center>";
    echo "<table width=100%><tr>";
    echo "<td align=center>";
    echo get_formbutton($this->_fields, $this->_buttonlabel_search, "", "", "", "submit") . "&nbsp;";
    if(!$this->hide_reset_button)
      echo "<input class=\"formeZoombutton\" type=\"button\" value=\"" . $this->_buttonlabel_newsearch . "\" onclick=\"window.location='" . $this->add_parametre($this->_url, "mode=reset&ancre=resultat") . "'\">";
    echo "</td>";
    echo "</tr></table></td></tr>";
  }
  
  function save_values(){
	    if(is_array($this->_fields)) {
	      reset($this->_fields);
	      while (list($index, $subarray) = each($this->_fields)){
	         $this->_fields[$index]["value"] = $this->wrap($this->_fields[$index]["html_type"],
	          gget("mode") == "find" || gget("mode") == "report" ? pget($this->_fields[$index]["name"]) : "", 
	          $this->_fields[$index]["toupper"], 
	          $this->_fields[$index]["non"], $index);
	         $this->_where[$index]["value"] = pget("where_" . $index);
	      }
	    }
	    if ($this->quick_filter != "" && $this->_fields[$this->quick_filter]["value"] == "")
	      $this->_fields[$this->quick_filter]["value"] = $this->_fields[$this->quick_filter]["defaut"];
  }

  function hide_reset_button(){
    $this->hide_reset_button = true;
  }
}
?>