<?php 
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
// 2005/02/17 code revision and cleanup sp

/**
 * Gestionnaire de formes
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
  function show($acces_right){
    $no_sequence = aget("no_sequence");
    $multifm = aget("multifm");
    if (function_exists("fermer")) {
      fermer();
    } else {
      $is_wizard = function_exists("init_wizard");
      if (function_exists("show_connexion")) {
        show_connexion();
      } else {
      if (function_exists("preshow"))
         preshow();
      if ((!$multifm && (sget("theaction") != gget("action") || !isset($_SESSION[get_constant("SITE_NAME")]["fm"])))
        || !isset($_SESSION[get_constant("SITE_NAME")]["fm".gget("action")]) 
        || trim(gget("objet").gget("mode").gget("index").gget("order")) == "") {
        if ($is_wizard)
          $fm = new FormWizard();
        else
          $fm = new FormMaster();
        $fm->_wright = $acces_right == "" ? "w" : $acces_right;
        if (function_exists("ignition"))
          ignition($fm);
        sset("theaction", gget("action"));
      } else {
        if (!$multifm)
          $fm = sget("fm");
        else {
          $fm = sget("fm".gget("action"));
          sset("fm", $fm);
        }
      }
      $cms_sequence = get_sequence(); 
      $url_sequence = gget("sequence");
      if (!$no_sequence && $url_sequence != "" && $cms_sequence != $url_sequence && !$is_wizard) {
        ignition($fm); 
        $fm->reset_first_time = true;
	   $msg = get_str("msg_errorprevious", "FormMaster");
     
     if(aget("controle_sequence_invalide")) {
       fermer_session();
       echo "<script language=\"javascript\">
               alert('" . get_str("msg_illegaloperation", "FormMaster") . "');
             </script>";
     }
     else {
	     echo_box($msg);
		 }
	    if ($is_wizard)
          $fm->dispatch_wiz($fm->_entry, "show");
        else
          $fm->dispatch($fm->_entry, "show");
      } else {    
        if ($is_wizard)
          $fm->dispatch_wiz();
        else
          $fm->dispatch();
      }
      inc_sequence();
        if (!$multifm)
          sset("fm", $fm);
        else
          sset("fm".gget("action"), $fm);
      }
    }
  }
  
/**
 * La squence sert  synchroniser les actions pour ne pas rpter les actions tel que
 * sauvegarde ou erase
 */
function get_sequence(){
      if (!isset($_SESSION[get_constant("SITE_NAME")]["cms_sequence"])) {
        $cms_sequence = array ();
        array_push($cms_sequence, ia_rand());
        sset("cms_sequence", $cms_sequence);
      } else {
        $cms_sequence = sget("cms_sequence");
      }
      return $cms_sequence[0];
}

function inc_sequence(){
  $cms_sequence = sget("cms_sequence");
  if (gget("printerfriendly") != "O" && gget("popup") != "O") {
    if (is_array($cms_sequence))
      array_shift($cms_sequence);
    sset("cms_sequence", $cms_sequence);
  } 
}

function next_sequence($force = ""){
  $cms_sequence = sget("cms_sequence");
  if (gget("printerfriendly") != "O" && gget("popup") != "O" || $force != "force") {
    if (!isset($cms_sequence[1])) {
      if (!is_array($cms_sequence))
        $cms_sequence = array ();
      array_push($cms_sequence, ia_rand());
    }
    sset("cms_sequence", $cms_sequence);
  }
  if  (gget(popup) != "O") 
    return $cms_sequence[1];
  else
    return $cms_sequence[0];
}

 /**
  * Controle les sequences incorrectes, cette fonction dtruit la session en cours si le numro de
  * sequence n'est pas valide
  */
  function sequence_valide($url){ 
    if(gget("sequence")) {
      if(gget("sequence") != get_sequence()){
        session_destroy();
        echo "<script>window.location='".$url."'</script>";
        return false;
      }
    }
    return true;
  }


 /**
 * Gestionnaire de formes
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
class FormMaster {
  var $_entry;
  var $_wright;
  var $first_time;
  var $reset_first_time;
  var $first_time_object_name;
  var $first_time_mode;
  var $sequence;
  var $_forms; /*
        form
        type zoom, detail
        init_function
        zoom
        parent
        master
        details
        status */
  
  function FormMaster(){
    $this->first_time = true;
    $this->reset_first_time = false;
  }
  
  function first_time_action($object_name, $mode = null){
    if (!isset($mode))
      $mode = "show";
    $this->first_time_object_name = $object_name;
    $this->first_time_mode = $mode;
  }
  
  function first_time_action_object($object_name, $mode = null){
    if (!isset($mode))
      $mode = "show";
    $this->first_time_object[$object_name]["mode"] = $mode;
    $this->first_time_object[$object_name]["first_time"] = true;
  }
  /**
    * @todo revise get_type_acces
    * @todo revise zoom_connection ...
    */
  function add_form($name, &$form){
    if (!isset($this->_forms)) {
      $this->_entry = $name;
    }
    $this->_forms[$name]["form"] = &$form;
    $this->_forms[$name]["form"]->set_name($name);
    if ($this->_wright == "r"){
      $this->_forms[$name]["form"]->no_update();
    }
    $this->_forms[$name]["status"] = "defined";
  }
  
  // retourne une reference a la forme qui est demande
  // si son status est undefined, la forme est initialisee
  function &get_form($name){
    if ($this->_forms[$name]["status"] == "undefined") {
      $this->_forms[$name]["init_function"]($this);
      $after_init = "after_" . $this->_forms[$name]["init_function"];
      if (function_exists($after_init))
        $after_init($this);
    }
    return $this->_forms[$name]["form"];
  }
  
  // prend une reference de la forme voulue et verifie si la methode
  // existe avant de l'executer
  function dispatch($object_name = null, $mode = null) {
    if (isset($this->_entry)) {
    if ($this->first_time || $this->reset_first_time) {
      if ($this->first_time_object_name != "" && ($this->first_time || $this->reset_first_time)) {
        $object_name = $this->first_time_object_name;
        $mode = $this->first_time_mode;
      }
      $this->first_time = false;
      $this->reset_first_time = false;
    }
    if ($this->_wright != "N"){
      if (!isset($object_name))
        $object_name = gget("objet");
      if ($object_name == "" || !isset($this->_forms[$object_name]))
        $object_name = $this->_entry;
      $the_form = &$this->get_form($object_name);
      if (isset($this->first_time_object[$object_name]["mode"])
       && ($this->first_time_object[$object_name]["first_time"] || gget("resetobj") === "O")){
        $mode = $this->first_time_object[$object_name]["mode"];
        $this->first_time_object[$object_name]["first_time"] = false;
      }
      $the_form->set_sequence($this, next_sequence());
      $pmode = pget("mode");
      $gmode = gget("mode");
      $mode = (isset($mode) ? $mode : "url_" . ($gmode == "pget" ? $pmode : $gmode));

      if (gget("printerfriendly") == "O" && $mode != "url_zoom" && $mode != "url_unzoom" && $mode != "url_report" && $mode != "url_saveas") $mode = "url_printerfriendly";
      if ($mode == "" || !method_exists($the_form, $mode))
         $mode = "show";
      $the_form->$mode($this);
    } else { 
      echo_box(get_str("msg_refusedaccess", "FormMaster"));
    }
    }
  }
  
  // prepare les parametres pour batir un zoom s'il est demande
  function register_zoom($name, $parent, $init_function){ 
    $this->_forms[$parent]["zoom"] = $name;
    $this->_forms[$parent]["form"]->zoom = $name;
    $this->_forms[$name]["parent"] = $parent;
    $this->_forms[$name]["init_function"] = $init_function;
    $this->_forms[$name]["status"] = "undefined";
  }
  function register_form($name, $init_function){ 
    $this->_forms[$name]["init_function"] = $init_function;
    $this->_forms[$name]["status"] = "undefined";
  }
  
  // prepare les parametres pour batir un detail s'il est demande
  function register_detail($name, $master, $joinfield, $init_function){ 
    if (!isset($this->_forms[$master]["details"]))
      $this->_forms[$master]["details"] = array ();
    if (!in_array($name, $this->_forms[$master]["details"]))
      array_push($this->_forms[$master]["details"], $name);
    $this->_forms[$name]["parent"] = $this->_forms[$master]["parent"];
    $this->_forms[$name]["master"] = $master;
    $this->_forms[$name]["joinfield"] = $joinfield;
    $this->_forms[$name]["init_function"] = $init_function;
    $this->_forms[$name]["status"] = "undefined";
    
    $the_master = &$this->get_form($master);
    $the_master->_type_formulaire = "master";
  }
  
  // prepare les parametres pour batir un detail de type searchsibling s'il est demande
  function register_searchsibling($name, $master, $joinfield, $init_function, $label = null){ 
    if (!isset($this->_forms[$master]["searchsiblings"]))
      $this->_forms[$master]["searchsiblings"] = array ();
    if (!in_array($name, $this->_forms[$master]["searchsiblings"]))
      array_push($this->_forms[$master]["searchsiblings"], $name);
    $this->_forms[$name]["parent"] = $this->_forms[$master]["parent"];
    $this->_forms[$name]["master"] = $master;
    $this->_forms[$name]["joinfield"] = $joinfield;
    $this->_forms[$name]["init_function"] = $init_function;
    $this->_forms[$name]["status"] = "undefined";
    $this->_forms[$name]["label"] = $label;
    
    $the_master = &$this->get_form($master);
    $the_master->_type_formulaire = "master";
  }
  
  // prepare les parametres pour batir un rapport s'il est demande
  function register_report($name, $searchform, $orderbyform, $init_function){ 
    $this->_forms[$searchform]["reports"][$name]["name"] = $name;
    $this->_forms[$searchform]["form"]->reports[$name]["name"] = $name;
      
    $this->_forms[$name]["searchform"] = $searchform;
    $this->_forms[$name]["orderbyform"] = $orderbyform;
    $this->_forms[$name]["init_function"] = $init_function;
    $this->_forms[$name]["status"] = "undefined";
  }
  
  // lien entre le parent et le zoom
  // a faire apres l'initialisation des deux objets
  // dans la plus part des cas, se fera apres l'initialisation
  // du zoom puisque normalement le parent devrait etre deja initialise
  function link_zoom($zoom){
    if (isset($this->_forms[$zoom]["parent"])) {
      $the_parent = &$this->get_form($this->_forms[$zoom]["parent"]);
      $the_parent->add_zoom($zoom);
      $the_child = &$this->get_form($zoom);
      $the_child->set_parent($this->_forms[$zoom]["parent"]);
    }
  }
  
  // lien entre le master et le detail
  // a faire apres l'initialisation des deux objets
  // dans la plus part des cas, se fera apres l'initialisation
  // du detail puisque normalement le master devrait etre deja initialise
  function link_detail($detail_name){
    $the_master = &$this->get_form($this->_forms[$detail_name]["master"]);
    $the_master->add_detail($detail_name);
    
    $the_detail = &$this->get_form($detail_name);
    $the_detail->set_master($this->_forms[$detail_name]["master"], $this->_forms[$detail_name]["joinfield"]);
  }
  
  // lien entre le master et le detail
  // a faire apres l'initialisation des deux objets
  // dans la plus part des cas, se fera apres l'initialisation
  // du detail puisque normalement le master devrait etre deja initialise
  function link_searchsibling($searchsibling_name){
    $the_master = &$this->get_form($this->_forms[$searchsibling_name]["master"]);
    $the_master->add_searchsibling($searchsibling_name);
    
    $the_searchsibling = &$this->get_form($searchsibling_name);
    $the_searchsibling->set_master($this->_forms[$searchsibling_name]["master"], $this->_forms[$searchsibling_name]["joinfield"]);
  }
  
  // lien entre le report et les objets qu'il utilise
  // a faire apres l'initialisation des deux objets
  // dans la plus part des cas, se fera apres l'initialisation
  // du report puisque normalement le master devrait etre deja initialise
  function link_report($report_name){    
    $the_report = &$this->get_form($report_name);
    $the_report->searchform = $this->_forms[$report_name]["searchform"];
    $the_report->orderbyform = $this->_forms[$report_name]["orderbyform"];
  }
  
}
?>