<?php
/******************************************************************************
  Copyright (c) 2001-2005 by Les consultants INTERACTION inc.

  Jade Web Framework

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  This software consists of voluntary contributions made by many
  individuals on behalf of Jade Web Framework Project.

  For more information on the Jade Web Framework Project, 
  please see 
  http://www.consultantsinteraction.com/fr/action.jade_presentation.shtml
******************************************************************************/
 
/**
 * Liste le contenu d'une table
 * @package Jade
 * @filesource
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
 /**
 * Liste le contenu d'une table
 *
 * Liste non ditable
 * @package Jade
 * @copyright Les consultants INTERACTION inc.
 * @license http://opensource.org/licenses/gpl-license.php GNU Lesser General Public License
 */
// 2005/02/17 code revision and cleanup sp
class FormList extends FormBase {
  var $_title = "";
  var $_no_zoom;
  var $_error_message_ligne_sup;
  var $_custom;
  var $_customjs;
  var $class_chiffre = "formeListeColChiffre";

  function FormList($sql, $key = "", $connect = null) {
    $this->FormBase($sql, $key, $connect);
    $this->_error_message_ligne_sup = get_str("msg_ligne_sup", "FormList");
    //* support optional search
    reset($this->_fields);
    $this->formname = "formelist";
    while (list($index) = each($this->_fields)){
      $this->_fields[$index]["optional_search"] = false;
    }
    $this->_sql->row_per_page(15);
    $this->_no_zoom = false;
    $this->hidden = false;
    $this->listofzoom = false;
    $this->no_orderby = false;
    $this->insertmode = false;
    $this->outlineclass = "formeListeOutline";
    $this->insertbutton_in_count = true;
    $this->insertbutton_in_title = true;
    $this->use_master_validation = true;
    $this->_no_save_button = false;
    $this->_buttonlabel_save =  get_str("alt_save", "FormList");
    $this->_buttonlabel_erase = get_str("alt_deleteselection", "FormList");
    $this->_buttonlabel_erase_msg = get_str("msg_deleteselection", "FormList");
    $this->savehandeled = false;
    $this->navigationwithpost = false;
  }
  
  function savehandeled(){
    $this->savehandeled = true;
	  $this->no_form();
	  $this->_no_save_button = true;
	  $this->formname("forme");
	  $this->use_master_validation = true;
  }
  
  
  function use_master_validation($value){
    $this->use_master_validation = $value;
  }
  
  function insertbutton_in_count($value = true){
    $this->insertbutton_in_count = $value;
  }
  
  function insertbutton_in_title($value = true){
    $this->insertbutton_in_title = $value;
  }
  
  function listofzoom($listofzoomname){
    $this->listofzoomname = $listofzoomname;
    $this->listofzoom = true;
    $this->_no_delete = false;
  }
  
  function hidden($hide){
    $this->hidden = $hide;
  }
  
  function no_zoom($value = true){
    $this->_no_zoom = $value;
  }
  
  function url_zoom(&$fm){
    if (!$this->_no_zoom)
      $fm->dispatch($this->zoom);
  }
  function url_unzoom(&$fm){
    $this->show($fm);
  }
  function url_add(&$fm){
    if ($this->listofzoom && $this->zoom == "") {
      $this->insertmode = true;
      $result = $this->save($fm);
      if ($result != "")
        echo_box($this->listofzoomform->msg_error, "error");
      $this->url_move_first($fm);
      
      if ($this->listofzoomform->on_insert_focus != "") {
        echo "<input type=\"hidden\" id=\"focuscontrol\" value=\"id_fld_" . $this->listofzoomform->on_insert_focus . "0\">";
      }
      $this->insertmode = false;
    } else {
      $fm->dispatch($this->zoom);
    }
  }
  
  function url_list(&$fm){
    $this->_index = gget("index");
    $this->show($fm);
  }

  function get_prev(){
    $lindex = gget("index");
    if ($lindex > 1) $lindex--;
    return $lindex;
  }  
  function get_next(){
    $lindex = gget("index");
    if ($lindex < $this->_sql->get_page_count()) $lindex++;
    return $lindex;
  }  
  function get_last(){
    return $this->_sql->get_page_count();
  }
  function get_first(){
    return 1;
  }
  
  function customjs($js, $alt, $icone_name, $icone_over = "", $name = null){
    if (!isset($name)) {
      if (!is_array($this->_customjs))
        $name = 0;
      else
        $name = count($this->_customjs);
    }
    
    $this->_customjs[$name]["js"] = $js;
    $this->_customjs[$name]["icone_name"] = $icone_name;
    $this->_customjs[$name]["icone_over"] = ($icone_over != "" ? $icone_over : $icone_name);
    $this->_customjs[$name]["alt"] = $alt;
    $this->_customjs[$name]["visible"] = true;
    $this->_customjs[$name]["active"] = true;
  }
  function customjs_visible($name, $value = true) {
    $this->_customjs[$name]["visible"] = $value;
  }
  function customjs_active($name, $value = true) {
    $this->_customjs[$name]["active"] = $value;
  }
    
  function custom($function_name, $alt, $icone_name, $icone_over = ""){
    $this->_custom["function_name"] = $function_name;
    $this->_custom["icone_name"] = $icone_name;
    $this->_custom["icone_over"] = ($icone_over != "" ? $icone_over : $icone_name);
    $this->_custom["alt"] = $alt;
  }
  function url_custom(&$fm){
    $this->_custom["function_name"]($fm);
  }
  
  function format($value, $format, $highlightreg = "", $fld_name = ""){
    if (isset($format) && $format != "")
      switch ($format){
        case "boolicon":
          if ($value == $this->_fields[$fld_name]["oui"]) 
          $value = 
          "<center><img src=\"".sget("forms_image_dir")."icon_oui.gif\" border=\"0\" alt=\"" . get_str("lbl_yes", "FromBase") . "\"></center>";
          else
          $value = 
          "<center><img src=\"".sget("forms_image_dir")."icon_non.gif\" border=\"0\" alt=\"" . get_str("lbl_no", "FromBase") . "\"></center>";
          break;
        case "dollar":
          $value = parent::format($value, $format, $highlightreg, $fld_name) . "\$";
          break;
        case "comptable":
            if (preg_match("/^-(.*)/", trim($value), $matches))
              $value = "(" . number_format($matches[1], 2) . "&nbsp;\$)";
            else
             $value = parent::format($value, $format, $highlightreg, $fld_name) . "&nbsp;\$&nbsp;";
          break;
        default :
          return parent::format($value, $format, $highlightreg, $fld_name);
      }
    if ($highlightreg != ""){
      $value = preg_replace("/(" . $highlightreg . ")/i", "<SPAN class=\"highlightreg\">\\1</SPAN>", $value);}
    return $value;
  }

  function no_orderby(){
    $this->no_orderby = true;
  }
  
  function ShowHeader() {
    echo "<tr>";    
    reset($this->_fields);
    if ($this->listofzoom)
      echo "<th>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>";
    while (list($index, $subarray) = each($this->_fields)) {
      if ($this->_fields[$index]["visible"] != "N") {
        if (!$this->printerfriendly && !$this->no_orderby) {
          $leurl = $this->add_parametre($this->_url, "mode=orderby&index=$index");
          if (strtolower($this->_sql->get_champ_orderby()) == $index){
            $leurl .=  "&order=" .  ($this->_sql->get_direction_orderby() == "ASC" ? "DESC" : "ASC") . "&ancre=" . $this->_name;
            if ($this->_sql->get_direction_orderby() == "ASC") {
              $icone = "<img src=\"".sget("forms_image_dir")."ufleche.gif\" height=\"10\" border=\"0\">&nbsp;"; 
            } else{
              $icone = "<img src=\"".sget("forms_image_dir")."dfleche.gif\" height=\"10\" border=\"0\">&nbsp;";
            }
            $the_title = " title=\"" . get_str("alt_invert_order", "FormList") . "\"";
          } else { 
            $icone = "";
            $leurl .=  "&order=ASC&ancre=" . $this->_name;
            $the_title = " title=\"" . get_str("alt_sort", "FormList") . "\"";
          }
          if (preg_match("/src=/", $subarray["label"])){
            $the_title = "";
          }
          $leurl = get_urlmd5($leurl);
          
          echo "<th onClick=\"" . ($this->navigationwithpost 
            ? "$this->formname.action='$leurl'; document.$this->formname.submit();"
            : "window.location='$leurl'") . "\" " . (isset($this->_fields[$index]["width"]) ? " style=\"width:".$this->_fields[$index]["width"]."\"" : "").  
          " onmouseover=\"this.className='formeListethselected'\" onmouseout=\"this.className=''\" >";
          echo $icone;
          echo "<a " . ($this->navigationwithpost 
            ? "href=\"#\" onClick=\"$this->formname.action='$leurl'; document.$this->formname.submit();\"" : "href=\"$leurl\"") . " $the_title>" . $subarray["label"] . "</a></th>";
        } else { 
          echo "<th " . (isset($this->_fields[$index]["width"]) ? " style=\"width:".$this->_fields[$index]["width"]."\"" : "") . 
          ">" . $subarray["label"] . "</th>";
        }
      }
    } 
    if (!$this->printerfriendly && $this->listofzoom && !$this->_no_update && !$this->_no_delete)
      echo "<th>&nbsp;</th>";
    if (isset($this->zoom) && !$this->_no_zoom && !$this->printerfriendly)
      $this->get_headerzoom();
    if (isset($this->_custom) && !$this->printerfriendly)
      echo "<th style=\"width:20\">&nbsp;</th>";
    if (isset($this->_customjs) && !$this->printerfriendly)
      $this->get_customjs_header();
      echo "</tr>\n";
  }
  function get_customjs_header() {
      reset($this->_customjs);
      while (list($index, $subarray) = each($this->_customjs)) {
        if ($subarray["visible"]) 
          echo "<th style=\"width:20\">&nbsp;</th>";
      }
  }
//* support optional search
  function optional_search($fieldname){
    if (is_array($fieldname)){
      while (list($index, $subarray) = each($fieldname))
       if (isset($this->_fields[$subarray])){
         $this->_fields[$subarray]["optional_search"] = true;
         $this->_fields[$subarray]["visible"] = "N";
       }
    } else {
      if (isset($this->_fields[$fieldname])) {
        $this->_fields[$fieldname]["optional_search"] = true;
        $this->_fields[$fieldname]["visible"] = "N";
      }
    }
  }
  
  function get_headerzoom(){
    echo "<th style=\"width:20\">&nbsp;</th>";
  }
  
  function set_rs($lindex){
    if ($this->listofzoom && $this->get_post) {
      if (is_array($this->_rs)){
        reset($this->_rs);
        while (list($index, $subarray) = each($this->_rs)){
          while (list($index2, $subarray2) = each($subarray)) 
            $this->_rs[$index][$index2] =             
              $this->listofzoomform->wrap(
                $this->listofzoomform->_fields[$index2]["html_type"], 
                pget($this->listofzoomform->_fields[$index2]["name"].$index),
                false, $this->listofzoomform->_fields[$index2]["non"] );
        }
      }
    } else {
      $this->_rs = $this->_sql->SelectPage($lindex);
      $this->_ors = $this->_rs;
    }
  }
  
  function ShowPages($lindex) {
    $nbpage = $this->nbpage;
    if ($nbpage > 1){
      if ($nbpage > 10) {
        $imin = ((($lindex % 10) == 0) ? (($lindex > 1) ? $lindex - 10 + 1: 1) : $lindex + 1 - ($lindex % 10));
        $imax = $imin + 10 - 1;
        $imax = (($imax > $nbpage) ? $nbpage : $imax);
      } else {
        $imin = 1;
        $imax = $nbpage;
      }
      if ($imin > 1) { 
        $leurl = $this->add_parametre($this->_url, "mode=list&index=" . ($lindex-10) . "&ancre=" . $this->_name);
        $this->get_button("-", ($this->navigationwithpost 
            ? "$this->formname.action='$leurl'; document.$this->formname.submit();"
            : "window.location='$leurl';"), get_str("alt_minusten", "FormList"));
      }
      for ($i = $imin ; $i <= $imax ; $i++) {
        $format = (($i == $lindex) ? " style=\"font-weight:bold;color:white\"" : "");
        $leurl = $this->add_parametre($this->_url, "mode=list&index=$i" . "&ancre=" . $this->_name);
        $this->get_button("$i", ($this->navigationwithpost 
            ? "$this->formname.action='$leurl'; document.$this->formname.submit();"
            : "window.location='$leurl';"),  get_str("alt_page", "FormList") . $i, $format);
      }
      if ($imax != $nbpage) {
        $leurl = $this->add_parametre($this->_url, "mode=list&index=" . ($lindex+10 < $nbpage ? $lindex+10 : $nbpage) . "&ancre=" . $this->_name);
        $this->get_button("+", ($this->navigationwithpost 
            ? "$this->formname.action='$leurl'; document.$this->formname.submit();"
            : "window.location='$leurl';"), get_str("alt_plusten", "FormList"));
      }
      if ($nbpage > 10) {
        // l'index et le parametre ancre sont modifies en javascript il faut donc
        // les exclurent de la validation en ajoutant le parametre ss=index|ancre
        $leurl = $this->add_parametre($this->_url, "mode=list&sp=index|ancre");
        $leurl = get_urlmd5($leurl);
        $leurl .= "&index=";
        echo "&nbsp;";
        $the_call = "prompt_page_number(" . sprintf(get_str("msg_goto", "FormList"), $nbpage, $nbpage) . ", '$leurl', '&ancre=" . $this->_name . "' , $nbpage);";
        $this->get_button("...", $the_call, get_str("alt_goto", "FormList"));
      }
    }
  }
  function get_button($label, $onclick, $tooltip, $format = ""){
    echo "<input type=\"button\" $format title=\"$tooltip\" class=\"formeListbutton\" value=\"&nbsp;$label&nbsp;\" onclick=\"$onclick\">";
  }
  
  function get_fieldtd($index2, $subarray2, $c){
    if (($this->_fields[$index2]["visible"] != "N" && !$this->listofzoom) ||
        ($this->listofzoom && $this->_fields[$index2]["visible"] != "N" && $this->listofzoomform->_fields[$index2]["visible"] != "N")){
      if (!$this->listofzoom || $this->_no_update) { 
        if ($this->_fields[$index2]["html_type"] == "select") {
          if (!is_array($this->_fields[$index2]["leschoix"])) {
            $choix = sql2arrayselect($this->_fields[$index2]["leschoix"], null, $this->_alt_bd);
            $this->_fields[$index2]["leschoix"] = $choix;
          } else {
            $choix = $this->_fields[$index2]["leschoix"];
          }
          $choix = (is_array($choix)) ? array_flip($choix) : array(""=>"");
          
          $subarray2 = $choix[$subarray2];
          if ($subarray2 == "" && $this->_fields[$index2]["addself"] && $this->_fields[$index2]["field_description"] != "")
            $subarray2 = $this->_rs[$c][$this->_fields[$index2]["field_description"]];
        }
        $fieldvalue = $this->format($subarray2, $this->_fields[$index2]["display_format"], $this->_fields[$index2]["highlightreg"], $index2) . "&nbsp;";
      } else {
        if (isset($this->listofzoomform->_fields[$index2])) {
          if ($this->listofzoomform->_fields[$index2]["html_type"] == "select") {
            if (!is_array($this->listofzoomform->_fields[$index2]["leschoix"])) {
              $this->listofzoomform->_fields[$index2]["leschoix"] = sql2arrayselect($this->listofzoomform->_fields[$index2]["leschoix"], null, $this->listofzoomform->_alt_bd);
            } 
            if (!is_array($this->_fields[$index2]["leschoix"])) {
              $choix = sql2arrayselect($this->_fields[$index2]["leschoix"], null, $this->_alt_bd);
              $this->_fields[$index2]["leschoix"] = $choix;
            } else {
             $choix = $this->_fields[$index2]["leschoix"];
            }
            $choix = (is_array($choix)) ? array_flip($choix) : array(""=>"");
            
            $subarray3 = $choix[$subarray2];
            if ($subarray3 == "" && $this->_fields[$index2]["addself"] && $this->_fields[$index2]["field_description"] != "")
              $this->listofzoomform->_fields[$index2]["pick_listdescription"]  = $this->_rs[$c][$this->_fields[$index2]["field_description"]];
          }
          $this->listofzoomform->_fields[$index2]["index_zoom"] = $c;
          $this->listofzoomform->_fields[$index2]["html_attribut"] = preg_replace("/\*{3}no\*{3}/", $c, $this->listofzoomform->_fields[$index2]["old_html_attribut"]);
          $fieldvalue = get_control(
            $this->listofzoomform->_fields[$index2],
            $this->listofzoomform->format($subarray2, $this->listofzoomform->_fields[$index2]["display_format"], $this->listofzoomform->_fields[$index2]["highlightreg"], $index2),
            $this->printerfriendly,
            "", "formelist", $this->_alt_bd);
        }
      }
      
      if ($this->listofzoomform->_fields[$index2]["temphidden"]) 
        echo "<td" . ($this->_fields[$index2]["html_class"] != "" ? " class=" . $this->_fields[$index2]["html_class"] : " class=\"formeZoom\"") .
         ($this->_fields[$index2]["html_attribut"] != "" ? " " . $this->_fields[$index2]["html_attribut"] : "") .
        "></td>";
      elseif (isset($this->listofzoomform->_fields[$index2]) && $this->listofzoomform->_fields[$index2]["html_type"] == "hidden")
        echo "<input type=\"hidden\" value=\"$fieldvalue\">";
      else 
        echo "<td" . ($this->_fields[$index2]["html_class"] != "" ? " class=" . $this->_fields[$index2]["html_class"] : ($this->listofzoom ? " class=\"formeZoom\"" : "")) .
         ($this->_fields[$index2]["html_attribut"] != "" ? " " . $this->_fields[$index2]["html_attribut"] : "") 
         . (isset($this->listofzoomform) && $this->listofzoomform->_fields[$index2]["html_type"] == "calendar" && !is_ie() ? " nowrap" : "")
         . ">$fieldvalue</td>";
    }
  }
  
  function get_validationfields(){
    static $result;
    if (!isset($result)) {
	    $result = "";
	    if ($this->listofzoom) {
	      $imax = count($this->_rs); 
	      $fm = sget("fm");
	      $fieldstemp = $this->listofzoomform->_fields;
	      for ($i = 0; $i<$imax; $i++) {
	          reset($fieldstemp);
	          while (list($index, $subarray) = each($fieldstemp)){
	            $fields[$index.$i] = $subarray;
	            $fields[$index.$i]["index_zoom"] = $i;
	            $i2 = $i + 1;
	            $msg_sup = preg_replace("/\*\*\*i\*\*\*/", $i2, $this->_error_message_ligne_sup);
	            $fields[$index.$i]["msg"] = substr($fields[$index.$i]["msg"], 0, strlen($fields[$index.$i]["msg"]) -1 ) . $msg_sup;
	        }
	        $result = array_merge($this->_fields, $fields);
	      }
	    }
    }
    return $result;
  }
  
  function get_js_validation_function() {
    $js_script = "<script>
    function validate_form_" . $this->formname . "() {
    var i;
    var found = true;
    var valide = true;
    ";
    if (isset($this->_master) && $this->use_master_validation){
      $fm = sget("fm");
      $themaster = &$fm->get_form($this->_master);
      $fields = $themaster->_fields;
      $js_script .= $this->get_js_script_no_submit($fields, $this->formname);
    }
    if ($this->listofzoom) {
      reset($this->listofzoomform->_fields);
      while (list($index, $subarray) = each($this->listofzoomform->_fields)) {
        $this->listofzoomform->_fields[$index]["index_zoom"] = "' + i + '";
        $this->listofzoomform->_fields[$index]["msg"] = 
          preg_replace("/&quot;/", "\"", $this->listofzoomform->_fields[$index]["msg"])
          //. preg_replace("/\*\*\*i\ * \ * \ */", "' + i + '", get_str("msg_ligne_sup", "FormList"))
          ;
      }
	    $js_script .= "
	    for (i = 0; i < " . $this->_sql->_row_per_page . "; i++ && found) {
	      if (document.getElementById('" . $this->_name. "' + i)) {
	        ";
	    $js_script .= get_js_script_no_submit($this->listofzoomform->_fields, $this->formname);
	    $js_script .= "
	        if (msg.join('') != '') {return false;}
	      } else {
	        found = false;
	    }
	  }";
	  }
    
    $js_script .= "return true}\n </script>";
    return $js_script;
  }
  
  function  get_js_script_no_submit($fields, $formname){
    static $js_script;
    if(!isset($js_script)){
      if (isset($this->_master) && $this->use_master_validation){
        $fm = sget("fm");
        $themaster = &$fm->get_form($this->_master);
        $fields = array_merge($themaster->_fields, $fields);
      } 
      $js_script = get_js_script_no_submit($fields, $formname);
    } 
    return $js_script;
  }
  
  function get_fieldtr($index, $subarray, $c){
        // chaque enregistrement
        if ($this->listofzoom && !$this->hidden) {
          echo "<tr id=\"" . $this->_name.$c  . "\" >";
          if ($this->listofzoom) {
            if ($index === "insertion") {
              $key = $index;
            } else {
              $key = $this->_rs[$index][$this->_key];
            }
            echo "<td class=\"$this->class_chiffre\" align=\"center\"><input type=\"hidden\" name=\"cb_" . $this->_name.$c . "\" value=\"$key\"><sup>" . ($c + 1) ."</sup></td>";
          } else
            echo "<td class=\"formeZoom\"><input type=\"checkbox\" name=\"cb_" . $this->_name.$c . "\" value=\"" . $this->_rs[$index][$this->_key] . "\"></td>";
        } elseif (!$this->hidden) { 
            echo "<tr class=\"formeListenotselected\" id=\"" . $this->_name.$c  . "\" >";
        } else {
          echo "<input type=\"hidden\" name=\"cb_" . $this->_name.$c . "\" value=\"" . $this->_rs[$index][$this->_key] . "\">";
        }
        if ($this->listofzoom)
          $this->listofzoomform->_no_update = $this->_no_update;
          if ($this->listofzoom)
            $this->listofzoomform->resettabhidden(null, $this->hidden);
          // chaque colonne
          while (list($index2, $subarray2) = each($subarray)) {
             if ($this->listofzoomform->_fields[$index2]["addself"] && $this->listofzoomform->_fields[$index2]["field_description"] != "")
              $this->listofzoomform->_fields[$index2]["pick_listdescription"] = $subarray[$this->listofzoomform->_fields[$index2]["field_description"]];
            $this->get_fieldtd($index2, $subarray2, $c);
          }

          if (!$this->hidden && 
            !$this->printerfriendly && $this->listofzoom) {
            $fields = $this->get_validationfields($c);
            if (isset($this->_master) && $this->use_master_validation){
              $fm = sget("fm");
              $themaster = &$fm->get_form($this->_master);
              $fields = array_merge($themaster->_fields, $fields);
            } 
            if (!$this->_no_delete && !$this->_no_update) {
              $classname = "";
              $classnemeselected = "formezoomListeselected";
              $onclick = "if (validate_form_" . $this->formname . "()) {if (confirm('" . $this->_buttonlabel_erase_ligne_msg 
              . "')) {document." . $this->formname 
              . ".action ='"  
              . $this->add_parametre($this->_url, "mode=erase&indexliste=$c") 
              . "'; setTimeout('document." . $this->formname 
              . ".submit()',500);}}";
              echo "<td align=center onClick=\"$onclick\" onmouseover=\"document.getElementById('" 
              . $this->_name . $c 
              . "').className='$classnemeselected';\" onmouseout=\"document.getElementById('"
              . $this->_name . $c 
              . "').className='$classname';\" class=\"formeListeCol1\" title=\"" . get_str("alt_delete", "FormList") . "\">&nbsp;<img src=\"".sget("forms_image_dir")."icon_effacer_liste.gif\" 
              onmouseover=\"document.getElementById('" 
              . $this->_name . $c 
              . "').className='$classnemeselected';\" onmouseout=\"document.getElementById('"
              . $this->_name . $c 
              . "').className='$classname';\" border=\"0\">&nbsp;</td>";
            }
          }
          if (isset($this->zoom) && !$this->_no_zoom && !$this->printerfriendly && !$this->hidden){ 
            $this->get_zoomtd($subarray, $c);
          }
          if (isset($this->_custom) && !$this->printerfriendly && !$this->hidden){
            if ($this->listofzoom) {
                $classname = "";
                $classnemeselected = "formezoomListeselected";
            } else {
                $classname = "formeListenotselected";
                $classnemeselected = "formeListeselected";
            }
          echo "<td class=\"formeListeCol1\">
            <a href=\""
            . $this->add_parametre($this->_url, "mode=custom&index=" . $subarray[$this->_key])
            . "\"><img onmouseover=\"this.src='".sget("forms_image_dir")."" 
            . $this->_custom["icone_over"] 
            . ".gif';document.getElementById('" 
            . $this->_name . $c 
            . "').className='$classnemeselected';\" onmouseout=\"this.src='".sget("forms_image_dir")."" 
            . $this->_custom["icone_name"] 
            . ".gif';document.getElementById('"
            . $this->_name . $c 
            . "').className='$classname';\" src=\"".sget("forms_image_dir").""
            . $this->_custom["icone_name"]
            . ".gif\" border=\"0\" alt=\""
            . $this->_custom["alt"]
            . "\"></a></td>";
          }
          // ajout condition 
          $this->get_cuntomjstd($subarray, $c);
          echo "</tr>\n";
  }
  
  function get_cuntomjstd($subarray, $c){
    if (isset($this->_customjs) && !$this->printerfriendly && !$this->hidden){
      reset($this->_customjs);
      while (list($index, $customsubarray) = each($this->_customjs)) {
        if ($customsubarray["visible"]) {
		      if ($this->listofzoom) {
				    $classname = "";
				    $classnemeselected = "formezoomListeselected";
				  } else {
				    $classname = "formeListenotselected";
				    $classnemeselected = "formeListeselected";
				  }
          if ($customsubarray["active"]) {
				    echo "<td class=\"formeListeCol1\" onClick=\""
				     . $this->get_customjs($subarray, $index)
				     . "\" onmouseover=\"icon$index$c.src='" . sget("forms_image_dir")
				     . $customsubarray["icone_over"] 
				     . ".gif';document.getElementById('" 
				     . $this->_name . $c 
				     . "').className='$classnemeselected';\" onmouseout=\"icon$index$c.src='" . sget("forms_image_dir") 
				     . $customsubarray["icone_name"] 
				     . ".gif';document.getElementById('"
				     . $this->_name . $c 
				     . "').className='$classname';\"><img id=\"icon$index$c\" src=\"" . sget("forms_image_dir")
				     . $customsubarray["icone_name"]
				     . ".gif\" border=\"0\" alt=\""
				     . $customsubarray["alt"]
				     . "\"></td>";
				   } else {
             echo "<td class=\"formeListeCol1\" style=\"cursor:auto;\"></td>";
				   }
			  }
			}
    }
  }
  function get_form() {
    if (!$this->no_form && !$this->hidden)
        $lehtml .=  "<form name=\"" . $this->formname . "\" action=\"" .
        $this->add_parametre($this->_url, "mode=pget&ancre=" . $this->_name) .
          "\" method=post>\n<input type=\"hidden\" name=\"sequence\" value=\"" . $this->_sequence . "\"><input type=\"hidden\" name=\"mode\" value=\"" . $this->_mode . "\">";
      else
        $lehtml .=  "<input type=\"hidden\" name=\"mode\" value=\"" . $this->_mode . "\">";
    return $lehtml;
  }
  function get_g_custom($small = false){
    if (isset($this->_g_custom) && !$this->printerfriendly) {
		  $size = $small ? 27 : 34;
	    reset($this->_g_custom);
	    $g_custom .= "<td align=right>";
	    while (list($index, $subarray) = each($this->_g_custom)){
	      $g_custom .= "<input type=\"button\" class=\"formeListbutton\"";
	      if ($subarray["with_submit"])
	        $g_custom .= "onclick=\"" . get_js_script_no_submit($this->_fields, $this->formname) . " else {submit_custom(document.forms['$this->formname'], '" . 
	           $this->add_parametre($this->_url, "mode=gcustom&fn=" . $index . "&index=" . $lindex) . "')} \"";
	      else 
	        $g_custom .= "onclick=\"window.location='" . $this->add_parametre($this->_url, "mode=gcustom&fn=" . $index . "&index=" . $lindex) . "'\"";
	      $g_custom .= " title=\"" . $subarray["alt"] . "\" value=\"&nbsp;&nbsp;" . $subarray["label"] . "&nbsp;&nbsp;\">";
	    }
	    return $g_custom . "</td>";
    } else 
      return "";
  }
  function _display(&$fm, $lindex = null) {
    if (is_primary_language())
      $this->_url = update_url_query($this->_url, "langue");
    else
      $this->_url = update_url_query($this->_url, "langue", get_language());
    $lindex = (
            (isset($lindex)) ? $lindex : 
              (
                (isset($this->_index)) ? $this->_index : 1
              )
            );
    if ($this->listofzoom) {
      if (!isset($this->listofzoomform))
        $this->listofzoomform = &$fm->get_form($this->listofzoomname);
    }
    echo $this->get_js_validation_function();
    $this->set_rs($lindex);
    echo "<a name=\"" . $this->_name . "\"></a>";
    echo "<table class=\"$this->outlineclass\" width=100%><tr><td>";
    if ($lindex > $this->_sql->get_page_count()) $lindex = $this->get_last();
    $this->_index = $lindex;
    if (!$this->hidden && 
      ($this->_title != "" 
      || ((($this->insertbutton_in_title && !$this->_no_insert)
          || $this->_help_wanted 
          || isset($this->_g_custom)) 
          && !$this->printerfriendly))){
      echo "<table class=\"formeListTitle\" width=100%><tr>";
      if ($this->_title != "")
        echo "<td>" . $this->_title . "</td>";
      if ($this->_help_wanted && !$this->printerfriendly) {
        echo "<td align=right><table cellpadding=5><tr>";
        if (isset($this->_g_custom)){
          reset($this->_g_custom);
          while (list($index, $subarray) = each($this->_g_custom)){
            echo "<td class=\"formeListeCol1\"><a href=\"" . 
            $this->add_parametre($this->_url, "mode=gcustom&fn=" . $index) . 
            "\" title=\"" . $subarray["alt"] . "\">&nbsp;&nbsp;" . $subarray["label"] .
            "&nbsp;&nbsp;</a></td>";    
          } 
        }
        if ($this->_help_wanted)
          echo "<td>" . $this->help_me_button() . "</td>";

        echo "</tr></table></td>";
      }
      echo $this->get_g_custom(true);
      if ($this->insertbutton_in_title && !$this->_no_insert) {
         echo "<td align=right>" . $this->get_insert_button();

        if (!$this->_no_save && !$this->_no_update && !$this->_no_save_button)  {
          echo  "<input  class=\"formeListbutton\"  type=\"button\" name=\"save\" value=\"" . $this->_buttonlabel_save . 
               "\" onclick=\"if (validate_form_" . $this->formname . "()) {document." . $this->formname . ".elements['mode'].value = 'save'; document." . $this->formname . ".submit();}\">";
        }
      echo "</td>";
      }
      echo "</tr></table>";
    }
    if (!$this->_hide_header && !$this->hidden) {
     ?>

    <table width=100% class="formeListe" cellpadding=0 cellspacing=0><tr valign=middle height=25>
  <?php 
    if (!$this->_no_navigate) {    
    $this->nbpage = $this->_sql->get_page_count();
    ?> 
    <td background="<?php echo sget("image_dir") ?>grad1.gif">
    
     <?php if ($this->nbpage > 1){
     $leurl = $this->add_parametre($this->_url, "mode=move_first&ancre=" . $this->_name); 
     $leurlprev = $this->add_parametre($this->_url, "mode=move_prev&index=" . $lindex . "&ancre=" . $this->_name);?> 
    <input type="button"  class="formeListbutton"  title="<?php echo get_str("alt_first_page","FormList") ?>" value="&nbsp;|<&nbsp;" <?php 
    if ($lindex <= 1) echo "DISABLED "; ?>onclick="<?php echo ($this->navigationwithpost 
            ? "$this->formname.action='$leurl'; document.$this->formname.submit();"
            : "window.location='$leurl'"); ?>"><input type="button"  class="formeListbutton"  title="<?php echo get_str("alt_prev_page", "FormList") ?>" value="&nbsp;<&nbsp;" <?php if ($lindex <= 1) echo "DISABLED "; ?>onclick="<?php 
            echo ($this->navigationwithpost 
            ? "$this->formname.action='$leurlprev'; document.$this->formname.submit();"
            : "window.location='$leurlprev'"); ?>">
    
     <?php }?> 
    </td>
  <?php } ?>
    <td background="<?php echo sget("image_dir") ?>grad1.gif" align=center><?php $this->ShowPages($lindex); ?></td>  
  <?php if (!$this->_no_navigate) {?>
    <td background="<?php echo sget("image_dir") ?>grad1.gif" align=right>
     <?php if ($this->nbpage > 1){
     $leurl = $this->add_parametre($this->_url, "mode=move_last&ancre=" . $this->_name); 
     $leurlnext = $this->add_parametre($this->_url, "mode=move_next&index=" . $lindex . "&ancre=" . $this->_name)?> 
    <input type="button"  class="formeListbutton" title="<?php echo get_str("alt_next_page", "FormList") ?>" value="&nbsp;>&nbsp;" <?php if ($lindex == $this->_sql->get_page_count() || $this->_sql->get_page_count() == 0) echo "DISABLED "; ?>onclick="<?php 
    echo ($this->navigationwithpost 
            ? "$this->formname.action='$leurlnext'; document.$this->formname.submit();"
            : "window.location='$leurlnext'"); ?>"><input type="button"  class="formeListbutton"  title="<?php echo get_str("alt_last_page", "FormList") ?>" value="&nbsp;>|&nbsp;" <?php if ($lindex == $this->_sql->get_page_count() || $this->_sql->get_page_count() == 0) echo "DISABLED "; ?>onclick="<?php 
    echo ($this->navigationwithpost 
            ? "$this->formname.action='$leurl'; document.$this->formname.submit();"
            : "window.location='$leurl'"); ?>">
  <?php } ?>
    </td>
  <?php } ?>
    </tr></table>
    <?php }
    if (!$this->hidden)
      echo "<table class=\"formeListe\" width=100%" . ($this->listofzoom ? " cellpadding=0" : " cellspacing=\"2\" cellpadding=\"2\"") . ">";
    echo $this->get_form();
    $c = 0;
    if (!$this->hidden)
      $this->ShowHeader();
    if ($this->listofzoom && $this->insertmode
       &&  $this->zoom == "") {
      reset($this->_fields);
      while (list($index) = each($this->_fields)){
        if ($this->listofzoomform->_fields[$index]["initializevalue"] != "")
          $subarrayvide[$index] = $this->listofzoomform->_fields[$index]["initializevalue"];
        elseif ($this->listofzoomform->_fields[$index]["initializefunction"] != "")
          $subarrayvide[$index] = $this->listofzoomform->_fields[$index]["initializefunction"]();
        else
          $subarrayvide[$index] = "";
      }
      $this->get_fieldtr("insertion", $subarrayvide, $c);
      $c++;
      reset($this->_fields);
    }
    if (is_array($this->_rs)){
      reset($this->_rs);
      while (list($index, $subarray) = each($this->_rs)){
        $this->get_fieldtr($index, $subarray, $c);
        $c++;
      }
    }
    if (!$this->hidden) {
      $this->get_footer_liste();
      echo "</table>";
      if (!$this->printerfriendly) {
        if (!$this->_hide_footer) {
          $this->get_footer();
        }
      }
      if (!$this->no_form)
        echo "</form>";
    }
    echo "</td></tr></table>";
   }
   
  function get_customjs($rs, $lindex){
    // Si des parametres sont passer aux fonctions js de la facon suivante '***document***'
    // le terme entre les * est le nom du champ de la bd contenant la valeur a utilise pour le remplacement
    if (preg_match_all("/(.*)\*\*\*(.*)\*\*\*(.*)/U", $this->_customjs[$lindex]["js"], $matches)){
      while (list($index, $subarray) = each($matches[1])){
        $js .= $subarray . addslashes($this->format($rs[$matches[2][$index]], $this->_fields[$matches[2][$index]]["display_format"], "", $matches[2][$index]));
      }
      preg_match("/.*\*\*\*.*\*\*\*(.*)/", $this->_customjs[$lindex]["js"], $matches);
      $js .= $matches[1];
    } else {
      $js = $this->_customjs[$lindex]["js"];
    }
    return $js;
  }
  
  function get_footer_liste(){ 
  }
  
  function get_zoomtd($subarray, $c){
    if ($this->listofzoom) {
      $classname = "";
      $classnemeselected = "formezoomListeselected";
    } else {
      $classname = "formeListenotselected";
      $classnemeselected = "formeListeselected";
    }
    $the_url = $this->add_parametre($this->_url, "mode=zoom&index=" . $subarray[$this->_key]);
    echo "<td class=\"formeListeCol1\" width=30 align=center onclick=\"window.location='$the_url'\"
     onmouseover=\"document.getElementById('iconezoom" . $c . "').src='" . sget("forms_image_dir") 
    . "zoomover.gif'; document.getElementById('" . $this->_name.$c 
    . "').className='$classnemeselected';\" onmouseout=\"document.getElementById('iconezoom" . $c . "').src='" 
    . sget("forms_image_dir") . "zoom.gif'; document.getElementById('"
    . $this->_name.$c ."').className='$classname';\"><img id=\"iconezoom" . $c . "\" onmouseover=\"this.src='" . sget("forms_image_dir") 
    . "zoomover.gif'; document.getElementById('" . $this->_name.$c 
    . "').className='$classnemeselected';\" onmouseout=\"this.src='" 
    . sget("forms_image_dir") . "zoom.gif'; document.getElementById('"
    . $this->_name.$c ."').className='$classname';\" src=\""
    . sget("forms_image_dir") . "zoom.gif\" border=\"0\" alt=\""
    . get_str("alt_edit", "FormList") . "\"></td>";
  }
  
  function get_imagebutton($image, $onclick, $tooltip, $format = ""){
    echo "<img src=\"".sget("forms_image_dir")."$image.gif\" $format
          onmouseover=\"this.src='".sget("forms_image_dir")."" . $image . "_over.gif';\" 
          onmouseout=\"this.src='".sget("forms_image_dir")."$image.gif';\"
          border=\"0\" alt=\"$tooltip\" onclick=\"$onclick\">" ;
  }
  
  function get_insert_button(){
    if (!$this->savehandeled) 
    return "<input 
     class=\"formeListbutton\" type=\"button\" 
     value=\"&nbsp;" . $this->_buttonlabel_add . "&nbsp;\" 
     onclick=\"" . ($this->listofzoom ? $this->get_js_script_no_submit($fields, $this->formname)
       . " else {document." . $this->formname . ".elements['mode'].value = 'add'; document." . $this->formname . ".submit();}" :
        "window.location='" . $this->add_parametre($this->_url, "objet=$this->_name&mode=add") . "'") . "\">";
    else
    return "<input 
     class=\"formeListbutton\" type=\"button\" 
     value=\"&nbsp;" . $this->_buttonlabel_add . "&nbsp;\" 
     onclick=\"" . get_js_script_no_submit($fields, $this->formname)
       . " else {document." . $this->formname . ".action='" . $this->add_parametre($this->_url, "objet=$this->_name&mode=add") .
        "'; document." . $this->formname . ".submit();}\">";
  }
  
  function get_footer(){
    if (!$this->_no_insert && !$this->_no_update && isset($this->zoom) && !$this->listofzoom) {
      if (!($this->insertbutton_in_count || $this->insertbutton_in_title)) {
        echo "<table width=100%><tr><td align=center>" . $this->get_insert_button() . " 
     </td></tr></table>";
      }
    } else {
      if (!$this->insertbutton_in_count) {
      if (!$this->_no_delete && !$this->_no_insert && !$this->_no_update && (isset($this->zoom) || $this->listofzoom)) {
        echo "<table width=100% class=\"formelistfooter\"><tr>";
        echo "<td align=\"right\"><table border=0 cellpadding=0 cellspacing=0 align=\"right\"><tr>"; 
        
        $fields = $this->get_validationfields();
        if (isset($this->_master) && $this->use_master_validation){
          $fm = sget("fm");
          $themaster = &$fm->get_form($this->_master);
          $fields = array_merge($themaster->_fields, $fields);
        } 
        if (!$this->_no_insert && !$this->_no_update && (isset($this->zoom) || $this->listofzoom)) {
          if ($this->listofzoom && $this->zoom == "") {
            $onclick = $this->get_js_script_no_submit($fields, $this->formname)
       . " else {document." . $this->formname . ".elements['mode'].value = 'add'; document." . $this->formname . ".submit();}";
          } else
            $onclick = "window.location='" . $this->add_parametre($this->_url, "mode=add") . "'";
          echo "<td><input class=\"formeListbutton\" type=\"button\" name=\"insert\" value=\"" . 
               $this->_buttonlabel_add . 
               "\" onclick=\"$onclick\">&nbsp;</td>";
        }
        if (!$this->_no_save && !$this->_no_update)  {
          echo "<td align=center>" . "<input  class=\"formeListbutton\"  type=\"button\" name=\"save\" value=\"" . $this->_buttonlabel_save . 
               "\" onclick=\"" . $this->get_js_script_no_submit($fields, $this->formname)
       . " else {document." . $this->formname . ".elements['mode'].value = 'save'; document." . $this->formname . ".submit();}\">" .
                "</td>";
        }
        echo "</tr></table></td></tr></table>";
      }
      }
    }
  }

  function row_per_page($row){
    $this->_sql->row_per_page($row);
  }

  // ----------------------------------------------------
  // Detruire lenregistrement
  // ----------------------------------------------------
  function _erase_all(){
    if (!$this->_no_update && !$this->_no_delete && isset($this->_joinfield) && isset($this->_filter_value)) {
      $lesql = "delete from " . $this->_sql->get_delete_table_name() .
             " where " . $this->_joinfield . " = " .
      wrapdata($this->_filter_value,
              $this->_sql->field_description[$this->_joinfield]["field_type"]) ;
    }
    return $lesql . ";";
  }

  function erase(&$fm){
    if (isset($this->_master)){
      $themaster = &$fm->get_form($this->_master);
      if ($themaster->_mode == "save") 
        $themaster->save($fm);
    } 
    if (!$this->_no_update) {
      $this->msg_error = "";
      $lindex = gget("indexliste");
      if ($lindex != ""){
        $imax = $lindex;
        $imin = $lindex;
      }else {
        $imax = $this->_sql->_row_per_page - 1;
        $imin = 0;
      }
      if (!isset($this->listofzoomform))
        $this->listofzoomform = &$fm->get_form($this->listofzoomname);
      for ($i = $imin; $i <= $imax; $i++)  {
        $akey = pget("cb_" . $this->_name . $i);
        if ($akey != "" && $akey != "insertion") {
          $this->listofzoomform->set_index($akey);
          if ($this->_type_formulaire == "detail") {
            $this->listofzoomform->_sql->RebuiltSql(); 
            if (isset($this->_master)) 
              $this->listofzoomform->_sql->_modifie_where =
                $this->_sql->_modifie_where;
          }
          $result .= $this->listofzoomform->erase($fm);
          if ($result != "")
           $this->msg_error .= $this->listofzoomform->msg_error;
        }
      }
    }
    return $result;
  }
  function url_erase(&$fm){
    $result = $this->erase($fm);
    if ($result != "")
	    echo_box($this->msg_error, "error");
    $this->show($fm);
  }
  
  function save(&$fm) {
	    $lindex = gget("indexliste");
	    $this->msg_error = "";
	    if ($lindex !== "")
	      $nosaveindex = $lindex;
	    else
	      $nosaveindex = 1000000;// pour pouvoir comparer avec 0 sans etre egal
	    $this->listofzoomform = &$fm->get_form($this->listofzoomname);
	    if ($this->listofzoomform->_use_parent_where) {
	      if (isset($this->_master))
	        $key = $fm->_forms[$this->_master]["form"]->_key;
	      $this->listofzoomform->_sql->_modifie_where = $this->_sql->_modifie_where;
	    }
	    if (!$this->_no_save && !$this->_no_update) {
	      $imax = $this->_sql->_row_per_page; 
	      for ($i = 0; $i <= $imax; $i++)  {
	        if ($nosaveindex != $i) {
	          $akey = pget("cb_" . $this->_name . $i);
	          if ($akey != "") {
	            if ($akey == "insertion"){
	              $this->listofzoomform->set_index(0);
	              if ($this->listofzoomform->_use_parent_where) {
	                $this->listofzoomform->_fields[$key]["value"] = $this->_filter_value;}
	              $result = $this->listofzoomform->insert($fm, $i);
	              $this->listofzoomform->set_index(0);
	            } else {
	              $this->listofzoomform->set_index($akey);
	              $this->listofzoomform->_ors = $this->_ors[$i];
	              $result = $this->listofzoomform->save($fm, $i);
	            } 
	            if ($result != "")
	              $this->msg_error .= "(ligne " . ($i + 1) . ") " . $this->listofzoomform->msg_error;
	          }
	        }
	      }
	    }
	    return $this->msg_error;
  }
  
  function url_save(&$fm) {
    $result = $this->save($fm);
    if ($result != "")
      echo_box($this->msg_error, "error");
    /* 
      $this->restore_save($fm, $result); //restore_save non defini  faire
    else*/
      $this->show($fm);
  }
  
  function url_listzoom(&$fm) {
    $this->listofzoom = !$this->listofzoom;
    $this->show($fm);
  }
}
?>